/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.maven.jaxws._RetoucheUtil;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.openide.ErrorManager;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class JaxWsChildren
extends Children.Keys<Object> {
    private Image cachedIcon;
    private static final String OPERATION_ICON = "org/netbeans/modules/websvc/core/webservices/ui/resources/wsoperation.png";
    private FileObject implClass;
    private JaxWsService service;
    private FileObject srcRoot;
    private FileChangeListener fcl;

    public JaxWsChildren(JaxWsService service, FileObject srcRoot, FileObject implClass) {
        this.service = service;
        this.srcRoot = srcRoot;
        this.implClass = implClass;
    }

    private List<ExecutableElement> getPublicMethods(CompilationController controller, TypeElement classElement) throws IOException {
        List<? extends Element> members = classElement.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(members);
        ArrayList<ExecutableElement> publicMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            Set<Modifier> modifiers = method.getModifiers();
            if (!modifiers.contains((Object)Modifier.PUBLIC)) continue;
            publicMethods.add(method);
        }
        return publicMethods;
    }

    protected void addNotify() {
        assert (this.implClass != null);
        if (this.fcl == null) {
            this.fcl = new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    JaxWsChildren.this.updateKeys();
                    ((JaxWsNode)JaxWsChildren.this.getNode()).fireShortDescriptionChange();
                    ((JaxWsNode)JaxWsChildren.this.getNode()).setServiceUrl();
                }
            };
            this.implClass.addFileChangeListener(this.fcl);
        }
        this.updateKeys();
    }

    protected void removeNotify() {
        if (this.fcl != null) {
            this.implClass.removeFileChangeListener(this.fcl);
            this.fcl = null;
        }
        this.setKeys(Collections.emptySet());
    }

    private void updateKeys() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaSource javaSource;
                final List[] keys = new List[1];
                if (JaxWsChildren.this.implClass != null && (javaSource = JavaSource.forFileObject((FileObject)JaxWsChildren.this.implClass)) != null) {
                    CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

                        public void run(CompilationController controller) throws IOException {
                            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                            List publicMethods = JaxWsChildren.this.getPublicMethods(controller, typeElement);
                            ArrayList<ExecutableElement> webMethods = new ArrayList<ExecutableElement>();
                            HashMap<ExecutableElement, AnnotationMirror> webMethodAnnMap = new HashMap<ExecutableElement, AnnotationMirror>();
                            for (ExecutableElement method : publicMethods) {
                                AnnotationMirror webMethodAnn = _RetoucheUtil.getAnnotation(controller, method, "javax.jws.WebMethod");
                                if (webMethodAnn != null) {
                                    boolean exclude = false;
                                    Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = webMethodAnn.getElementValues();
                                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                                        if (!entry.getKey().getSimpleName().contentEquals("exclude")) continue;
                                        Object value = expressions.get(entry.getKey()).getValue();
                                        if (!Boolean.TRUE.equals(value)) break;
                                        exclude = true;
                                        break;
                                    }
                                    if (exclude) continue;
                                    webMethods.add(method);
                                    webMethodAnnMap.put(method, webMethodAnn);
                                    continue;
                                }
                                webMethods.add(method);
                            }
                            ArrayList<WebOperationInfo> webOperations = new ArrayList<WebOperationInfo>();
                            for (ExecutableElement webMethod : webMethods) {
                                TypeMirror returnType;
                                WebOperationInfo webOperation = new WebOperationInfo();
                                AnnotationMirror webMethodAnn = (AnnotationMirror)webMethodAnnMap.get(webMethod);
                                if (webMethodAnn != null) {
                                    Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = webMethodAnn.getElementValues();
                                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                                        if (!entry.getKey().getSimpleName().contentEquals("operationName")) continue;
                                        webOperation.setOperationName((String)expressions.get(entry.getKey()).getValue());
                                    }
                                }
                                if (webOperation.getOperationName() == null) {
                                    webOperation.setOperationName(webMethod.getSimpleName().toString());
                                }
                                if ((returnType = webMethod.getReturnType()) instanceof DeclaredType) {
                                    TypeElement element = (TypeElement)((DeclaredType)returnType).asElement();
                                    webOperation.setReturnType(element.getQualifiedName().toString());
                                } else {
                                    webOperation.setReturnType(returnType.toString());
                                }
                                List<? extends VariableElement> params = webMethod.getParameters();
                                ArrayList<String> paramTypes = new ArrayList<String>();
                                for (VariableElement variableElement : params) {
                                    TypeMirror type = variableElement.asType();
                                    if (type instanceof DeclaredType) {
                                        TypeElement element = (TypeElement)((DeclaredType)type).asElement();
                                        paramTypes.add(element.getQualifiedName().toString());
                                        continue;
                                    }
                                    paramTypes.add(type.toString());
                                }
                                webOperation.setParamTypes(paramTypes);
                                webOperations.add(webOperation);
                            }
                            keys[0] = webOperations;
                        }

                        public void cancel() {
                        }
                    };
                    try {
                        javaSource.runUserActionTask((Task)task, true);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
                if (keys[0] == null) {
                    keys[0] = Collections.emptyList();
                }
                JaxWsChildren.this.setKeys(keys[0]);
            }
        });
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof WebOperationInfo) {
            final WebOperationInfo method = (WebOperationInfo)key;
            AbstractNode n = new AbstractNode(Children.LEAF){

                public Image getIcon(int type) {
                    if (JaxWsChildren.this.cachedIcon == null) {
                        JaxWsChildren.this.cachedIcon = ImageUtilities.loadImage((String)JaxWsChildren.OPERATION_ICON);
                    }
                    return JaxWsChildren.this.cachedIcon;
                }

                public Action[] getActions(boolean context) {
                    return new Action[]{SystemAction.get(PropertiesAction.class)};
                }

                public Action getPreferredAction() {
                    return SystemAction.get(PropertiesAction.class);
                }

                public String getDisplayName() {
                    return method.getOperationName() + ": " + JaxWsChildren.this.getClassName(method.getReturnType());
                }
            };
            StringBuffer buf = new StringBuffer();
            for (String paramType : method.getParamTypes()) {
                buf.append(buf.length() == 0 ? paramType : ", " + paramType);
            }
            n.setShortDescription(NbBundle.getMessage(JaxWsChildren.class, (String)"TXT_operationDesc", (Object)method.getReturnType(), (Object)method.getOperationName(), (Object)buf.toString()));
            return new Node[]{n};
        }
        return new Node[0];
    }

    private String getClassName(String fullClassName) {
        StringTokenizer tok = new StringTokenizer(fullClassName, ".");
        String token = "";
        while (tok.hasMoreTokens()) {
            token = tok.nextToken();
        }
        return token;
    }

    private static class WebOperationInfo {
        private String operationName;
        private List<String> paramTypes;
        private String returnType;

        private WebOperationInfo() {
        }

        String getOperationName() {
            return this.operationName;
        }

        void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        List<String> getParamTypes() {
            return this.paramTypes;
        }

        void setParamTypes(List<String> paramTypes) {
            this.paramTypes = paramTypes;
        }

        String getReturnType() {
            return this.returnType;
        }

        void setReturnType(String returnType) {
            this.returnType = returnType;
        }
    }
}

