/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.driver.Action;
import org.clang.driver.Command;
import org.clang.driver.Driver;
import org.clang.driver.Job;
import org.clang.driver.JobAction;
import org.clang.driver.JobList;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.CompilationStatics;
import org.clang.driver.options;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.DenseMapInfoObject;
import org.llvm.adt.DenseMapInfoPair;
import org.llvm.adt.DenseMapInfoPointer;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.option.ArgStringList;
import org.llvm.option.DerivedArgList;
import org.llvm.option.InputArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.raw_fd_ostream;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;

public class Compilation
implements Destructors.ClassWithDestructor {
    private Driver TheDriver;
    private ToolChain DefaultToolChain;
    private InputArgList Args;
    private DerivedArgList TranslatedArgs;
    private SmallVector<Action> Actions;
    private JobList Jobs;
    private DenseMap<std.pair<ToolChain, char.ptr>, DerivedArgList> TCArgs;
    private ArgStringList TempFiles;
    private DenseMap<JobAction, char.ptr> ResultFiles;
    private DenseMap<JobAction, char.ptr> FailureResultFiles;
    private StringRef[] Redirects;
    private boolean ForDiagnostics;

    public Compilation(Driver D, ToolChain _DefaultToolChain, InputArgList _Args, DerivedArgList _TranslatedArgs) {
        this.TheDriver = D;
        this.DefaultToolChain = _DefaultToolChain;
        this.Args = _Args;
        this.TranslatedArgs = _TranslatedArgs;
        this.Actions = new SmallVector(3, (Object)null);
        this.Jobs = new JobList();
        this.TCArgs = new DenseMap((DenseMapInfo)new DenseMapInfoPair((DenseMapInfo)new DenseMapInfoObject((Object)DummyToolChain.EMPTY, (Object)DummyToolChain.TOMBSTONE), (DenseMapInfo)new DenseMapInfoPointer((void.ptr)NativePointer.EMPTY, (void.ptr)NativePointer.EMPTY_TOMBSTONE)), (Object)null);
        this.TempFiles = new ArgStringList();
        this.ResultFiles = new DenseMap((DenseMapInfo)new DenseMapInfoObject((Object)JobAction.EMPTY, (Object)JobAction.TOMBSTONE), (Object)null);
        this.FailureResultFiles = new DenseMap((DenseMapInfo)new DenseMapInfoObject((Object)JobAction.EMPTY, (Object)JobAction.TOMBSTONE), (Object)null);
        this.Redirects = null;
        this.ForDiagnostics = false;
    }

    public void $destroy() {
        if (this.TranslatedArgs != null) {
            this.TranslatedArgs.$destroy();
        }
        if (this.Args != null) {
            this.Args.$destroy();
        }
        DenseMapIterator it = (DenseMapIterator)Native.$tryClone((NativeCloneable)this.TCArgs.begin());
        DenseMapIterator ie = this.TCArgs.end();
        while (it.$noteq(ie)) {
            if (it.$star().second != this.TranslatedArgs && it.$star().second != null) {
                ((DerivedArgList)it.$star().second).$destroy();
            }
            it.$preInc();
        }
        it = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)this.Actions.begin());
        ie = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)this.Actions.end());
        while (it.$noteq((Object)ie)) {
            if (it.$star() != null) {
                ((Action)it.$star()).$destroy();
            }
            it.$preInc();
        }
        if (this.Redirects != null) {
            Destructors.$destroy((Object)this.Redirects[1]);
            Destructors.$destroy((Object)this.Redirects[2]);
            Destructors.$destroyArray((Object)this.Redirects);
        }
        this.FailureResultFiles.$destroy();
        this.ResultFiles.$destroy();
        this.TempFiles.$destroy();
        this.TCArgs.$destroy();
        this.Jobs.$destroy();
        this.Actions.$destroy();
    }

    public Driver getDriver() {
        return this.TheDriver;
    }

    public ToolChain getDefaultToolChain() {
        return this.DefaultToolChain;
    }

    public InputArgList getInputArgs() {
        return this.Args;
    }

    public DerivedArgList getArgs() {
        return this.TranslatedArgs;
    }

    public SmallVector<Action> getActions() {
        return this.Actions;
    }

    public JobList getJobs() {
        return this.Jobs;
    }

    public void addCommand(std_ptr.unique_ptr<Command> C) {
        this.Jobs.addJob((std_ptr.unique_ptr<Job>)new std_ptr.unique_ptr(std.move(C)));
    }

    public ArgStringList getTempFiles() {
        return this.TempFiles;
    }

    public DenseMap<JobAction, char.ptr> getResultFiles() {
        return this.ResultFiles;
    }

    public DenseMap<JobAction, char.ptr> getFailureResultFiles() {
        return this.FailureResultFiles;
    }

    public StringRef getSysRoot() {
        return new StringRef(this.getDriver().SysRoot);
    }

    public DerivedArgList getArgsForToolChain(ToolChain TC, char.ptr BoundArch) {
        DerivedArgList Entry2;
        if (TC == null) {
            TC = this.DefaultToolChain;
        }
        if ((Entry2 = (DerivedArgList)this.TCArgs.$at((Object)std.make_pair((Object)TC, (Object)BoundArch))) == null && (Entry2 = TC.TranslateArgs(this.TranslatedArgs, BoundArch)) == null) {
            Entry2 = this.TranslatedArgs;
        }
        return Entry2;
    }

    public char.ptr addTempFile(char.ptr Name) {
        this.TempFiles.push_back((Object)Name);
        return Name;
    }

    public char.ptr addResultFile(char.ptr Name, JobAction JA) {
        this.ResultFiles.ref$at((Object)JA).$set((Object)Name);
        return Name;
    }

    public char.ptr addFailureResultFile(char.ptr Name, JobAction JA) {
        this.FailureResultFiles.ref$at((Object)JA).$set((Object)Name);
        return Name;
    }

    public boolean CleanupFile(char.ptr File) {
        return this.CleanupFile(File, false);
    }

    public boolean CleanupFile(char.ptr File, boolean IssueErrors) {
        if (!fs.can_write((Twine)new Twine(File)) || !fs.is_regular_file((Twine)new Twine(File))) {
            return true;
        }
        std_errors.error_code EC = fs.remove((Twine)new Twine(File));
        if (EC.$boolean()) {
            if (IssueErrors) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(348L), (StringRef)new StringRef(EC.message())).$destroy();
            }
            return false;
        }
        return true;
    }

    public boolean CleanupFileList(ArgStringList Files) {
        return this.CleanupFileList(Files, false);
    }

    public boolean CleanupFileList(ArgStringList Files, boolean IssueErrors) {
        boolean Success = true;
        SmallVectorImpl.iterator it = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)Files.begin());
        SmallVectorImpl.iterator ie = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)Files.end());
        while (it.$noteq((Object)ie)) {
            Success &= this.CleanupFile((char.ptr)it.$star(), IssueErrors);
            it.$preInc();
        }
        return Success;
    }

    public boolean CleanupFileMap(DenseMap<JobAction, char.ptr> Files, JobAction JA) {
        return this.CleanupFileMap(Files, JA, false);
    }

    public boolean CleanupFileMap(DenseMap<JobAction, char.ptr> Files, JobAction JA, boolean IssueErrors) {
        boolean Success = true;
        DenseMapIterator it = Files.begin();
        DenseMapIterator ie = Files.end();
        while (it.$noteq(ie)) {
            if (JA == null || it.$star().first == JA) {
                Success &= this.CleanupFile((char.ptr)it.$star().second, IssueErrors);
            }
            it.$preInc();
        }
        return Success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ExecuteCommand(Command C, type.ref<Command> FailingCommand) {
        std.string Error2 = null;
        try {
            if ((this.getDriver().CCPrintOptions || this.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_v.getValue()))) && !this.getDriver().CCGenDiagnostics) {
                raw_ostream OS = llvm.errs();
                if (this.getDriver().CCPrintOptions && this.getDriver().CCPrintOptionsFilename != null) {
                    std_errors.error_code EC = new std_errors.error_code();
                    OS = new raw_fd_ostream(new StringRef(this.getDriver().CCPrintOptionsFilename), EC, fs.$bitor_OpenFlags((fs.OpenFlags)fs.OpenFlags.F_Append, (fs.OpenFlags)fs.OpenFlags.F_Text));
                    if (EC.$boolean()) {
                        ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(308L), (StringRef)new StringRef(EC.message())).$destroy();
                        FailingCommand.$set((Object)C);
                        if (OS != null) {
                            OS.$destroy();
                        }
                        int n = 1;
                        return n;
                    }
                }
                if (this.getDriver().CCPrintOptions) {
                    OS.$out(NativePointer.$((String)"[Logging clang options]"));
                }
                C.Print(OS, NativePointer.$((String)"\n"), this.getDriver().CCPrintOptions);
                if (OS != llvm.errs() && OS != null) {
                    OS.$destroy();
                }
            }
            Error2 = new std.string();
            bool.ptr ExecutionFailed = NativePointer.create_bool$ptr((boolean)false);
            int Res = C.Execute(this.Redirects, Error2, ExecutionFailed);
            if (!Error2.empty()) {
                assert (Res != 0) : "Error string set with 0 result code!";
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(313L), (StringRef)new StringRef(Error2)).$destroy();
            }
            if (Res != 0) {
                FailingCommand.$set((Object)C);
            }
            int n = ExecutionFailed.$star() ? 1 : Res;
            return n;
        }
        finally {
            if (Error2 != null) {
                Error2.$destroy();
            }
        }
    }

    public void ExecuteJob(Job J, SmallVectorImpl<std.pairIntType<Command>> FailingCommands) {
        Command C = (Command)Casts.dyn_cast(Command.class, (Object)J);
        if (C != null) {
            if (!CompilationStatics.InputsOk(C, FailingCommands)) {
                return;
            }
            type.ref FailingCommand = NativePointer.create_type$ref(null);
            int Res = this.ExecuteCommand(C, (type.ref<Command>)FailingCommand);
            if (Res != 0) {
                FailingCommands.push_back((Object)std.make_pair_int_T((int)Res, (Object)FailingCommand.$deref()));
            }
        } else {
            JobList Jobs = (JobList)llvm.cast(JobList.class, (Object)J);
            for (Job Job2 : Jobs) {
                this.ExecuteJob(Job2, FailingCommands);
            }
        }
    }

    public void initCompilationForDiagnostics() {
        this.ForDiagnostics = true;
        llvm.DeleteContainerPointers(this.Actions);
        this.Jobs.clear();
        this.TempFiles.clear();
        this.ResultFiles.clear();
        this.FailureResultFiles.clear();
        Object[] OutputOpts = new OptSpecifier[]{new OptSpecifier((long)options.ID.OPT_o.getValue()), new OptSpecifier((long)options.ID.OPT_MD.getValue()), new OptSpecifier((long)options.ID.OPT_MMD.getValue())};
        long e = llvm.array_lengthof((Object[])OutputOpts);
        for (long i = 0L; i != e; ++i) {
            if (!this.TranslatedArgs.hasArg((OptSpecifier)OutputOpts[(int)i])) continue;
            this.TranslatedArgs.eraseArg((OptSpecifier)OutputOpts[(int)i]);
        }
        this.TranslatedArgs.ClaimAllArgs();
        this.Redirects = new StringRef[3];
        this.Redirects[0] = null;
        this.Redirects[1] = new StringRef();
        this.Redirects[2] = new StringRef();
    }

    public boolean isForDiagnostics() {
        return this.ForDiagnostics;
    }

    public String toString() {
        return "TheDriver=" + this.TheDriver + ", DefaultToolChain=" + this.DefaultToolChain + ", Args=" + this.Args + ", TranslatedArgs=" + this.TranslatedArgs + ", Actions=" + this.Actions + ", Jobs=" + this.Jobs + ", TCArgs=" + this.TCArgs + ", TempFiles=" + this.TempFiles + ", ResultFiles=" + this.ResultFiles + ", FailureResultFiles=" + this.FailureResultFiles + ", Redirects=" + this.Redirects + ", ForDiagnostics=" + this.ForDiagnostics;
    }

    private static class DummyToolChain
    extends ToolChain {
        private static final DummyToolChain EMPTY = new DummyToolChain();
        private static final DummyToolChain TOMBSTONE = new DummyToolChain();

        private DummyToolChain() {
        }

        @Override
        public boolean isPICDefault() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean isPIEDefault() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean isPICDefaultForced() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

