/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver;

import java.util.Iterator;
import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticErrorTrap;
import org.clang.basic.DiagnosticsEngine;
import org.clang.driver.Action;
import org.clang.driver.AnalyzeJobAction;
import org.clang.driver.AssembleJobAction;
import org.clang.driver.BackendJobAction;
import org.clang.driver.BindArchAction;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.CompileJobAction;
import org.clang.driver.CrashReportInfo;
import org.clang.driver.DriverGlobals;
import org.clang.driver.DsymutilJobAction;
import org.clang.driver.InputAction;
import org.clang.driver.Job;
import org.clang.driver.JobAction;
import org.clang.driver.JobList;
import org.clang.driver.LinkJobAction;
import org.clang.driver.LipoJobAction;
import org.clang.driver.MigrateJobAction;
import org.clang.driver.Multilib;
import org.clang.driver.MultilibSet;
import org.clang.driver.PrecompileJobAction;
import org.clang.driver.PreprocessJobAction;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.VerifyDebugInfoJobAction;
import org.clang.driver.VerifyJobAction;
import org.clang.driver.VerifyPCHJobAction;
import org.clang.driver.impl.DriverStatics;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.toolchains;
import org.clang.driver.options;
import org.clang.driver.phases;
import org.clang.driver.tools.impl.darwin;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSet;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMap;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.DerivedArgList;
import org.llvm.option.InputArgList;
import org.llvm.option.OptGlobals;
import org.llvm.option.OptSpecifier;
import org.llvm.option.OptTable;
import org.llvm.option.Option;
import org.llvm.option.arg_iterator;
import org.llvm.support.MallocAllocator;
import org.llvm.support.PrettyStackTraceString;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_fd_ostream;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.llvm.support.sys.sys;

public class Driver
implements Destructors.ClassWithDestructor {
    private OptTable Opts = DriverGlobals.createDriverOptTable();
    private DiagnosticsEngine Diags;
    private DriverMode Mode;
    public std.string Name;
    public std.string Dir;
    public std.string ClangExecutable;
    public std.string InstalledDir;
    public std.string ResourceDir;
    public SmallVector<std.string> PrefixDirs;
    public std.string SysRoot;
    public std.string DyldPrefix;
    public boolean UseStdLib;
    public std.string DefaultTargetTriple;
    public std.string DriverTitle;
    public std.string HostBits;
    public std.string HostMachine;
    public std.string HostSystem;
    public std.string HostRelease;
    public char.ptr CCPrintOptionsFilename;
    public char.ptr CCPrintHeadersFilename;
    public char.ptr CCLogDiagnosticsFilename;
    public boolean CCCPrintBindings;
    public boolean CCPrintOptions;
    public boolean CCPrintHeaders;
    public boolean CCLogDiagnostics;
    public boolean CCGenDiagnostics;
    private std.string CCCGenericGCCName;
    private boolean CheckInputsExist;
    public boolean CCCUsePCH;
    private boolean SuppressMissingInputWarning;
    private std.list<std.string> TempFiles;
    private std.list<std.string> ResultFiles;
    private StringMap<ToolChain, MallocAllocator> ToolChains;

    public DiagnosticBuilder Diag(long DiagID) {
        return this.Diags.Report(DiagID);
    }

    public boolean CCCIsCXX() {
        return this.Mode == DriverMode.GXXMode;
    }

    public boolean CCCIsCPP() {
        return this.Mode == DriverMode.CPPMode;
    }

    public boolean IsCLMode() {
        return this.Mode == DriverMode.CLMode;
    }

    private DerivedArgList TranslateInputArgs(InputArgList Args) {
        DerivedArgList DAL = new DerivedArgList(Args);
        boolean HasNostdlib = Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue()));
        for (Arg A : Args) {
            long e;
            if ((A.getOption().matches(new OptSpecifier((long)options.ID.OPT_Wl_COMMA.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_Xlinker.getValue()))) && A.containsValue(new StringRef(NativePointer.$((String)"--no-demangle")))) {
                DAL.AddFlagArg(A, this.Opts.getOption(new OptSpecifier((long)options.ID.OPT_Z_Xlinker__no_demangle.getValue())));
                e = A.getNumValues();
                for (long i = 0L; i != e; ++i) {
                    if (!llvm.$noteq_StringRef((StringRef)new StringRef(A.getValue(i)), (StringRef)new StringRef(NativePointer.$((String)"--no-demangle")))) continue;
                    DAL.AddSeparateArg(A, this.Opts.getOption(new OptSpecifier((long)options.ID.OPT_Xlinker.getValue())), new StringRef(A.getValue(i)));
                }
                continue;
            }
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_Wp_COMMA.getValue())) && (llvm.$eq_StringRef((StringRef)new StringRef(A.getValue(0L)), (CharSequence)"-MD") || llvm.$eq_StringRef((StringRef)new StringRef(A.getValue(0L)), (CharSequence)"-MMD"))) {
                if (llvm.$eq_StringRef((StringRef)new StringRef(A.getValue(0L)), (CharSequence)"-MD")) {
                    DAL.AddFlagArg(A, this.Opts.getOption(new OptSpecifier((long)options.ID.OPT_MD.getValue())));
                } else {
                    DAL.AddFlagArg(A, this.Opts.getOption(new OptSpecifier((long)options.ID.OPT_MMD.getValue())));
                }
                if (A.getNumValues() != 2L) continue;
                DAL.AddSeparateArg(A, this.Opts.getOption(new OptSpecifier((long)options.ID.OPT_MF.getValue())), new StringRef(A.getValue(1L)));
                continue;
            }
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_l.getValue()))) {
                StringRef Value = new StringRef(A.getValue());
                if (!HasNostdlib && llvm.$eq_StringRef((StringRef)Value, (CharSequence)"stdc++")) {
                    DAL.AddFlagArg(A, this.Opts.getOption(new OptSpecifier((long)options.ID.OPT_Z_reserved_lib_stdcxx.getValue())));
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)Value, (CharSequence)"cc_kext")) {
                    DAL.AddFlagArg(A, this.Opts.getOption(new OptSpecifier((long)options.ID.OPT_Z_reserved_lib_cckext.getValue())));
                    continue;
                }
            }
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT__DASH_DASH.getValue()))) {
                A.claim();
                e = A.getNumValues();
                for (long i = 0L; i != e; ++i) {
                    DAL.append(DriverStatics.MakeInputArg(DAL, this.Opts, new StringRef(A.getValue(i))));
                }
                continue;
            }
            DAL.append(A);
        }
        if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_mlinker_version_EQ.getValue()))) {
            DAL.AddJoinedArg(null, this.Opts.getOption(new OptSpecifier((long)options.ID.OPT_mlinker_version_EQ.getValue())), new StringRef(NativePointer.$((String)"2.22")));
            DAL.getLastArg(new OptSpecifier((long)options.ID.OPT_mlinker_version_EQ.getValue())).claim();
        }
        return DAL;
    }

    private phases.ID getFinalPhase(DerivedArgList DAL) {
        return this.getFinalPhase(DAL, null);
    }

    private phases.ID getFinalPhase(DerivedArgList DAL, type.ptr<Arg> FinalPhaseArg) {
        Arg PhaseArg = null;
        phases.ID FinalPhase = this.CCCIsCPP() || (PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT_E.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_EP.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT_M.getValue()), new OptSpecifier((long)options.ID.OPT_MM.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_P.getValue()))) != null ? phases.ID.Preprocess : ((PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT_fsyntax_only.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT_module_file_info.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT_verify_pch.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT_rewrite_objc.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT_rewrite_legacy_objc.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT__migrate.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT__analyze.getValue()), new OptSpecifier((long)options.ID.OPT__analyze_auto.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT_emit_ast.getValue()))) != null ? phases.ID.Compile : ((PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT_S.getValue()))) != null ? phases.ID.Backend : ((PhaseArg = DAL.getLastArg(new OptSpecifier((long)options.ID.OPT_c.getValue()))) != null ? phases.ID.Assemble : phases.ID.Link)));
        if (FinalPhaseArg != null) {
            FinalPhaseArg.$set(PhaseArg);
        }
        return FinalPhase;
    }

    private void setUpResponseFiles(Compilation C, Job J) {
        JobList Jobs = (JobList)Casts.dyn_cast(JobList.class, (Object)J);
        if (Jobs != null) {
            for (Job Job2 : Jobs) {
                this.setUpResponseFiles(C, Job2);
            }
            return;
        }
        Command CurCommand = (Command)Casts.dyn_cast(Command.class, (Object)J);
        if (CurCommand == null) {
            return;
        }
        if (CurCommand.getCreator().getResponseFilesSupport() == Tool.ResponseFileSupport.RF_None || sys.argumentsFitWithinSystemLimits((ArrayRef)new ArrayRef((SmallVectorImpl)CurCommand.getArguments()))) {
            return;
        }
        std.string TmpName = this.GetTemporaryPath(new StringRef(NativePointer.$((String)"response")), NativePointer.$((String)"txt"));
        CurCommand.setResponseFile(C.addTempFile(C.getArgs().MakeArgString(TmpName.c_str())));
    }

    private void generatePrefixedToolNames(char.ptr Tool2, ToolChain TC, SmallVectorImpl<std.string> Names) {
        Names.push_back((Object)std.$plus_str_T((std.string)std.$plus_str_T((std.string)this.DefaultTargetTriple, (char.iterator)NativePointer.$((String)"-")), (char.iterator)Tool2));
        Names.push_back((Object)new std.string(Tool2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Driver(StringRef ClangExecutable, StringRef DefaultTargetTriple, DiagnosticsEngine Diags) {
        this.Diags = Diags;
        this.Mode = DriverMode.GCCMode;
        this.Name = new std.string();
        this.Dir = new std.string();
        this.ClangExecutable = new std.string(ClangExecutable.$basic_string());
        this.InstalledDir = new std.string();
        this.ResourceDir = new std.string();
        this.PrefixDirs = new SmallVector(4, (Object)new std.string());
        this.SysRoot = new std.string(NativePointer.$((String)""));
        this.DyldPrefix = new std.string();
        this.UseStdLib = true;
        this.DefaultTargetTriple = new std.string(DefaultTargetTriple.$basic_string());
        this.DriverTitle = new std.string(NativePointer.$((String)"clang LLVM compiler"));
        this.HostBits = new std.string();
        this.HostMachine = new std.string();
        this.HostSystem = new std.string();
        this.HostRelease = new std.string();
        this.CCPrintOptionsFilename = null;
        this.CCPrintHeadersFilename = null;
        this.CCLogDiagnosticsFilename = null;
        this.CCCPrintBindings = false;
        this.CCPrintHeaders = false;
        this.CCLogDiagnostics = false;
        this.CCGenDiagnostics = false;
        this.CCCGenericGCCName = new std.string(NativePointer.$((String)""));
        this.CheckInputsExist = true;
        this.CCCUsePCH = true;
        this.SuppressMissingInputWarning = false;
        this.TempFiles = new std.list();
        this.ResultFiles = new std.list();
        this.ToolChains = new StringMap(null);
        SmallString P = null;
        try {
            this.Name.$assign(path.stem((StringRef)ClangExecutable).$basic_string());
            this.Dir.$assign(path.parent_path((StringRef)ClangExecutable).$basic_string());
            StringRef ClangResourceDir = StringRef.EMPTY;
            P = new SmallString(new StringRef(this.Dir), 128);
            if (llvm.$noteq_StringRef((StringRef)ClangResourceDir, (StringRef)StringRef.EMPTY)) {
                path.append((SmallString)P, (StringRef)ClangResourceDir);
            } else {
                StringRef ClangLibdirSuffix = StringRef.EMPTY;
                path.append((SmallString)P, (Twine)new Twine(NativePointer.$((String)"..")), (Twine)llvm.$plus_Twine((Twine)new Twine(NativePointer.$((String)"lib")), (Twine)new Twine(ClangLibdirSuffix)), (Twine)new Twine(NativePointer.$((String)"clang")), (Twine)new Twine(NativePointer.$((String)"3.6.0")));
            }
            this.ResourceDir.$assign(P.str().$basic_string());
        }
        finally {
            if (P != null) {
                P.$destroy();
            }
        }
    }

    public void $destroy() {
        if (this.Opts != null) {
            this.Opts.$destroy();
        }
        llvm.DeleteContainerSeconds(this.ToolChains);
        this.ToolChains.$destroy();
        this.ResultFiles.$destroy();
        this.TempFiles.$destroy();
        this.CCCGenericGCCName.$destroy();
        this.HostRelease.$destroy();
        this.HostSystem.$destroy();
        this.HostMachine.$destroy();
        this.HostBits.$destroy();
        this.DriverTitle.$destroy();
        this.DefaultTargetTriple.$destroy();
        this.DyldPrefix.$destroy();
        this.SysRoot.$destroy();
        this.PrefixDirs.$destroy();
        this.ResourceDir.$destroy();
        this.InstalledDir.$destroy();
        this.ClangExecutable.$destroy();
        this.Dir.$destroy();
        this.Name.$destroy();
    }

    public std.string getCCCGenericGCCName() {
        return this.CCCGenericGCCName;
    }

    public OptTable getOpts() {
        return this.Opts;
    }

    public DiagnosticsEngine getDiags() {
        return this.Diags;
    }

    public boolean getCheckInputsExist() {
        return this.CheckInputsExist;
    }

    public void setCheckInputsExist(boolean Value) {
        this.CheckInputsExist = Value;
    }

    public std.string getTitle() {
        return this.DriverTitle;
    }

    public void setTitle(std.string Value) {
        this.DriverTitle.$assign(Value);
    }

    public char.ptr getClangProgramPath() {
        return this.ClangExecutable.c_str();
    }

    public char.ptr getInstalledDir() {
        if (!this.InstalledDir.empty()) {
            return this.InstalledDir.c_str();
        }
        return this.Dir.c_str();
    }

    public void setInstalledDir(StringRef Value) {
        this.InstalledDir.$assign(Value.$basic_string());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Compilation BuildCompilation(ArrayRef<char.ptr> ArgList2) {
        PrettyStackTraceString CrashInfo = null;
        SmallVector Inputs = null;
        try {
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Compilation construction"));
            char.ptr env = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"COMPILER_PATH")));
            if (env != null) {
                StringRef CompilerPath = new StringRef(env);
                while (!CompilerPath.empty()) {
                    std.pair Split = CompilerPath.split(sys.EnvPathSeparator);
                    this.PrefixDirs.push_back((Object)((StringRef)Split.first).$basic_string());
                    CompilerPath.$assign((StringRef)Split.second);
                }
            }
            this.ParseDriverMode((ArrayRef<char.ptr>)ArgList2.slice(1));
            InputArgList Args = this.ParseArgStrings((ArrayRef<char.ptr>)ArgList2.slice(1));
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_no_canonical_prefixes.getValue()));
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_pipe.getValue()));
            boolean CCCPrintActions = Args.hasArg(new OptSpecifier((long)options.ID.OPT_ccc_print_phases.getValue()));
            this.CCCPrintBindings = Args.hasArg(new OptSpecifier((long)options.ID.OPT_ccc_print_bindings.getValue()));
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ccc_gcc_name.getValue()));
            if (A != null) {
                this.CCCGenericGCCName.$assign(A.getValue());
            }
            this.CCCUsePCH = Args.hasFlag(new OptSpecifier((long)options.ID.OPT_ccc_pch_is_pch.getValue()), new OptSpecifier((long)options.ID.OPT_ccc_pch_is_pth.getValue()));
            if (this.IsCLMode()) {
                Triple T = null;
                try {
                    T = new Triple(new Twine(this.DefaultTargetTriple));
                    T.setOS(Triple.OSType.Win32);
                    T.setEnvironment(Triple.EnvironmentType.MSVC);
                    this.DefaultTargetTriple.$assign(T.str());
                }
                finally {
                    if (T != null) {
                        T.$destroy();
                    }
                }
            }
            if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_target.getValue()))) != null) {
                this.DefaultTargetTriple.$assign(A.getValue());
            }
            if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_ccc_install_dir.getValue()))) != null) {
                this.Dir.$assign(this.InstalledDir.$assign(A.getValue()));
            }
            arg_iterator it = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT_B.getValue()));
            arg_iterator ie = Args.filtered_end();
            while (OptGlobals.$noteq_arg_iterator((arg_iterator)it, (arg_iterator)ie)) {
                Arg A2 = it.$star();
                A2.claim();
                this.PrefixDirs.push_back((Object)new std.string(A2.getValue(0L)));
                it.$preInc();
            }
            A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__sysroot_EQ.getValue()));
            if (A != null) {
                this.SysRoot.$assign(A.getValue());
            }
            if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__dyld_prefix_EQ.getValue()))) != null) {
                this.DyldPrefix.$assign(A.getValue());
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue()))) {
                this.UseStdLib = false;
            }
            if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_resource_dir.getValue()))) != null) {
                this.ResourceDir.$assign(A.getValue());
            }
            DerivedArgList TranslatedArgs = this.TranslateInputArgs(Args);
            ToolChain TC = this.getToolChain((ArgList)Args);
            Compilation C = new Compilation(this, TC, Args, TranslatedArgs);
            if (!this.HandleImmediateArgs(C)) {
                Compilation compilation = C;
                return compilation;
            }
            Inputs = new SmallVector(16, (Object)new std.pair((Object)types.ID.TY_INVALID, null));
            this.BuildInputs(C.getDefaultToolChain(), TranslatedArgs, (SmallVector<std.pair<types.ID, Arg>>)Inputs);
            if (TC.getTriple().isOSBinFormatMachO()) {
                this.BuildUniversalActions(C.getDefaultToolChain(), C.getArgs(), (SmallVector<std.pair<types.ID, Arg>>)Inputs, C.getActions());
            } else {
                this.BuildActions(C.getDefaultToolChain(), C.getArgs(), (SmallVector<std.pair<types.ID, Arg>>)Inputs, C.getActions());
            }
            if (CCCPrintActions) {
                this.PrintActions(C);
                Compilation compilation = C;
                return compilation;
            }
            this.BuildJobs(C);
            Compilation compilation = C;
            return compilation;
        }
        finally {
            if (Inputs != null) {
                Inputs.$destroy();
            }
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    public void ParseDriverMode(ArrayRef<char.ptr> Args) {
        std.string OptName = this.getOpts().getOption(new OptSpecifier((long)options.ID.OPT_driver_mode.getValue())).getPrefixedName();
        int E = Args.size();
        for (int I = 0; I != E; ++I) {
            StringRef Arg2;
            if (Args.$at(I) == null || !(Arg2 = new StringRef((char.ptr)Args.$at(I))).startswith(new StringRef(OptName))) continue;
            StringRef Value = Arg2.drop_front(OptName.size());
            int M = (Integer)new StringSwitch(Value).Case((CharSequence)"gcc", (Object)DriverMode.GCCMode.getValue()).Case((CharSequence)"g++", (Object)DriverMode.GXXMode.getValue()).Case((CharSequence)"cpp", (Object)DriverMode.CPPMode.getValue()).Case((CharSequence)"cl", (Object)DriverMode.CLMode.getValue()).Default((Object)-1);
            if ((long)M != -1L) {
                this.Mode = DriverMode.valueOf(M);
                continue;
            }
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(356L), (StringRef)new StringRef(OptName)), (StringRef)Value).$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputArgList ParseArgStrings(ArrayRef<char.ptr> ArgStrings) {
        PrettyStackTraceString CrashInfo = null;
        try {
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Command line argument parsing"));
            std.pairUIntUInt includeExcludeOptionFlagMasks = this.getIncludeExcludeOptionFlagMasks();
            long IncludedFlagsBitmask = includeExcludeOptionFlagMasks.first;
            long ExcludedFlagsBitmask = includeExcludeOptionFlagMasks.second;
            uint.ref MissingArgIndex = NativePointer.create_uint$ref((long)0L);
            uint.ref MissingArgCount = NativePointer.create_uint$ref((long)0L);
            InputArgList Args = this.getOpts().ParseArgs(ArgStrings.begin(), ArgStrings.end(), MissingArgIndex, MissingArgCount, IncludedFlagsBitmask, ExcludedFlagsBitmask);
            if (MissingArgCount.$deref() != 0L) {
                ClangGlobals.$out_DiagnosticBuilder_uint((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(335L), (char.ptr)Args.getArgString(MissingArgIndex.$deref())), (long)MissingArgCount.$deref()).$destroy();
            }
            for (Arg A : Args) {
                if (A.getOption().hasFlag(128L)) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(354L), (StringRef)new StringRef(A.getAsString((ArgList)Args))).$destroy();
                    continue;
                }
                if (!A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue())) || !A.containsValue(StringRef.EMPTY)) continue;
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(369L), (StringRef)new StringRef(A.getAsString((ArgList)Args))).$destroy();
            }
            arg_iterator it = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT_UNKNOWN.getValue()));
            arg_iterator ie = Args.filtered_end();
            while (OptGlobals.$noteq_arg_iterator((arg_iterator)it, (arg_iterator)ie)) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diags.Report(349L), (StringRef)new StringRef(it.$star().getAsString((ArgList)Args))).$destroy();
                it.$preInc();
            }
            Iterator iterator2 = Args;
            return iterator2;
        }
        finally {
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    public void BuildInputs(ToolChain TC, DerivedArgList Args, SmallVector<std.pair<types.ID, Arg>> Inputs) {
        types.ID InputType = types.ID.TY_Nothing;
        Arg InputTypeArg = null;
        Arg TCTP = Args.getLastArgNoClaim(new OptSpecifier((long)options.ID.OPT__SLASH_TC.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_TP.getValue()));
        if (TCTP != null) {
            InputTypeArg = TCTP;
            InputType = TCTP.getOption().matches(new OptSpecifier((long)options.ID.OPT__SLASH_TC.getValue())) ? types.ID.TY_C : types.ID.TY_CXX;
            arg_iterator it = Args.filtered_begin(new OptSpecifier((long)options.ID.OPT__SLASH_TC.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_TP.getValue()));
            arg_iterator ie = Args.filtered_end();
            Arg Previous = it.$postInc().$star();
            boolean ShowNote = false;
            while (OptGlobals.$noteq_arg_iterator((arg_iterator)it, (arg_iterator)ie)) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(375L), (StringRef)Previous.getSpelling()), (StringRef)it.$star().getSpelling()).$destroy();
                Previous = it.$postInc().$star();
                ShowNote = true;
            }
            if (ShowNote) {
                this.Diag(363L).$destroy();
            }
            assert (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_x.getValue()))) : "-x and /TC or /TP is not allowed";
        }
        for (Arg A : Args) {
            Arg InputArg;
            char.ptr Value;
            if (A.getOption().getKind() == Option.OptionClass.InputClass) {
                Value = Native.$tryClone((char.ptr)A.getValue());
                types.ID Ty = types.ID.TY_INVALID;
                if (InputType == types.ID.TY_Nothing) {
                    if (InputTypeArg != null) {
                        InputTypeArg.claim();
                    }
                    if (std.memcmp((char.ptr)Value, (char.ptr)NativePointer.$((String)"-"), (int)2) == 0) {
                        if (!Args.hasArgNoClaim(new OptSpecifier((long)options.ID.OPT_E.getValue())) && !this.CCCIsCPP()) {
                            this.Diag(this.IsCLMode() ? 353L : 352L).$destroy();
                        }
                        Ty = types.ID.TY_C;
                    } else {
                        char.ptr Ext = Native.$tryClone((char.ptr)std.strrchr((char.ptr)Value, (char)'.'));
                        if (Ext != null) {
                            Ty = TC.LookupTypeForExtension((char.ptr)Ext.$add(1));
                        }
                        if (Ty == types.ID.TY_INVALID) {
                            Ty = this.CCCIsCPP() ? types.ID.TY_C : types.ID.TY_Object;
                        }
                        if (this.CCCIsCXX()) {
                            types.ID OldTy = Ty;
                            if ((Ty = types.lookupCXXTypeForCType(Ty)) != OldTy) {
                                ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(378L), (char.ptr)types.getTypeName(OldTy)), (char.ptr)types.getTypeName(Ty)).$destroy();
                            }
                        }
                    }
                    if (Ty != types.ID.TY_Object) {
                        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_ObjC.getValue()))) {
                            Ty = types.ID.TY_ObjC;
                        } else if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_ObjCXX.getValue()))) {
                            Ty = types.ID.TY_ObjCXX;
                        }
                    }
                } else {
                    char.ptr Ext;
                    assert (InputTypeArg != null) : "InputType set w/o InputTypeArg";
                    if (!InputTypeArg.getOption().matches(new OptSpecifier((long)options.ID.OPT_x.getValue())) && (Ext = Native.$tryClone((char.ptr)std.strrchr((char.ptr)Value, (byte)NativePointer.$((char)'.')))) != null && TC.LookupTypeForExtension((char.ptr)Ext.$add(1)) == types.ID.TY_Object) {
                        Ty = types.ID.TY_Object;
                    }
                    if (Ty == types.ID.TY_INVALID) {
                        Ty = InputType;
                        InputTypeArg.claim();
                    }
                }
                if (!DriverStatics.DiagnoseInputExistence(this, Args, new StringRef(Value))) continue;
                Inputs.push_back((Object)new std.pair(std.make_pair((Object)((Object)Ty), (Object)A)));
                continue;
            }
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT__SLASH_Tc.getValue()))) {
                Value = new StringRef(A.getValue());
                if (DriverStatics.DiagnoseInputExistence(this, Args, (StringRef)Value)) {
                    InputArg = DriverStatics.MakeInputArg(Args, this.Opts, new StringRef(A.getValue()));
                    Inputs.push_back((Object)new std.pair(std.make_pair((Object)((Object)types.ID.TY_C), (Object)InputArg)));
                }
                A.claim();
                continue;
            }
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT__SLASH_Tp.getValue()))) {
                Value = new StringRef(A.getValue());
                if (DriverStatics.DiagnoseInputExistence(this, Args, (StringRef)Value)) {
                    InputArg = DriverStatics.MakeInputArg(Args, this.Opts, new StringRef(A.getValue()));
                    Inputs.push_back((Object)new std.pair(std.make_pair((Object)((Object)types.ID.TY_CXX), (Object)InputArg)));
                }
                A.claim();
                continue;
            }
            if (A.getOption().hasFlag(32L)) {
                Inputs.push_back((Object)new std.pair(std.make_pair((Object)((Object)types.ID.TY_Object), (Object)A)));
                continue;
            }
            if (!A.getOption().matches(new OptSpecifier((long)options.ID.OPT_x.getValue()))) continue;
            InputTypeArg = A;
            InputType = types.lookupTypeForTypeSpecifier(A.getValue());
            A.claim();
            if (InputType.getValue() != 0) continue;
            ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(350L), (char.ptr)A.getValue()).$destroy();
            InputType = types.ID.TY_Object;
        }
        if (this.CCCIsCPP() && Inputs.empty()) {
            Arg A = DriverStatics.MakeInputArg(Args, this.Opts, StringRef.MINUS);
            Inputs.push_back((Object)new std.pair(std.make_pair((Object)((Object)types.ID.TY_C), (Object)A)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BuildActions(ToolChain TC, DerivedArgList Args, SmallVector<std.pair<types.ID, Arg>> Inputs, SmallVector<Action> Actions) {
        PrettyStackTraceString CrashInfo = null;
        SmallVector LinkerInputs = null;
        SmallVector PL = null;
        try {
            StringRef V;
            Arg A;
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Building compilation actions"));
            if (!this.SuppressMissingInputWarning && Inputs.empty()) {
                this.Diag(338L).$destroy();
                return;
            }
            type.ptr FinalPhaseArgPtr = NativePointer.create_type$ptr((Object)null);
            phases.ID FinalPhase = this.getFinalPhase(Args, (type.ptr<Arg>)FinalPhaseArgPtr);
            Arg FinalPhaseArg = (Arg)FinalPhaseArgPtr.$star();
            if (FinalPhase == phases.ID.Link && Args.hasArg(new OptSpecifier((long)options.ID.OPT_emit_llvm.getValue()))) {
                this.Diag(315L).$destroy();
            }
            if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_Z_Joined.getValue()))) != null) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(358L), (StringRef)new StringRef(A.getAsString((ArgList)Args))).$destroy();
            }
            if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_Fo.getValue()))) != null) {
                V = new StringRef(A.getValue());
                if (Inputs.size() > 1 && !V.empty() && !path.is_separator((byte)V.back())) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(345L), (StringRef)A.getSpelling()), (StringRef)new StringRef(V)).$destroy();
                    Args.eraseArg(new OptSpecifier((long)options.ID.OPT__SLASH_Fo.getValue()));
                }
            }
            if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_Fa.getValue()))) != null) {
                V = new StringRef(A.getValue());
                if (Inputs.size() > 1 && !V.empty() && !path.is_separator((byte)V.back())) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(345L), (StringRef)A.getSpelling()), (StringRef)new StringRef(V)).$destroy();
                    Args.eraseArg(new OptSpecifier((long)options.ID.OPT__SLASH_Fa.getValue()));
                }
            }
            if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_o.getValue()))) != null && A.getValue().$at(0) == NativePointer.$((char)'\u0000')) {
                ClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(335L), (StringRef)A.getSpelling()), (int)1).$destroy();
                Args.eraseArg(new OptSpecifier((long)options.ID.OPT__SLASH_o.getValue()));
            }
            LinkerInputs = new SmallVector(3, (Object)null);
            PL = new SmallVector(phases.MaxNumberOfPhases);
            long e = Inputs.size();
            for (long i = 0L; i != e; ++i) {
                std_ptr.unique_ptr Current = null;
                try {
                    phases.ID Phase;
                    types.ID InputType = (types.ID)((Object)((std.pair)Inputs.$at((long)i)).first);
                    Arg InputArg = (Arg)((std.pair)Inputs.$at((long)i)).second;
                    PL.clear();
                    types.getCompilationPhases(InputType, (SmallVectorImpl<phases.ID>)PL);
                    phases.ID InitialPhase = (phases.ID)((Object)PL.$at(0));
                    if (InitialPhase.getValue() > FinalPhase.getValue()) {
                        InputArg.claim();
                        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_Qunused_arguments.getValue()))) continue;
                        if (this.CCCIsCPP()) {
                            ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(371L), (StringRef)new StringRef(InputArg.getAsString((ArgList)Args))), (char.ptr)phases.getPhaseName(InitialPhase)).$destroy();
                            continue;
                        }
                        if (InitialPhase == phases.ID.Compile && FinalPhase == phases.ID.Preprocess && types.getPreprocessedType(InputType) == types.ID.TY_INVALID) {
                            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_T((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(377L), (StringRef)new StringRef(InputArg.getAsString((ArgList)Args))), (FinalPhaseArg != null ? 1 : 0) != 0), (StringRef)(FinalPhaseArg != null ? FinalPhaseArg.getOption().getName() : StringRef.EMPTY)).$destroy();
                            continue;
                        }
                        ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_T((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(370L), (StringRef)new StringRef(InputArg.getAsString((ArgList)Args))), (char.ptr)phases.getPhaseName(InitialPhase)), (FinalPhaseArg != null ? 1 : 0) != 0), (StringRef)(FinalPhaseArg != null ? FinalPhaseArg.getOption().getName() : StringRef.EMPTY)).$destroy();
                        continue;
                    }
                    Current = new std_ptr.unique_ptr((Object)new InputAction(InputArg, InputType));
                    SmallVectorImpl.iterator _i = PL.begin();
                    SmallVectorImpl.iterator _e = PL.end();
                    while (_i.$noteq((Object)_e) && (Phase = (phases.ID)((Object)_i.$star())).getValue() <= FinalPhase.getValue()) {
                        if (Phase == phases.ID.Link) {
                            assert (_i.$add(1).$eq((Object)_e)) : "linking must be final compilation step.";
                            LinkerInputs.push_back(Current.release());
                            break;
                        }
                        if (Phase != phases.ID.Assemble || ((Action)Current.$arrow()).getType() == types.ID.TY_PP_Asm) {
                            Current.$assignRvalue(this.ConstructPhaseAction((ArgList)Args, Phase, (std_ptr.unique_ptr<Action>)new std_ptr.unique_ptr(std.move((std_ptr.unique_ptr)Current))));
                            if (((Action)Current.$arrow()).getType() == types.ID.TY_Nothing) break;
                        }
                        _i.$preInc();
                    }
                    if (!Current.$boolean()) continue;
                    Actions.push_back(Current.release());
                    continue;
                }
                finally {
                    if (Current != null) {
                        Current.$destroy();
                    }
                }
            }
            if (!LinkerInputs.empty()) {
                Actions.push_back((Object)new LinkJobAction((SmallVector<Action>)LinkerInputs, types.ID.TY_Image));
            }
            if (FinalPhase == phases.ID.Link && PL.size() == 1) {
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_CompileOnly_Group.getValue()));
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_cl_compile_Group.getValue()));
            }
            Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_cl_ignored_Group.getValue()));
        }
        finally {
            if (PL != null) {
                PL.$destroy();
            }
            if (LinkerInputs != null) {
                LinkerInputs.$destroy();
            }
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BuildUniversalActions(ToolChain TC, DerivedArgList Args, SmallVector<std.pair<types.ID, Arg>> BAInputs, SmallVector<Action> Actions) {
        PrettyStackTraceString CrashInfo = null;
        StringSet ArchNames = null;
        SmallVector Archs = null;
        SmallVector SingleActions = null;
        try {
            CrashInfo = new PrettyStackTraceString((CharSequence)"Building universal build actions");
            ArchNames = new StringSet();
            Archs = new SmallVector(4, null);
            for (Arg A : Args) {
                if (!A.getOption().matches(new OptSpecifier((long)options.ID.OPT_arch.getValue()))) continue;
                Triple.ArchType Arch = darwin.getArchTypeForMachOArchName(new StringRef(A.getValue()));
                if (Arch == Triple.ArchType.UnknownArch) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(319L), (StringRef)new StringRef(A.getAsString((ArgList)Args))).$destroy();
                    continue;
                }
                A.claim();
                if (!ArchNames.insert((StringRef)new StringRef((char.ptr)A.getValue())).second) continue;
                Archs.push_back((Object)A.getValue());
            }
            if (Archs.size() == 0) {
                Archs.push_back((Object)Args.MakeArgString(new StringRef(TC.getDefaultUniversalArchName())));
            }
            SingleActions = new SmallVector(3, null);
            this.BuildActions(TC, Args, BAInputs, (SmallVector<Action>)SingleActions);
            long e = SingleActions.size();
            for (long i = 0L; i != e; ++i) {
                SmallVector Inputs = null;
                try {
                    Action Act = (Action)SingleActions.$at(i);
                    if (Archs.size() > 1 && !types.canLipoType(Act.getType())) {
                        ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(326L), (char.ptr)types.getTypeName(Act.getType())).$destroy();
                    }
                    Inputs = new SmallVector(3, null);
                    long _e = Archs.size();
                    for (long _i = 0L; _i != _e; ++_i) {
                        Inputs.push_back((Object)new BindArchAction((std_ptr.unique_ptr<Action>)new std_ptr.unique_ptr((Object)Act), (char.ptr)Archs.$at(_i)));
                        if (_i == 0L) continue;
                        ((Action)Inputs.back()).setOwnsInputs(false);
                    }
                    if (Inputs.size() == 1 || Act.getType() == types.ID.TY_Nothing) {
                        Actions.append((type.iterator)Inputs.begin(), (type.iterator)Inputs.end());
                    } else {
                        Actions.push_back((Object)new LipoJobAction((SmallVector<Action>)Inputs, Act.getType()));
                    }
                    Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_g_Group.getValue()));
                    if (A == null || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_g0.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_gstabs.getValue())) || !DriverStatics.ContainsCompileOrAssembleAction((Action)Actions.back())) continue;
                    if (Act.getType() == types.ID.TY_Image) {
                        SmallVector _Inputs = null;
                        try {
                            _Inputs = new SmallVector(3, null);
                            _Inputs.push_back(Actions.back());
                            Actions.pop_back();
                            Actions.push_back((Object)new DsymutilJobAction((SmallVector<Action>)_Inputs, types.ID.TY_dSYM));
                        }
                        finally {
                            if (_Inputs != null) {
                                _Inputs.$destroy();
                            }
                        }
                    }
                    if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_verify_debug_info.getValue()))) continue;
                    std_ptr.unique_ptr VerifyInput = null;
                    try {
                        VerifyInput = new std_ptr.unique_ptr(Actions.back());
                        Actions.pop_back();
                        Actions.push_back((Object)new VerifyDebugInfoJobAction((std_ptr.unique_ptr<Action>)std.move((std_ptr.unique_ptr)VerifyInput), types.ID.TY_Nothing));
                        continue;
                    }
                    finally {
                        if (VerifyInput != null) {
                            VerifyInput.$destroy();
                        }
                    }
                }
                finally {
                    if (Inputs != null) {
                        Inputs.$destroy();
                    }
                }
            }
        }
        finally {
            if (SingleActions != null) {
                SingleActions.$destroy();
            }
            if (Archs != null) {
                Archs.$destroy();
            }
            if (ArchNames != null) {
                ArchNames.$destroy();
            }
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BuildJobs(Compilation C) {
        PrettyStackTraceString CrashInfo = null;
        StringSet ArchNames = null;
        try {
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Building compilation jobs"));
            Arg FinalOutput = C.getArgs().getLastArg(new OptSpecifier((long)options.ID.OPT_o.getValue()));
            if (FinalOutput != null) {
                long NumOutputs = 0L;
                for (Action A : C.getActions()) {
                    if (A.getType() == types.ID.TY_Nothing) continue;
                    ++NumOutputs;
                }
                if (NumOutputs > 1L) {
                    this.Diag(346L).$destroy();
                    FinalOutput = null;
                }
            }
            ArchNames = new StringSet();
            if (C.getDefaultToolChain().getTriple().isOSBinFormatMachO()) {
                for (Object A : C.getArgs()) {
                    if (!A.getOption().matches(new OptSpecifier((long)options.ID.OPT_arch.getValue()))) continue;
                    ArchNames.insert(new StringRef(A.getValue()));
                }
            }
            for (Object A : C.getActions()) {
                char.ptr LinkingOutput = null;
                if (llvm.isa(LipoJobAction.class, (Object)A)) {
                    LinkingOutput = FinalOutput != null ? Native.$tryClone((char.ptr)FinalOutput.getValue()) : Native.$tryClone((char.ptr)this.getDefaultImageName());
                }
                InputInfo II = new InputInfo();
                this.BuildJobsForAction(C, (Action)A, C.getDefaultToolChain(), null, true, ArchNames.size() > 1, LinkingOutput, II);
            }
            if (this.Diags.hasErrorOccurred() || C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_Qunused_arguments.getValue()))) {
                return;
            }
            C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__HASH_HASH_HASH.getValue()));
            C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_driver_mode.getValue()));
            for (Object A : C.getArgs()) {
                if (A.isClaimed() || A.getOption().hasFlag(64L)) continue;
                Option Opt = A.getOption();
                if (Opt.getKind() == Option.OptionClass.FlagClass) {
                    boolean DuplicateClaimed = false;
                    arg_iterator it = C.getArgs().filtered_begin(new OptSpecifier(Opt));
                    arg_iterator ie = C.getArgs().filtered_end();
                    while (OptGlobals.$noteq_arg_iterator((arg_iterator)it, (arg_iterator)ie)) {
                        if (it.$star().isClaimed()) {
                            DuplicateClaimed = true;
                            break;
                        }
                        it.$preInc();
                    }
                    if (DuplicateClaimed) continue;
                }
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(379L), (StringRef)new StringRef(A.getAsString((ArgList)C.getArgs()))).$destroy();
            }
        }
        finally {
            if (ArchNames != null) {
                ArchNames.$destroy();
            }
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    public int ExecuteCompilation(Compilation C, SmallVectorImpl<std.pairIntType<Command>> FailingCommands) {
        if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__HASH_HASH_HASH.getValue()))) {
            C.getJobs().Print(llvm.errs(), NativePointer.$((String)"\n"), true);
            return 0;
        }
        if (this.Diags.hasErrorOccurred()) {
            return 1;
        }
        this.setUpResponseFiles(C, C.getJobs());
        C.ExecuteJob(C.getJobs(), FailingCommands);
        C.CleanupFileList(C.getTempFiles());
        if (FailingCommands.empty()) {
            return 0;
        }
        SmallVectorImpl.iterator it = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)FailingCommands.begin());
        SmallVectorImpl.iterator ie = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)FailingCommands.end());
        while (it.$noteq((Object)ie)) {
            int Res = ((std.pairIntType)it.$star()).first;
            Command FailingCommand = (Command)((std.pairIntType)it.$star()).second;
            if (!C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_save_temps.getValue()))) {
                JobAction JA = (JobAction)llvm.cast(JobAction.class, (Object)FailingCommand.getSource());
                C.CleanupFileMap(C.getResultFiles(), JA, true);
                if (Res < 0) {
                    C.CleanupFileMap(C.getFailureResultFiles(), JA, true);
                }
            }
            Tool FailingTool = FailingCommand.getCreator();
            if (!FailingCommand.getCreator().hasGoodDiagnostics() || Res != 1) {
                if (Res < 0) {
                    ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(314L), (char.ptr)FailingTool.getShortName()).$destroy();
                } else {
                    ClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(312L), (char.ptr)FailingTool.getShortName()), (int)Res).$destroy();
                }
            }
            it.$preInc();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCompilationDiagnostics(Compilation C, Command FailingCommand) {
        SmallVector Inputs = null;
        StringSet ArchNames = null;
        SmallVector FailingCommands = null;
        SmallString VFS = null;
        raw_fd_ostream ScriptOS = null;
        try {
            if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_fno_crash_diagnostics.getValue()))) {
                return;
            }
            if (FailingCommand.getCreator().isLinkJob() || FailingCommand.getCreator().isDsymutilJob()) {
                return;
            }
            this.PrintVersion(C, llvm.errs());
            ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(362L), (char.ptr)NativePointer.$((String)"PLEASE submit a bug report to http://llvm.org/bugs/ and include the crash backtrace, preprocessed source, and associated run script.")).$destroy();
            this.Mode = DriverMode.CPPMode;
            this.CCGenDiagnostics = true;
            Command Cmd = new Command(FailingCommand);
            DiagnosticErrorTrap Trap = new DiagnosticErrorTrap(this.Diags);
            C.initCompilationForDiagnostics();
            Inputs = new SmallVector(16, (Object)new std.pair((Object)types.ID.TY_INVALID, null));
            this.BuildInputs(C.getDefaultToolChain(), C.getArgs(), (SmallVector<std.pair<types.ID, Arg>>)Inputs);
            Object it = Inputs.begin();
            SmallVectorImpl.iterator ie = Inputs.end();
            while (it.$noteq((Object)ie)) {
                boolean IgnoreInput = false;
                if (types.getPreprocessedType((types.ID)((Object)((std.pair)it.$star()).first)) == types.ID.TY_INVALID) {
                    IgnoreInput = true;
                } else if (std.strcmp((char.ptr)((Arg)((std.pair)it.$star()).second).getValue(), (char.ptr)NativePointer.$((String)"-")) == 0) {
                    ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(362L), (char.ptr)NativePointer.$((String)"Error generating preprocessed source(s) - ignoring input from stdin.")).$destroy();
                    IgnoreInput = true;
                }
                if (IgnoreInput) {
                    it = Inputs.erase((SmallVectorImpl.iterator)it);
                    ie = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)Inputs.end());
                    continue;
                }
                it.$preInc();
            }
            if (Inputs.empty()) {
                ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(362L), (char.ptr)NativePointer.$((String)"Error generating preprocessed source(s) - no preprocessable inputs.")).$destroy();
                return;
            }
            ArchNames = new StringSet();
            for (Arg A : C.getArgs()) {
                if (!A.getOption().matches(new OptSpecifier((long)options.ID.OPT_arch.getValue()))) continue;
                StringRef ArchName = new StringRef(A.getValue());
                ArchNames.insert(new StringRef(ArchName));
            }
            if (ArchNames.size() > 1) {
                ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(362L), (char.ptr)NativePointer.$((String)"Error generating preprocessed source(s) - cannot generate preprocessed source with multiple -arch options.")).$destroy();
                return;
            }
            ToolChain TC = C.getDefaultToolChain();
            if (TC.getTriple().isOSBinFormatMachO()) {
                this.BuildUniversalActions(TC, C.getArgs(), (SmallVector<std.pair<types.ID, Arg>>)Inputs, C.getActions());
            } else {
                this.BuildActions(TC, C.getArgs(), (SmallVector<std.pair<types.ID, Arg>>)Inputs, C.getActions());
            }
            this.BuildJobs(C);
            if (Trap.hasErrorOccurred()) {
                ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(362L), (char.ptr)NativePointer.$((String)"Error generating preprocessed source(s).")).$destroy();
                return;
            }
            FailingCommands = new SmallVector(4, (Object)new std.pairIntType(null));
            C.ExecuteJob(C.getJobs(), (SmallVectorImpl<std.pairIntType<Command>>)FailingCommands);
            if (!FailingCommands.empty()) {
                if (!C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_save_temps.getValue()))) {
                    C.CleanupFileList(C.getTempFiles(), true);
                }
                ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(362L), (char.ptr)NativePointer.$((String)"Error generating preprocessed source(s).")).$destroy();
                return;
            }
            ArgStringList TempFiles = C.getTempFiles();
            if (TempFiles.empty()) {
                ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(362L), (char.ptr)NativePointer.$((String)"Error generating preprocessed source(s).")).$destroy();
                return;
            }
            ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(362L), (char.ptr)NativePointer.$((String)"\n********************\n\nPLEASE ATTACH THE FOLLOWING FILES TO THE BUG REPORT:\nPreprocessed source(s) and associated run script(s) are located at:")).$destroy();
            VFS = new SmallString(128);
            for (char.ptr TempFile : TempFiles) {
                ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(362L), (char.ptr)TempFile).$destroy();
                if (!new StringRef(TempFile).endswith((CharSequence)".cache")) continue;
                VFS.$assign(path.filename((StringRef)new StringRef(TempFile)));
                path.append((SmallString)VFS, (Twine)new Twine(NativePointer.$((String)"vfs")), (Twine)new Twine(NativePointer.$((String)"vfs.yaml")));
            }
            CrashReportInfo CrashInfo = new CrashReportInfo(new StringRef((char.ptr)TempFiles.$at(0)), VFS.$StringRef());
            std.string Script = std.$plus_str_T((std.string)((StringRef)CrashInfo.Filename.rsplit((byte)NativePointer.$((char)'.')).first).str(), (char.iterator)NativePointer.$((String)".sh"));
            std_errors.error_code EC = new std_errors.error_code();
            ScriptOS = new raw_fd_ostream(new StringRef(Script), EC, fs.OpenFlags.F_Excl);
            if (EC.$boolean()) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(362L), (StringRef)new StringRef(std.$plus_str((std.string)std.$plus_str_T((std.string)std.$plus_T_str((Object)NativePointer.$((String)"Error generating run script: "), (std.string)Script), (char.iterator)NativePointer.$((String)" ")), (std.string)EC.message()))).$destroy();
            } else {
                Cmd.Print((raw_ostream)ScriptOS, NativePointer.$((String)"\n"), true, CrashInfo);
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(362L), (StringRef)new StringRef(Script)).$destroy();
            }
            for (Arg A : C.getArgs().filtered(new OptSpecifier((long)options.ID.OPT_frewrite_map_file.getValue()), new OptSpecifier((long)options.ID.OPT_frewrite_map_file_EQ.getValue()))) {
                ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(362L), (char.ptr)A.getValue()).$destroy();
            }
            ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.Diag(362L), (char.ptr)NativePointer.$((String)"\n\n********************")).$destroy();
        }
        finally {
            if (ScriptOS != null) {
                ScriptOS.$destroy();
            }
            if (VFS != null) {
                VFS.$destroy();
            }
            if (FailingCommands != null) {
                FailingCommands.$destroy();
            }
            if (ArchNames != null) {
                ArchNames.$destroy();
            }
            if (Inputs != null) {
                Inputs.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PrintActions(Compilation C) {
        std.mapTypeUInt Ids = null;
        try {
            Ids = new std.mapTypeUInt();
            SmallVectorImpl.iterator it = C.getActions().begin();
            SmallVectorImpl.iterator ie = C.getActions().end();
            while (it.$noteq((Object)ie)) {
                DriverStatics.PrintActions1(C, (Action)it.$star(), (std.mapTypeUInt<Action>)Ids);
                it.$preInc();
            }
        }
        finally {
            if (Ids != null) {
                Ids.$destroy();
            }
        }
    }

    public void PrintHelp(boolean ShowHidden) {
        uint.ref IncludedFlagsBitmask = NativePointer.create_uint$ref();
        uint.ref ExcludedFlagsBitmask = NativePointer.create_uint$ref();
        std.tie((uint.ref)IncludedFlagsBitmask, (uint.ref)ExcludedFlagsBitmask).$assign(this.getIncludeExcludeOptionFlagMasks());
        ExcludedFlagsBitmask.$set(ExcludedFlagsBitmask.$deref() | 0x1000L);
        if (!ShowHidden) {
            ExcludedFlagsBitmask.$set(ExcludedFlagsBitmask.$deref() | 1L);
        }
        this.getOpts().PrintHelp(llvm.outs(), this.Name.c_str(), this.DriverTitle.c_str(), IncludedFlagsBitmask.$deref(), ExcludedFlagsBitmask.$deref());
    }

    public void PrintVersion(Compilation C, raw_ostream OS) {
        OS.$out(ClangGlobals.getClangFullVersion()).$out(NativePointer.$((char)'\n'));
        ToolChain TC = C.getDefaultToolChain();
        OS.$out(NativePointer.$((String)"Target: ")).$out(TC.getTripleString()).$out(NativePointer.$((char)'\n'));
        Arg A = C.getArgs().getLastArg(new OptSpecifier((long)options.ID.OPT_mthread_model.getValue()));
        if (A != null) {
            if (TC.isThreadModelSupported(new StringRef(A.getValue()))) {
                OS.$out(NativePointer.$((String)"Thread model: ")).$out(A.getValue());
            }
        } else {
            OS.$out(NativePointer.$((String)"Thread model: ")).$out(TC.getThreadModel());
        }
        OS.$out(NativePointer.$((char)'\n'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string GetFilePath(char.ptr Name, ToolChain TC) {
        SmallString P = null;
        try {
            SmallVectorImpl.iterator it = this.PrefixDirs.begin();
            SmallVectorImpl.iterator ie = this.PrefixDirs.end();
            while (it.$noteq((Object)ie)) {
                std.string Dir = null;
                SmallString _P = null;
                try {
                    Dir = new std.string((std.string)it.$star());
                    if (!Dir.empty()) {
                        if (Dir.$at(0) == NativePointer.$((char)'=')) {
                            Dir.$assign(std.$plus_str((std.string)this.SysRoot, (std.string)Dir.substr(1)));
                        }
                        _P = new SmallString(new StringRef(Dir), 128);
                        path.append((SmallString)_P, (char.ptr)Name);
                        if (fs.exists((Twine)new Twine(_P.$StringRef()))) {
                            std.string string2 = _P.str().$basic_string();
                            return string2;
                        }
                    }
                }
                finally {
                    if (_P != null) {
                        _P.$destroy();
                    }
                    if (Dir != null) {
                        Dir.$destroy();
                    }
                }
                it.$preInc();
            }
            P = new SmallString(new StringRef(this.ResourceDir), 128);
            path.append((SmallString)P, (char.ptr)Name);
            if (fs.exists((Twine)new Twine(P.$StringRef()))) {
                it = P.str().$basic_string();
                return it;
            }
            SmallVector<std.string> List2 = TC.getFilePaths();
            SmallVectorImpl.iterator it2 = List2.begin();
            SmallVectorImpl.iterator ie2 = List2.end();
            while (it2.$noteq((Object)ie2)) {
                std.string Dir = null;
                SmallString _P = null;
                try {
                    Dir = new std.string((std.string)it2.$star());
                    if (!Dir.empty()) {
                        if (Dir.$at(0) == NativePointer.$((char)'=')) {
                            Dir.$assign(std.$plus_str((std.string)this.SysRoot, (std.string)Dir.substr(1)));
                        }
                        _P = new SmallString(new StringRef(Dir), 128);
                        path.append((SmallString)_P, (char.ptr)Name);
                        if (fs.exists((Twine)new Twine(_P.$StringRef()))) {
                            std.string string3 = _P.str().$basic_string();
                            return string3;
                        }
                    }
                }
                finally {
                    if (_P != null) {
                        _P.$destroy();
                    }
                    if (Dir != null) {
                        Dir.$destroy();
                    }
                }
                it2.$preInc();
            }
            std.string string4 = new std.string(Name);
            return string4;
        }
        finally {
            if (P != null) {
                P.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string GetProgramPath(char.ptr Name, ToolChain TC) {
        SmallVector TargetSpecificExecutables = null;
        try {
            SmallString P;
            TargetSpecificExecutables = new SmallVector(2, (Object)new std.string());
            this.generatePrefixedToolNames(Name, TC, (SmallVectorImpl<std.string>)TargetSpecificExecutables);
            for (std.string PrefixDir : this.PrefixDirs) {
                SmallString P2;
                if (fs.is_directory((Twine)new Twine(PrefixDir))) {
                    P2 = null;
                    try {
                        P2 = new SmallString(new StringRef(PrefixDir), 128);
                        if (!DriverStatics.ScanDirForExecutable(P2, (ArrayRef<std.string>)new ArrayRef((SmallVectorImpl)TargetSpecificExecutables))) continue;
                        std.string string2 = P2.str().$basic_string();
                        return string2;
                    }
                    finally {
                        if (P2 != null) {
                            P2.$destroy();
                        }
                        continue;
                    }
                }
                P2 = null;
                try {
                    P2 = new SmallString(new StringRef(std.$plus_str_T((std.string)PrefixDir, (char.iterator)Name)), 128);
                    if (!fs.can_execute((Twine)new Twine(P2.$StringRef()))) continue;
                    std.string string3 = P2.str().$basic_string();
                    return string3;
                }
                finally {
                    if (P2 == null) continue;
                    P2.$destroy();
                }
            }
            SmallVector<std.string> List2 = TC.getProgramPaths();
            for (std.string Path : List2) {
                P = null;
                try {
                    P = new SmallString(new StringRef(Path), 128);
                    if (!DriverStatics.ScanDirForExecutable(P, (ArrayRef<std.string>)new ArrayRef((SmallVectorImpl)TargetSpecificExecutables))) continue;
                    std.string string4 = P.str().$basic_string();
                    return string4;
                }
                finally {
                    if (P == null) continue;
                    P.$destroy();
                }
            }
            for (std.string TargetSpecificExecutable : TargetSpecificExecutables) {
                P = sys.findProgramByName((StringRef)new StringRef(TargetSpecificExecutable));
                if (!P.$boolean()) continue;
                std.string string5 = (std.string)P.$star();
                return string5;
            }
            Iterator iterator2 = new std.string(Name);
            return iterator2;
        }
        finally {
            if (TargetSpecificExecutables != null) {
                TargetSpecificExecutables.$destroy();
            }
        }
    }

    public boolean HandleImmediateArgs(Compilation C) {
        MultilibSet Multilibs;
        if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_dumpmachine.getValue()))) {
            llvm.outs().$out(C.getDefaultToolChain().getTripleString()).$out_char(NativePointer.$((char)'\n'));
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_dumpversion.getValue()))) {
            llvm.outs().$out(NativePointer.$((String)"4.2.1\n"));
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__print_diagnostic_categories.getValue()))) {
            DriverStatics.PrintDiagnosticCategories(llvm.outs());
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_help.getValue())) || C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__help_hidden.getValue()))) {
            this.PrintHelp(C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__help_hidden.getValue())));
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__version.getValue()))) {
            this.PrintVersion(C, llvm.outs());
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_v.getValue())) || C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__HASH_HASH_HASH.getValue()))) {
            this.PrintVersion(C, llvm.errs());
            this.SuppressMissingInputWarning = true;
        }
        ToolChain TC = C.getDefaultToolChain();
        if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_v.getValue()))) {
            TC.printVerboseInfo(llvm.errs());
        }
        if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_print_search_dirs.getValue()))) {
            llvm.outs().$out(NativePointer.$((String)"programs: ="));
            SmallVectorImpl.iterator it = TC.getProgramPaths().begin();
            SmallVectorImpl.iterator ie = TC.getProgramPaths().end();
            while (it.$noteq((Object)ie)) {
                if (it != TC.getProgramPaths().begin()) {
                    llvm.outs().$out_char(NativePointer.$((char)':'));
                }
                llvm.outs().$out((std.string)it.$star());
                it.$preInc();
            }
            llvm.outs().$out(NativePointer.$((String)"\n"));
            llvm.outs().$out(NativePointer.$((String)"libraries: =")).$out(this.ResourceDir);
            StringRef sysroot = C.getSysRoot();
            SmallVectorImpl.iterator it2 = TC.getFilePaths().begin();
            SmallVectorImpl.iterator ie2 = TC.getFilePaths().end();
            while (it2.$noteq((Object)ie2)) {
                llvm.outs().$out_char(NativePointer.$((char)':'));
                char.ptr path2 = Native.$tryClone((char.ptr)((std.string)it2.$star()).c_str());
                if (path2.$at(0) == NativePointer.$((char)'=')) {
                    llvm.outs().$out(new StringRef(sysroot)).$out((char.ptr)path2.$add(1));
                } else {
                    llvm.outs().$out(path2);
                }
                it2.$preInc();
            }
            llvm.outs().$out(NativePointer.$((String)"\n"));
            return false;
        }
        Arg A = C.getArgs().getLastArg(new OptSpecifier((long)options.ID.OPT_print_file_name_EQ.getValue()));
        if (A != null) {
            llvm.outs().$out(this.GetFilePath(A.getValue(), TC)).$out(NativePointer.$((String)"\n"));
            return false;
        }
        A = C.getArgs().getLastArg(new OptSpecifier((long)options.ID.OPT_print_prog_name_EQ.getValue()));
        if (A != null) {
            llvm.outs().$out(this.GetProgramPath(A.getValue(), TC)).$out(NativePointer.$((String)"\n"));
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_print_libgcc_file_name.getValue()))) {
            llvm.outs().$out(this.GetFilePath(NativePointer.$((String)"libgcc.a"), TC)).$out(NativePointer.$((String)"\n"));
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_print_multi_lib.getValue()))) {
            Multilibs = TC.getMultilibs();
            StdVector.iterator<Multilib> I = Multilibs.begin();
            StdVector.iterator<Multilib> E = Multilibs.end();
            while (Native.$noteq(I, E)) {
                DriverGlobals.$out_raw_ostream_Multilib(llvm.outs(), (Multilib)I.$star()).$out(NativePointer.$((String)"\n"));
                I.$preInc();
            }
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_print_multi_directory.getValue()))) {
            Multilibs = TC.getMultilibs();
            StdVector.iterator<Multilib> I = Multilibs.begin();
            StdVector.iterator<Multilib> E = Multilibs.end();
            while (Native.$noteq(I, E)) {
                if (((Multilib)I.$arrow()).gccSuffix().empty()) {
                    llvm.outs().$out(NativePointer.$((String)".\n"));
                } else {
                    StringRef Suffix = new StringRef(((Multilib)I.$arrow()).gccSuffix());
                    assert (Suffix.front() == 47);
                    llvm.outs().$out(Suffix.substr(1)).$out(NativePointer.$((String)"\n"));
                }
                I.$preInc();
            }
            return false;
        }
        return !C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_print_multi_os_directory.getValue()));
    }

    public std_ptr.unique_ptr<Action> ConstructPhaseAction(ArgList Args, phases.ID Phase, std_ptr.unique_ptr<Action> Input) {
        PrettyStackTraceString CrashInfo = null;
        try {
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Constructing phase actions"));
            switch (Phase) {
                case Link: {
                    throw new llvm_unreachable((CharSequence)"link action invalid here.");
                }
                case Preprocess: {
                    types.ID OutputTy;
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_M.getValue()), new OptSpecifier((long)options.ID.OPT_MM.getValue()))) {
                        OutputTy = types.ID.TY_Dependencies;
                    } else {
                        OutputTy = ((Action)Input.$arrow()).getType();
                        if (!Args.hasFlag(new OptSpecifier((long)options.ID.OPT_frewrite_includes.getValue()), new OptSpecifier((long)options.ID.OPT_fno_rewrite_includes.getValue()), false) && !this.CCGenDiagnostics) {
                            OutputTy = types.getPreprocessedType(OutputTy);
                        }
                        assert (OutputTy != types.ID.TY_INVALID) : "Cannot preprocess this input type!";
                    }
                    std_ptr.unique_ptr unique_ptr2 = new std_ptr.unique_ptr(llvm.make_unique((Object)new PreprocessJobAction((std_ptr.unique_ptr<Action>)std.move(Input), OutputTy)));
                    return unique_ptr2;
                }
                case Precompile: {
                    types.ID OutputTy = types.ID.TY_PCH;
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fsyntax_only.getValue()))) {
                        OutputTy = types.ID.TY_Nothing;
                    }
                    std_ptr.unique_ptr unique_ptr3 = new std_ptr.unique_ptr(llvm.make_unique((Object)new PrecompileJobAction((std_ptr.unique_ptr<Action>)std.move(Input), OutputTy)));
                    return unique_ptr3;
                }
                case Compile: {
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_fsyntax_only.getValue()))) {
                        std_ptr.unique_ptr OutputTy = new std_ptr.unique_ptr(llvm.make_unique((Object)new CompileJobAction((std_ptr.unique_ptr<Action>)std.move(Input), types.ID.TY_Nothing)));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_rewrite_objc.getValue()))) {
                        std_ptr.unique_ptr OutputTy = new std_ptr.unique_ptr(llvm.make_unique((Object)new CompileJobAction((std_ptr.unique_ptr<Action>)std.move(Input), types.ID.TY_RewrittenObjC)));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_rewrite_legacy_objc.getValue()))) {
                        std_ptr.unique_ptr OutputTy = new std_ptr.unique_ptr(llvm.make_unique((Object)new CompileJobAction((std_ptr.unique_ptr<Action>)std.move(Input), types.ID.TY_RewrittenLegacyObjC)));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT__analyze.getValue()), new OptSpecifier((long)options.ID.OPT__analyze_auto.getValue()))) {
                        std_ptr.unique_ptr OutputTy = new std_ptr.unique_ptr(llvm.make_unique((Object)new AnalyzeJobAction((std_ptr.unique_ptr<Action>)std.move(Input), types.ID.TY_Plist)));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT__migrate.getValue()))) {
                        std_ptr.unique_ptr OutputTy = new std_ptr.unique_ptr(llvm.make_unique((Object)new MigrateJobAction((std_ptr.unique_ptr<Action>)std.move(Input), types.ID.TY_Remap)));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_emit_ast.getValue()))) {
                        std_ptr.unique_ptr OutputTy = new std_ptr.unique_ptr(llvm.make_unique((Object)new CompileJobAction((std_ptr.unique_ptr<Action>)std.move(Input), types.ID.TY_AST)));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_module_file_info.getValue()))) {
                        std_ptr.unique_ptr OutputTy = new std_ptr.unique_ptr(llvm.make_unique((Object)new CompileJobAction((std_ptr.unique_ptr<Action>)std.move(Input), types.ID.TY_ModuleFile)));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_verify_pch.getValue()))) {
                        std_ptr.unique_ptr OutputTy = new std_ptr.unique_ptr(llvm.make_unique((Object)new VerifyPCHJobAction((std_ptr.unique_ptr<Action>)std.move(Input), types.ID.TY_Nothing)));
                        return OutputTy;
                    }
                    std_ptr.unique_ptr OutputTy = new std_ptr.unique_ptr(llvm.make_unique((Object)new CompileJobAction((std_ptr.unique_ptr<Action>)std.move(Input), types.ID.TY_LLVM_BC)));
                    return OutputTy;
                }
                case Backend: {
                    if (this.IsUsingLTO(Args)) {
                        types.ID Output = Args.hasArg(new OptSpecifier((long)options.ID.OPT_S.getValue())) ? types.ID.TY_LTO_IR : types.ID.TY_LTO_BC;
                        std_ptr.unique_ptr unique_ptr4 = new std_ptr.unique_ptr(llvm.make_unique((Object)new BackendJobAction((std_ptr.unique_ptr<Action>)std.move(Input), Output)));
                        return unique_ptr4;
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_emit_llvm.getValue()))) {
                        types.ID Output = Args.hasArg(new OptSpecifier((long)options.ID.OPT_S.getValue())) ? types.ID.TY_LLVM_IR : types.ID.TY_LLVM_BC;
                        std_ptr.unique_ptr unique_ptr5 = new std_ptr.unique_ptr(llvm.make_unique((Object)new BackendJobAction((std_ptr.unique_ptr<Action>)std.move(Input), Output)));
                        return unique_ptr5;
                    }
                    std_ptr.unique_ptr unique_ptr6 = new std_ptr.unique_ptr(llvm.make_unique((Object)new BackendJobAction((std_ptr.unique_ptr<Action>)std.move(Input), types.ID.TY_PP_Asm)));
                    return unique_ptr6;
                }
                case Assemble: {
                    std_ptr.unique_ptr unique_ptr7 = new std_ptr.unique_ptr(llvm.make_unique((Object)new AssembleJobAction((std_ptr.unique_ptr<Action>)std.move(Input), types.ID.TY_Object)));
                    return unique_ptr7;
                }
            }
            throw new llvm_unreachable((CharSequence)"invalid phase in ConstructPhaseAction");
        }
        finally {
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BuildJobsForAction(Compilation C, Action A, ToolChain TC, char.ptr BoundArch, boolean AtTopLevel, boolean MultipleArchs, char.ptr LinkingOutput, InputInfo Result) {
        PrettyStackTraceString CrashInfo = null;
        SmallVector InputInfos = null;
        try {
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Building compilation jobs"));
            InputAction IA = (InputAction)Casts.dyn_cast(InputAction.class, (Object)A);
            if (IA != null) {
                Arg Input = IA.getInputArg();
                Input.claim();
                if (Input.getOption().matches(new OptSpecifier((long)options.ID.OPT_INPUT.getValue()))) {
                    char.ptr Name = Native.$tryClone((char.ptr)Input.getValue());
                    Result.$assign(new InputInfo(Name, A.getType(), Name));
                } else {
                    Result.$assign(new InputInfo(Input, A.getType(), NativePointer.$((String)"")));
                }
                return;
            }
            BindArchAction BAA = (BindArchAction)Casts.dyn_cast(BindArchAction.class, (Object)A);
            if (BAA != null) {
                char.ptr ArchName = Native.$tryClone((char.ptr)BAA.getArchName());
                ToolChain _TC = ArchName != null ? this.getToolChain((ArgList)C.getArgs(), new StringRef(ArchName)) : C.getDefaultToolChain();
                this.BuildJobsForAction(C, (Action)BAA.begin().$star(), _TC, BAA.getArchName(), AtTopLevel, MultipleArchs, LinkingOutput, Result);
                return;
            }
            SmallVector<Action> Inputs = A.getInputs();
            JobAction JA = (JobAction)llvm.cast(JobAction.class, (Object)A);
            Tool T = DriverStatics.SelectToolForJob(C, TC, JA, Inputs);
            if (T == null) {
                return;
            }
            InputInfos = new SmallVector(4, (Object)new InputInfo());
            for (Action Input : Inputs) {
                boolean SubJobAtTopLevel = false;
                if (AtTopLevel && (llvm.isa(DsymutilJobAction.class, (Object)A) || llvm.isa(VerifyJobAction.class, (Object)A))) {
                    SubJobAtTopLevel = true;
                }
                InputInfo II = new InputInfo();
                this.BuildJobsForAction(C, Input, TC, BoundArch, SubJobAtTopLevel, MultipleArchs, LinkingOutput, II);
                InputInfos.push_back((Object)II);
            }
            char.ptr BaseInput = Native.$tryClone((char.ptr)((InputInfo)InputInfos.$at(0)).getBaseInput());
            if (JA.getType() == types.ID.TY_dSYM) {
                BaseInput = Native.$tryClone((char.ptr)((InputInfo)InputInfos.$at(0)).getFilename());
            }
            if (JA.getType() == types.ID.TY_Nothing) {
                Result.$assign(new InputInfo(A.getType(), BaseInput));
            } else {
                Result.$assign(new InputInfo(this.GetNamedOutputPath(C, JA, BaseInput, BoundArch, AtTopLevel, MultipleArchs), A.getType(), BaseInput));
            }
            if (this.CCCPrintBindings && !this.CCGenDiagnostics) {
                llvm.errs().$out(NativePointer.$((String)"# \"")).$out(T.getToolChain().getTripleString()).$out(NativePointer.$((char)'\"')).$out(NativePointer.$((String)" - \"")).$out(T.getName()).$out(NativePointer.$((String)"\", inputs: ["));
                long e = InputInfos.size();
                for (long i = 0L; i != e; ++i) {
                    llvm.errs().$out(((InputInfo)InputInfos.$at(i)).getAsString());
                    if (i + 1L == e) continue;
                    llvm.errs().$out(NativePointer.$((String)", "));
                }
                llvm.errs().$out(NativePointer.$((String)"], output: ")).$out(Result.getAsString()).$out(NativePointer.$((String)"\n"));
            } else {
                T.ConstructJob(C, JA, Result, (SmallVector<InputInfo>)InputInfos, (ArgList)C.getArgsForToolChain(TC, BoundArch), LinkingOutput);
            }
        }
        finally {
            if (InputInfos != null) {
                InputInfos.$destroy();
            }
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    public char.ptr getDefaultImageName() {
        Triple Target = null;
        try {
            Target = new Triple(new Twine(Triple.normalize((StringRef)new StringRef(this.DefaultTargetTriple))));
            char.ptr ptr2 = Target.isOSWindows() ? NativePointer.$((String)"a.exe") : NativePointer.$((String)"a.out");
            return ptr2;
        }
        finally {
            if (Target != null) {
                Target.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char.ptr GetNamedOutputPath(Compilation C, JobAction JA, char.ptr BaseInput, char.ptr BoundArch, boolean AtTopLevel, boolean MultipleArchs) {
        PrettyStackTraceString CrashInfo = null;
        SmallString BasePath = null;
        try {
            char.ptr ptr2;
            char.ptr NamedOutput;
            StringRef Val;
            StringRef BaseName;
            Arg FinalOutput;
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Computing output path"));
            if (AtTopLevel && !llvm.isa(DsymutilJobAction.class, (Object)JA) && !llvm.isa(VerifyJobAction.class, (Object)JA) && (FinalOutput = C.getArgs().getLastArg(new OptSpecifier((long)options.ID.OPT_o.getValue()))) != null) {
                char.ptr ptr3 = C.addResultFile(FinalOutput.getValue(), JA);
                return ptr3;
            }
            if (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_P.getValue()))) {
                assert (AtTopLevel && llvm.isa(PreprocessJobAction.class, (Object)JA));
                BaseName = path.filename((StringRef)new StringRef(BaseInput));
                StringRef NameArg = new StringRef();
                Arg A = C.getArgs().getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_Fi.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_o.getValue()));
                if (A != null) {
                    NameArg.$assign(A.getValue());
                }
                A = C.addResultFile(DriverStatics.MakeCLOutputFilename((ArgList)C.getArgs(), NameArg, BaseName, types.ID.TY_PP_C), JA);
                return A;
            }
            if (AtTopLevel && !this.CCGenDiagnostics && (llvm.isa(PreprocessJobAction.class, (Object)JA) || JA.getType() == types.ID.TY_ModuleFile)) {
                BaseName = NativePointer.$((String)"-");
                return BaseName;
            }
            if (JA.getType() == types.ID.TY_PP_Asm && (C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_FA.getValue())) || C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_Fa.getValue())))) {
                BaseName = path.filename((StringRef)new StringRef(BaseInput));
                StringRef FaValue = C.getArgs().getLastArgValue(new OptSpecifier((long)options.ID.OPT__SLASH_Fa.getValue()));
                char.ptr A = C.addResultFile(DriverStatics.MakeCLOutputFilename((ArgList)C.getArgs(), FaValue, BaseName, JA.getType()), JA);
                return A;
            }
            if (!AtTopLevel && !C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_save_temps.getValue())) && !C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_Fo.getValue())) || this.CCGenDiagnostics) {
                StringRef Name = path.filename((StringRef)new StringRef(BaseInput));
                std.pair Split = Name.split(NativePointer.$((char)'.'));
                std.string TmpName = this.GetTemporaryPath((StringRef)Split.first, types.getTypeTempSuffix(JA.getType(), this.IsCLMode()));
                char.ptr ptr4 = C.addTempFile(C.getArgs().MakeArgString(TmpName.c_str()));
                return ptr4;
            }
            BasePath = new SmallString(new StringRef(BaseInput), 128);
            BaseName = new StringRef();
            if (llvm.isa(DsymutilJobAction.class, (Object)JA) || llvm.isa(VerifyJobAction.class, (Object)JA)) {
                BaseName.$assign(BasePath.$StringRef());
            } else {
                BaseName.$assign(path.filename((StringRef)BasePath.$StringRef()));
            }
            if (JA.getType() == types.ID.TY_Object && C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_Fo.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_o.getValue()))) {
                Val = new StringRef(C.getArgs().getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_Fo.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_o.getValue())).getValue());
                NamedOutput = Native.$tryClone((char.ptr)DriverStatics.MakeCLOutputFilename((ArgList)C.getArgs(), Val, BaseName, types.ID.TY_Object));
            } else if (JA.getType() == types.ID.TY_Image && C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_Fe.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_o.getValue()))) {
                Val = new StringRef(C.getArgs().getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_Fe.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_o.getValue())).getValue());
                NamedOutput = Native.$tryClone((char.ptr)DriverStatics.MakeCLOutputFilename((ArgList)C.getArgs(), Val, BaseName, types.ID.TY_Image));
            } else if (JA.getType() == types.ID.TY_Image) {
                if (this.IsCLMode()) {
                    NamedOutput = Native.$tryClone((char.ptr)DriverStatics.MakeCLOutputFilename((ArgList)C.getArgs(), StringRef.EMPTY, BaseName, types.ID.TY_Image));
                } else if (MultipleArchs && BoundArch != null) {
                    SmallString Output = null;
                    try {
                        Output = new SmallString(new StringRef(this.getDefaultImageName()), 128);
                        Output.$addassign(StringRef.MINUS);
                        Output.append(new StringRef(BoundArch));
                        NamedOutput = Native.$tryClone((char.ptr)C.getArgs().MakeArgString(Output.c_str()));
                    }
                    finally {
                        if (Output != null) {
                            Output.$destroy();
                        }
                    }
                } else {
                    NamedOutput = Native.$tryClone((char.ptr)this.getDefaultImageName());
                }
            } else {
                SmallString Suffixed = null;
                try {
                    char.ptr Suffix = Native.$tryClone((char.ptr)types.getTypeTempSuffix(JA.getType(), this.IsCLMode()));
                    assert (Suffix != null) : "All types used for output should have a suffix.";
                    int End = std.string.npos;
                    if (!types.appendSuffixForType(JA.getType())) {
                        End = BaseName.rfind(NativePointer.$((char)'.'));
                    }
                    Suffixed = new SmallString(BaseName.substr(0, End), 128);
                    if (MultipleArchs && BoundArch != null) {
                        Suffixed.$addassign(StringRef.MINUS);
                        Suffixed.append(BoundArch);
                    }
                    if (!AtTopLevel && C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_emit_llvm.getValue())) && JA.getType() == types.ID.TY_LLVM_BC) {
                        Suffixed.$addassign((CharSequence)".tmp");
                    }
                    Suffixed.$addassign(NativePointer.$((char)'.'));
                    Suffixed.$addassign(Suffix);
                    NamedOutput = Native.$tryClone((char.ptr)C.getArgs().MakeArgString(Suffixed.c_str()));
                }
                finally {
                    if (Suffixed != null) {
                        Suffixed.$destroy();
                    }
                }
            }
            if (!AtTopLevel && C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_save_temps.getValue())) && llvm.$eq_StringRef((StringRef)new StringRef(NamedOutput), (StringRef)BaseName)) {
                SmallString Result = null;
                try {
                    bool.ref SameFile = NativePointer.create_bool$ref((boolean)false);
                    Result = new SmallString(256);
                    fs.current_path((SmallString)Result);
                    path.append((SmallString)Result, (StringRef)BaseName);
                    fs.equivalent((Twine)new Twine(BaseInput), (Twine)new Twine(Result.c_str()), (bool.ref)SameFile);
                    if (SameFile.$deref()) {
                        StringRef Name = path.filename((StringRef)new StringRef(BaseInput));
                        std.pair Split = Name.split(NativePointer.$((char)'.'));
                        std.string TmpName = this.GetTemporaryPath((StringRef)Split.first, types.getTypeTempSuffix(JA.getType(), this.IsCLMode()));
                        char.ptr ptr5 = C.addTempFile(C.getArgs().MakeArgString(TmpName.c_str()));
                        return ptr5;
                    }
                }
                finally {
                    if (Result != null) {
                        Result.$destroy();
                    }
                }
            }
            if (JA.getType() == types.ID.TY_PCH) {
                path.remove_filename((SmallString)BasePath);
                if (BasePath.empty()) {
                    BasePath.$assign(NamedOutput);
                } else {
                    path.append((SmallString)BasePath, (char.ptr)NamedOutput);
                }
                ptr2 = C.addResultFile(C.getArgs().MakeArgString(BasePath.c_str()), JA);
                return ptr2;
            }
            ptr2 = C.addResultFile(NamedOutput, JA);
            return ptr2;
        }
        finally {
            if (BasePath != null) {
                BasePath.$destroy();
            }
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string GetTemporaryPath(StringRef Prefix, char.ptr Suffix) {
        SmallString Path = null;
        try {
            Path = new SmallString(128);
            std_errors.error_code EC = fs.createTemporaryFile((Twine)new Twine(Prefix), (StringRef)new StringRef(Suffix), (SmallString)Path);
            if (EC.$boolean()) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diag(32L), (StringRef)new StringRef(EC.message())).$destroy();
                std.string string2 = new std.string(NativePointer.$((String)""));
                return string2;
            }
            std.string string3 = Path.str().$basic_string();
            return string3;
        }
        finally {
            if (Path != null) {
                Path.$destroy();
            }
        }
    }

    public boolean ShouldUseClangCompiler(JobAction JA) {
        if (JA.size() != 1L || !types.isAcceptedByClang(((Action)JA.begin().$star()).getType())) {
            return false;
        }
        return llvm.isa(PreprocessJobAction.class, (Object)JA) || llvm.isa(PrecompileJobAction.class, (Object)JA) || llvm.isa(CompileJobAction.class, (Object)JA) || llvm.isa(BackendJobAction.class, (Object)JA);
    }

    public boolean IsUsingLTO(ArgList Args) {
        return Args.hasFlag(new OptSpecifier((long)options.ID.OPT_flto.getValue()), new OptSpecifier((long)options.ID.OPT_fno_lto.getValue()), false);
    }

    private ToolChain getToolChain(ArgList Args) {
        return this.getToolChain(Args, StringRef.EMPTY);
    }

    private ToolChain getToolChain(ArgList Args, StringRef DarwinArchName) {
        Triple Target = DriverStatics.computeTargetTriple(new StringRef(this.DefaultTargetTriple), Args, DarwinArchName);
        ToolChain TC = (ToolChain)this.ToolChains.$at(new StringRef(Target.str()));
        if (TC == null) {
            block0 : switch (Target.getOS()) {
                case Darwin: 
                case MacOSX: 
                case IOS: {
                    TC = new toolchains.DarwinClang(this, Target, Args);
                    break;
                }
                case DragonFly: {
                    TC = new toolchains.DragonFly(this, Target, Args);
                    break;
                }
                case OpenBSD: {
                    TC = new toolchains.OpenBSD(this, Target, Args);
                    break;
                }
                case Bitrig: {
                    TC = new toolchains.Bitrig(this, Target, Args);
                    break;
                }
                case NetBSD: {
                    TC = new toolchains.NetBSD(this, Target, Args);
                    break;
                }
                case FreeBSD: {
                    TC = new toolchains.FreeBSD(this, Target, Args);
                    break;
                }
                case Minix: {
                    TC = new toolchains.Minix(this, Target, Args);
                    break;
                }
                case Linux: {
                    if (Target.getArch() == Triple.ArchType.hexagon) {
                        TC = new toolchains.Hexagon_TC(this, Target, Args);
                        break;
                    }
                    TC = new toolchains.Linux(this, Target, Args);
                    break;
                }
                case Solaris: {
                    TC = new toolchains.Solaris(this, Target, Args);
                    break;
                }
                case Win32: {
                    switch (Target.getEnvironment()) {
                        default: {
                            if (Target.isOSBinFormatELF()) {
                                TC = new toolchains.Generic_ELF(this, Target, Args);
                                break block0;
                            }
                            if (Target.isOSBinFormatMachO()) {
                                TC = new toolchains.MachO(this, Target, Args);
                                break block0;
                            }
                            TC = new toolchains.Generic_GCC(this, Target, Args);
                            break block0;
                        }
                        case GNU: {
                            if (Target.isOSBinFormatELF()) {
                                TC = new toolchains.Generic_ELF(this, Target, Args);
                                break block0;
                            }
                            TC = new toolchains.Generic_GCC(this, Target, Args);
                            break block0;
                        }
                        case Itanium: {
                            TC = new toolchains.CrossWindowsToolChain(this, Target, Args);
                            break block0;
                        }
                        case MSVC: 
                        case UnknownEnvironment: 
                    }
                    TC = new toolchains.MSVCToolChain(this, Target, Args);
                    break;
                }
                default: {
                    TC = llvm.$eq_StringRef((StringRef)Target.getArchName(), (CharSequence)"tce") ? new toolchains.TCEToolChain(this, Target, Args) : (Target.getArch() == Triple.ArchType.hexagon ? new toolchains.Hexagon_TC(this, Target, Args) : (Target.getArch() == Triple.ArchType.xcore ? new toolchains.XCore(this, Target, Args) : (Target.isOSBinFormatELF() ? new toolchains.Generic_ELF(this, Target, Args) : (Target.isOSBinFormatMachO() ? new toolchains.MachO(this, Target, Args) : new toolchains.Generic_GCC(this, Target, Args)))));
                }
            }
        }
        return TC;
    }

    private std.pairUIntUInt getIncludeExcludeOptionFlagMasks() {
        long IncludedFlagsBitmask = 0L;
        long ExcludedFlagsBitmask = 4096L;
        if (this.Mode == DriverMode.CLMode) {
            IncludedFlagsBitmask |= 0x200L;
            IncludedFlagsBitmask |= 0x100L;
        } else {
            ExcludedFlagsBitmask |= 0x200L;
        }
        return std.make_pair_uint_uint((long)IncludedFlagsBitmask, (long)ExcludedFlagsBitmask);
    }

    public static boolean GetReleaseVersion(char.ptr Str, uint.ref Major, uint.ref Minor, uint.ref Micro, bool.ref HadExtra) {
        HadExtra.$set(false);
        Major.$set(Minor.$set(Micro.$set(0L)));
        if (Str.$star() == NativePointer.$((char)'\u0000')) {
            return true;
        }
        char.ptr End = NativePointer.create_char$ptr((byte[])null);
        Major.$set(std.strtol((char.ptr)Str, (type.ptr)End.$addr(), (int)10));
        if (Str.$star() != NativePointer.$((char)'\u0000') && End.$star() == NativePointer.$((char)'\u0000')) {
            return true;
        }
        if (End.$star() != NativePointer.$((char)'.')) {
            return false;
        }
        Str = Native.$tryClone((char.ptr)((char.ptr)End.$add(1)));
        Minor.$set(std.strtol((char.ptr)Str, (type.ptr)End.$addr(), (int)10));
        if (Str.$star() != NativePointer.$((char)'\u0000') && End.$star() == NativePointer.$((char)'\u0000')) {
            return true;
        }
        if (End.$star() != NativePointer.$((char)'.')) {
            return false;
        }
        Str = Native.$tryClone((char.ptr)((char.ptr)End.$add(1)));
        Micro.$set(std.strtol((char.ptr)Str, (type.ptr)End.$addr(), (int)10));
        if (Str.$star() != NativePointer.$((char)'\u0000') && End.$star() == NativePointer.$((char)'\u0000')) {
            return true;
        }
        if (Str.$eq((Object)End)) {
            return false;
        }
        HadExtra.$set(true);
        return true;
    }

    public String toString() {
        return "Opts=" + this.Opts + ", Diags=" + this.Diags + ", Mode=" + (Object)((Object)this.Mode) + ", Name=" + this.Name + ", Dir=" + this.Dir + ", ClangExecutable=" + this.ClangExecutable + ", InstalledDir=" + this.InstalledDir + ", ResourceDir=" + this.ResourceDir + ", PrefixDirs=" + this.PrefixDirs + ", SysRoot=" + this.SysRoot + ", DyldPrefix=" + this.DyldPrefix + ", UseStdLib=" + this.UseStdLib + ", DefaultTargetTriple=" + this.DefaultTargetTriple + ", DriverTitle=" + this.DriverTitle + ", HostBits=" + this.HostBits + ", HostMachine=" + this.HostMachine + ", HostSystem=" + this.HostSystem + ", HostRelease=" + this.HostRelease + ", CCPrintOptionsFilename=" + this.CCPrintOptionsFilename + ", CCPrintHeadersFilename=" + this.CCPrintHeadersFilename + ", CCLogDiagnosticsFilename=" + this.CCLogDiagnosticsFilename + ", CCCPrintBindings=" + this.CCCPrintBindings + ", CCPrintOptions=" + this.CCPrintOptions + ", CCPrintHeaders=" + this.CCPrintHeaders + ", CCLogDiagnostics=" + this.CCLogDiagnostics + ", CCGenDiagnostics=" + this.CCGenDiagnostics + ", CCCGenericGCCName=" + this.CCCGenericGCCName + ", CheckInputsExist=" + this.CheckInputsExist + ", CCCUsePCH=" + this.CCCUsePCH + ", SuppressMissingInputWarning=" + this.SuppressMissingInputWarning + ", TempFiles=" + this.TempFiles + ", ResultFiles=" + this.ResultFiles + ", ToolChains=" + this.ToolChains;
    }

    private static final class DriverMode
    extends Enum<DriverMode> {
        public static final /* enum */ DriverMode GCCMode = new DriverMode(0L);
        public static final /* enum */ DriverMode GXXMode = new DriverMode(GCCMode.getValue() + 1);
        public static final /* enum */ DriverMode CPPMode = new DriverMode(GXXMode.getValue() + 1);
        public static final /* enum */ DriverMode CLMode = new DriverMode(CPPMode.getValue() + 1);
        private final int value;
        private static final /* synthetic */ DriverMode[] $VALUES;

        public static DriverMode[] values() {
            return (DriverMode[])$VALUES.clone();
        }

        public static DriverMode valueOf(String name) {
            return Enum.valueOf(DriverMode.class, name);
        }

        public static DriverMode valueOf(int val) {
            DriverMode out;
            DriverMode driverMode = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private DriverMode(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new DriverMode[]{GCCMode, GXXMode, CPPMode, CLMode};
        }

        private static final class Values {
            private static final DriverMode[] VALUES;
            private static final DriverMode[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (DriverMode kind : DriverMode.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new DriverMode[min < 0 ? 1 - min : 0];
                VALUES = new DriverMode[max >= 0 ? 1 + max : 0];
                for (DriverMode kind : DriverMode.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((DriverMode)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((DriverMode)kind).value] = kind;
                }
            }
        }
    }
}

