/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.SanitizerKind;
import org.clang.basic.SanitizerSet;
import org.clang.driver.Driver;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.SanitizeKind;
import org.clang.driver.impl.SanitizerArgsStatics;
import org.clang.driver.options;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.SpecialCaseList;
import org.llvm.support.llvm;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public class SanitizerArgs
implements Destructors.ClassWithDestructor {
    private SanitizerSet Sanitizers;
    private SanitizerSet RecoverableSanitizers;
    private std.string BlacklistFile;
    private int SanitizeCoverage;
    private int MsanTrackOrigins;
    private int AsanFieldPadding;
    private boolean AsanZeroBaseShadow;
    private boolean UbsanTrapOnError;
    private boolean AsanSharedRuntime;
    private boolean LinkCXXRuntimes;
    private int.ref SanitizeCoverageRef = new int.ref(){

        public int $deref() {
            return SanitizerArgs.this.SanitizeCoverage;
        }

        public int $set(int value) {
            SanitizerArgs.this.SanitizeCoverage = value;
            return value;
        }

        public int.ptr deref$ptr() {
            throw new UnsupportedOperationException("Not supported.");
        }
    };
    private int.ref MsanTrackOriginsRef = new int.ref(){

        public int $deref() {
            return SanitizerArgs.this.MsanTrackOrigins;
        }

        public int $set(int value) {
            SanitizerArgs.this.MsanTrackOrigins = value;
            return value;
        }

        public int.ptr deref$ptr() {
            throw new UnsupportedOperationException("Not supported.");
        }
    };
    private int.ref AsanFieldPaddingRef = new int.ref(){

        public int $deref() {
            return SanitizerArgs.this.AsanFieldPadding;
        }

        public int $set(int value) {
            SanitizerArgs.this.AsanFieldPadding = value;
            return value;
        }

        public int.ptr deref$ptr() {
            throw new UnsupportedOperationException("Not supported.");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SanitizerArgs(ToolChain TC, ArgList Args) {
        StringRef S;
        Arg A;
        std.string BLPath;
        Arg BLArg;
        this.Sanitizers = new SanitizerSet();
        this.RecoverableSanitizers = new SanitizerSet();
        this.BlacklistFile = new std.string();
        this.clear();
        long AllRemove = 0L;
        long DiagnosedKinds = 0L;
        long Kinds = 0L;
        long NotSupported = SanitizerArgsStatics.getToolchainUnsupportedKinds(TC);
        Driver D = TC.getDriver();
        std.reverse_iterator I = Args.rbegin();
        std.reverse_iterator E = Args.rend();
        while (ADTAliases.$noteq_reverse_iterator((abstract_iterator)I, (abstract_iterator)E)) {
            Arg Arg2 = (Arg)I.$star();
            if (Arg2.getOption().matches(new OptSpecifier((long)options.ID.OPT_fsanitize_EQ.getValue()))) {
                Arg2.claim();
                long Add = SanitizerArgsStatics.parseArgValues(D, Arg2, true);
                long KindsToDiagnose = (Add &= AllRemove ^ 0xFFFFFFFFFFFFFFFFL) & NotSupported & (DiagnosedKinds ^ 0xFFFFFFFFFFFFFFFFL);
                if (KindsToDiagnose != 0L) {
                    std.string Desc = SanitizerArgsStatics.describeSanitizeArg((Arg)I.$star(), KindsToDiagnose);
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(355L), (StringRef)new StringRef(Desc)), (StringRef)new StringRef(TC.getTriple().str())).$destroy();
                    DiagnosedKinds |= KindsToDiagnose;
                }
                Add &= NotSupported ^ 0xFFFFFFFFFFFFFFFFL;
                Add = SanitizerArgsStatics.expandGroups(Add);
                Add &= AllRemove ^ 0xFFFFFFFFFFFFFFFFL;
                Kinds |= (Add &= NotSupported ^ 0xFFFFFFFFFFFFFFFFL);
            } else if (Arg2.getOption().matches(new OptSpecifier((long)options.ID.OPT_fno_sanitize_EQ.getValue()))) {
                Arg2.claim();
                long Remove = SanitizerArgsStatics.parseArgValues(D, Arg2, true);
                AllRemove |= SanitizerArgsStatics.expandGroups(Remove);
            }
            I.$preInc();
        }
        SanitizerArgsStatics.addAllOf(this.Sanitizers, Kinds);
        long RecoverableKinds = SanitizeKind.RecoverableByDefault;
        long DiagnosedUnrecoverableKinds = 0L;
        for (Arg Arg3 : Args) {
            if (Arg3.getOption().matches(new OptSpecifier((long)options.ID.OPT_fsanitize_recover.getValue()))) {
                RecoverableKinds |= SanitizerArgsStatics.expandGroups(SanitizeKind.LegacyFsanitizeRecoverMask);
                Arg3.claim();
                continue;
            }
            if (Arg3.getOption().matches(new OptSpecifier((long)options.ID.OPT_fno_sanitize_recover.getValue()))) {
                RecoverableKinds &= SanitizerArgsStatics.expandGroups(SanitizeKind.LegacyFsanitizeRecoverMask) ^ 0xFFFFFFFFFFFFFFFFL;
                Arg3.claim();
                continue;
            }
            if (Arg3.getOption().matches(new OptSpecifier((long)options.ID.OPT_fsanitize_recover_EQ.getValue()))) {
                long Add = SanitizerArgsStatics.parseArgValues(D, Arg3, true);
                long KindsToDiagnose = Add & (long)SanitizeKind.Unrecoverable & (DiagnosedUnrecoverableKinds ^ 0xFFFFFFFFFFFFFFFFL);
                if (KindsToDiagnose != 0L) {
                    SanitizerSet SetToDiagnose = new SanitizerSet();
                    SanitizerArgsStatics.addAllOf(SetToDiagnose, KindsToDiagnose);
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(356L), (StringRef)Arg3.getOption().getName()), (StringRef)new StringRef(SanitizerArgsStatics.__toString(SetToDiagnose))).$destroy();
                    DiagnosedUnrecoverableKinds |= KindsToDiagnose;
                }
                RecoverableKinds |= SanitizerArgsStatics.expandGroups(Add);
                Arg3.claim();
                continue;
            }
            if (!Arg3.getOption().matches(new OptSpecifier((long)options.ID.OPT_fno_sanitize_recover_EQ.getValue()))) continue;
            RecoverableKinds &= SanitizerArgsStatics.expandGroups(SanitizerArgsStatics.parseArgValues(D, Arg3, true)) ^ 0xFFFFFFFFFFFFFFFFL;
            Arg3.claim();
        }
        RecoverableKinds &= Kinds;
        SanitizerArgsStatics.addAllOf(this.RecoverableSanitizers, RecoverableKinds &= (long)(~SanitizeKind.Unrecoverable));
        this.UbsanTrapOnError = Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fsanitize_undefined_trap_on_error.getValue()), new OptSpecifier((long)options.ID.OPT_fno_sanitize_undefined_trap_on_error.getValue()), false);
        if (this.UbsanTrapOnError && SanitizerArgsStatics.hasOneOf(this.Sanitizers, SanitizeKind.NotAllowedWithTrap)) {
            ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForMask(D, Args, SanitizeKind.NotAllowedWithTrap))), (char.ptr)NativePointer.$((String)"-fsanitize-undefined-trap-on-error")).$destroy();
        }
        boolean NeedsAsan = this.Sanitizers.has(SanitizerKind.Address);
        boolean NeedsTsan = this.Sanitizers.has(SanitizerKind.Thread);
        boolean NeedsMsan = this.Sanitizers.has(SanitizerKind.Memory);
        boolean NeedsLsan = this.Sanitizers.has(SanitizerKind.Leak);
        if (NeedsAsan && NeedsTsan) {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForKind(D, Args, SanitizerKind.Address))), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForKind(D, Args, SanitizerKind.Thread))).$destroy();
        }
        if (NeedsAsan && NeedsMsan) {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForKind(D, Args, SanitizerKind.Address))), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForKind(D, Args, SanitizerKind.Memory))).$destroy();
        }
        if (NeedsTsan && NeedsMsan) {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForKind(D, Args, SanitizerKind.Thread))), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForKind(D, Args, SanitizerKind.Memory))).$destroy();
        }
        if (NeedsLsan && NeedsTsan) {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForKind(D, Args, SanitizerKind.Leak))), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForKind(D, Args, SanitizerKind.Thread))).$destroy();
        }
        if (NeedsLsan && NeedsMsan) {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForKind(D, Args, SanitizerKind.Leak))), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForKind(D, Args, SanitizerKind.Memory))).$destroy();
        }
        if ((BLArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fsanitize_blacklist.getValue()), new OptSpecifier((long)options.ID.OPT_fno_sanitize_blacklist.getValue()))) != null) {
            if (BLArg.getOption().matches(new OptSpecifier((long)options.ID.OPT_fsanitize_blacklist.getValue()))) {
                BLPath = new std.string(BLArg.getValue());
                if (fs.exists((Twine)new Twine(BLPath))) {
                    std.string BLError = null;
                    std_ptr.unique_ptr SCL = null;
                    try {
                        BLError = new std.string();
                        SCL = SpecialCaseList.create((StringRef)new StringRef(BLPath), (std.string)BLError);
                        if (SCL.get() == null) {
                            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(333L), (StringRef)new StringRef(BLError)).$destroy();
                        }
                        this.BlacklistFile.$assign(BLPath);
                    }
                    finally {
                        if (SCL != null) {
                            SCL.$destroy();
                        }
                        if (BLError != null) {
                            BLError.$destroy();
                        }
                    }
                } else {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(342L), (StringRef)new StringRef(BLPath)).$destroy();
                }
            }
        } else {
            BLPath = null;
            try {
                BLPath = new std.string();
                if (this.getDefaultBlacklist(D, BLPath) && fs.exists((Twine)new Twine(BLPath))) {
                    this.BlacklistFile.$assign(BLPath);
                }
            }
            finally {
                if (BLPath != null) {
                    BLPath.$destroy();
                }
            }
        }
        if (NeedsMsan && (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fsanitize_memory_track_origins_EQ.getValue()), new OptSpecifier((long)options.ID.OPT_fsanitize_memory_track_origins.getValue()), new OptSpecifier((long)options.ID.OPT_fno_sanitize_memory_track_origins.getValue()))) != null) {
            if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fsanitize_memory_track_origins.getValue()))) {
                this.MsanTrackOrigins = 1;
            } else if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fno_sanitize_memory_track_origins.getValue()))) {
                this.MsanTrackOrigins = 0;
            } else {
                S = new StringRef(A.getValue());
                if (S.getAsInteger(0, this.MsanTrackOriginsRef) || this.MsanTrackOrigins < 0 || this.MsanTrackOrigins > 2) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(331L), (StringRef)new StringRef(A.getAsString(Args))), (StringRef)new StringRef(S)).$destroy();
                }
            }
        }
        if (SanitizerArgsStatics.hasOneOf(this.Sanitizers, SanitizeKind.SupportsCoverage) && (A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fsanitize_coverage.getValue()))) != null && ((S = new StringRef(A.getValue())).getAsInteger(0, this.SanitizeCoverageRef) || this.SanitizeCoverage < 0 || this.SanitizeCoverage > 4)) {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(331L), (StringRef)new StringRef(A.getAsString(Args))), (StringRef)new StringRef(S)).$destroy();
        }
        if (NeedsAsan) {
            Arg WindowsDebugRTArg;
            this.AsanSharedRuntime = Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared_libasan.getValue())) || TC.getTriple().getEnvironment() == Triple.EnvironmentType.Android;
            this.AsanZeroBaseShadow = TC.getTriple().getEnvironment() == Triple.EnvironmentType.Android;
            A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_fsanitize_address_field_padding.getValue()));
            if (A != null && ((S = new StringRef(A.getValue())).getAsInteger(0, this.AsanFieldPaddingRef) || this.AsanFieldPadding < 0 || this.AsanFieldPadding > 2)) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(331L), (StringRef)new StringRef(A.getAsString(Args))), (StringRef)new StringRef(S)).$destroy();
            }
            if ((WindowsDebugRTArg = Args.getLastArg(new OptSpecifier((long)options.ID.OPT__SLASH_MTd.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_MT.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_MDd.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_MD.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_LDd.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_LD.getValue()))) != null) {
                switch (options.ID.valueOf(WindowsDebugRTArg.getOption().getID())) {
                    case OPT__SLASH_MTd: 
                    case OPT__SLASH_MDd: 
                    case OPT__SLASH_LDd: {
                        ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(306L), (StringRef)new StringRef(WindowsDebugRTArg.getAsString(Args))), (StringRef)new StringRef(SanitizerArgsStatics.lastArgumentForKind(D, Args, SanitizerKind.Address))).$destroy();
                        D.Diag(361L).$destroy();
                    }
                }
            }
        }
        this.LinkCXXRuntimes = Args.hasArg(new OptSpecifier((long)options.ID.OPT_fsanitize_link_cxx_runtime.getValue())) || D.CCCIsCXX();
    }

    public boolean needsAsanRt() {
        return this.Sanitizers.has(SanitizerKind.Address);
    }

    public boolean needsSharedAsanRt() {
        return this.AsanSharedRuntime;
    }

    public boolean needsTsanRt() {
        return this.Sanitizers.has(SanitizerKind.Thread);
    }

    public boolean needsMsanRt() {
        return this.Sanitizers.has(SanitizerKind.Memory);
    }

    public boolean needsLsanRt() {
        return this.Sanitizers.has(SanitizerKind.Leak) && !this.Sanitizers.has(SanitizerKind.Address);
    }

    public boolean needsUbsanRt() {
        return !this.UbsanTrapOnError && SanitizerArgsStatics.hasOneOf(this.Sanitizers, SanitizeKind.NeedsUbsanRt);
    }

    public boolean needsDfsanRt() {
        return this.Sanitizers.has(SanitizerKind.DataFlow);
    }

    public boolean sanitizesVptr() {
        return this.Sanitizers.has(SanitizerKind.Vptr);
    }

    public boolean requiresPIE() {
        return this.AsanZeroBaseShadow || SanitizerArgsStatics.hasOneOf(this.Sanitizers, SanitizeKind.RequiresPIE);
    }

    public boolean needsUnwindTables() {
        return SanitizerArgsStatics.hasOneOf(this.Sanitizers, SanitizeKind.NeedsUnwindTables);
    }

    public boolean linkCXXRuntimes() {
        return this.LinkCXXRuntimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArgs(ArgList Args, ArgStringList CmdArgs) {
        if (this.Sanitizers.empty()) {
            return;
        }
        CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"-fsanitize="), (std.string)SanitizerArgsStatics.__toString(this.Sanitizers))));
        if (!this.RecoverableSanitizers.empty()) {
            CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"-fsanitize-recover="), (std.string)SanitizerArgsStatics.__toString(this.RecoverableSanitizers))));
        }
        if (this.UbsanTrapOnError) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-fsanitize-undefined-trap-on-error"));
        }
        if (!this.BlacklistFile.empty()) {
            SmallString BlacklistOpt = null;
            try {
                BlacklistOpt = new SmallString(new StringRef(NativePointer.$((String)"-fsanitize-blacklist=")), 64);
                BlacklistOpt.$addassign(this.BlacklistFile);
                CmdArgs.push_back((Object)Args.MakeArgString(BlacklistOpt.$StringRef()));
            }
            finally {
                if (BlacklistOpt != null) {
                    BlacklistOpt.$destroy();
                }
            }
        }
        if (this.MsanTrackOrigins != 0) {
            CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"-fsanitize-memory-track-origins="), (std.string)llvm.utostr((long)this.MsanTrackOrigins))));
        }
        if (this.AsanFieldPadding != 0) {
            CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"-fsanitize-address-field-padding="), (std.string)llvm.utostr((long)this.AsanFieldPadding))));
        }
        if (this.SanitizeCoverage != 0) {
            CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"-fsanitize-coverage="), (std.string)llvm.utostr((long)this.SanitizeCoverage))));
        }
        if (this.Sanitizers.has(SanitizerKind.Memory)) {
            CmdArgs.push_back((Object)Args.MakeArgString(NativePointer.$((String)"-fno-assume-sane-operator-new")));
        }
    }

    private void clear() {
        this.Sanitizers.clear();
        this.RecoverableSanitizers.clear();
        this.BlacklistFile.$assign(NativePointer.$((String)""));
        this.SanitizeCoverage = 0;
        this.MsanTrackOrigins = 0;
        this.AsanFieldPadding = 0;
        this.AsanZeroBaseShadow = false;
        this.UbsanTrapOnError = false;
        this.AsanSharedRuntime = false;
        this.LinkCXXRuntimes = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getDefaultBlacklist(Driver D, std.string BLPath) {
        char.ptr BlacklistFile = null;
        if (this.Sanitizers.has(SanitizerKind.Address)) {
            BlacklistFile = NativePointer.$((String)"asan_blacklist.txt");
        } else if (this.Sanitizers.has(SanitizerKind.Memory)) {
            BlacklistFile = NativePointer.$((String)"msan_blacklist.txt");
        } else if (this.Sanitizers.has(SanitizerKind.Thread)) {
            BlacklistFile = NativePointer.$((String)"tsan_blacklist.txt");
        } else if (this.Sanitizers.has(SanitizerKind.DataFlow)) {
            BlacklistFile = NativePointer.$((String)"dfsan_abilist.txt");
        }
        if (BlacklistFile != null) {
            SmallString Path = null;
            try {
                Path = new SmallString(new StringRef(D.ResourceDir), 64);
                path.append((SmallString)Path, (char.ptr)BlacklistFile);
                BLPath.$assign(Path.str().$basic_string());
                boolean bl = true;
                return bl;
            }
            finally {
                if (Path != null) {
                    Path.$destroy();
                }
            }
        }
        return false;
    }

    public void $destroy() {
    }

    public String toString() {
        return "Sanitizers=" + this.Sanitizers + ", RecoverableSanitizers=" + this.RecoverableSanitizers + ", BlacklistFile=" + this.BlacklistFile + ", SanitizeCoverage=" + this.SanitizeCoverage + ", MsanTrackOrigins=" + this.MsanTrackOrigins + ", AsanFieldPadding=" + this.AsanFieldPadding + ", AsanZeroBaseShadow=" + this.AsanZeroBaseShadow + ", UbsanTrapOnError=" + this.UbsanTrapOnError + ", AsanSharedRuntime=" + this.AsanSharedRuntime + ", LinkCXXRuntimes=" + this.LinkCXXRuntimes;
    }
}

