/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.SanitizerKind;
import org.clang.basic.SanitizerSet;
import org.clang.driver.Driver;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.SanitizeKind;
import org.clang.driver.options;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm_unreachable;

public final class SanitizerArgsStatics {
    public static boolean hasOneOf(SanitizerSet Sanitizers, long Kinds) {
        if (Sanitizers.has(SanitizerKind.Address) && (Kinds & (long)SanitizeKind.Address) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.Memory) && (Kinds & (long)SanitizeKind.Memory) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.Thread) && (Kinds & (long)SanitizeKind.Thread) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.Leak) && (Kinds & (long)SanitizeKind.Leak) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.Alignment) && (Kinds & (long)SanitizeKind.Alignment) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.ArrayBounds) && (Kinds & (long)SanitizeKind.ArrayBounds) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.Bool) && (Kinds & (long)SanitizeKind.Bool) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.Enum) && (Kinds & (long)SanitizeKind.Enum) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.FloatCastOverflow) && (Kinds & (long)SanitizeKind.FloatCastOverflow) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.FloatDivideByZero) && (Kinds & (long)SanitizeKind.FloatDivideByZero) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.Function) && (Kinds & (long)SanitizeKind.Function) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.IntegerDivideByZero) && (Kinds & (long)SanitizeKind.IntegerDivideByZero) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.NonnullAttribute) && (Kinds & (long)SanitizeKind.NonnullAttribute) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.Null) && (Kinds & (long)SanitizeKind.Null) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.ObjectSize) && (Kinds & (long)SanitizeKind.ObjectSize) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.Return) && (Kinds & (long)SanitizeKind.Return) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.ReturnsNonnullAttribute) && (Kinds & (long)SanitizeKind.ReturnsNonnullAttribute) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.Shift) && (Kinds & (long)SanitizeKind.Shift) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.SignedIntegerOverflow) && (Kinds & (long)SanitizeKind.SignedIntegerOverflow) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.Unreachable) && (Kinds & (long)SanitizeKind.Unreachable) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.VLABound) && (Kinds & (long)SanitizeKind.VLABound) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.Vptr) && (Kinds & (long)SanitizeKind.Vptr) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.UnsignedIntegerOverflow) && (Kinds & (long)SanitizeKind.UnsignedIntegerOverflow) != 0L) {
            return true;
        }
        if (Sanitizers.has(SanitizerKind.DataFlow) && (Kinds & (long)SanitizeKind.DataFlow) != 0L) {
            return true;
        }
        return Sanitizers.has(SanitizerKind.LocalBounds) && (Kinds & (long)SanitizeKind.LocalBounds) != 0L;
    }

    public static void addAllOf(SanitizerSet Sanitizers, long Kinds) {
        if ((Kinds & (long)SanitizeKind.Address) != 0L) {
            Sanitizers.set(SanitizerKind.Address, true);
        }
        if ((Kinds & (long)SanitizeKind.Memory) != 0L) {
            Sanitizers.set(SanitizerKind.Memory, true);
        }
        if ((Kinds & (long)SanitizeKind.Thread) != 0L) {
            Sanitizers.set(SanitizerKind.Thread, true);
        }
        if ((Kinds & (long)SanitizeKind.Leak) != 0L) {
            Sanitizers.set(SanitizerKind.Leak, true);
        }
        if ((Kinds & (long)SanitizeKind.Alignment) != 0L) {
            Sanitizers.set(SanitizerKind.Alignment, true);
        }
        if ((Kinds & (long)SanitizeKind.ArrayBounds) != 0L) {
            Sanitizers.set(SanitizerKind.ArrayBounds, true);
        }
        if ((Kinds & (long)SanitizeKind.Bool) != 0L) {
            Sanitizers.set(SanitizerKind.Bool, true);
        }
        if ((Kinds & (long)SanitizeKind.Enum) != 0L) {
            Sanitizers.set(SanitizerKind.Enum, true);
        }
        if ((Kinds & (long)SanitizeKind.FloatCastOverflow) != 0L) {
            Sanitizers.set(SanitizerKind.FloatCastOverflow, true);
        }
        if ((Kinds & (long)SanitizeKind.FloatDivideByZero) != 0L) {
            Sanitizers.set(SanitizerKind.FloatDivideByZero, true);
        }
        if ((Kinds & (long)SanitizeKind.Function) != 0L) {
            Sanitizers.set(SanitizerKind.Function, true);
        }
        if ((Kinds & (long)SanitizeKind.IntegerDivideByZero) != 0L) {
            Sanitizers.set(SanitizerKind.IntegerDivideByZero, true);
        }
        if ((Kinds & (long)SanitizeKind.NonnullAttribute) != 0L) {
            Sanitizers.set(SanitizerKind.NonnullAttribute, true);
        }
        if ((Kinds & (long)SanitizeKind.Null) != 0L) {
            Sanitizers.set(SanitizerKind.Null, true);
        }
        if ((Kinds & (long)SanitizeKind.ObjectSize) != 0L) {
            Sanitizers.set(SanitizerKind.ObjectSize, true);
        }
        if ((Kinds & (long)SanitizeKind.Return) != 0L) {
            Sanitizers.set(SanitizerKind.Return, true);
        }
        if ((Kinds & (long)SanitizeKind.ReturnsNonnullAttribute) != 0L) {
            Sanitizers.set(SanitizerKind.ReturnsNonnullAttribute, true);
        }
        if ((Kinds & (long)SanitizeKind.Shift) != 0L) {
            Sanitizers.set(SanitizerKind.Shift, true);
        }
        if ((Kinds & (long)SanitizeKind.SignedIntegerOverflow) != 0L) {
            Sanitizers.set(SanitizerKind.SignedIntegerOverflow, true);
        }
        if ((Kinds & (long)SanitizeKind.Unreachable) != 0L) {
            Sanitizers.set(SanitizerKind.Unreachable, true);
        }
        if ((Kinds & (long)SanitizeKind.VLABound) != 0L) {
            Sanitizers.set(SanitizerKind.VLABound, true);
        }
        if ((Kinds & (long)SanitizeKind.Vptr) != 0L) {
            Sanitizers.set(SanitizerKind.Vptr, true);
        }
        if ((Kinds & (long)SanitizeKind.UnsignedIntegerOverflow) != 0L) {
            Sanitizers.set(SanitizerKind.UnsignedIntegerOverflow, true);
        }
        if ((Kinds & (long)SanitizeKind.DataFlow) != 0L) {
            Sanitizers.set(SanitizerKind.DataFlow, true);
        }
        if ((Kinds & (long)SanitizeKind.LocalBounds) != 0L) {
            Sanitizers.set(SanitizerKind.LocalBounds, true);
        }
    }

    public static long toSanitizeKind(SanitizerKind K) {
        if (K == SanitizerKind.Address) {
            return SanitizeKind.Address;
        }
        if (K == SanitizerKind.Memory) {
            return SanitizeKind.Memory;
        }
        if (K == SanitizerKind.Thread) {
            return SanitizeKind.Thread;
        }
        if (K == SanitizerKind.Leak) {
            return SanitizeKind.Leak;
        }
        if (K == SanitizerKind.Alignment) {
            return SanitizeKind.Alignment;
        }
        if (K == SanitizerKind.ArrayBounds) {
            return SanitizeKind.ArrayBounds;
        }
        if (K == SanitizerKind.Bool) {
            return SanitizeKind.Bool;
        }
        if (K == SanitizerKind.Enum) {
            return SanitizeKind.Enum;
        }
        if (K == SanitizerKind.FloatCastOverflow) {
            return SanitizeKind.FloatCastOverflow;
        }
        if (K == SanitizerKind.FloatDivideByZero) {
            return SanitizeKind.FloatDivideByZero;
        }
        if (K == SanitizerKind.Function) {
            return SanitizeKind.Function;
        }
        if (K == SanitizerKind.IntegerDivideByZero) {
            return SanitizeKind.IntegerDivideByZero;
        }
        if (K == SanitizerKind.NonnullAttribute) {
            return SanitizeKind.NonnullAttribute;
        }
        if (K == SanitizerKind.Null) {
            return SanitizeKind.Null;
        }
        if (K == SanitizerKind.ObjectSize) {
            return SanitizeKind.ObjectSize;
        }
        if (K == SanitizerKind.Return) {
            return SanitizeKind.Return;
        }
        if (K == SanitizerKind.ReturnsNonnullAttribute) {
            return SanitizeKind.ReturnsNonnullAttribute;
        }
        if (K == SanitizerKind.Shift) {
            return SanitizeKind.Shift;
        }
        if (K == SanitizerKind.SignedIntegerOverflow) {
            return SanitizeKind.SignedIntegerOverflow;
        }
        if (K == SanitizerKind.Unreachable) {
            return SanitizeKind.Unreachable;
        }
        if (K == SanitizerKind.VLABound) {
            return SanitizeKind.VLABound;
        }
        if (K == SanitizerKind.Vptr) {
            return SanitizeKind.Vptr;
        }
        if (K == SanitizerKind.UnsignedIntegerOverflow) {
            return SanitizeKind.UnsignedIntegerOverflow;
        }
        if (K == SanitizerKind.DataFlow) {
            return SanitizeKind.DataFlow;
        }
        if (K == SanitizerKind.LocalBounds) {
            return SanitizeKind.LocalBounds;
        }
        throw new llvm_unreachable((CharSequence)"Invalid SanitizerKind!");
    }

    public static long parseValue(char.ptr Value) {
        long ParsedKind = ((Integer)new StringSwitch(new StringRef(Value)).Case(NativePointer.$((String)"address"), (Object)SanitizeKind.Address).Case(NativePointer.$((String)"memory"), (Object)SanitizeKind.Memory).Case(NativePointer.$((String)"thread"), (Object)SanitizeKind.Thread).Case(NativePointer.$((String)"leak"), (Object)SanitizeKind.Leak).Case(NativePointer.$((String)"alignment"), (Object)SanitizeKind.Alignment).Case(NativePointer.$((String)"array-bounds"), (Object)SanitizeKind.ArrayBounds).Case(NativePointer.$((String)"bool"), (Object)SanitizeKind.Bool).Case(NativePointer.$((String)"enum"), (Object)SanitizeKind.Enum).Case(NativePointer.$((String)"float-cast-overflow"), (Object)SanitizeKind.FloatCastOverflow).Case(NativePointer.$((String)"float-divide-by-zero"), (Object)SanitizeKind.FloatDivideByZero).Case(NativePointer.$((String)"function"), (Object)SanitizeKind.Function).Case(NativePointer.$((String)"integer-divide-by-zero"), (Object)SanitizeKind.IntegerDivideByZero).Case(NativePointer.$((String)"nonnull-attribute"), (Object)SanitizeKind.NonnullAttribute).Case(NativePointer.$((String)"null"), (Object)SanitizeKind.Null).Case(NativePointer.$((String)"object-size"), (Object)SanitizeKind.ObjectSize).Case(NativePointer.$((String)"return"), (Object)SanitizeKind.Return).Case(NativePointer.$((String)"returns-nonnull-attribute"), (Object)SanitizeKind.ReturnsNonnullAttribute).Case(NativePointer.$((String)"shift"), (Object)SanitizeKind.Shift).Case(NativePointer.$((String)"signed-integer-overflow"), (Object)SanitizeKind.SignedIntegerOverflow).Case(NativePointer.$((String)"unreachable"), (Object)SanitizeKind.Unreachable).Case(NativePointer.$((String)"vla-bound"), (Object)SanitizeKind.VLABound).Case(NativePointer.$((String)"vptr"), (Object)SanitizeKind.Vptr).Case(NativePointer.$((String)"unsigned-integer-overflow"), (Object)SanitizeKind.UnsignedIntegerOverflow).Case(NativePointer.$((String)"dataflow"), (Object)SanitizeKind.DataFlow).Case(NativePointer.$((String)"undefined"), (Object)SanitizeKind.UndefinedGroup).Case(NativePointer.$((String)"undefined-trap"), (Object)SanitizeKind.UndefinedTrapGroup).Case(NativePointer.$((String)"integer"), (Object)SanitizeKind.IntegerGroup).Case(NativePointer.$((String)"local-bounds"), (Object)SanitizeKind.LocalBounds).Case(NativePointer.$((String)"bounds"), (Object)SanitizeKind.BoundsGroup).Case(NativePointer.$((String)"all"), (Object)SanitizeKind.AllGroup).Default((Object)0)).intValue();
        return ParsedKind;
    }

    public static long parseArgValues(Driver D, Arg A, boolean DiagnoseErrors) {
        assert (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fsanitize_EQ.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fno_sanitize_EQ.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fsanitize_recover_EQ.getValue())) || A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fno_sanitize_recover_EQ.getValue()))) : "Invalid argument in parseArgValues!";
        long Kinds = 0L;
        long N = A.getNumValues();
        for (long I = 0L; I != N; ++I) {
            char.ptr Value = Native.$tryClone((char.ptr)A.getValue(I));
            long Kind2 = A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fsanitize_EQ.getValue())) && 0 == std.strcmp((char.ptr)NativePointer.$((String)"all"), (char.ptr)Value) ? 0L : SanitizerArgsStatics.parseValue(Value);
            if (Kind2 != 0L) {
                Kinds |= Kind2;
                continue;
            }
            if (!DiagnoseErrors) continue;
            ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(356L), (StringRef)A.getOption().getName()), (char.ptr)Value).$destroy();
        }
        return Kinds;
    }

    public static std.string lastArgumentForMask(Driver D, ArgList Args, long Mask) {
        std.reverse_iterator I = Args.rbegin();
        std.reverse_iterator E = Args.rend();
        while (ADTAliases.$noteq_reverse_iterator((abstract_iterator)I, (abstract_iterator)E)) {
            Arg Arg2 = (Arg)I.$star();
            if (Arg2.getOption().matches(new OptSpecifier((long)options.ID.OPT_fsanitize_EQ.getValue()))) {
                long AddKinds = SanitizerArgsStatics.expandGroups(SanitizerArgsStatics.parseArgValues(D, Arg2, false));
                if ((AddKinds & Mask) != 0L) {
                    return SanitizerArgsStatics.describeSanitizeArg(Arg2, Mask);
                }
            } else if (Arg2.getOption().matches(new OptSpecifier((long)options.ID.OPT_fno_sanitize_EQ.getValue()))) {
                long RemoveKinds = SanitizerArgsStatics.expandGroups(SanitizerArgsStatics.parseArgValues(D, Arg2, false));
                Mask &= RemoveKinds ^ 0xFFFFFFFFFFFFFFFFL;
            }
            I.$preInc();
        }
        throw new llvm_unreachable((CharSequence)"arg list didn't provide expected value");
    }

    public static std.string lastArgumentForKind(Driver D, ArgList Args, SanitizerKind K) {
        return SanitizerArgsStatics.lastArgumentForMask(D, Args, SanitizerArgsStatics.toSanitizeKind(K));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.string describeSanitizeArg(Arg A, long Mask) {
        std.string Sanitizers = null;
        try {
            assert (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_fsanitize_EQ.getValue()))) : "Invalid argument in describeSanitizerArg!";
            Sanitizers = new std.string();
            long N = A.getNumValues();
            for (long I = 0L; I != N; ++I) {
                if ((SanitizerArgsStatics.expandGroups(SanitizerArgsStatics.parseValue(A.getValue(I))) & Mask) == 0L) continue;
                if (!Sanitizers.empty()) {
                    Sanitizers.$addassign(NativePointer.$((String)","));
                }
                Sanitizers.$addassign(A.getValue(I));
            }
            assert (!Sanitizers.empty()) : "arg didn't provide expected value";
            std.string string2 = std.$plus_T_str((Object)NativePointer.$((String)"-fsanitize="), (std.string)Sanitizers);
            return string2;
        }
        finally {
            if (Sanitizers != null) {
                Sanitizers.$destroy();
            }
        }
    }

    public static std.string __toString(SanitizerSet Sanitizers) {
        std.string Res = null;
        try {
            Res = new std.string();
            if (Sanitizers.has(SanitizerKind.Address)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"address"));
            }
            if (Sanitizers.has(SanitizerKind.Memory)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"memory"));
            }
            if (Sanitizers.has(SanitizerKind.Thread)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"thread"));
            }
            if (Sanitizers.has(SanitizerKind.Leak)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"leak"));
            }
            if (Sanitizers.has(SanitizerKind.Alignment)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"alignment"));
            }
            if (Sanitizers.has(SanitizerKind.ArrayBounds)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"array-bounds"));
            }
            if (Sanitizers.has(SanitizerKind.Bool)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"bool"));
            }
            if (Sanitizers.has(SanitizerKind.Enum)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"enum"));
            }
            if (Sanitizers.has(SanitizerKind.FloatCastOverflow)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"float-cast-overflow"));
            }
            if (Sanitizers.has(SanitizerKind.FloatDivideByZero)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"float-divide-by-zero"));
            }
            if (Sanitizers.has(SanitizerKind.Function)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"function"));
            }
            if (Sanitizers.has(SanitizerKind.IntegerDivideByZero)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"integer-divide-by-zero"));
            }
            if (Sanitizers.has(SanitizerKind.NonnullAttribute)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"nonnull-attribute"));
            }
            if (Sanitizers.has(SanitizerKind.Null)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"null"));
            }
            if (Sanitizers.has(SanitizerKind.ObjectSize)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"object-size"));
            }
            if (Sanitizers.has(SanitizerKind.Return)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"return"));
            }
            if (Sanitizers.has(SanitizerKind.ReturnsNonnullAttribute)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"returns-nonnull-attribute"));
            }
            if (Sanitizers.has(SanitizerKind.Shift)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"shift"));
            }
            if (Sanitizers.has(SanitizerKind.SignedIntegerOverflow)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"signed-integer-overflow"));
            }
            if (Sanitizers.has(SanitizerKind.Unreachable)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"unreachable"));
            }
            if (Sanitizers.has(SanitizerKind.VLABound)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"vla-bound"));
            }
            if (Sanitizers.has(SanitizerKind.Vptr)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"vptr"));
            }
            if (Sanitizers.has(SanitizerKind.UnsignedIntegerOverflow)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"unsigned-integer-overflow"));
            }
            if (Sanitizers.has(SanitizerKind.DataFlow)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"dataflow"));
            }
            if (Sanitizers.has(SanitizerKind.LocalBounds)) {
                if (!Res.empty()) {
                    Res.$addassign(NativePointer.$((String)","));
                }
                Res.$addassign(NativePointer.$((String)"local-bounds"));
            }
            std.string string2 = new std.string(Res);
            return string2;
        }
        finally {
            if (Res != null) {
                Res.$destroy();
            }
        }
    }

    public static long expandGroups(long Kinds) {
        if ((Kinds & (long)SanitizeKind.UndefinedGroup) != 0L) {
            Kinds |= (long)SanitizeKind.Undefined;
        }
        if ((Kinds & (long)SanitizeKind.UndefinedTrapGroup) != 0L) {
            Kinds |= (long)SanitizeKind.UndefinedTrap;
        }
        if ((Kinds & (long)SanitizeKind.IntegerGroup) != 0L) {
            Kinds |= (long)SanitizeKind.Integer;
        }
        if ((Kinds & (long)SanitizeKind.BoundsGroup) != 0L) {
            Kinds |= (long)SanitizeKind.Bounds;
        }
        if ((Kinds & (long)SanitizeKind.AllGroup) != 0L) {
            Kinds |= 0xFFFFFFFFFFFFFFFFL;
        }
        return Kinds;
    }

    public static long getToolchainUnsupportedKinds(ToolChain TC) {
        boolean IsFreeBSD = TC.getTriple().getOS() == Triple.OSType.FreeBSD;
        boolean IsLinux = TC.getTriple().getOS() == Triple.OSType.Linux;
        boolean IsX86 = TC.getTriple().getArch() == Triple.ArchType.x86;
        boolean IsX86_64 = TC.getTriple().getArch() == Triple.ArchType.x86_64;
        long Unsupported = 0L;
        if (!IsLinux || !IsX86_64) {
            Unsupported |= (long)(SanitizeKind.Memory | SanitizeKind.DataFlow);
        }
        if (!IsLinux && !IsFreeBSD || !IsX86_64) {
            Unsupported |= (long)SanitizeKind.Thread;
        }
        if (!IsLinux || !IsX86 && !IsX86_64) {
            Unsupported |= (long)SanitizeKind.Function;
        }
        return Unsupported;
    }
}

