/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modeldiscovery.provider;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.ProviderPropertyType;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.configurations.PkgConfigManager;
import org.netbeans.modules.cnd.modeldiscovery.provider.ModelSource;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AnalyzeModel
implements DiscoveryProvider {
    public static final String MODEL_FOLDER_PROVIDER_ID = "model-folder";
    private final Map<String, ProviderProperty> myProperties = new HashMap<String, ProviderProperty>();
    private final ProviderProperty<String> MODEL_FOLDER_PROPERTY;
    private final ProviderProperty<Boolean> PREFER_LOCAL_FILES_PROPERTY;
    private boolean isStoped = false;

    public AnalyzeModel() {
        this.myProperties.clear();
        this.MODEL_FOLDER_PROPERTY = new ProviderProperty<String>(){
            private String myPath;

            public String getName() {
                return AnalyzeModel.i18n("Model_Files_Name");
            }

            public String getDescription() {
                return AnalyzeModel.i18n("Model_Files_Description");
            }

            public String getValue() {
                return this.myPath;
            }

            public void setValue(String value) {
                this.myPath = value;
            }

            public ProviderPropertyType<String> getPropertyType() {
                return ProviderPropertyType.ModelFolderPropertyType;
            }
        };
        this.myProperties.put(this.MODEL_FOLDER_PROPERTY.getPropertyType().key(), this.MODEL_FOLDER_PROPERTY);
        this.PREFER_LOCAL_FILES_PROPERTY = new ProviderProperty<Boolean>(){
            private Boolean myValue = Boolean.FALSE;

            public String getName() {
                return AnalyzeModel.i18n("Prefer_Local_Files");
            }

            public String getDescription() {
                return AnalyzeModel.i18n("Prefer_Local_Files_Description");
            }

            public Boolean getValue() {
                return this.myValue;
            }

            public void setValue(Boolean value) {
                this.myValue = value;
            }

            public ProviderPropertyType<Boolean> getPropertyType() {
                return ProviderPropertyType.PreferLocalFilesPropertyType;
            }
        };
        this.myProperties.put(this.PREFER_LOCAL_FILES_PROPERTY.getPropertyType().key(), this.PREFER_LOCAL_FILES_PROPERTY);
    }

    public String getID() {
        return MODEL_FOLDER_PROVIDER_ID;
    }

    public String getName() {
        return AnalyzeModel.i18n("Model_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeModel.i18n("Model_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String key) {
        return this.myProperties.get(key);
    }

    public boolean cancel() {
        this.isStoped = true;
        return true;
    }

    public List<org.netbeans.modules.cnd.discovery.api.Configuration> analyze(ProjectProxy project, Progress progress, Interrupter interrupter) {
        this.isStoped = false;
        MyConfiguration conf = new MyConfiguration(project, progress);
        ArrayList<org.netbeans.modules.cnd.discovery.api.Configuration> confs = new ArrayList<org.netbeans.modules.cnd.discovery.api.Configuration>();
        confs.add(conf);
        return confs;
    }

    private Map<String, List<String>> search(String root) {
        HashSet<String> set = new HashSet<String>();
        HashSet<String> antiLoop = new HashSet<String>();
        ArrayList<String> list = new ArrayList<String>();
        list.add(root);
        Iterator it = list.iterator();
        while (it.hasNext() && !this.isStoped) {
            File f = new File((String)it.next());
            this.gatherSubFolders(f, set, antiLoop);
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Iterator it2 = set.iterator();
        while (it2.hasNext() && !this.isStoped) {
            File[] ff;
            File d = new File((String)it2.next());
            if (!d.exists() || !d.isDirectory() || !d.canRead() || (ff = d.listFiles()) == null) continue;
            for (int i = 0; i < ff.length; ++i) {
                if (!ff[i].isFile()) continue;
                List<String> l = map.get(ff[i].getName());
                if (l == null) {
                    l = new ArrayList<String>();
                    map.put(ff[i].getName(), l);
                }
                String path = ff[i].getAbsolutePath();
                if (Utilities.isWindows()) {
                    path = path.replace('\\', '/');
                }
                l.add(path);
            }
        }
        return map;
    }

    private void gatherSubFolders(File d, HashSet<String> set, HashSet<String> antiLoop) {
        if (this.isStoped) {
            return;
        }
        if (d.exists() && d.isDirectory() && d.canRead()) {
            String canPath;
            if (CndPathUtilities.isIgnoredFolder((File)d)) {
                return;
            }
            try {
                canPath = d.getCanonicalPath();
            }
            catch (IOException ex) {
                return;
            }
            if (!antiLoop.contains(canPath)) {
                antiLoop.add(canPath);
                String path = d.getAbsolutePath();
                if (Utilities.isWindows()) {
                    path = path.replace('\\', '/');
                }
                set.add(path);
                File[] ff = d.listFiles();
                if (ff != null) {
                    for (int i = 0; i < ff.length; ++i) {
                        if (!ff[i].isDirectory()) continue;
                        this.gatherSubFolders(ff[i], set, antiLoop);
                    }
                }
            }
        }
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(AnalyzeModel.class, (String)id);
    }

    public boolean isApplicable(ProjectProxy project) {
        CsmProject langProject;
        Project makeProject;
        ConfigurationDescriptorProvider pdp;
        return project.getProject() != null && (pdp = (ConfigurationDescriptorProvider)(makeProject = project.getProject()).getLookup().lookup(ConfigurationDescriptorProvider.class)).gotDescriptor() && (langProject = CsmModelAccessor.getModel().getProject((Object)makeProject)) != null;
    }

    public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy project, Interrupter interrupter) {
        return new ApplicableImpl(true, null, null, 40, false, null, null, null, null);
    }

    private class MyConfiguration
    implements org.netbeans.modules.cnd.discovery.api.Configuration {
        private List<SourceFileProperties> myFileProperties;
        private List<String> myIncludedFiles;
        private final MakeConfigurationDescriptor makeConfigurationDescriptor;
        private final CsmProject langProject;
        private final ProjectProxy project;
        private final Progress progress;

        private MyConfiguration(ProjectProxy project, Progress progress) {
            Project makeProject = project.getProject();
            this.progress = progress;
            this.project = project;
            this.langProject = CsmModelAccessor.getModel().getProject((Object)makeProject);
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
            this.makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        }

        public List<ProjectProperties> getProjectConfiguration() {
            return ProjectImpl.divideByLanguage(this.getSourcesConfiguration(), (ProjectProxy)this.project);
        }

        public List<String> getDependencies() {
            return null;
        }

        public List<String> getBuildArtifacts() {
            return null;
        }

        public boolean isExcluded(Item item) {
            MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
            ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
            if (itemConfiguration == null) {
                return true;
            }
            BooleanConfiguration excl = itemConfiguration.getExcluded();
            return excl.getValue();
        }

        private ExecutionEnvironment getExecutionEnvironment() {
            MakeConfiguration activeConfiguration = this.makeConfigurationDescriptor.getActiveConfiguration();
            ExecutionEnvironment env = null;
            if (activeConfiguration != null) {
                env = activeConfiguration.getDevelopmentHost().getExecutionEnvironment();
            }
            if (env == null) {
                env = ExecutionEnvironmentFactory.getLocal();
            }
            return env;
        }

        private List<SourceFileProperties> getSourceFileProperties(String root) {
            ArrayList<SourceFileProperties> res = new ArrayList<SourceFileProperties>();
            if (root != null && this.langProject != null) {
                Item item;
                int i;
                Map searchBase = AnalyzeModel.this.search(root);
                PkgConfigManager.PkgConfig pkgConfig = PkgConfigManager.getDefault().getPkgConfig(this.getExecutionEnvironment());
                boolean preferLocal = (Boolean)AnalyzeModel.this.PREFER_LOCAL_FILES_PROPERTY.getValue();
                Item[] items = this.makeConfigurationDescriptor.getProjectItems();
                HashMap<String, Item> projectSearchBase = new HashMap<String, Item>();
                for (i = 0; i < items.length && !AnalyzeModel.this.isStoped; ++i) {
                    item = items[i];
                    String path = item.getNormalizedPath();
                    projectSearchBase.put(path, item);
                }
                for (i = 0; i < items.length && !AnalyzeModel.this.isStoped; ++i) {
                    CsmFile langFile;
                    NativeFileItem.Language lang;
                    item = items[i];
                    if (this.isExcluded(item) || (lang = item.getLanguage()) != NativeFileItem.Language.C && lang != NativeFileItem.Language.CPP || (langFile = this.langProject.findFile((Object)item, true, false)) == null) continue;
                    ModelSource source = new ModelSource(item, langFile, searchBase, projectSearchBase, pkgConfig, preferLocal);
                    res.add(source);
                }
            }
            return res;
        }

        public List<SourceFileProperties> getSourcesConfiguration() {
            if (this.myFileProperties == null) {
                this.myFileProperties = this.getSourceFileProperties((String)AnalyzeModel.this.MODEL_FOLDER_PROPERTY.getValue());
            }
            return this.myFileProperties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getIncludedFiles() {
            if (this.myIncludedFiles == null) {
                HashSet<String> unique = new HashSet<String>();
                Item[] items = this.makeConfigurationDescriptor.getProjectItems();
                if (this.progress != null) {
                    this.progress.start(items.length);
                }
                try {
                    File file;
                    for (int i = 0; i < items.length && !AnalyzeModel.this.isStoped; ++i) {
                        CharSequence path;
                        Item item = items[i];
                        if (this.isExcluded(item) || !CndFileUtils.exists((File)(file = new File((String)(path = item.getAbsPath()))))) continue;
                        unique.add(CndFileUtils.normalizeAbsolutePath((String)file.getAbsolutePath()));
                    }
                    HashSet<CharSequence> unUnique = new HashSet<CharSequence>();
                    for (SourceFileProperties source : this.getSourcesConfiguration()) {
                        if (source instanceof ModelSource) {
                            unUnique.addAll(((ModelSource)source).getIncludedFiles());
                        }
                        if (this.progress == null) continue;
                        this.progress.increment(null);
                    }
                    for (CharSequence path : unUnique) {
                        file = new File(path.toString());
                        if (!CndFileUtils.exists((File)file)) continue;
                        unique.add(CndFileUtils.normalizeAbsolutePath((String)file.getAbsolutePath()));
                    }
                    this.myIncludedFiles = new ArrayList<String>(unique);
                }
                finally {
                    if (this.progress != null) {
                        this.progress.done();
                    }
                }
            }
            return this.myIncludedFiles;
        }
    }
}

