/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.ResolvedDependencies;
import org.netbeans.modules.javacard.project.deps.ResolvedDependency;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.xml.sax.SAXException;

class JCSourceForBinaryQuery
implements SourceForBinaryQueryImplementation {
    private final JCProject project;

    JCSourceForBinaryQuery(JCProject project) {
        this.project = project;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        try {
            ResolvedDependencies deps = this.project.syncGetResolvedDependencies();
            URL jarRoot = JCSourceForBinaryQuery.deJar(binaryRoot);
            File test = new File(jarRoot.toURI());
            for (ResolvedDependency resolvedDependency : deps.all()) {
                URL url;
                FileObject fo;
                File sources;
                File f = resolvedDependency.resolveFile(ArtifactKind.ORIGIN);
                if (!f.equals(test) || (sources = resolvedDependency.resolveFile(ArtifactKind.SOURCES_PATH)) == null || !sources.exists() || (fo = URLMapper.findFileObject((URL)(url = JCSourceForBinaryQuery.wrapJar(sources.toURI().toURL())))) == null) continue;
                return new R(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)sources)));
            }
            return null;
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static URL deJar(URL url) {
        if (url == null) {
            return null;
        }
        URL u = FileUtil.getArchiveFile((URL)url);
        return u == null ? url : u;
    }

    public static URL wrapJar(URL url) {
        if (url == null) {
            return null;
        }
        String name = url.toExternalForm().toLowerCase();
        if (name.endsWith(".jar") || name.endsWith(".zip")) {
            return FileUtil.getArchiveRoot((URL)url);
        }
        if (!name.endsWith("/")) {
            try {
                return new URL(url.toExternalForm() + "/");
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return url;
    }

    public static boolean isParentOf(URL root, URL file) {
        if (root == null || file == null) {
            return false;
        }
        return JCSourceForBinaryQuery.deJar(file).toExternalForm().startsWith(JCSourceForBinaryQuery.deJar(root).toExternalForm());
    }

    private static final class R
    implements SourceForBinaryQuery.Result,
    FileChangeListener {
        private FileObject root;
        private final ChangeSupport supp = new ChangeSupport((Object)this);

        private R(FileObject root) {
            this.root = root;
            root.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)root));
        }

        public FileObject[] getRoots() {
            FileObject[] fileObjectArray;
            if (this.root.isValid()) {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = this.root;
            } else {
                fileObjectArray = new FileObject[]{};
            }
            return fileObjectArray;
        }

        public void addChangeListener(ChangeListener l) {
            this.supp.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.supp.removeChangeListener(l);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.supp.fireChange();
        }

        public void fileDataCreated(FileEvent fe) {
            this.supp.fireChange();
        }

        public void fileChanged(FileEvent fe) {
            this.supp.fireChange();
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.supp.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

