/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.io.File;
import java.io.IOException;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

abstract class JavaSymbolDescriptorBase
extends SymbolDescriptor {
    private final ElementHandle<TypeElement> owner;
    private final Project project;
    private final FileObject root;
    private final ClassIndexImpl ci;
    private volatile FileObject cachedFo;
    private volatile String cachedPath;

    JavaSymbolDescriptorBase(@NonNull ElementHandle<TypeElement> owner, @NullAllowed Project project, @NonNull FileObject root, @NonNull ClassIndexImpl ci) {
        assert (owner != null);
        assert (root != null);
        assert (ci != null);
        this.owner = owner;
        this.project = project;
        this.root = root;
        this.ci = ci;
    }

    JavaSymbolDescriptorBase(@NonNull JavaSymbolDescriptorBase other) {
        this.owner = other.owner;
        this.project = other.project;
        this.root = other.root;
        this.ci = other.ci;
        this.cachedFo = other.cachedFo;
        this.cachedPath = other.cachedPath;
    }

    @NonNull
    public final String getOwnerName() {
        return this.owner.getQualifiedName();
    }

    @CheckForNull
    public final FileObject getFileObject() {
        FileObject res = this.cachedFo;
        if (res == null) {
            ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{this.root}));
            res = this.cachedFo = SourceUtils.getFile(this.owner, (ClasspathInfo)cpInfo);
        }
        return res;
    }

    @NonNull
    public final String getFileDisplayPath() {
        String res = this.cachedPath;
        if (res == null) {
            File rootFile = FileUtil.toFile((FileObject)this.root);
            if (rootFile != null) {
                try {
                    String binaryName = this.owner.getBinaryName();
                    String relativePath = this.ci.getSourceName(binaryName);
                    if (relativePath == null) {
                        relativePath = binaryName;
                        int lastDot = relativePath.lastIndexOf(46);
                        int csIndex = relativePath.indexOf(36, lastDot);
                        if (csIndex > 0 && csIndex < relativePath.length() - 1) {
                            relativePath = binaryName.substring(0, csIndex);
                        }
                        relativePath = String.format("%s.%s", FileObjects.convertPackage2Folder((String)relativePath, (char)File.separatorChar), "java");
                    }
                    res = new File(rootFile, relativePath).getAbsolutePath();
                }
                catch (IOException | InterruptedException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            if (res == null) {
                FileObject fo = this.getFileObject();
                res = fo == null ? "" : FileUtil.getFileDisplayName((FileObject)fo);
            }
            this.cachedPath = res;
        }
        return res;
    }

    @NonNull
    public final String getProjectName() {
        ProjectInformation info = this.getProjectInfo();
        return info == null ? "" : info.getDisplayName();
    }

    @CheckForNull
    public final Icon getProjectIcon() {
        ProjectInformation info = this.getProjectInfo();
        return info == null ? null : info.getIcon();
    }

    public final int getOffset() {
        return -1;
    }

    @NonNull
    final FileObject getRoot() {
        return this.root;
    }

    @NonNull
    final ElementHandle<TypeElement> getOwner() {
        return this.owner;
    }

    @CheckForNull
    private ProjectInformation getProjectInfo() {
        return this.project == null ? null : (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
    }
}

