/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.impl.PreprocessorSupport;
import org.clank.support.NativeTrace;

public abstract class AbstractClankCompilationDataBase
implements ClankCompilationDataBase {
    public static final String SORT_PARSED_FILES_PROPERTY = "cnd.model.parse.sorted";
    public static final boolean SORT_PARSED_FILES = Boolean.valueOf(System.getProperty("cnd.model.parse.sorted", "false")) != false || NativeTrace.TRACE_FILE_INFO_EXIT > 0;
    private final Collection<ClankCompilationDataBase.Entry> compilations;
    private final String name;
    private static final Comparator<ClankCompilationDataBase.Entry> COMPARATOR = new Comparator<ClankCompilationDataBase.Entry>(){

        @Override
        public int compare(ClankCompilationDataBase.Entry o1, ClankCompilationDataBase.Entry o2) {
            return o1.getCompiledFiles().iterator().next().toString().compareTo(o2.getCompiledFiles().iterator().next().toString());
        }
    };

    public AbstractClankCompilationDataBase(String dbName, List<ClankCompilationDataBase.Entry> compilations) {
        this.name = dbName;
        if (SORT_PARSED_FILES) {
            compilations = AbstractClankCompilationDataBase.sort(compilations);
        }
        this.compilations = Collections.unmodifiableCollection(compilations);
    }

    @Override
    public final Collection<ClankCompilationDataBase.Entry> getCompilations() {
        return this.compilations;
    }

    @Override
    public final CharSequence getName() {
        return this.name;
    }

    private static List<ClankCompilationDataBase.Entry> sort(List<ClankCompilationDataBase.Entry> entries) {
        if (PreprocessorSupport.THREADS_COUNT != 1) {
            new IllegalStateException("Sort make sense only with 1 thread, not " + PreprocessorSupport.THREADS_COUNT).printStackTrace(System.err);
        }
        Collections.sort(entries, COMPARATOR);
        return entries;
    }
}

