/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.clang.frontend.InputKind;
import org.clang.frontend.LangStandard;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.impl.AbstractClankCompilationDataBase;
import org.clang.tools.services.impl.PreprocessorSupport;
import org.clang.tools.services.support.DataBaseEntry;
import org.clang.tools.services.support.DataBaseEntryBuilder;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class CompilationDBFromDumpedEntries
extends AbstractClankCompilationDataBase {
    private static final String SYSTEM_DEFINES_PREFIX = "@system defines";
    private static final String USER_UNDEFINES_PREFIX = "@user undefines";
    private static final String USER_DEFINES_PREFIX = "@user defines";
    private static final String INCLUDE_SYSTEM_PREFIX = "@include <...>";
    private static final String INCLUDE_USER_PREFIX = "@include \"...\"";
    private static final String INCLUDE_FILE_PREFIX = "@-include";
    private static final String LANG_STD_PREFIX = "@Language standard";
    private static final String LANG_PREFIX = "@Language";
    private static final String CWD_PREFIX = "@CWD";
    private static final String TU_PREFIX = "@TU";
    private static final String NULL_VAL = "NULL";

    private CompilationDBFromDumpedEntries(String dbName, List<ClankCompilationDataBase.Entry> compilations) {
        super(dbName, compilations);
    }

    public static void DumpEntry(ClankCompilationDataBase.Entry compileEntry, raw_ostream out) {
        out.$out((CharSequence)TU_PREFIX).$out(NativePointer.$((String)"\n"));
        for (CharSequence Path : compileEntry.getCompiledFiles()) {
            out.$out(Path).$out(NativePointer.$((String)"\n"));
        }
        out.$out((CharSequence)CWD_PREFIX).$out(NativePointer.$((String)"\n"));
        CharSequence CWD = compileEntry.getCompileWorkingDir();
        out.$out(CWD == null ? NULL_VAL : CWD).$out(NativePointer.$((String)"\n"));
        out.$out((CharSequence)LANG_PREFIX).$out(NativePointer.$((String)"\n"));
        out.$out((CharSequence)compileEntry.getLanguage().name()).$out(NativePointer.$((String)"\n"));
        out.$out((CharSequence)LANG_STD_PREFIX).$out(NativePointer.$((String)"\n"));
        out.$out((CharSequence)compileEntry.getLangStandard().name()).$out(NativePointer.$((String)"\n"));
        out.$out((CharSequence)INCLUDE_FILE_PREFIX).$out(NativePointer.$((String)"\n"));
        for (CharSequence path : compileEntry.getIncludeFiles()) {
            out.$out(path).$out(NativePointer.$((String)"\n"));
        }
        out.$out((CharSequence)INCLUDE_USER_PREFIX).$out(NativePointer.$((String)"\n"));
        for (CharSequence Path : compileEntry.getUserIncludePaths()) {
            out.$out(Path).$out(NativePointer.$((String)"\n"));
        }
        out.$out((CharSequence)INCLUDE_SYSTEM_PREFIX).$out(NativePointer.$((String)"\n"));
        for (CharSequence Path : compileEntry.getPredefinedSystemIncludePaths()) {
            out.$out(Path).$out(NativePointer.$((String)"\n"));
        }
        out.$out((CharSequence)USER_DEFINES_PREFIX).$out(NativePointer.$((String)"\n"));
        for (String macro : compileEntry.getUserMacroDefines()) {
            out.$out((CharSequence)macro).$out(NativePointer.$((String)"\n"));
        }
        out.$out((CharSequence)USER_UNDEFINES_PREFIX).$out(NativePointer.$((String)"\n"));
        for (String macro : compileEntry.getUserMacroUndefines()) {
            out.$out((CharSequence)macro).$out(NativePointer.$((String)"\n"));
        }
        out.$out((CharSequence)SYSTEM_DEFINES_PREFIX).$out(NativePointer.$((String)"\n"));
        for (String macro : compileEntry.getSystemMacroDefines()) {
            out.$out((CharSequence)macro).$out(NativePointer.$((String)"\n"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClankCompilationDataBase createFromDumpEntries(String path) {
        long time = System.currentTimeMillis();
        try {
            File file = new File(path);
            if (!file.exists()) {
                System.err.println("File does not exist: " + path);
                ClankCompilationDataBase clankCompilationDataBase = null;
                return clankCompilationDataBase;
            }
            ArrayList<ClankCompilationDataBase.Entry> compileLines = new ArrayList<ClankCompilationDataBase.Entry>();
            Charset charset = Charset.forName("UTF-8");
            DataBaseEntryBuilder builder = null;
            ConcurrentHashMap differentLines = new ConcurrentHashMap();
            try (BufferedReader reader = Files.newBufferedReader(Paths.get(path, new String[0]), charset);){
                DataBaseEntry entry;
                String line;
                while ((line = reader.readLine()) != null) {
                    if (DumpEntryBuilder.isStartNewEntry(line)) {
                        if (builder != null && PreprocessorSupport.isInterstingTestFile(entry = builder.createDataBaseEntry())) {
                            compileLines.add(entry);
                        }
                        builder = new DumpEntryBuilder();
                    }
                    ((DumpEntryBuilder)builder).handle(line);
                }
                if (builder != null && PreprocessorSupport.isInterstingTestFile(entry = builder.createDataBaseEntry())) {
                    compileLines.add(entry);
                }
            }
            catch (IOException x) {
                System.err.format("IOException: %s%n", x);
            }
            CompilationDBFromDumpedEntries compilationDBFromDumpedEntries = new CompilationDBFromDumpedEntries(path, compileLines);
            return compilationDBFromDumpedEntries;
        }
        finally {
            time = System.currentTimeMillis() - time;
            llvm.outs().$out((CharSequence)"Creating DB from ").$out((CharSequence)path).$out((CharSequence)" took ").$out((CharSequence)NativeTrace.formatNumber((long)time)).$out((CharSequence)"ms \n").flush();
        }
    }

    private static final class DumpEntryBuilder
    extends DataBaseEntryBuilder {
        private State state = State.INITIAL;
        private static final State[] STATE_VALUES = State.values();

        private DumpEntryBuilder() {
        }

        private static boolean isStartNewEntry(String line) {
            return State.TU.matches(line);
        }

        private boolean startNewState(String param) {
            for (State st : STATE_VALUES) {
                if (!st.matches(param)) continue;
                this.state = st;
                return true;
            }
            return false;
        }

        private void handle(String param) {
            if (this.startNewState(param)) {
                return;
            }
            switch (this.state) {
                case TU: {
                    this.setMainFile(param);
                    break;
                }
                case CWD: {
                    if (CompilationDBFromDumpedEntries.NULL_VAL.equals(param)) {
                        this.setCwd(null);
                        break;
                    }
                    this.setCwd(param);
                    break;
                }
                case DASH_INCLUDE: {
                    this.addIncFile(param);
                    break;
                }
                case DASH_I: {
                    this.addUserIncludePath(param);
                    break;
                }
                case DASH_D: {
                    this.addUserMacroDef(param);
                    break;
                }
                case DASH_U: {
                    this.addUserMacroUndef(param);
                    break;
                }
                case DASH_STD: {
                    this.setLangStd(LangStandard.Kind.valueOf((String)param));
                    break;
                }
                case DASH_X: {
                    this.setLang(InputKind.valueOf((String)param));
                    break;
                }
                case INCLUDE_SYSTEM: {
                    this.addPredefinedSystemIncludePath(param);
                    break;
                }
                case SYSTEM_DEFINES: {
                    this.addPredefinedSystemMacroDef(param);
                    break;
                }
                default: {
                    throw new AssertionError((Object)this.state.name());
                }
            }
        }

        private static final class State
        extends Enum<State> {
            public static final /* enum */ State TU = new State("@TU");
            public static final /* enum */ State CWD = new State("@CWD");
            public static final /* enum */ State DASH_STD = new State("@Language standard");
            public static final /* enum */ State DASH_X = new State("@Language");
            public static final /* enum */ State DASH_INCLUDE = new State("@-include");
            public static final /* enum */ State DASH_I = new State("@include \"...\"");
            public static final /* enum */ State INCLUDE_SYSTEM = new State("@include <...>");
            public static final /* enum */ State DASH_D = new State("@user defines");
            public static final /* enum */ State DASH_U = new State("@user undefines");
            public static final /* enum */ State SYSTEM_DEFINES = new State("@system defines");
            public static final /* enum */ State INITIAL = new State(null);
            private final String flag;
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String name) {
                return Enum.valueOf(State.class, name);
            }

            private State(String flags) {
                this.flag = flags;
            }

            private boolean matches(String param) {
                if (this.flag != null) {
                    assert (this.flag.length() > 0);
                    if (param.startsWith(this.flag)) {
                        return true;
                    }
                }
                return false;
            }

            static {
                $VALUES = new State[]{TU, CWD, DASH_STD, DASH_X, DASH_INCLUDE, DASH_I, INCLUDE_SYSTEM, DASH_D, DASH_U, SYSTEM_DEFINES, INITIAL};
            }
        }
    }
}

