/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.impl.AbstractClankCompilationDataBase;
import org.clang.tools.services.support.DataBaseEntry;
import org.clang.tools.services.support.DataBaseEntryBuilder;

public class CompilationDBFromNB
extends AbstractClankCompilationDataBase {
    private CompilationDBFromNB(List<ClankCompilationDataBase.Entry> compilations) {
        super("DBFromNB with [" + compilations.size() + "] entries", compilations);
    }

    public static ClankCompilationDataBase createFromNBCompileLines(String nbPropFile) {
        File file = new File(nbPropFile);
        if (!file.exists()) {
            System.err.println("File does not exist: " + nbPropFile);
            return null;
        }
        ArrayList<ClankCompilationDataBase.Entry> compileLines = new ArrayList<ClankCompilationDataBase.Entry>();
        Charset charset = Charset.forName("UTF-8");
        ConcurrentHashMap<String, AtomicInteger> differentLines = new ConcurrentHashMap<String, AtomicInteger>();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(nbPropFile, new String[0]), charset);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                DataBaseEntry entry = CompilationDBFromNB.createEntry(line);
                if (entry == null) continue;
                String opts = line.substring(line.indexOf("#") + 1);
                if (!differentLines.containsKey(opts)) {
                    differentLines.put(opts, new AtomicInteger(0));
                }
                ((AtomicInteger)differentLines.get(opts)).incrementAndGet();
                compileLines.add(entry);
            }
        }
        catch (IOException x) {
            System.err.format("IOException: %s%n", x);
        }
        return new CompilationDBFromNB(compileLines);
    }

    private static DataBaseEntry createEntry(String line) {
        int hash;
        int eq = line.indexOf("=");
        if (eq < 0) {
            System.err.println("not found '=' in line " + line);
        }
        if ((hash = line.indexOf("#")) < 0) {
            System.err.println("not found '#' in  line " + line);
        }
        String file = line.substring(0, eq);
        String cwd = line.substring(eq + 1, hash);
        String compileString = line.substring(hash + 1);
        CompileLineEntryBuilder builder = new CompileLineEntryBuilder(file);
        for (String option : CompilationDBFromNB.splitCommandLine(compileString)) {
            builder.handle(option);
        }
        return builder.createDataBaseEntry();
    }

    private static List<String> splitCommandLine(String line) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        StringBuilder current = new StringBuilder();
        boolean isSingleQuoteMode = false;
        boolean isDoubleQuoteMode = false;
        block5: while (i < line.length()) {
            char c = line.charAt(i);
            ++i;
            switch (c) {
                case '\'': {
                    if (isSingleQuoteMode) {
                        isSingleQuoteMode = false;
                    } else if (!isDoubleQuoteMode) {
                        isSingleQuoteMode = true;
                    }
                    current.append(c);
                    continue block5;
                }
                case '\"': {
                    if (isDoubleQuoteMode) {
                        isDoubleQuoteMode = false;
                    } else if (!isSingleQuoteMode) {
                        isDoubleQuoteMode = true;
                    }
                    current.append(c);
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (isSingleQuoteMode || isDoubleQuoteMode) {
                        current.append(c);
                        continue block5;
                    }
                    if (current.length() <= 0) continue block5;
                    res.add(current.toString());
                    current.setLength(0);
                    continue block5;
                }
            }
            current.append(c);
        }
        if (current.length() > 0) {
            res.add(current.toString().trim());
        }
        return res;
    }

    private static final class CompileLineEntryBuilder
    extends DataBaseEntryBuilder {
        private final String mainFile;
        private State state;

        public CompileLineEntryBuilder(String mainFile) {
            this(mainFile, null);
        }

        public CompileLineEntryBuilder(String mainFile, String cwd) {
            super(mainFile, cwd == null ? null : cwd);
            this.mainFile = mainFile;
            this.state = State.INITIAL;
        }

        private void resetState() {
            this.state = State.INITIAL;
        }

        private String startNewState(String param) {
            for (State st : State.values()) {
                if (!st.matches(param)) continue;
                param = st.getValue(param);
                this.state = st;
                break;
            }
            return param;
        }

        private void handle(String param) {
            if (this.state == State.INITIAL) {
                param = this.startNewState(param);
            }
            if (param.isEmpty()) {
                return;
            }
            switch (this.state) {
                case DASH_INCLUDE: {
                    this.addIncFile(param);
                    break;
                }
                case DASH_I: {
                    this.addUserIncludePath(param);
                    break;
                }
                case DASH_D: {
                    this.addUserMacroDef(param);
                    break;
                }
                case DASH_U: {
                    this.addUserMacroUndef(param);
                    break;
                }
                case DASH_STD: {
                    this.setLangStd(param);
                    break;
                }
                case DASH_X: {
                    this.setLang(param, this.mainFile);
                    break;
                }
                case INITIAL: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)this.state.name());
                }
            }
            this.resetState();
        }

        private static final class State
        extends Enum<State> {
            public static final /* enum */ State DASH_INCLUDE = new State("-include");
            public static final /* enum */ State DASH_D = new State("-D");
            public static final /* enum */ State DASH_I = new State("-I");
            public static final /* enum */ State DASH_STD = new State("-std=", "-std");
            public static final /* enum */ State DASH_U = new State("-U");
            public static final /* enum */ State DASH_X = new State("-x");
            public static final /* enum */ State INITIAL = new State(new String[0]);
            private final String[] flags;
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String name) {
                return Enum.valueOf(State.class, name);
            }

            private State(String ... flags) {
                this.flags = flags;
            }

            private boolean matches(String param) {
                return this.getOptIndex(param) >= 0;
            }

            private int getOptIndex(String param) {
                if (this.flags != null) {
                    for (int i = 0; i < this.flags.length; ++i) {
                        String str = this.flags[i];
                        assert (str.length() > 0);
                        if (!param.startsWith(str)) continue;
                        return i;
                    }
                }
                return -1;
            }

            private String getValue(String param) {
                assert (this.matches(param));
                int idx = this.getOptIndex(param);
                return param.substring(this.flags[idx].length());
            }

            static {
                $VALUES = new State[]{DASH_INCLUDE, DASH_D, DASH_I, DASH_STD, DASH_U, DASH_X, INITIAL};
            }
        }
    }
}

