/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticConsumer;
import org.clang.basic.DiagnosticIDs;
import org.clang.basic.DiagnosticOptions;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileData;
import org.clang.basic.FileEntry;
import org.clang.basic.FileManager;
import org.clang.basic.LangOptions;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SrcMgr;
import org.clang.basic.spi.PreprocessorImplementation;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.vfs.FileSystem;
import org.clang.frontend.ClangGlobals;
import org.clang.frontend.FrontendOptions;
import org.clang.lex.GlobalModuleIndex;
import org.clang.lex.HeaderSearch;
import org.clang.lex.HeaderSearchOptions;
import org.clang.lex.ModuleIdPath;
import org.clang.lex.ModuleLoadResult;
import org.clang.lex.ModuleLoader;
import org.clang.lex.Preprocessor;
import org.clang.lex.PreprocessorOptions;
import org.clang.tools.services.impl.DefaultDiagnosticConsumer;
import org.clang.tools.services.impl.DelegatingFileSystem;
import org.clang.tools.services.impl.PreprocessorInitializerHelper;
import org.clang.tools.services.impl.SharedMemoryBufferCache;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.NativeTrace;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.aliases.StringMap;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public class PreprocessorInitializer {
    static final fs.UniqueID INVALID_ID = (fs.UniqueID)fs.DenseMapInfoUnqieID.getTombstoneKey();
    static final FileData CACHE_MISSING = new FileData();
    protected static final IntrusiveRefCntPtr<DiagnosticIDs> DiagID;
    private static final DiagnosticOptions dOpts;
    private static final StringMap<FileData, BumpPtrAllocator> FileStatCache;
    private static final StringMap<FileData, BumpPtrAllocator> DirectoryStatCache;
    private static final StringMap<MemoryBuffer, BumpPtrAllocator> MemoryBufferCache;
    private static final AtomicInteger MemoryBufferCacheHits;
    private static final AtomicInteger MemoryBufferCacheMisses;
    private static final AtomicInteger MemoryBufferMainFileHits;
    protected LangOptions LangOpts = null;
    protected SourceManager SourceMgr = null;
    protected HeaderSearch HS = null;
    protected ModuleLoader ModLoader = null;
    protected final FileManager FileMgr;
    protected final DefaultDiagnosticConsumer DiagnosticConsumer;
    protected final DiagnosticsEngine Diags;
    protected final TargetOptions TargetOpts;
    protected final IntrusiveRefCntPtr<TargetInfo> Target;
    protected final raw_ostream err;
    private static final Boolean DELEGATE_FS;
    private static final Boolean MACRO_EXPANSION_ONLY_IN_DIRECTIVES;
    private final SharedMemoryBufferCache sharedMemoryBufferCache;

    public PreprocessorInitializer(raw_ostream llvm_err, String triple, IntrusiveRefCntPtr<FileSystem> FS) {
        this.err = llvm_err == null ? llvm.errs() : llvm_err;
        this.sharedMemoryBufferCache = new SharedMemoryBufferCache(MemoryBufferCache, MemoryBufferCacheHits, MemoryBufferMainFileHits, MemoryBufferCacheMisses);
        assert (FS != null) : "must be at least RealFileSystem";
        assert (FS.get() != null) : "must be at least RealFileSystem";
        FS = DELEGATE_FS != false ? DelegatingFileSystem.create(this.sharedMemoryBufferCache, FS) : FS;
        this.FileMgr = PreprocessorInitializerHelper.$getFileManager(this.sharedMemoryBufferCache, FileStatCache, DirectoryStatCache, FS);
        this.DiagnosticConsumer = new DefaultDiagnosticConsumer(llvm_err, dOpts);
        this.Diags = new DiagnosticsEngine(DiagID, dOpts, (DiagnosticConsumer)this.DiagnosticConsumer);
        this.TargetOpts = new TargetOptions();
        this.TargetOpts.Triple.$assign((CharSequence)triple);
        this.Target = new IntrusiveRefCntPtr((Object)TargetInfo.CreateTargetInfo((DiagnosticsEngine)this.Diags, (std_ptr.shared_ptr)new std_ptr.shared_ptr((Object)this.TargetOpts)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFileCache(CharSequence localPathOrRemoteUrl) {
        FileData lookup;
        assert (FileStatCache != null);
        assert (DirectoryStatCache != null);
        StringRef Path2 = new StringRef(localPathOrRemoteUrl);
        assert (path.is_absolute((StringRef)Path2)) : "Path should be absolute: " + Path2;
        StringMap<FileData, BumpPtrAllocator> stringMap = FileStatCache;
        synchronized (stringMap) {
            lookup = (FileData)FileStatCache.lookup(Path2);
            if (lookup != null && lookup != CACHE_MISSING) {
                lookup.UniqueID = INVALID_ID;
            }
        }
        stringMap = DirectoryStatCache;
        synchronized (stringMap) {
            lookup = (FileData)DirectoryStatCache.lookup(Path2);
            if (lookup != null && lookup != CACHE_MISSING) {
                lookup.UniqueID = INVALID_ID;
            }
        }
        stringMap = MemoryBufferCache;
        synchronized (stringMap) {
            MemoryBufferCache.erase(Path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAllFileCache() {
        StringMap<FileData, BumpPtrAllocator> stringMap = FileStatCache;
        synchronized (stringMap) {
            FileStatCache.clear();
        }
        stringMap = DirectoryStatCache;
        synchronized (stringMap) {
            DirectoryStatCache.clear();
        }
        stringMap = MemoryBufferCache;
        synchronized (stringMap) {
            MemoryBufferCache.clear();
            MemoryBufferCacheHits.set(0);
            MemoryBufferMainFileHits.set(0);
            MemoryBufferCacheMisses.set(0);
        }
    }

    private boolean InitSourceManager(String filePath, SourceManager SourceMgr, FileManager FileMgr, DiagnosticsEngine Diag) {
        StringRef InputFile = new StringRef((CharSequence)filePath);
        this.sharedMemoryBufferCache.skipMainFile(InputFile);
        FileEntry File2 = FileMgr.getFile(InputFile, true);
        if (File2 == null) {
            org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)Diag.Report(410L), (StringRef)InputFile).$destroy();
            return false;
        }
        int MainFID = SourceMgr.createFileID(File2, SourceLocation.getInvalid(), SrcMgr.CharacteristicKind.C_User);
        SourceMgr.setMainFileID(MainFID);
        return true;
    }

    void destroyPreprocessor(Preprocessor PP) {
        PP.$destroy();
    }

    public final Preprocessor createPreprocessor(String InputFile) {
        ModuleLoader MLoader = this.createModuleLoader();
        LangOptions LOpts = this.createLangOptions();
        PreprocessorOptions PPOpts = this.createPreprocessorOptions();
        HeaderSearchOptions HSOpts = this.createHeaderSearchOptions();
        assert (this.SourceMgr == null);
        assert (this.HS == null);
        this.SourceMgr = new SourceManager(this.Diags, this.FileMgr);
        this.HS = new HeaderSearch(new IntrusiveRefCntPtr((Object)HSOpts), this.SourceMgr, this.Diags, LOpts, (TargetInfo)this.Target.get());
        Preprocessor PP = new Preprocessor(new IntrusiveRefCntPtr((Object)PPOpts), this.Diags, LOpts, this.SourceMgr, this.HS, MLoader, null, false);
        PP.Initialize((TargetInfo)this.Target.$star());
        this.Diags.getClient().BeginSourceFile(LOpts, (PreprocessorImplementation)PP);
        ClangGlobals.InitializeFileRemapping((DiagnosticsEngine)PP.getDiagnostics(), (SourceManager)PP.getSourceManager(), (FileManager)PP.getFileManager(), (PreprocessorOptions)PPOpts);
        ClangGlobals.InitializePreprocessor((Preprocessor)PP, (PreprocessorOptions)PPOpts, (FrontendOptions)new FrontendOptions());
        ClangGlobals.ApplyHeaderSearchOptions((HeaderSearch)PP.getHeaderSearchInfo(), (HeaderSearchOptions)HSOpts, (LangOptions)PP.getLangOpts(), (Triple)PP.getTargetInfo().getTriple());
        if (!this.InitSourceManager(InputFile, this.SourceMgr, this.FileMgr, this.Diags)) {
            this.destroyPreprocessor(PP);
            return null;
        }
        if (MACRO_EXPANSION_ONLY_IN_DIRECTIVES.booleanValue()) {
            PP.SetMacroExpansionOnlyInDirectives();
        }
        return PP;
    }

    protected ModuleLoader createModuleLoader() {
        assert (this.ModLoader == null);
        this.ModLoader = new VoidModuleLoader();
        return this.ModLoader;
    }

    protected LangOptions createLangOptions() {
        assert (this.LangOpts == null);
        this.LangOpts = new LangOptions();
        return this.LangOpts;
    }

    protected HeaderSearchOptions createHeaderSearchOptions() {
        HeaderSearchOptions HSOpts = new HeaderSearchOptions();
        HSOpts.UseBuiltinIncludes = false;
        HSOpts.UseLibcxx = false;
        HSOpts.UseStandardCXXIncludes = false;
        HSOpts.UseStandardSystemIncludes = false;
        return HSOpts;
    }

    protected PreprocessorOptions createPreprocessorOptions() {
        PreprocessorOptions out = new PreprocessorOptions();
        out.UsePredefines = false;
        return out;
    }

    public void $destroy() {
        this.Target.$destroy();
        this.TargetOpts.$destroy();
        this.SourceMgr.$destroy();
        this.HS.$destroy();
        this.ModLoader.$destroy();
        this.LangOpts.$destroy();
        this.Diags.$destroy();
        this.DiagnosticConsumer.$destroy();
        PreprocessorInitializerHelper.$releaseFileManager(this.FileMgr);
    }

    static void printFileStats() {
        llvm.errs().$out((CharSequence)"PreprocessorInitializer:").$out((CharSequence)"\n\t File StatCache size: ").$out((CharSequence)NativeTrace.formatNumber((long)FileStatCache.size())).$out((CharSequence)"\n\t Directory StatCache size: ").$out((CharSequence)NativeTrace.formatNumber((long)DirectoryStatCache.size())).$out((CharSequence)"\n\t MemoryBufferCache size: ").$out((CharSequence)NativeTrace.formatNumber((long)MemoryBufferCache.size())).$out((CharSequence)"\n\t MemoryBufferCacheHits: ").$out((CharSequence)NativeTrace.formatNumber((long)MemoryBufferCacheHits.intValue())).$out((CharSequence)"\n\t MemoryBufferCacheMisses: ").$out((CharSequence)NativeTrace.formatNumber((long)MemoryBufferCacheMisses.intValue())).$out((CharSequence)"\n\t MemoryBufferMainFileHits: ").$out((CharSequence)NativeTrace.formatNumber((long)MemoryBufferMainFileHits.intValue())).$out((CharSequence)"\n").flush();
    }

    static {
        dOpts = new DiagnosticOptions();
        DiagID = new IntrusiveRefCntPtr((Object)new DiagnosticIDs());
        FileStatCache = new StringMap(65536L, null);
        DirectoryStatCache = new StringMap(8192L, null);
        MemoryBufferCache = new StringMap(16384L, null);
        MemoryBufferCacheHits = new AtomicInteger(0);
        MemoryBufferCacheMisses = new AtomicInteger(0);
        MemoryBufferMainFileHits = new AtomicInteger(0);
        DELEGATE_FS = Boolean.valueOf(System.getProperty("clank.delegate.fs", "true"));
        MACRO_EXPANSION_ONLY_IN_DIRECTIVES = Boolean.valueOf(System.getProperty("clank.unexpanded", "false"));
    }

    public static final class VoidModuleLoader
    extends ModuleLoader
    implements Destructors.ClassWithDestructor {
        public ModuleLoadResult loadModule(SourceLocation ImportLoc, ModuleIdPath Path2, Module.NameVisibilityKind Visibility, boolean IsInclusionDirective) {
            return new ModuleLoadResult();
        }

        public void makeModuleVisible(Module Mod, Module.NameVisibilityKind Visibility, SourceLocation ImportLoc, boolean Complain) {
        }

        public GlobalModuleIndex loadGlobalModuleIndex(SourceLocation TriggerLoc) {
            return null;
        }

        public boolean lookupMissingImports(StringRef Name, SourceLocation TriggerLoc) {
            return false;
        }

        public void $destroy() {
            super.$destroy();
        }
    }
}

