/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.impl;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.clang.basic.DiagnosticConsumer;
import org.clang.basic.PresumedLoc;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.frontend.ClangGlobals;
import org.clang.frontend.PreprocessorOutputOptions;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.ClankProgressHandler;
import org.clang.tools.services.ClankRunPreprocessorSettings;
import org.clang.tools.services.ClankRunSettings;
import org.clang.tools.services.impl.AdvancedPreprocessorInitializer;
import org.clang.tools.services.impl.PreprocessorInitializer;
import org.clang.tools.services.support.ClangUtilities;
import org.clang.tools.services.support.FileInfo;
import org.clang.tools.services.support.FileInfoCallback;
import org.clang.tools.services.support.Interrupter;
import org.clang.tools.services.support.PrintWriter_ostream;
import org.clank.java.std;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public final class PreprocessorSupport {
    public static final String KEEP_STAT_MISSES_PROP = "clank.keep.stat.miss";
    public static final boolean KEEP_STAT_MISSES;
    public static final String CLANK_THREADS_COUNT_PROP = "clank.threads";
    public static final int THREADS_COUNT;
    public static final String CLANK_ALLOW_TO_SKIP_TOKENS_BETWEEN_DIRECTIVES_PROP = "clank.callback.allow.skip.token";
    public static final boolean ALLOW_TO_SKIP_TOKENS_BETWEEN_DIRECTIVES;

    private PreprocessorSupport() {
    }

    private static PreprocessorOutputOptions createPPOptions(ClankRunPreprocessorSettings settings) {
        PreprocessorOutputOptions opts = new PreprocessorOutputOptions();
        if (settings.PrettyPrintTokens) {
            opts.ShowCPP = true;
            opts.ShowLineMarkers = false;
            opts.ShowMacros = true;
        }
        opts.ShowComments = true;
        opts.ShowMacroComments = true;
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceCompilations(Collection<ClankCompilationDataBase> dbs, ClankRunSettings settings) {
        raw_ostream out = settings.out;
        raw_ostream err = settings.err;
        ClankProgressHandler handle = settings.progress;
        Interrupter cancelled = settings.cancelled;
        assert (out != null);
        assert (err != null);
        PreprocessorSupport.clearStatistics();
        try {
            block3: for (ClankCompilationDataBase db : dbs) {
                handle.setDisplayName("Compilation DataBase for " + db.getName());
                handle.switchToIndeterminate();
                Collection<ClankCompilationDataBase.Entry> entries = db.getCompilations();
                int size = entries.size();
                handle.switchToDeterminate(size, -1L);
                int doneFiles = 0;
                for (ClankCompilationDataBase.Entry entry : entries) {
                    if (cancelled.isCancelled()) continue block3;
                    CharSequence absPath = ClangUtilities.getFirstCompiledPath(entry);
                    handle.progress(absPath + " (" + (doneFiles + 1) + " of " + size + ")", doneFiles++);
                    ClangUtilities.DumpEntry(entry, out);
                }
            }
        }
        finally {
            out.flush();
            err.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preprocess(Collection<ClankCompilationDataBase> dbs, final ClankRunPreprocessorSettings settings, final Map<String, MemoryBuffer> remappedBuffers) {
        final raw_ostream out = settings.out;
        final raw_ostream err = settings.err;
        final ClankProgressHandler handle = settings.progress;
        final Interrupter cancelled = settings.cancelled;
        assert (out != null);
        assert (err != null);
        try {
            final PreprocessorOutputOptions Opts = PreprocessorSupport.createPPOptions(settings);
            PreprocessorSupport.clearStatistics();
            for (ClankCompilationDataBase db : dbs) {
                if (NativeTrace.VERBOSE_MODE) {
                    err.$out((CharSequence)"START ").$out(db.getName()).$out((CharSequence)" in ").$out(THREADS_COUNT).$out((CharSequence)(THREADS_COUNT == 1 ? " thread" : " threads")).$out((CharSequence)"\n").flush();
                }
                handle.setDisplayName("Preprocess " + db.getName());
                handle.switchToIndeterminate();
                Collection<ClankCompilationDataBase.Entry> tmp = db.getCompilations();
                final int size = tmp.size();
                final ConcurrentLinkedQueue<ClankCompilationDataBase.Entry> entries = new ConcurrentLinkedQueue<ClankCompilationDataBase.Entry>(tmp);
                tmp = null;
                handle.switchToDeterminate(size, -1L);
                final AtomicInteger doneFiles = new AtomicInteger(0);
                final AtomicLong totalTime = new AtomicLong(0L);
                final Object printfLock = new Object();
                if (THREADS_COUNT > 1) {
                    int i;
                    Thread[] threads = new Thread[THREADS_COUNT];
                    assert (settings.IncludeInfoCallbacks != null);
                    for (i = 0; i < threads.length; ++i) {
                        try {
                            final FileInfoCallback callback = i == 0 ? settings.IncludeInfoCallbacks : settings.IncludeInfoCallbacks.copy();
                            threads[i] = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    PreprocessorSupport.preprocessEntries(entries, doneFiles, handle, size, cancelled, out, err, callback, settings, Opts, remappedBuffers, totalTime, printfLock);
                                }
                            }, "Preprocessing thread #" + i);
                            continue;
                        }
                        catch (UnsupportedOperationException e) {
                            assert (false) : "must be cloneable to pass clones in threads " + ((Object)((Object)settings.IncludeInfoCallbacks)).getClass().getName();
                            continue;
                        }
                    }
                    for (i = 0; i < threads.length; ++i) {
                        threads[i].start();
                    }
                    for (i = 0; i < threads.length; ++i) {
                        try {
                            threads[i].join();
                            continue;
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(PreprocessorSupport.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                } else {
                    PreprocessorSupport.preprocessEntries(entries, doneFiles, handle, size, cancelled, out, err, settings.IncludeInfoCallbacks, settings, Opts, remappedBuffers, totalTime, printfLock);
                }
                if (!NativeTrace.VERBOSE_MODE) continue;
                FileInfo.printTokenStats();
                PreprocessorInitializer.printFileStats();
                err.$out((CharSequence)"DONE  ").$out(db.getName()).$out((CharSequence)" ").$out((CharSequence)NativeTrace.formatNumber((long)totalTime.get())).$out((CharSequence)"ms").$out((CharSequence)"\n").flush();
            }
            if (settings.TraceClankStatistics) {
                PreprocessorSupport.PrintClankStatistics(err);
            }
        }
        finally {
            out.flush();
            err.flush();
        }
    }

    static boolean isInterstingTestFile(ClankCompilationDataBase.Entry entry) {
        CharSequence absFilePath = ClangUtilities.getFirstCompiledPath(entry);
        String file = System.getProperty("check.one.file.only");
        if (file != null && file.contentEquals(absFilePath)) {
            return true;
        }
        return file == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preprocessEntries(ConcurrentLinkedQueue<ClankCompilationDataBase.Entry> entries, AtomicInteger doneFiles, ClankProgressHandler handle, int size, Interrupter cancelled, raw_ostream out, raw_ostream err, FileInfoCallback Callback, ClankRunPreprocessorSettings settings, PreprocessorOutputOptions Opts, Map<String, MemoryBuffer> remappedBuffers, AtomicLong totalTime, Object printfLock) {
        ClankCompilationDataBase.Entry entry;
        while ((entry = entries.poll()) != null) {
            doneFiles.incrementAndGet();
            CharSequence absolutePath = ClangUtilities.getFirstCompiledPath(entry);
            handle.progress(absolutePath + " (" + doneFiles.get() + " of " + size + ")", doneFiles.get());
            if (cancelled.isCancelled()) break;
            long time = PreprocessorSupport.dumpPreprocessedEntry(entry, out, err, settings.PrintDiagnosticsOS, Opts, Callback, settings.PrettyPrintDiagnostics, settings.PrettyPrintTokens, settings.TracePPStatistics, settings.SuppressIncludeNotFoundError, cancelled, remappedBuffers);
            totalTime.addAndGet(time);
            if (!NativeTrace.VERBOSE_MODE) continue;
            Object object = printfLock;
            synchronized (object) {
                err.$out((CharSequence)"done  ").$out(absolutePath).$out((CharSequence)" (").$out(doneFiles.get()).$out((CharSequence)" of ").$out(size).$out((CharSequence)") ").$out((CharSequence)NativeTrace.formatNumber((long)time)).$out((CharSequence)"ms").$out((CharSequence)"\n").flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long dumpPreprocessed(ClankCompilationDataBase.Entry entry, raw_ostream llvm_out, raw_ostream llvm_err, raw_ostream llvm_diag, PreprocessorOutputOptions Opts, FileInfoCallback CollectIncludeInfo, boolean printDiags, boolean printTokens, boolean printPPStatistics, boolean suppressIncludeNotFoundError, Interrupter cancelled) {
        long time = System.currentTimeMillis();
        boolean done = false;
        try {
            PreprocessorSupport.dumpPreprocessedEntry(entry, llvm_out, llvm_err, llvm_diag, Opts, CollectIncludeInfo, printDiags, printTokens, printPPStatistics, suppressIncludeNotFoundError, cancelled, Collections.emptyMap());
        }
        finally {
            llvm.errs().flush();
            llvm_out.flush();
            llvm_diag.flush();
        }
        return done ? time : 0L;
    }

    private static long dumpPreprocessedEntry(ClankCompilationDataBase.Entry entry, raw_ostream llvm_out, raw_ostream llvm_err, raw_ostream llvm_diag, PreprocessorOutputOptions Opts, FileInfoCallback FileCallback, boolean printDiags, boolean printTokens, boolean printPPStatistics, boolean suppressIncludeNotFoundError, Interrupter cancelled, Map<String, MemoryBuffer> remappedBuffers) {
        String InputFile;
        long time = System.currentTimeMillis();
        boolean done = false;
        AdvancedPreprocessorInitializer initializer = new AdvancedPreprocessorInitializer(entry, "x86_64", printDiags ? llvm_diag : llvm.nulls(), remappedBuffers);
        Preprocessor PP = initializer.createPreprocessor(InputFile = ClangUtilities.getFirstCompiledPath(entry).toString());
        if (PP != null) {
            PP.SetSuppressIncludeNotFoundError(suppressIncludeNotFoundError);
            if (printTokens) {
                ClangGlobals.DoPrintPreprocessedInput((Preprocessor)PP, (raw_ostream)(printTokens ? llvm_out : llvm.nulls()), (PreprocessorOutputOptions)Opts);
                PP.EndSourceFile();
            } else {
                PreprocessorSupport.ConsumePreprocessedInput(PP, llvm_out, llvm_err, llvm_diag, FileCallback, cancelled);
            }
            DiagnosticConsumer client = PP.getDiagnostics().getClient();
            if (client != null) {
                client.EndSourceFile();
            }
            time = System.currentTimeMillis() - time;
            done = true;
            if (printPPStatistics) {
                PreprocessorSupport.PrintPPStatistics(PP, entry, llvm_out);
            }
            PreprocessorSupport.destroyPreprocessor(PP);
        }
        initializer.$destroy();
        return done ? time : 0L;
    }

    private static void PrintPPStatistics(Preprocessor PP, ClankCompilationDataBase.Entry entry, raw_ostream OS) {
        assert (PP != null);
        assert (entry != null);
        assert (OS != null);
        OS.$out((CharSequence)"\nSTATISTICS FOR '").$out(ClangUtilities.getFirstCompiledPath(entry)).$out((CharSequence)"':\n");
        PP.PrintStats(OS);
        PP.getIdentifierTable().PrintStats(OS);
        PP.getHeaderSearchInfo().PrintStats(OS);
        PP.getSourceManager().PrintStats(OS);
        OS.$out((CharSequence)"\n");
        OS.flush();
    }

    private static void PrintClankStatistics(raw_ostream OS) {
        if (NativeTrace.STATISTICS) {
            PrintWriter javaOS = PreprocessorSupport.tryExtractPrintWriter(OS, System.out);
            org.clang.frontendtool.ClangGlobals.PrintStats((raw_ostream)OS, (PrintWriter)javaOS);
            javaOS.flush();
        } else {
            OS.$out((CharSequence)"Statistics was not gathered\n");
        }
        OS.flush();
    }

    private static PrintWriter tryExtractPrintWriter(raw_ostream OS, PrintStream fallback) {
        PrintWriter javaOS = PreprocessorSupport.tryExtractPrintWriter(OS);
        if (javaOS == null) {
            javaOS = new PrintWriter(fallback);
        }
        return javaOS;
    }

    private static PrintWriter tryExtractPrintWriter(raw_ostream OS) {
        PrintWriter javaOS = null;
        if (OS instanceof PrintWriter_ostream) {
            javaOS = ((PrintWriter_ostream)OS).getJavaDelegate();
        }
        return javaOS;
    }

    private static void destroyPreprocessor(Preprocessor PP) {
        PP.$destroy();
    }

    private static void clearStatistics() {
        org.clang.frontendtool.ClangGlobals.clearStatistics();
    }

    private static void ConsumePreprocessedInput(Preprocessor PP, raw_ostream out, raw_ostream err, raw_ostream llvm_diag, FileInfoCallback CollectIncludeInfo, Interrupter cancelled) {
        PresumedLoc PLoc;
        if (CollectIncludeInfo == null) {
            CollectIncludeInfo = new FileInfoCallback(err);
        }
        CollectIncludeInfo.prepareEnterMainSourceFile(PP);
        PP.addPPCallbacks(llvm.make_unique((Object)((Object)CollectIncludeInfo)));
        PP.EnterMainSourceFile();
        SourceManager SourceMgr = PP.getSourceManager();
        Token Tok = new Token();
        int numTokens = 0;
        do {
            PP.Lex(Tok);
            CollectIncludeInfo.onToken(Tok);
            ++numTokens;
        } while (!Tok.is((short)1) && SourceLocation.isFileID((int)Tok.getRawLocation()) && !(PLoc = SourceMgr.getPresumedLoc(Tok.getRawLocation())).isInvalid() && std.strcmp((char.ptr)PLoc.getFilename(), (CharSequence)"<built-in>") == 0);
        while (Tok.isNot((short)1) && !cancelled.isCancelled()) {
            ++numTokens;
            PP.Lex(Tok);
            if (cancelled.isCancelled()) break;
            CollectIncludeInfo.onToken(Tok);
        }
        if (!cancelled.isCancelled()) {
            PP.EndSourceFile();
        }
        if (NativeTrace.VERBOSE_MODE) {
            err.$out((CharSequence)"Lexed ").$out((CharSequence)NativeTrace.formatNumber((long)numTokens)).$out((CharSequence)" tokens \n");
        }
    }

    static {
        String prop = System.getProperty(KEEP_STAT_MISSES_PROP);
        boolean keepMisses = prop == null ? NativeTrace.isStandalone() : Boolean.valueOf(prop);
        KEEP_STAT_MISSES = keepMisses;
        THREADS_COUNT = Integer.getInteger(CLANK_THREADS_COUNT_PROP, 1);
        ALLOW_TO_SKIP_TOKENS_BETWEEN_DIRECTIVES = Boolean.parseBoolean(System.getProperty(CLANK_ALLOW_TO_SKIP_TOKENS_BETWEEN_DIRECTIVES_PROP, "false"));
    }
}

