/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.support;

import java.util.Collection;
import java.util.Collections;
import org.clang.frontend.InputKind;
import org.clang.frontend.LangStandard;
import org.clang.tools.services.ClankCompilationDataBase;

public final class DataBaseEntry
implements ClankCompilationDataBase.Entry {
    private final Collection<CharSequence> mainFile;
    private final CharSequence cwd;
    private final InputKind lang;
    private final LangStandard.Kind langStd;
    private final Collection<CharSequence> incFiles;
    private final Collection<CharSequence> userIncludePaths;
    private final Collection<String> userMacroDefs;
    private final Collection<String> userMacroUndefs;
    private final Collection<CharSequence> predefinedIncludePaths;
    private final Collection<String> predefinedMacroDefs;

    DataBaseEntry(CharSequence mainFile, CharSequence cwd, Collection<CharSequence> incFiles, Collection<CharSequence> userIncludePaths, Collection<String> userMacroDefs, Collection<String> userMacroUndefs, Collection<CharSequence> predefinedIncludePaths, Collection<String> predefinedMacroDefs, InputKind lang, LangStandard.Kind langStd) {
        this.mainFile = Collections.singletonList(mainFile);
        this.cwd = cwd;
        this.incFiles = incFiles;
        this.userIncludePaths = userIncludePaths;
        this.userMacroDefs = userMacroDefs;
        this.userMacroUndefs = userMacroUndefs;
        this.predefinedIncludePaths = predefinedIncludePaths;
        this.predefinedMacroDefs = predefinedMacroDefs;
        this.lang = lang;
        this.langStd = langStd;
    }

    @Override
    public Collection<CharSequence> getCompiledFiles() {
        return this.mainFile;
    }

    @Override
    public CharSequence getCompileWorkingDir() {
        return this.cwd;
    }

    @Override
    public Collection<CharSequence> getIncludeFiles() {
        return this.incFiles;
    }

    @Override
    public Collection<CharSequence> getUserIncludePaths() {
        return this.userIncludePaths;
    }

    @Override
    public Collection<String> getUserMacroDefines() {
        return this.userMacroDefs;
    }

    @Override
    public Collection<String> getUserMacroUndefines() {
        return this.userMacroUndefs;
    }

    @Override
    public Collection<CharSequence> getPredefinedSystemIncludePaths() {
        return this.predefinedIncludePaths;
    }

    @Override
    public Collection<String> getSystemMacroDefines() {
        return this.predefinedMacroDefs;
    }

    @Override
    public InputKind getLanguage() {
        return this.lang;
    }

    @Override
    public LangStandard.Kind getLangStandard() {
        return this.langStd;
    }

    public String toString() {
        return "EntryImpl{files=" + this.toString(this.mainFile) + "\n cwd=" + this.cwd + "\n lang=" + this.lang + ", langStd=" + this.langStd + "\n incFiles=" + this.toString(this.incFiles) + "\n userIncludePaths=" + this.toString(this.userIncludePaths) + "\n userMacroDefs=" + this.toString(this.userMacroDefs) + "\n userMacroUndefs=" + this.toString(this.userMacroUndefs) + "\n predefinedIncludePaths=" + this.toString(this.predefinedIncludePaths) + "\n predefinedMacroDefs=" + this.toString(this.predefinedMacroDefs) + "\n}";
    }

    private CharSequence toString(Collection<? extends CharSequence> cs) {
        StringBuilder builder = new StringBuilder();
        for (CharSequence charSequence : cs) {
            builder.append("\n").append(charSequence);
        }
        return builder;
    }
}

