/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.support;

import java.util.ArrayList;
import java.util.Collection;
import org.clang.frontend.InputKind;
import org.clang.frontend.LangStandard;
import org.clang.tools.services.support.ClangUtilities;
import org.clang.tools.services.support.DataBaseEntry;

public class DataBaseEntryBuilder {
    private CharSequence mainFile;
    private CharSequence cwd;
    private final Collection<CharSequence> incFiles = new ArrayList<CharSequence>();
    private final Collection<CharSequence> userIncludePaths = new ArrayList<CharSequence>();
    private final Collection<String> userMacroDefs = new ArrayList<String>();
    private final Collection<String> userMacroUndefs = new ArrayList<String>();
    private final Collection<CharSequence> predefinedIncludePaths = new ArrayList<CharSequence>();
    private final Collection<String> predefinedMacroDefs = new ArrayList<String>();
    private InputKind lang = InputKind.IK_None;
    private LangStandard.Kind langStd = LangStandard.Kind.lang_unspecified;

    public DataBaseEntryBuilder() {
    }

    public DataBaseEntryBuilder(CharSequence mainFile, CharSequence cwd) {
        this.mainFile = mainFile;
        this.cwd = cwd;
    }

    public DataBaseEntryBuilder setMainFile(CharSequence mainFile) {
        this.mainFile = mainFile;
        return this;
    }

    public DataBaseEntryBuilder setCwd(CharSequence cwd) {
        this.cwd = cwd;
        return this;
    }

    public DataBaseEntryBuilder addIncFile(String incFile) {
        this.incFiles.add(incFile);
        return this;
    }

    public DataBaseEntryBuilder addUserIncludePath(CharSequence userIncludePath) {
        this.userIncludePaths.add(userIncludePath);
        return this;
    }

    public DataBaseEntryBuilder addUserMacroDef(String userMacroDef) {
        this.userMacroDefs.add(userMacroDef);
        return this;
    }

    public DataBaseEntryBuilder addUserMacroUndef(String userMacroUndef) {
        this.userMacroUndefs.add(userMacroUndef);
        return this;
    }

    public DataBaseEntryBuilder addPredefinedSystemIncludePath(CharSequence predefinedIncludePath) {
        this.predefinedIncludePaths.add(predefinedIncludePath);
        return this;
    }

    public DataBaseEntryBuilder addPredefinedSystemMacroDef(String predefinedMacroDef) {
        this.predefinedMacroDefs.add(predefinedMacroDef);
        return this;
    }

    public DataBaseEntryBuilder setLang(InputKind lang) {
        this.lang = lang;
        return this;
    }

    public DataBaseEntryBuilder setLang(String param, String mainFile) {
        return this.setLang(ClangUtilities.getInputKind(param, mainFile));
    }

    public DataBaseEntryBuilder setLangStd(LangStandard.Kind langStd) {
        this.langStd = langStd;
        return this;
    }

    public DataBaseEntryBuilder setLangStd(String param) {
        return this.setLangStd(ClangUtilities.getLangStandard(param));
    }

    public DataBaseEntry createDataBaseEntry() {
        return new DataBaseEntry(this.mainFile, this.cwd, this.incFiles, this.userIncludePaths, this.userMacroDefs, this.userMacroUndefs, this.predefinedIncludePaths, this.predefinedMacroDefs, this.lang, this.langStd);
    }
}

