/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette2.codegen;

import java.util.Collection;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.nette2.utils.EditorUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class ActionRenderMethodChecker {
    private FileObject presenterFile;
    private final EditorSupport editorSupport;

    public ActionRenderMethodChecker(FileObject presenterFile) {
        assert (presenterFile != null);
        this.presenterFile = presenterFile;
        this.editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
    }

    public boolean existsActionMethod(String action) {
        return this.existsMethod(action, "action");
    }

    public boolean existsRenderMethod(String name) {
        return this.existsMethod(name, "render");
    }

    private boolean existsMethod(String name, String type) {
        Collection classMethods;
        boolean result = false;
        PhpClass properlyNamedPhpClass = this.getProperlyNamedPhpClass();
        if (properlyNamedPhpClass != null && (classMethods = properlyNamedPhpClass.getMethods()) != null) {
            for (PhpClass.Method method : classMethods) {
                if (!method.getName().equals(type + EditorUtils.firstLetterCapital(name))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private PhpClass getProperlyNamedPhpClass() {
        PhpClass result = null;
        if (this.editorSupport != null) {
            Collection classes = this.editorSupport.getClasses(this.presenterFile);
            for (PhpClass phpClazz : classes) {
                if (!phpClazz.getName().contains(this.presenterFile.getName())) continue;
                result = phpClazz;
                break;
            }
        }
        return result;
    }
}

