/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.api;

import org.netbeans.modules.db.dataview.api.DataView;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class DataViewPageContext {
    public static final int DEFAULT_PAGE_SIZE = 20;
    private static final String PROP_STORED_PAGE_SIZE = "storedPageSize";
    private static int defaultPageSize = -1;

    private DataViewPageContext() {
    }

    public static int getPageSize(DataView view) {
        return view.delegate.getPageSize();
    }

    public static int getStoredPageSize() {
        if (defaultPageSize < 0 && (defaultPageSize = NbPreferences.forModule(DataViewPageContext.class).getInt(PROP_STORED_PAGE_SIZE, 20)) < 0) {
            defaultPageSize = 20;
        }
        return defaultPageSize;
    }

    public static void setStoredPageSize(final int pageSize) {
        if (pageSize < 0) {
            throw new IllegalArgumentException("Negative pageSize");
        }
        defaultPageSize = pageSize;
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                NbPreferences.forModule(DataViewPageContext.class).putInt(DataViewPageContext.PROP_STORED_PAGE_SIZE, pageSize);
            }
        });
    }
}

