/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.CharConversionException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class DataView {
    private static final Logger LOG = Logger.getLogger(DataView.class.getName());
    private static final int MAX_TAB_LENGTH = 25;
    private DatabaseConnection dbConn;
    private final List<Throwable> errMessages = new ArrayList<Throwable>();
    private String sqlString;
    private SQLStatementGenerator stmtGenerator;
    private SQLExecutionHelper execHelper;
    private final List<DataViewPageContext> dataPage = new ArrayList<DataViewPageContext>();
    private final List<DataViewUI> dataViewUI = new ArrayList<DataViewUI>();
    private JComponent container;
    private int initialPageSize = org.netbeans.modules.db.dataview.api.DataViewPageContext.getStoredPageSize();
    private boolean nbOutputComponent = false;
    private int updateCount;
    private long executionTime;

    public static DataView create(DatabaseConnection dbConn, String sqlString, int pageSize) {
        assert (dbConn != null);
        DataView dv = new DataView();
        dv.dbConn = dbConn;
        dv.sqlString = sqlString.trim();
        dv.nbOutputComponent = false;
        if (pageSize >= 0) {
            dv.initialPageSize = pageSize;
        }
        try {
            dv.execHelper = new SQLExecutionHelper(dv);
            dv.execHelper.initialDataLoad();
            dv.stmtGenerator = new SQLStatementGenerator();
        }
        catch (Exception ex) {
            dv.setErrorStatusText(ex);
        }
        return dv;
    }

    public static DataView create(DatabaseConnection dbConn, String sqlString, int pageSize, boolean nbOutputComponent) {
        DataView dataView = DataView.create(dbConn, sqlString, pageSize);
        dataView.nbOutputComponent = nbOutputComponent;
        return dataView;
    }

    public synchronized List<Component> createComponents() {
        if (!this.hasResultSet()) {
            return Collections.emptyList();
        }
        this.container = this.dataPage.size() > 1 ? new JTabbedPane() : new JPanel(new BorderLayout());
        for (int i = 0; i < this.dataPage.size(); ++i) {
            DataViewUI ui = new DataViewUI(this, this.dataPage.get(i), this.nbOutputComponent);
            ui.setName("Result Set " + i);
            this.dataViewUI.add(ui);
            this.container.add((Component)((Object)ui));
            this.resetToolbar(this.hasExceptions());
        }
        String sql = this.getSQLString();
        String sqlSpaceNormalized = sql.replaceAll("\\s+", " ");
        if (sqlSpaceNormalized.length() > 25) {
            String trimmed = sqlSpaceNormalized.substring(0, 25) + "\u2026";
            this.container.setName(trimmed);
        } else {
            this.container.setName(sqlSpaceNormalized);
        }
        try {
            int length = Math.min(sql.length(), 512);
            String displaySQL = sql.substring(0, length);
            if (sql.length() > 512) {
                displaySQL = displaySQL + "\u2026";
            }
            this.container.setToolTipText(NbBundle.getMessage(DataView.class, (String)"DataViewUI_ToolTip", (Object)XMLUtil.toAttributeValue((String)this.dbConn.getDisplayName()), (Object)XMLUtil.toAttributeValue((String)displaySQL)));
        }
        catch (CharConversionException ex) {
            LOG.log(Level.WARNING, "", ex);
        }
        ArrayList<Component> results = new ArrayList<Component>();
        results.add(this.container);
        return results;
    }

    public boolean hasExceptions() {
        return !this.errMessages.isEmpty();
    }

    public boolean hasResultSet() {
        return this.dataPage.size() > 0;
    }

    public Collection<Throwable> getExceptions() {
        return Collections.unmodifiableCollection(this.errMessages);
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public JButton[] getEditButtons() {
        assert (this.nbOutputComponent);
        return this.dataViewUI.get(0).getEditButtons();
    }

    public synchronized void setEditable(final boolean editable) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                for (DataViewPageContext pageContext : DataView.this.dataPage) {
                    pageContext.getModel().setEditable(editable);
                }
            }
        });
    }

    public int getPageSize() {
        if (this.dataViewUI.isEmpty()) {
            return this.initialPageSize;
        }
        return this.dataViewUI.get(0).getPageSize();
    }

    List<DataViewPageContext> getPageContexts() {
        return this.dataPage;
    }

    DataViewPageContext getPageContext(int i) {
        return this.dataPage.get(i);
    }

    DataViewPageContext addPageContext(final DataViewDBTable table) throws InterruptedException {
        try {
            final DataViewPageContext pageContext = new DataViewPageContext(this.initialPageSize);
            this.dataPage.add(pageContext);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    pageContext.setTableMetaData(table);
                    pageContext.getModel().setColumns(table.getColumns().toArray(new DBColumn[0]));
                }
            });
            return pageContext;
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    DatabaseConnection getDatabaseConnection() {
        return this.dbConn;
    }

    String getSQLString() {
        return this.sqlString;
    }

    SQLExecutionHelper getSQLExecutionHelper() {
        if (this.execHelper == null) {
            this.execHelper = new SQLExecutionHelper(this);
        }
        return this.execHelper;
    }

    SQLStatementGenerator getSQLStatementGenerator() {
        if (this.stmtGenerator == null) {
            this.stmtGenerator = new SQLStatementGenerator();
        }
        return this.stmtGenerator;
    }

    public void resetEditable() {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                for (DataViewPageContext pageContext : DataView.this.dataPage) {
                    pageContext.resetEditableState();
                }
            }
        });
    }

    synchronized void disableButtons() {
        assert (this.dataViewUI != null);
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                for (DataViewUI ui : DataView.this.dataViewUI) {
                    ui.disableButtons();
                }
            }
        });
        this.errMessages.clear();
    }

    synchronized void removeComponents() {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                if (DataView.this.container != null) {
                    if (DataView.this.container != null) {
                        DataView.this.container.getParent().remove(DataView.this.container);
                    }
                    DataView.this.container.removeAll();
                    DataView.this.container.repaint();
                    DataView.this.container.revalidate();
                }
            }
        });
    }

    void setInfoStatusText(String statusText) {
        if (statusText != null) {
            StatusDisplayer.getDefault().setStatusText(statusText);
        }
    }

    synchronized void setErrorStatusText(Throwable ex) {
        if (ex != null) {
            if (ex instanceof DBException && ex.getCause() instanceof SQLException) {
                this.errMessages.add(ex.getCause());
            }
            this.errMessages.add(ex);
            String title = NbBundle.getMessage(DataView.class, (String)"MSG_error");
            StatusDisplayer.getDefault().setStatusText(title + ": " + ex.getMessage());
        }
    }

    synchronized void setErrorStatusText(String message, Throwable ex) {
        if (ex != null) {
            this.errMessages.add(ex);
        }
        String title = NbBundle.getMessage(DataView.class, (String)"MSG_error");
        StatusDisplayer.getDefault().setStatusText(title + ": " + message);
    }

    void resetToolbar(final boolean wasError) {
        assert (this.dataViewUI != null);
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                for (DataViewUI ui : DataView.this.dataViewUI) {
                    ui.resetToolbar(wasError);
                }
            }
        });
    }

    void setUpdateCount(int updateCount) {
        this.updateCount = updateCount;
    }

    void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    private DataView() {
    }
}

