/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.table.TableColumnExt;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.netbeans.modules.db.dataview.table.JXTableDecorator;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;

public final class JXTableRowHeader
extends JComponent {
    private final PropertyChangeListener backingTableListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equals("rowHeight")) {
                JXTableRowHeader.this.headerTable.setRowHeight(((Integer)pce.getNewValue()).intValue());
            }
        }
    };
    private static final Icon rightArrow = new Icon(){

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawLine(x + 4, y + 4, x + 4, y + 4);
            g.translate(x + 4, y + 4);
            g.fillPolygon(new Polygon(new int[]{0, 5, 0}, new int[]{-5, 0, 5}, 3));
        }
    };
    private final IconBorder iconBorder = new IconBorder();
    private final CountingTableModel ctm;
    private final JXTable headerTable;
    private final JXTable backingTable;

    public JTableHeader getTableHeader() {
        JTableHeader header = this.headerTable.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        return header;
    }

    public JXTableRowHeader(JXTable table) {
        assert (table != null) : "JXTableRowHeader needs to be instanciated with a JXTable";
        this.backingTable = table;
        this.ctm = new CountingTableModel(this.backingTable);
        this.headerTable = new JXTableDecorator(this.ctm, new InternalTableColumnModel());
        this.backingTable.addPropertyChangeListener(this.backingTableListener);
        this.headerTable.setRowHeight(this.backingTable.getRowHeight());
        this.headerTable.setSelectionModel(this.backingTable.getSelectionModel());
        this.setLayout(new GridLayout(1, 1));
        this.headerTable.setAutoResizeMode(0);
        this.headerTable.getTableHeader().setReorderingAllowed(false);
        this.headerTable.getTableHeader().setResizingAllowed(false);
        this.add((Component)this.headerTable);
        TableColumn column = this.headerTable.getColumnModel().getColumn(0);
        this.headerTable.packAll();
        TableCellRenderer defaultRenderer = this.createDefaultRenderer();
        Component c = defaultRenderer.getTableCellRendererComponent((JTable)this.headerTable, "00000", false, false, 0, 0);
        column.setPreferredWidth((int)c.getMinimumSize().getWidth() + 10);
        column.setCellRenderer(this.createDefaultRenderer());
        this.headerTable.setPreferredScrollableViewportSize(new Dimension(column.getPreferredWidth(), 0));
        this.headerTable.setInheritsPopupMenu(true);
        this.headerTable.setShowGrid(true, true);
        this.headerTable.setGridColor(ResultSetJXTable.GRID_COLOR);
        this.headerTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)ResultSetJXTable.ROW_COLOR, (Color)ResultSetJXTable.ALTERNATE_ROW_COLOR)});
    }

    protected TableCellRenderer createDefaultRenderer() {
        return new RowHeaderColumnRenderer();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.headerTable.getToolTipText(event);
    }

    private class RowHeaderColumnRenderer
    extends DefaultTableRenderer {
        private RowHeaderColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, columnIndex);
            if (isSelected) {
                JXTableRowHeader.this.iconBorder.setIcon(rightArrow);
                Border origBorder = ((JComponent)comp).getBorder();
                CompoundBorder border = new CompoundBorder(origBorder, (Border)JXTableRowHeader.this.iconBorder);
                ((JComponent)comp).setBorder(border);
                comp.setBackground(UIManager.getColor("Table.selectionBackground"));
                comp.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
            return comp;
        }
    }

    private static class CountingTableModel
    implements TableModel,
    PropertyChangeListener,
    TableModelListener,
    RowSorterListener {
        private static final String PROP_ROW_SORTER = "rowSorter";
        private static final String PROP_SORTER = "sorter";
        private static final String PROP_MODEL = "model";
        private int count;
        private TableModel backingTableModel;
        private RowSorter<?> backingSorter;
        private final Set<TableModelListener> listeners = new HashSet<TableModelListener>();
        private final JXTable backingTable;

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String propertyName = pce.getPropertyName();
            if (PROP_ROW_SORTER.equals(propertyName) || PROP_SORTER.equals(propertyName)) {
                if (this.backingSorter != null) {
                    this.backingSorter.removeRowSorterListener(this);
                }
                if (pce.getNewValue() != null) {
                    this.backingSorter = (RowSorter)pce.getNewValue();
                    this.backingSorter.addRowSorterListener(this);
                }
                this.tableDataChanged();
            } else if (PROP_MODEL.equals(propertyName)) {
                if (this.backingTableModel != null) {
                    this.backingTableModel.removeTableModelListener(this);
                }
                this.backingTableModel = (TableModel)pce.getNewValue();
                if (this.backingTableModel != null) {
                    this.backingTableModel.addTableModelListener(this);
                }
                this.tableDataChanged();
            }
        }

        public CountingTableModel(JXTable table) {
            this.backingTable = table;
            this.backingTable.addPropertyChangeListener((PropertyChangeListener)this);
            this.backingTableModel = table.getModel();
            this.backingTableModel.addTableModelListener(this);
            this.setCount(this.backingTable.getRowCount());
        }

        private void fireTableDataChanged() {
            for (TableModelListener tml : this.listeners) {
                tml.tableChanged(new TableModelEvent(this));
            }
        }

        private void setCount(int count) {
            if (count != this.count) {
                this.count = count;
                this.fireTableDataChanged();
            }
        }

        @Override
        public void addTableModelListener(TableModelListener tl) {
            this.listeners.add(tl);
        }

        @Override
        public Class<?> getColumnClass(int i) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int i) {
            return "Row number";
        }

        @Override
        public int getRowCount() {
            return this.count;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.backingTableModel instanceof DataViewTableUIModel) {
                try {
                    int modelRow = this.backingTable.convertRowIndexToModel(row);
                    return Integer.toString(((DataViewTableUIModel)this.backingTableModel).getTotalRowOffset(modelRow) + 1);
                }
                catch (IndexOutOfBoundsException ex) {
                    return null;
                }
            }
            return Integer.toString(row + 1);
        }

        @Override
        public boolean isCellEditable(int i, int i1) {
            return false;
        }

        @Override
        public void removeTableModelListener(TableModelListener tl) {
            this.listeners.remove(tl);
        }

        @Override
        public void setValueAt(Object o, int i, int i1) {
            throw new NoSuchMethodError();
        }

        private void tableDataChanged() {
            this.setCount(this.backingTable.getRowCount());
            this.fireTableDataChanged();
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.tableDataChanged();
        }

        @Override
        public void sorterChanged(RowSorterEvent rse) {
            this.tableDataChanged();
        }
    }

    private static class InternalTableColumnModel
    extends DefaultTableColumnModel {
        public InternalTableColumnModel() {
            TableColumnExt col = new TableColumnExt(0, 75);
            col.setEditable(false);
            col.setHeaderValue((Object)"#");
            col.setToolTipText("Row number");
            col.setSortable(false);
            this.addColumn((TableColumn)col);
        }
    }
}

