/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table.celleditor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.util.Cancellable;

class MonitorableStreamTransfer
implements ProgressRunnable<Exception>,
Cancellable {
    private InputStream is;
    private OutputStream os;
    private int transfered;
    private Integer size;
    private boolean cancel;

    public MonitorableStreamTransfer(InputStream is, OutputStream os, Integer knownsize) {
        this.is = is;
        this.os = os;
        this.size = knownsize;
    }

    public Exception run(ProgressHandle handle) {
        Exception result = null;
        if (handle != null && this.size != null) {
            handle.switchToDeterminate(this.size.intValue());
        }
        try {
            int read = 0;
            byte[] buffer = new byte[262144];
            while ((read = this.is.read(buffer)) > 0 && !this.cancel) {
                this.os.write(buffer, 0, read);
                this.transfered += read;
                if (handle == null || this.size == null) continue;
                handle.progress(this.transfered);
            }
        }
        catch (IOException ex) {
            try {
                this.is.close();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            try {
                this.os.close();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return ex;
        }
        if (handle != null) {
            handle.finish();
        }
        return result;
    }

    public boolean cancel() {
        if (this.cancel) {
            return false;
        }
        this.cancel = true;
        return true;
    }

    public boolean isCancel() {
        return this.cancel;
    }
}

