/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.actions.UsedNamespaceName;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

public class UsedNamesCollector {
    private final PHPParseResult parserResult;
    private final int caretPosition;
    private Map<String, List<UsedNamespaceName>> possibleNames;
    private static final List<String> SPECIAL_NAMES = new LinkedList<String>();

    public UsedNamesCollector(PHPParseResult parserResult, int caretPosition) {
        this.parserResult = parserResult;
        this.caretPosition = caretPosition;
    }

    public Map<String, List<UsedNamespaceName>> collectNames() {
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this.parserResult.getModel().getFileScope(), this.caretPosition);
        assert (namespaceScope != null);
        OffsetRange offsetRange = namespaceScope.getBlockRange();
        Collection<? extends UseScope> declaredUses = namespaceScope.getDeclaredUses();
        NamespaceNameVisitor namespaceNameVisitor = new NamespaceNameVisitor(offsetRange);
        this.parserResult.getProgram().accept(namespaceNameVisitor);
        this.possibleNames = namespaceNameVisitor.getExistingNames();
        return this.filterNamesWithoutUses(declaredUses);
    }

    private Map<String, List<UsedNamespaceName>> filterNamesWithoutUses(Collection<? extends UseScope> declaredUses) {
        HashMap<String, List<UsedNamespaceName>> result = new HashMap<String, List<UsedNamespaceName>>();
        for (String typeName : this.possibleNames.keySet()) {
            if (this.existsUseForTypeName(declaredUses, QualifiedName.create(typeName))) continue;
            result.put(typeName, this.possibleNames.get(typeName));
        }
        return result;
    }

    private boolean existsUseForTypeName(Collection<? extends UseScope> declaredUses, QualifiedName typeName) {
        boolean result = false;
        String firstSegmentName = typeName.getSegments().getFirst();
        for (UseScope useScope : declaredUses) {
            AliasedName aliasName = useScope.getAliasedName();
            if (aliasName != null) {
                if (!firstSegmentName.equals(aliasName.getAliasName())) continue;
                result = true;
                break;
            }
            if (!useScope.getName().endsWith(firstSegmentName)) continue;
            result = true;
            break;
        }
        return result;
    }

    static {
        SPECIAL_NAMES.add("parent");
        SPECIAL_NAMES.add("self");
        SPECIAL_NAMES.add("static");
    }

    private static class NamespaceNameVisitor
    extends DefaultVisitor {
        private final OffsetRange offsetRange;
        private final Map<String, List<UsedNamespaceName>> existingNames = new HashMap<String, List<UsedNamespaceName>>();

        public NamespaceNameVisitor(OffsetRange offsetRange) {
            this.offsetRange = offsetRange;
        }

        @Override
        public void scan(ASTNode node) {
            if (this.isNodeForScan(node)) {
                super.scan(node);
            }
        }

        private boolean isNodeForScan(ASTNode node) {
            return node != null && this.isInNamespace(node) && !(node instanceof UseStatement);
        }

        private boolean isInNamespace(ASTNode node) {
            return this.offsetRange.containsInclusive(node.getStartOffset()) || this.offsetRange.containsInclusive(node.getEndOffset());
        }

        @Override
        public void visit(Program node) {
            this.scan(node.getStatements());
            this.scan(node.getComments());
        }

        @Override
        public void visit(NamespaceDeclaration node) {
            this.scan(node.getBody());
        }

        @Override
        public void visit(NamespaceName node) {
            UsedNamespaceName usedName = new UsedNamespaceName(node);
            if (this.isValidTypeName(usedName.getName())) {
                this.processUsedName(usedName);
            }
        }

        @Override
        public void visit(PHPDocTypeNode node) {
            UsedNamespaceName usedName = new UsedNamespaceName(node);
            if (this.isValidTypeName(usedName.getName())) {
                this.processUsedName(usedName);
            }
        }

        private boolean isValidTypeName(String typeName) {
            return !SPECIAL_NAMES.contains(typeName) && !Type.isPrimitive(typeName);
        }

        private void processUsedName(UsedNamespaceName usedName) {
            List<UsedNamespaceName> usedNames = this.existingNames.get(usedName.getName());
            if (usedNames == null) {
                usedNames = new LinkedList<UsedNamespaceName>();
                this.existingNames.put(usedName.getName(), usedNames);
            }
            usedNames.add(usedName);
        }

        public Map<String, List<UsedNamespaceName>> getExistingNames() {
            return Collections.unmodifiableMap(this.existingNames);
        }
    }
}

