/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QuerySupportFactory;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.completion.Bundle;
import org.netbeans.modules.php.editor.completion.CCDocHtmlFormatter;
import org.netbeans.modules.php.editor.completion.PHPCodeCompletion;
import org.netbeans.modules.php.editor.index.PHPDOCTagElement;
import org.netbeans.modules.php.editor.index.PredefinedSymbolElement;
import org.netbeans.modules.php.editor.parser.annotation.LinkParsedLine;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

final class DocRenderer {
    private static final String TD_STYLE = "style=\"text-aling:left; border-width: 0px;padding: 1px;padding:3px;\" ";
    private static final String TD_STYLE_MAX_WIDTH = "style=\"text-aling:left; border-width: 0px;padding: 1px;padding:3px;width:80%;\" ";
    private static final String TABLE_STYLE = "style=\"border: 0px; width: 100%;\"";
    private static final Logger LOGGER = Logger.getLogger(PHPCodeCompletion.class.getName());

    private DocRenderer() {
    }

    static Documentation document(ParserResult info, ElementHandle element) {
        if (element instanceof PHPDOCTagElement) {
            PHPDOCTagElement pHPDOCTagElement = (PHPDOCTagElement)element;
            String doc = pHPDOCTagElement.getDoc();
            return Documentation.create((String)(doc == null ? Bundle.PHPDocNotFound() : doc));
        }
        if (element instanceof PredefinedSymbolElement) {
            PredefinedSymbolElement predefinedSymbolElement = (PredefinedSymbolElement)element;
            String doc = predefinedSymbolElement.getDoc();
            return Documentation.create((String)(doc == null ? Bundle.PHPDocNotFound() : doc));
        }
        if (element instanceof PhpElement) {
            return DocRenderer.documentIndexedElement((PhpElement)element);
        }
        if (element instanceof TypeMemberElement) {
            TypeMemberElement indexedClassMember = (TypeMemberElement)element;
            return DocRenderer.documentIndexedElement(indexedClassMember);
        }
        return null;
    }

    private static Documentation documentIndexedElement(PhpElement indexedElement) {
        PhpDocumentation phpDocumentation = PhpDocumentation.NONE;
        CCDocHtmlFormatter locationHeader = new CCDocHtmlFormatter();
        CCDocHtmlFormatter header = new CCDocHtmlFormatter();
        String location = DocRenderer.getLocation(indexedElement);
        ElementQuery elementQuery = indexedElement.getElementQuery();
        if (location != null) {
            locationHeader.appendHtml(String.format("<div align=\"right\"><font size=-1>%s</font></div>", location));
        }
        if (DocRenderer.canBeProcessed(indexedElement) && (phpDocumentation = DocRenderer.getPhpDocumentation(indexedElement, header)) == PhpDocumentation.NONE && indexedElement instanceof MethodElement) {
            ElementFilter forName = ElementFilter.forName(NameKind.exact(indexedElement.getName()));
            ElementQuery.Index index = elementQuery.getQueryScope().isIndexScope() ? (ElementQuery.Index)elementQuery : ElementQueryFactory.createIndexQuery(QuerySupportFactory.get(indexedElement.getFileObject()));
            Set<TypeElement> inheritedTypes = index.getInheritedTypes(((MethodElement)indexedElement).getType());
            Iterator<TypeElement> typeIt = inheritedTypes.iterator();
            while (phpDocumentation == PhpDocumentation.NONE && typeIt.hasNext()) {
                Set<MethodElement> inheritedMethods = forName.filter(index.getDeclaredMethods(typeIt.next()));
                Iterator<MethodElement> methodIt = inheritedMethods.iterator();
                while (phpDocumentation == PhpDocumentation.NONE && methodIt.hasNext()) {
                    header = new CCDocHtmlFormatter();
                    phpDocumentation = DocRenderer.getPhpDocumentation(methodIt.next(), header);
                }
            }
        }
        return phpDocumentation.createDocumentation(locationHeader);
    }

    private static boolean canBeProcessed(PhpElement indexedElement) {
        return indexedElement != null && indexedElement.getOffset() > -1 && indexedElement.getFileObject() != null;
    }

    private static PhpDocumentation getPhpDocumentation(PhpElement indexedElement, CCDocHtmlFormatter header) {
        PhpDocumentation result = PhpDocumentation.NONE;
        if (DocRenderer.canBeProcessed(indexedElement)) {
            FileObject nextFo = indexedElement.getFileObject();
            try {
                Source source = Source.create((FileObject)nextFo);
                if (source != null) {
                    PHPDocExtractor phpDocExtractor = new PHPDocExtractor(header, indexedElement);
                    ParserManager.parse(Collections.singleton(source), (UserTask)phpDocExtractor);
                    result = phpDocExtractor.getPhpDocumentation();
                }
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result;
    }

    private static String getLocation(PhpElement indexedElement) {
        String location = null;
        if (indexedElement.isPlatform()) {
            location = Bundle.PHPPlatform();
        } else {
            FileObject fobj = indexedElement.getFileObject();
            if (fobj != null) {
                Project project = FileOwnerQuery.getOwner((FileObject)fobj);
                if (project != null) {
                    Sources sources = ProjectUtils.getSources((Project)project);
                    for (SourceGroup group : sources.getSourceGroups("PHPSOURCE")) {
                        String relativePath = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)fobj);
                        if (relativePath == null) continue;
                        location = relativePath;
                        break;
                    }
                    if (location == null) {
                        location = fobj.getPath();
                    }
                } else {
                    location = indexedElement.getFilenameUrl();
                }
            }
        }
        return location;
    }

    private static interface PhpDocumentation {
        public static final PhpDocumentation NONE = new PhpDocumentation(){

            @Override
            public Documentation createDocumentation(CCDocHtmlFormatter locationHeader) {
                return Documentation.create((String)String.format("%s%s", locationHeader.getText(), Bundle.PHPDocNotFound()));
            }
        };

        public Documentation createDocumentation(CCDocHtmlFormatter var1);

        public static final class PhpDocumentationImpl
        implements PhpDocumentation {
            private final String description;
            private final URL url;

            private PhpDocumentationImpl(String description, URL url) {
                this.description = description;
                this.url = url;
            }

            @Override
            public Documentation createDocumentation(CCDocHtmlFormatter locationHeader) {
                assert (locationHeader != null);
                return Documentation.create((String)String.format("%s%s", locationHeader.getText(), this.description), (URL)this.url);
            }
        }

        public static final class Factory {
            static PhpDocumentation create(CCDocHtmlFormatter header, StringBuilder body, List<String> links) {
                URL url = null;
                if (links.size() > 0) {
                    try {
                        url = new URL(links.get(0));
                    }
                    catch (MalformedURLException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                    if (links.size() > 1) {
                        Factory.attachLinks(body, links);
                    }
                }
                String description = String.format("%s%s", header.getText(), body.length() == 0 ? Bundle.PHPDocNotFound() : body);
                return new PhpDocumentationImpl(description, url);
            }

            private static void attachLinks(StringBuilder body, List<String> links) {
                assert (links.size() > 1) : links.size();
                body.append("<h3>");
                body.append(Bundle.OnlineDocs());
                body.append("</h3>\n");
                for (String link : links) {
                    String line = String.format("<a href=\"%s\">%s</a><br>%n", link, link);
                    body.append(line);
                }
            }
        }
    }

    static final class PHPDocExtractor
    extends UserTask {
        private static final Pattern KEEP_TAGS_PATTERN = Pattern.compile("<(?!(/|b|code|br|i|kbd|li|ol|p|pre|samp|ul|var|table|tr|th|td)(\\b|\\s))", 2);
        private static final Pattern REPLACE_NEWLINE_PATTERN = Pattern.compile("(\r?\n){2,}");
        private static final Pattern LIST_PATTERN = Pattern.compile("(\r?\n)(?=([-+#o]\\s|\\d\\.?\\s))");
        private static final ArrayList<String> LINK_TAGS = new ArrayList();
        private final CCDocHtmlFormatter header;
        private final StringBuilder phpDoc = new StringBuilder();
        private final PhpElement indexedElement;
        private final List<String> links = new ArrayList<String>();

        public PHPDocExtractor(CCDocHtmlFormatter header, PhpElement indexedElement) {
            this.header = header;
            this.indexedElement = indexedElement;
        }

        public PhpDocumentation getPhpDocumentation() {
            return PhpDocumentation.Factory.create(this.header, this.phpDoc, this.links);
        }

        public void cancel() {
        }

        private void doFunctionDeclaration(FunctionDeclaration functionDeclaration) {
            String fname = CodeUtils.extractFunctionName(functionDeclaration);
            this.header.appendHtml("<font size=\"+1\">");
            this.header.name(ElementKind.METHOD, true);
            this.header.appendText(fname);
            this.header.name(ElementKind.METHOD, false);
            this.header.appendHtml("</font>");
            this.header.parameters(true);
            this.header.appendText("(");
            int paramCount = functionDeclaration.getFormalParameters().size();
            for (int i = 0; i < paramCount; ++i) {
                Identifier paramId;
                FormalParameter param = functionDeclaration.getFormalParameters().get(i);
                if (param.getParameterType() != null && (paramId = CodeUtils.extractUnqualifiedIdentifier(param.getParameterType())) != null) {
                    this.header.type(true);
                    this.header.appendText(paramId.getName() + " ");
                    this.header.type(false);
                }
                this.header.appendText(CodeUtils.getParamDisplayName(param));
                if (param.isOptional()) {
                    this.header.type(true);
                    this.header.appendText("=");
                    if (param.getDefaultValue() instanceof Scalar) {
                        Scalar scalar = (Scalar)param.getDefaultValue();
                        this.header.appendText(scalar.getStringValue());
                    }
                    this.header.type(false);
                }
                if (i + 1 >= paramCount) continue;
                this.header.appendText(", ");
            }
            this.header.appendText(")");
            this.header.parameters(false);
        }

        public void run(ResultIterator resultIterator) throws Exception {
            Program program;
            ParserResult presult = (ParserResult)resultIterator.getParserResult();
            if (presult != null && (program = Utils.getRoot(presult)) != null) {
                ASTNode node = Utils.getNodeAtOffset(program, this.indexedElement.getOffset());
                if (node == null) {
                    LOGGER.log(Level.WARNING, "Could not find AST node for element {0} defined in {1}", new Object[]{this.indexedElement.getName(), this.indexedElement.getFilenameUrl()});
                    return;
                }
                if (node instanceof FunctionDeclaration) {
                    this.doFunctionDeclaration((FunctionDeclaration)node);
                } else {
                    PhpElement constant;
                    this.header.name(this.indexedElement.getKind(), true);
                    this.header.appendText(this.indexedElement.getName());
                    this.header.name(this.indexedElement.getKind(), false);
                    String value = null;
                    if (this.indexedElement instanceof ConstantElement) {
                        constant = (ConstantElement)this.indexedElement;
                        value = constant.getValue();
                    } else if (this.indexedElement instanceof TypeConstantElement) {
                        constant = (TypeConstantElement)this.indexedElement;
                        value = constant.getValue();
                    }
                    if (value != null) {
                        this.header.appendText(" = ");
                        this.header.appendText(value);
                    }
                }
                this.header.appendHtml("<br/><br/>");
                if (node instanceof PHPDocTag) {
                    if (node instanceof PHPDocMethodTag) {
                        this.extractPHPDoc((PHPDocMethodTag)node);
                    } else if (node instanceof PHPDocVarTypeTag) {
                        PHPDocVarTypeTag varTypeTag = (PHPDocVarTypeTag)node;
                        String type = this.composeType(varTypeTag.getTypes());
                        this.phpDoc.append(PHPDocExtractor.processPhpDoc(String.format("%s<br /><table><tr><th align=\"left\">Type:</th><td>%s</td></tr></table>", varTypeTag.getDocumentation(), type)));
                    } else {
                        this.phpDoc.append(PHPDocExtractor.processPhpDoc(((PHPDocTag)node).getDocumentation()));
                    }
                } else {
                    Comment comment = Utils.getCommentForNode(program, node);
                    if (comment instanceof PHPDocBlock) {
                        this.extractPHPDoc((PHPDocBlock)comment);
                    }
                }
            }
        }

        private void extractPHPDoc(PHPDocMethodTag methodTag) {
            StringBuilder params = new StringBuilder();
            StringBuilder returnValue = new StringBuilder();
            String description = methodTag.getDocumentation();
            if (description != null && description.length() > 0) {
                description = PHPDocExtractor.processPhpDoc(description);
            }
            if (methodTag.getParameters() != null && methodTag.getParameters().size() > 0) {
                for (PHPDocVarTypeTag tag : methodTag.getParameters()) {
                    params.append(this.composeParameterLine(tag));
                }
            }
            returnValue.append(this.composeTypesAndDescription(methodTag.getTypes(), null));
            this.phpDoc.append(this.composeFunctionDoc(description, params.toString(), returnValue.toString(), null));
        }

        private void extractPHPDoc(PHPDocBlock pHPDocBlock) {
            StringBuilder params = new StringBuilder();
            StringBuilder returnValue = new StringBuilder();
            StringBuilder others = new StringBuilder();
            for (PHPDocTag tag : pHPDocBlock.getTags()) {
                String oline;
                AnnotationParsedLine kind = tag.getKind();
                if (kind.equals((Object)PHPDocTag.Type.PARAM)) {
                    params.append(this.composeParameterLine((PHPDocVarTypeTag)tag));
                    continue;
                }
                if (kind.equals((Object)PHPDocTag.Type.RETURN)) {
                    PHPDocTypeTag returnTag = (PHPDocTypeTag)tag;
                    returnValue.append(this.composeTypesAndDescription(returnTag.getTypes(), returnTag.getDocumentation()));
                    continue;
                }
                if (kind.equals((Object)PHPDocTag.Type.VAR)) {
                    PHPDocTypeTag typeTag = (PHPDocTypeTag)tag;
                    others.append(this.composeTypesAndDescription(typeTag.getTypes(), typeTag.getDocumentation()));
                    continue;
                }
                if (kind.equals((Object)PHPDocTag.Type.DEPRECATED)) {
                    oline = String.format("<tr><th align=\"left\">%s</th><td>%s</td></tr>%n", PHPDocExtractor.processPhpDoc(tag.getKind().getName()), PHPDocExtractor.processPhpDoc(tag.getDocumentation(), ""));
                    others.append(oline);
                    continue;
                }
                if (kind instanceof LinkParsedLine) {
                    this.links.add(kind.getDescription());
                    continue;
                }
                oline = String.format("<tr><th align=\"left\">%s</th><td>%s</td></tr>%n", PHPDocExtractor.processPhpDoc(tag.getKind().getName()), PHPDocExtractor.processPhpDoc(tag.getKind().getDescription(), ""));
                others.append(oline);
            }
            this.phpDoc.append(this.composeFunctionDoc(this.processDescription(PHPDocExtractor.processPhpDoc(pHPDocBlock.getDescription(), "")), params.toString(), returnValue.toString(), others.toString()));
        }

        protected String processDescription(String text) {
            StringBuilder result = new StringBuilder();
            int lastIndex = 0;
            int index = text.indexOf(123, 0);
            while (index > -1 && text.length() > index + 1) {
                String tag;
                int endIndex;
                result.append(text.substring(lastIndex, index));
                lastIndex = index;
                char charAt = text.charAt(index + 2);
                if ((charAt == 'l' || charAt == 's' || charAt == 'u') && (endIndex = text.indexOf(32, index)) > -1 && LINK_TAGS.contains(tag = text.substring(index + 1, endIndex).trim()) && (endIndex = text.indexOf(125, index = endIndex + 1)) > -1) {
                    String link = text.substring(index, endIndex).trim();
                    result.append(String.format("<a href=\"%s\">%s</a>", link, link));
                    lastIndex = endIndex + 1;
                }
                index = text.indexOf(123, index + 1);
            }
            if (lastIndex > -1) {
                result.append(text.substring(lastIndex));
            }
            return result.toString();
        }

        private String composeFunctionDoc(String description, String parameters, String returnValue, String others) {
            StringBuilder value = new StringBuilder();
            value.append(description);
            value.append("<br />\n");
            if (parameters.length() > 0) {
                value.append("<h3>");
                value.append(Bundle.Parameters());
                value.append("</h3>\n<table cellspacing=0 style=\"border: 0px; width: 100%;\">\n").append(parameters).append("</table>\n");
            }
            if (returnValue.length() > 0) {
                value.append("<h3>");
                value.append(Bundle.ReturnValue());
                value.append("</h3>\n<table>\n");
                value.append(returnValue);
                value.append("</table>");
            }
            if (others != null && others.length() > 0) {
                value.append("<table>\n").append(others).append("</table>\n");
            }
            return value.toString();
        }

        private String composeParameterLine(PHPDocVarTypeTag param) {
            String type = this.composeType(param.getTypes());
            String pline = String.format("<tr><td>&nbsp;</td><td valign=\"top\" %s><nobr>%s</nobr></td><td valign=\"top\" %s><nobr><b>%s</b></nobr></td><td valign=\"top\" %s>%s</td></tr>%n", DocRenderer.TD_STYLE, type, DocRenderer.TD_STYLE, param.getVariable().getValue(), DocRenderer.TD_STYLE_MAX_WIDTH, param.getDocumentation() == null ? "&nbsp" : PHPDocExtractor.processPhpDoc(param.getDocumentation()));
            return pline;
        }

        private String composeTypesAndDescription(List<PHPDocTypeNode> types, String description) {
            StringBuilder returnValue = new StringBuilder();
            if (types != null && types.size() > 0) {
                returnValue.append(String.format("<tr><th align=\"left\">%s:</th><td>%s</td></tr>", Bundle.Type(), this.composeType(types)));
            }
            if (description != null && description.length() > 0) {
                returnValue.append(String.format("<tr><th align=\"left\" valign=\"top\">%s:</th><td>%s</td></tr>", Bundle.Description(), PHPDocExtractor.processPhpDoc(description)));
            }
            return returnValue.toString();
        }

        private String composeType(List<PHPDocTypeNode> types) {
            StringBuilder type = new StringBuilder();
            if (types != null) {
                for (PHPDocTypeNode typeNode : types) {
                    if (type.length() > 0) {
                        type.append(" | ");
                    }
                    type.append(typeNode.getValue());
                    if (!typeNode.isArray()) continue;
                    type.append("[]");
                }
            }
            return type.toString();
        }

        static String processPhpDoc(String phpDoc) {
            return PHPDocExtractor.processPhpDoc(phpDoc, Bundle.PHPDocNotFound());
        }

        static String processPhpDoc(String phpDoc, String defaultText) {
            String result = defaultText;
            if (StringUtils.hasText((String)phpDoc)) {
                String notags = KEEP_TAGS_PATTERN.matcher(phpDoc).replaceAll("&lt;");
                notags = REPLACE_NEWLINE_PATTERN.matcher(notags).replaceAll("<br><br>");
                result = LIST_PATTERN.matcher(notags).replaceAll("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            return result;
        }

        static {
            LINK_TAGS.add("@link");
            LINK_TAGS.add("@see");
            LINK_TAGS.add("@use");
        }
    }
}

