/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.elements.BaseFunctionElementSupport;
import org.netbeans.modules.php.editor.elements.FullyQualifiedElementImpl;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.ParameterElementImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.elements.TypeNameResolverImpl;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.FunctionDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.openide.util.Parameters;

public final class FunctionElementImpl
extends FullyQualifiedElementImpl
implements FunctionElement {
    public static final String IDX_FIELD = "base";
    private final BaseFunctionElementSupport functionSupport;

    private FunctionElementImpl(QualifiedName qualifiedName, int offset, String fileUrl, ElementQuery elementQuery, BaseFunctionElementSupport.Parameters parameters, BaseFunctionElementSupport.ReturnTypes returnTypes, boolean isDeprecated) {
        super(qualifiedName.toName().toString(), qualifiedName.toNamespaceName().toString(), fileUrl, offset, elementQuery, isDeprecated);
        this.functionSupport = new BaseFunctionElementSupport(parameters, returnTypes);
    }

    public static Set<FunctionElement> fromSignature(IndexQueryImpl indexQuery, IndexResult indexResult) {
        return FunctionElementImpl.fromSignature((NameKind)NameKind.empty(), indexQuery, indexResult);
    }

    public static Set<FunctionElement> fromSignature(NameKind query, IndexQueryImpl indexQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<FunctionElement> retval = values.length > 0 ? new HashSet<FunctionElement>() : Collections.emptySet();
        for (String val : values) {
            FunctionElement fnc = FunctionElementImpl.fromSignature(query, indexQuery, Signature.get(val));
            if (fnc == null) continue;
            retval.add(fnc);
        }
        return retval;
    }

    public static FunctionElement fromSignature(NameKind query, IndexQueryImpl indexScopeQuery, Signature sig) {
        Parameters.notNull((CharSequence)"NameKind query: can't be null", (Object)query);
        FunctionSignatureParser signParser = new FunctionSignatureParser(sig);
        FunctionElementImpl retval = null;
        if (FunctionElementImpl.matchesQuery(query, signParser)) {
            retval = new FunctionElementImpl(signParser.getQualifiedName(), signParser.getOffset(), signParser.getFileUrl(), indexScopeQuery, new ParametersFromSignature(signParser), new ReturnTypesFromSignature(signParser), signParser.isDeprecated());
        }
        return retval;
    }

    public static FunctionElement fromNode(NamespaceElement namespace, FunctionDeclaration node, ElementQuery.File fileQuery) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        Parameters.notNull((CharSequence)"fileQuery", (Object)fileQuery);
        FunctionDeclarationInfo info = FunctionDeclarationInfo.create(node);
        QualifiedName fullyQualifiedName = namespace != null ? namespace.getFullyQualifiedName() : QualifiedName.createForDefaultNamespaceName();
        return new FunctionElementImpl(fullyQualifiedName.append(info.getName()), info.getRange().getStart(), fileQuery.getURL().toExternalForm(), fileQuery, BaseFunctionElementSupport.ParametersImpl.create(info.getParameters()), BaseFunctionElementSupport.ReturnTypesImpl.create(TypeResolverImpl.parseTypes(VariousUtils.getReturnTypeFromPHPDoc(fileQuery.getResult().getProgram(), node))), VariousUtils.isDeprecatedFromPHPDoc(fileQuery.getResult().getProgram(), node));
    }

    private static boolean matchesQuery(NameKind query, FunctionSignatureParser signParser) {
        Parameters.notNull((CharSequence)"NameKind query: can't be null", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(FunctionElement.KIND, signParser.getQualifiedName());
    }

    @Override
    public PhpElementKind getPhpElementKind() {
        return FunctionElement.KIND;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getSignatureLastPart());
        this.checkFunctionSignature(sb);
        return sb.toString();
    }

    private String getSignatureLastPart() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getOffset()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        List<ParameterElement> parameterList = this.getParameters();
        for (int idx = 0; idx < parameterList.size(); ++idx) {
            ParameterElementImpl parameter = (ParameterElementImpl)parameterList.get(idx);
            if (idx > 0) {
                sb.append((Object)PhpElementImpl.Separator.COMMA);
            }
            sb.append(parameter.getSignature());
        }
        sb.append((Object)PhpElementImpl.Separator.SEMICOLON);
        for (TypeResolver typeResolver : this.getReturnTypes()) {
            TypeResolverImpl resolverImpl = (TypeResolverImpl)typeResolver;
            sb.append(resolverImpl.getSignature());
        }
        sb.append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getPhpModifiers().toFlags()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.isDeprecated() ? 1 : 0).append((Object)PhpElementImpl.Separator.SEMICOLON);
        sb.append(this.getFilenameUrl()).append((Object)PhpElementImpl.Separator.SEMICOLON);
        return sb.toString();
    }

    private void checkFunctionSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            FunctionSignatureParser parser = new FunctionSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getQualifiedName().toName().toString()));
            assert (this.getNamespaceName().equals(parser.getQualifiedName().toNamespaceName()));
            assert (this.getOffset() == parser.getOffset());
            assert (this.getParameters().size() == parser.getParameters().size());
            assert (this.getReturnTypes().size() == parser.getReturnTypes().size());
        }
    }

    @Override
    public List<ParameterElement> getParameters() {
        return this.functionSupport.getParameters();
    }

    @Override
    public Collection<TypeResolver> getReturnTypes() {
        return this.functionSupport.getReturnTypes();
    }

    @Override
    public String asString(BaseFunctionElement.PrintAs as) {
        return this.asString(as, TypeNameResolverImpl.forNull());
    }

    @Override
    public String asString(BaseFunctionElement.PrintAs as, TypeNameResolver typeNameResolver) {
        return this.functionSupport.asString(as, this, typeNameResolver);
    }

    private static final class ReturnTypesFromSignature
    implements BaseFunctionElementSupport.ReturnTypes {
        private final FunctionSignatureParser functionSignatureParser;
        private Set<TypeResolver> retrievedReturnTypes = null;

        public ReturnTypesFromSignature(FunctionSignatureParser functionSignatureParser) {
            this.functionSignatureParser = functionSignatureParser;
        }

        @Override
        public synchronized Set<TypeResolver> getReturnTypes() {
            if (this.retrievedReturnTypes == null) {
                this.retrievedReturnTypes = this.functionSignatureParser.getReturnTypes();
            }
            return this.retrievedReturnTypes;
        }
    }

    private static final class ParametersFromSignature
    implements BaseFunctionElementSupport.Parameters {
        private final FunctionSignatureParser functionSignatureParser;
        private List<ParameterElement> retrievedParameters = null;

        public ParametersFromSignature(FunctionSignatureParser functionSignatureParser) {
            this.functionSignatureParser = functionSignatureParser;
        }

        @Override
        public synchronized List<ParameterElement> getParameters() {
            if (this.retrievedParameters == null) {
                this.retrievedParameters = this.functionSignatureParser.getParameters();
            }
            return this.retrievedParameters;
        }
    }

    private static class FunctionSignatureParser {
        private final Signature signature;

        FunctionSignatureParser(Signature signature) {
            this.signature = signature;
        }

        QualifiedName getQualifiedName() {
            return FullyQualifiedElementImpl.composeQualifiedName(this.signature.string(5), this.signature.string(1));
        }

        int getOffset() {
            return this.signature.integer(2);
        }

        List<ParameterElement> getParameters() {
            return ParameterElementImpl.parseParameters(this.signature.string(3));
        }

        Set<TypeResolver> getReturnTypes() {
            return TypeResolverImpl.parseTypes(this.signature.string(4));
        }

        boolean isDeprecated() {
            return this.signature.integer(6) == 1;
        }

        String getFileUrl() {
            return this.signature.string(7);
        }
    }
}

