/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NamespaceIndexFilter;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.NamespaceDeclarationInfo;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public final class ModelUtils {
    private static final Logger LOGGER = Logger.getLogger(ModelUtils.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(ModelUtils.class);

    private ModelUtils() {
    }

    public static Set<AliasedName> getAliasedNames(Model model, int offset) {
        HashSet<AliasedName> aliases = new HashSet<AliasedName>();
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(model.getFileScope(), offset);
        if (namespaceScope != null) {
            Collection<? extends UseScope> declaredUses = namespaceScope.getDeclaredUses();
            for (UseScope useScope : declaredUses) {
                AliasedName aliasedName = useScope.getAliasedName();
                if (aliasedName == null) continue;
                aliases.add(aliasedName);
            }
        }
        return aliases;
    }

    public static NamespaceScope getNamespaceScope(NamespaceDeclaration currenNamespace, FileScope fileScope) {
        NamespaceDeclarationInfo ndi = currenNamespace != null ? NamespaceDeclarationInfo.create(currenNamespace) : null;
        NamespaceScope currentScope = ndi != null ? ModelUtils.getFirst(ModelUtils.filter(fileScope.getDeclaredNamespaces(), ndi.getName())) : fileScope.getDefaultDeclaredNamespace();
        return currentScope;
    }

    public static Collection<? extends TypeScope> getDeclaredTypes(FileScope fileScope) {
        ArrayList<? extends TypeScope> retval = new ArrayList<TypeScope>();
        Collection<? extends NamespaceScope> declaredNamespaces = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : declaredNamespaces) {
            retval.addAll(namespaceScope.getDeclaredTypes());
        }
        return retval;
    }

    public static Collection<? extends ClassScope> getDeclaredClasses(FileScope fileScope) {
        ArrayList<? extends ClassScope> retval = new ArrayList<ClassScope>();
        Collection<? extends NamespaceScope> declaredNamespaces = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : declaredNamespaces) {
            retval.addAll(namespaceScope.getDeclaredClasses());
        }
        return retval;
    }

    public static Collection<? extends InterfaceScope> getDeclaredInterfaces(FileScope fileScope) {
        ArrayList<? extends InterfaceScope> retval = new ArrayList<InterfaceScope>();
        Collection<? extends NamespaceScope> declaredNamespaces = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : declaredNamespaces) {
            retval.addAll(namespaceScope.getDeclaredInterfaces());
        }
        return retval;
    }

    public static Collection<? extends TraitScope> getDeclaredTraits(FileScope fileScope) {
        ArrayList<? extends TraitScope> retval = new ArrayList<TraitScope>();
        Collection<? extends NamespaceScope> declaredNamespaces = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : declaredNamespaces) {
            retval.addAll(namespaceScope.getDeclaredTraits());
        }
        return retval;
    }

    public static Collection<? extends ConstantElement> getDeclaredConstants(FileScope fileScope) {
        ArrayList<? extends ConstantElement> retval = new ArrayList<ConstantElement>();
        Collection<? extends NamespaceScope> declaredNamespaces = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : declaredNamespaces) {
            retval.addAll(namespaceScope.getDeclaredConstants());
        }
        return retval;
    }

    public static Collection<? extends FunctionScope> getDeclaredFunctions(FileScope fileScope) {
        ArrayList<? extends FunctionScope> retval = new ArrayList<FunctionScope>();
        Collection<? extends NamespaceScope> declaredNamespaces = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : declaredNamespaces) {
            retval.addAll(namespaceScope.getDeclaredFunctions());
        }
        return retval;
    }

    public static Collection<? extends VariableName> getDeclaredVariables(FileScope fileScope) {
        ArrayList<? extends VariableName> retval = new ArrayList<VariableName>();
        Collection<? extends NamespaceScope> declaredNamespaces = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : declaredNamespaces) {
            retval.addAll(namespaceScope.getDeclaredVariables());
        }
        return retval;
    }

    public static List<? extends ModelElement> getElements(Scope scope, boolean resursively) {
        ArrayList<ModelElement> retval = new ArrayList<ModelElement>();
        List<? extends ModelElement> elements = scope.getElements();
        retval.addAll(elements);
        for (ModelElement modelElement : elements) {
            if (!(modelElement instanceof Scope)) continue;
            retval.addAll(ModelUtils.getElements((Scope)modelElement, resursively));
        }
        return retval;
    }

    public static Collection<? extends TypeScope> resolveType(Model model, StaticDispatch dispatch) {
        VariableScope variableScope = model.getVariableScope(dispatch.getStartOffset());
        QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(ASTNodeInfo.toQualifiedName(dispatch, true), dispatch.getStartOffset(), variableScope);
        NamespaceIndexFilter filter = new NamespaceIndexFilter(fullyQualifiedName.toString());
        Collection<? extends TypeScope> staticTypeName = VariousUtils.getStaticTypeName(variableScope != null ? variableScope : model.getFileScope(), filter.getName());
        return filter.filterModelElements(staticTypeName, true);
    }

    @NonNull
    public static Collection<? extends TypeScope> resolveType(Model model, VariableBase varBase) {
        return ModelUtils.resolveType(model, varBase, true);
    }

    @NonNull
    public static Collection<? extends TypeScope> resolveType(Model model, VariableBase varBase, boolean justDispatcher) {
        String vartype;
        Collection<Object> retval = Collections.emptyList();
        VariableScope scp = model.getVariableScope(varBase.getStartOffset());
        if (scp != null && (vartype = VariousUtils.extractTypeFroVariableBase(varBase)) != null) {
            retval = VariousUtils.getType(scp, vartype, varBase.getStartOffset(), justDispatcher);
        }
        return retval;
    }

    @NonNull
    public static Collection<? extends TypeScope> resolveType(Model model, Assignment varBase) {
        Collection<Object> retval = Collections.emptyList();
        VariableScope scp = model.getVariableScope(varBase.getStartOffset());
        if (scp != null) {
            String vartype = CodeUtils.extractVariableType(varBase);
            if (vartype == null) {
                QualifiedName qName;
                Expression rightHandSide = varBase.getRightHandSide();
                if (rightHandSide instanceof VariableBase) {
                    vartype = VariousUtils.extractTypeFroVariableBase((VariableBase)rightHandSide);
                    if (vartype != null) {
                        return VariousUtils.getType(scp, vartype, varBase.getStartOffset(), false);
                    }
                } else if (rightHandSide instanceof StaticDispatch && (qName = ASTNodeInfo.toQualifiedName(rightHandSide, true)) != null) {
                    VariableScope variableScope = model.getVariableScope(rightHandSide.getStartOffset());
                    QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(qName, rightHandSide.getStartOffset(), variableScope);
                    NamespaceIndexFilter filter = new NamespaceIndexFilter(fullyQualifiedName.toString());
                    Collection<? extends TypeScope> staticTypeName = VariousUtils.getStaticTypeName(variableScope != null ? variableScope : model.getFileScope(), filter.getName());
                    return filter.filterModelElements(staticTypeName, true);
                }
            } else {
                retval = VariousUtils.getType(scp, vartype, varBase.getStartOffset(), false);
            }
        }
        return retval;
    }

    @NonNull
    public static Collection<? extends TypeScope> resolveTypeAfterReferenceToken(Model model, TokenSequence<PHPTokenId> tokenSequence, int offset) {
        String semiType;
        tokenSequence.move(offset);
        List retval = Collections.emptyList();
        VariableScope scp = model.getVariableScope(offset);
        if (scp != null && (semiType = VariousUtils.getSemiType(tokenSequence, VariousUtils.State.START, scp)) != null) {
            return VariousUtils.getType(scp, semiType, offset, true);
        }
        return retval;
    }

    @CheckForNull
    public static <T> T getFirst(Collection<? extends T> all) {
        if (all instanceof List) {
            return all.size() > 0 ? (T)((List)all).get(0) : null;
        }
        return all.size() > 0 ? (T)all.iterator().next() : null;
    }

    @CheckForNull
    public static <T extends ModelElement> T getLast(List<? extends T> all) {
        return (T)(all.size() > 0 ? (ModelElement)all.get(all.size() - 1) : null);
    }

    @NonNull
    public static <T extends ModelElement> List<? extends T> filter(Collection<T> allElements, final QuerySupport.Kind nameKind, QualifiedName qualifiedName) {
        final QualifiedNameKind kind = qualifiedName.getKind();
        final String name = qualifiedName.toName().toString();
        final String namespaceName = qualifiedName.toNamespaceName().toString();
        return ModelUtils.filter(allElements, new ElementFilter<T>(){

            @Override
            public boolean isAccepted(T element) {
                if (ModelUtils.nameKindMatch(element.getName(), nameKind, name)) {
                    switch (kind) {
                        case QUALIFIED: {
                            return element.getNamespaceName().toString().endsWith(namespaceName);
                        }
                        case UNQUALIFIED: {
                            return true;
                        }
                        case FULLYQUALIFIED: {
                            return ModelUtils.nameKindMatch(element.getNamespaceName().toString(), nameKind, namespaceName);
                        }
                    }
                    assert (false) : kind;
                }
                return false;
            }
        });
    }

    @NonNull
    public static <T extends ModelElement> List<? extends T> filter(Collection<T> allElements, QualifiedName qName) {
        return ModelUtils.filter(allElements, QuerySupport.Kind.EXACT, qName);
    }

    @NonNull
    public static <T extends ModelElement> List<? extends T> filter(Collection<T> allElements, String ... elementName) {
        return ModelUtils.filter(allElements, QuerySupport.Kind.EXACT, elementName);
    }

    @NonNull
    public static <T extends ModelElement> List<? extends T> filter(Collection<T> allElements, final QuerySupport.Kind nameKind, final String ... elementName) {
        return ModelUtils.filter(allElements, new ElementFilter<T>(){

            @Override
            public boolean isAccepted(T element) {
                PhpElementKind kind = element.getPhpElementKind();
                boolean caseSensitive = EnumSet.of(PhpElementKind.VARIABLE, PhpElementKind.FIELD).contains((Object)kind);
                return elementName.length == 0 || ModelUtils.nameKindMatch(!caseSensitive, element.getName(), nameKind, elementName);
            }
        });
    }

    @NonNull
    public static <T extends ModelElement> List<? extends T> filter(Collection<? extends T> allElements, FileObject fileObject) {
        ArrayList<ModelElement> retval = new ArrayList<ModelElement>();
        for (ModelElement element : allElements) {
            if (element.getFileObject() != fileObject) continue;
            retval.add(element);
        }
        return retval;
    }

    @CheckForNull
    public static <T extends ModelElement> T getFirst(Collection<T> allElements, String ... elementName) {
        return (T)((ModelElement)ModelUtils.getFirst(ModelUtils.filter(allElements, QuerySupport.Kind.EXACT, elementName)));
    }

    @CheckForNull
    public static <T extends ModelElement> T getFirst(Collection<T> allElements, final QuerySupport.Kind nameKind, final String ... elementName) {
        return (T)((ModelElement)ModelUtils.getFirst(ModelUtils.filter(allElements, new ElementFilter<T>(){

            @Override
            public boolean isAccepted(T element) {
                return elementName.length == 0 || ModelUtils.nameKindMatch(element.getName(), nameKind, elementName);
            }
        })));
    }

    @CheckForNull
    public static <T extends ModelElement> T getFirst(Collection<? extends T> allElements, FileObject fileObject) {
        ArrayList<ModelElement> retval = new ArrayList<ModelElement>();
        for (ModelElement element : allElements) {
            if (element.getFileObject() != fileObject) continue;
            retval.add(element);
        }
        return (T)((ModelElement)ModelUtils.getFirst(retval));
    }

    @NonNull
    public static <T extends ModelElement> Collection<? extends T> merge(Collection<? extends T> ... all) {
        ArrayList<? extends T> retval = new ArrayList<T>();
        for (Collection<? extends T> list : all) {
            retval.addAll(list);
        }
        return retval;
    }

    @CheckForNull
    public static FileScope getFileScope(ModelElement element) {
        FileScope retval;
        FileScope fileScope = retval = element instanceof FileScope ? (FileScope)element : null;
        while (retval == null && element != null) {
            retval = (FileScope)((element = element.getInScope()) instanceof FileScope ? element : null);
        }
        return retval;
    }

    @CheckForNull
    public static NamespaceScope getNamespaceScope(ModelElement element) {
        NamespaceScope retval;
        NamespaceScope namespaceScope = retval = element instanceof NamespaceScope ? (NamespaceScope)element : null;
        while (retval == null && element != null) {
            retval = (NamespaceScope)((element = element.getInScope()) instanceof NamespaceScope ? element : null);
        }
        return retval;
    }

    @CheckForNull
    public static NamespaceScope getNamespaceScope(FileScope fileScope, int offset) {
        NamespaceScope retval = fileScope.getDefaultDeclaredNamespace();
        Collection<? extends NamespaceScope> declaredNamespaces = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : declaredNamespaces) {
            OffsetRange blockRange = namespaceScope.getBlockRange();
            if (blockRange == null || !blockRange.containsInclusive(offset) || retval != null && namespaceScope.isDefaultNamespace()) continue;
            retval = namespaceScope;
        }
        return retval;
    }

    @CheckForNull
    public static TypeScope getTypeScope(ModelElement element) {
        TypeScope retval;
        TypeScope typeScope = retval = element instanceof TypeScope ? (TypeScope)element : null;
        while (retval == null && element != null) {
            retval = (TypeScope)((element = element.getInScope()) instanceof TypeScope ? element : null);
        }
        return retval;
    }

    @CheckForNull
    public static ClassScope getClassScope(ModelElement element) {
        ClassScope retval;
        ClassScope classScope = retval = element instanceof ClassScope ? (ClassScope)element : null;
        while (retval == null && element != null) {
            retval = (ClassScope)((element = element.getInScope()) instanceof ClassScope ? element : null);
        }
        return retval;
    }

    @NonNull
    public static IndexScope getIndexScope(ModelElement element) {
        IndexScope retval = element instanceof IndexScope ? (IndexScope)element : null;
        ModelElement tmpElement = element;
        while (retval == null && tmpElement != null) {
            retval = (IndexScope)((tmpElement = tmpElement.getInScope()) instanceof IndexScope ? tmpElement : null);
        }
        if (retval == null) {
            FileScope fileScope = ModelUtils.getFileScope(element);
            assert (fileScope != null);
            retval = fileScope.getIndexScope();
        }
        return retval;
    }

    public static <T extends ModelElement> List<? extends T> filter(Collection<? extends T> instances, ElementFilter<T> filter) {
        ArrayList<ModelElement> retval = new ArrayList<ModelElement>();
        for (ModelElement baseElement : instances) {
            boolean accepted = filter.isAccepted(baseElement);
            if (!accepted) continue;
            retval.add(baseElement);
        }
        return retval;
    }

    public static boolean nameKindMatch(String text, QuerySupport.Kind nameKind, String ... queries) {
        return ModelUtils.nameKindMatch(true, text, nameKind, queries);
    }

    private static boolean nameKindMatch(boolean forceCaseInsensitivity, String text, QuerySupport.Kind nameKind, String ... queries) {
        boolean result = false;
        block8: for (String query : queries) {
            switch (nameKind) {
                case CAMEL_CASE: {
                    if (!ModelUtils.toCamelCase(text).startsWith(query)) continue block8;
                    result = true;
                    continue block8;
                }
                case CASE_INSENSITIVE_PREFIX: {
                    if (!text.toLowerCase().startsWith(query.toLowerCase())) continue block8;
                    result = true;
                    continue block8;
                }
                case CASE_INSENSITIVE_REGEXP: {
                    text = text.toLowerCase();
                    result = ModelUtils.regexpMatch(text, query);
                    continue block8;
                }
                case REGEXP: {
                    result = ModelUtils.regexpMatch(text, query);
                    continue block8;
                }
                case EXACT: {
                    boolean retval;
                    boolean bl = retval = forceCaseInsensitivity ? text.equalsIgnoreCase(query) : text.equals(query);
                    if (!retval) continue block8;
                    result = true;
                    continue block8;
                }
                case PREFIX: {
                    if (!text.startsWith(query)) continue block8;
                    result = true;
                    continue block8;
                }
            }
        }
        return result;
    }

    private static boolean regexpMatch(String text, String query) {
        boolean result = false;
        Pattern p = Pattern.compile(query);
        if (ModelUtils.nameKindMatch(p, text)) {
            result = true;
        }
        return result;
    }

    public static String getCamelCaseName(ModelElement element) {
        return ModelUtils.toCamelCase(element.getName());
    }

    public static String toCamelCase(String plainName) {
        char[] retval = new char[plainName.length()];
        int retvalSize = 0;
        for (int i = 0; i < retval.length; ++i) {
            char c = plainName.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            retval[retvalSize] = c;
            ++retvalSize;
        }
        return String.valueOf(String.valueOf(retval, 0, retvalSize));
    }

    private static boolean nameKindMatch(Pattern p, String text) {
        return p.matcher(text).matches();
    }

    @CheckForNull
    public static FileScope getFileScope(FileObject fileObject) {
        return ModelUtils.getFileScope(fileObject, 0);
    }

    @CheckForNull
    public static FileScope getFileScope(final FileObject fileObject, int timeout) {
        FileScope result = null;
        Future futureResult = RP.submit((Callable)new Callable<FileScope>(){

            @Override
            public FileScope call() throws Exception {
                final FileScope[] fileScope = new FileScope[1];
                try {
                    ParserManager.parse(Collections.singletonList(Source.create((FileObject)fileObject)), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            Parser.Result parserResult = resultIterator.getParserResult();
                            if (parserResult instanceof PHPParseResult) {
                                PHPParseResult phpResult = (PHPParseResult)parserResult;
                                fileScope[0] = phpResult.getModel().getFileScope();
                            }
                        }
                    });
                }
                catch (ParseException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
                return fileScope[0];
            }
        });
        try {
            result = (FileScope)futureResult.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return result;
    }

    @CheckForNull
    public static Model getModel(Source source) {
        return ModelUtils.getModel(source, 0);
    }

    @CheckForNull
    public static Model getModel(final Source source, int timeout) {
        Model result = null;
        Future futureResult = RP.submit((Callable)new Callable<Model>(){

            @Override
            public Model call() throws Exception {
                final Model[] model = new Model[1];
                try {
                    ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            Parser.Result parserResult = resultIterator.getParserResult();
                            if (parserResult instanceof PHPParseResult) {
                                PHPParseResult phpResult = (PHPParseResult)parserResult;
                                model[0] = phpResult.getModel();
                            }
                        }
                    });
                }
                catch (ParseException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
                return model[0];
            }
        });
        try {
            result = (Model)futureResult.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return result;
    }

    public static interface ElementFilter<T extends ModelElement> {
        public boolean isAccepted(T var1);
    }
}

