/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.SuggestionRule;
import org.netbeans.modules.php.editor.verification.VerificationUtils;
import org.openide.filesystems.FileObject;

public class IdenticalComparisonSuggestion
extends SuggestionRule {
    private static final String HINT_ID = "Identical.Comparison.Hint";

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        BaseDocument doc = context.doc;
        int caretOffset = this.getCaretOffset();
        OffsetRange lineBounds = VerificationUtils.createLineBounds(caretOffset, doc);
        if (lineBounds.containsInclusive(caretOffset)) {
            FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
            if (fileObject == null) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, phpParseResult.getModel(), context.doc, lineBounds);
            phpParseResult.getProgram().accept(checkVisitor);
            hints.addAll(checkVisitor.getHints());
        }
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.IdenticalComparisonHintDesc();
    }

    public String getDisplayName() {
        return Bundle.IdenticalComparisonHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    private static class FixInfo {
        private final String typeName;
        private final int length;
        private final int start;
        private final OffsetRange scopeRange;

        public FixInfo(OffsetRange scopeRange, int start, int length, String typeName) {
            this.scopeRange = scopeRange;
            this.start = start;
            this.length = length;
            this.typeName = typeName;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public OffsetRange getScopeRange() {
            return this.scopeRange;
        }
    }

    private class WithoutTypeFix
    extends TypeFix {
        public WithoutTypeFix(FixInfo fixInfo, BaseDocument doc) {
            super(fixInfo, doc);
        }

        public String getDescription() {
            return Bundle.WithoutTypeFixDesc();
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            edits.replace(this.fixInfo.getStart(), this.fixInfo.getLength(), " === ", true, 0);
            edits.apply();
        }
    }

    private class WithRightTypeFix
    extends TypeFix {
        public WithRightTypeFix(FixInfo fixInfo, BaseDocument doc) {
            super(fixInfo, doc);
        }

        public String getDescription() {
            return Bundle.WithRightTypeFixDesc(this.fixInfo.getTypeName());
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            edits.replace(this.fixInfo.getStart(), this.fixInfo.getLength(), " === (" + this.fixInfo.getTypeName() + ") ", true, 0);
            edits.apply();
        }
    }

    private abstract class TypeFix
    implements HintFix {
        protected final BaseDocument doc;
        protected final FixInfo fixInfo;

        public TypeFix(FixInfo fixInfo, BaseDocument doc) {
            this.fixInfo = fixInfo;
            this.doc = doc;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final Model model;
        private final List<FixInfo> fixInfos = new ArrayList<FixInfo>();
        private final List<Hint> hints = new ArrayList<Hint>();
        private final BaseDocument doc;
        private final OffsetRange lineRange;

        public CheckVisitor(FileObject fileObject, Model model, BaseDocument doc, OffsetRange lineRange) {
            this.fileObject = fileObject;
            this.model = model;
            this.doc = doc;
            this.lineRange = lineRange;
        }

        public List<Hint> getHints() {
            for (FixInfo fixInfo : this.fixInfos) {
                this.hints.add(new Hint((Rule)IdenticalComparisonSuggestion.this, Bundle.IdenticalComparisonDesc(), this.fileObject, fixInfo.getScopeRange(), this.createFixes(fixInfo), 500));
            }
            return this.hints;
        }

        private List<HintFix> createFixes(FixInfo fixInfo) {
            ArrayList<HintFix> hintFixes = new ArrayList<HintFix>();
            hintFixes.add(new WithoutTypeFix(fixInfo, this.doc));
            if (!fixInfo.getTypeName().isEmpty()) {
                hintFixes.add(new WithRightTypeFix(fixInfo, this.doc));
            }
            return hintFixes;
        }

        @Override
        public void scan(ASTNode node) {
            if (node != null && VerificationUtils.isBefore(node.getStartOffset(), this.lineRange.getEnd())) {
                super.scan(node);
            }
        }

        @Override
        public void visit(InfixExpression node) {
            if (this.lineRange.containsInclusive(node.getStartOffset())) {
                this.processExpression(node);
            }
        }

        private void processExpression(InfixExpression node) {
            if (node.getOperator().equals((Object)InfixExpression.OperatorType.IS_EQUAL)) {
                int start = node.getLeft().getEndOffset();
                int length = node.getRight().getStartOffset() - start;
                OffsetRange scopeRange = new OffsetRange(node.getLeft().getStartOffset(), node.getRight().getEndOffset());
                this.fixInfos.add(new FixInfo(scopeRange, start, length, this.extractTypeName(node.getLeft())));
            }
            this.scan(node.getLeft());
            this.scan(node.getRight());
        }

        private String extractTypeName(Expression node) {
            String retval = "";
            if (node instanceof Variable) {
                Variable variable = (Variable)node;
                retval = this.extractTypeName(variable);
            }
            return retval;
        }

        private String extractTypeName(Variable variable) {
            VariableScope variableScope = this.model.getVariableScope(variable.getStartOffset());
            Collection<? extends VariableName> declaredVariables = variableScope.getDeclaredVariables();
            String originalVariableName = CodeUtils.extractVariableName(variable);
            VariableName exactVariable = this.getExactVariable(declaredVariables, originalVariableName);
            Collection<? extends String> typeNames = this.getTypeNames(exactVariable, variable.getStartOffset());
            return this.getCastableType(typeNames);
        }

        private VariableName getExactVariable(Collection<? extends VariableName> declaredVariables, String originalVariableName) {
            VariableName retval = null;
            for (VariableName variableName : declaredVariables) {
                if (!variableName.getName().equals(originalVariableName)) continue;
                retval = variableName;
                break;
            }
            return retval;
        }

        private Collection<? extends String> getTypeNames(VariableName variableName, int offset) {
            Collection retval = null;
            if (variableName != null) {
                retval = variableName.getTypeNames(offset);
            }
            return retval;
        }

        private String getCastableType(Collection<? extends String> typeNames) {
            String typeName;
            String retval = "";
            if (typeNames != null && typeNames.size() == 1 && (typeName = ModelUtils.getFirst(typeNames)) != null) {
                retval = this.resolveCastableType(typeName);
            }
            return retval;
        }

        private String resolveCastableType(String typeName) {
            String retval = "";
            switch (typeName) {
                case "int": 
                case "integer": 
                case "double": 
                case "float": 
                case "bool": 
                case "boolean": 
                case "string": 
                case "array": {
                    retval = typeName;
                    break;
                }
                case "real": {
                    retval = "float";
                    break;
                }
            }
            return retval;
        }
    }
}

