/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchCase;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.CustomisableRule;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.ImmutableVariablesCustomizer;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class ImmutableVariablesHint
extends HintRule
implements CustomisableRule {
    private static final String HINT_ID = "Immutable.Variables.Hint";
    private static final String NUMBER_OF_ALLOWED_ASSIGNMENTS = "php.verification.number.of.allowed.assignments";
    private static final int DEFAULT_NUMBER_OF_ALLOWED_ASSIGNMENTS = 1;
    private static final List<String> UNCHECKED_VARIABLES = new ArrayList<String>();
    private Preferences preferences;

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return;
        }
        CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc);
        phpParseResult.getProgram().accept(checkVisitor);
        hints.addAll(checkVisitor.getHints());
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.ImmutableVariableHintDesc();
    }

    public String getDisplayName() {
        return Bundle.ImmutableVariableHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        ImmutableVariablesCustomizer customizer = new ImmutableVariablesCustomizer(preferences, this);
        this.setNumberOfAllowedAssignments(preferences, this.getNumberOfAllowedAssignments(preferences));
        return customizer;
    }

    public void setNumberOfAllowedAssignments(Preferences preferences, Integer value) {
        preferences.putInt(NUMBER_OF_ALLOWED_ASSIGNMENTS, value);
    }

    public int getNumberOfAllowedAssignments(Preferences preferences) {
        return preferences.getInt(NUMBER_OF_ALLOWED_ASSIGNMENTS, 1);
    }

    static {
        UNCHECKED_VARIABLES.add("this");
        UNCHECKED_VARIABLES.add("GLOBALS");
        UNCHECKED_VARIABLES.add("_SERVER");
        UNCHECKED_VARIABLES.add("_GET");
        UNCHECKED_VARIABLES.add("_POST");
        UNCHECKED_VARIABLES.add("_FILES");
        UNCHECKED_VARIABLES.add("_COOKIE");
        UNCHECKED_VARIABLES.add("_SESSION");
        UNCHECKED_VARIABLES.add("_REQUEST");
        UNCHECKED_VARIABLES.add("_ENV");
    }

    private class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final Stack<ASTNode> parentNodes = new Stack();
        private final Map<ASTNode, Map<String, List<Variable>>> assignments = new HashMap<ASTNode, Map<String, List<Variable>>>();
        private final List<Hint> hints = new ArrayList<Hint>();
        private boolean variableAssignment;
        private final int numberOfAllowedAssignments;

        public CheckVisitor(FileObject fileObject, BaseDocument baseDocument) {
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.numberOfAllowedAssignments = ImmutableVariablesHint.this.getNumberOfAllowedAssignments(ImmutableVariablesHint.this.preferences);
        }

        public List<Hint> getHints() {
            for (ASTNode scopeNode : this.assignments.keySet()) {
                Map<String, List<Variable>> names = this.assignments.get(scopeNode);
                this.checkNamesInScope(names);
            }
            return this.hints;
        }

        private void checkNamesInScope(Map<String, List<Variable>> names) {
            for (Map.Entry<String, List<Variable>> entry : names.entrySet()) {
                this.checkAllowedAssignments(entry.getValue());
            }
        }

        private void checkAllowedAssignments(List<Variable> variables) {
            int variablesSize = variables.size();
            if (variablesSize > this.numberOfAllowedAssignments) {
                this.createHints(variables);
            }
        }

        private void createHints(List<Variable> variables) {
            for (Variable variable : variables) {
                this.createHint(variable, variables.size());
            }
        }

        private void createHint(Variable variable, int numberOfAssignments) {
            int end;
            int start = variable.getStartOffset() + 1;
            OffsetRange offsetRange = new OffsetRange(start, end = variable.getEndOffset());
            if (ImmutableVariablesHint.this.showHint(offsetRange, this.baseDocument)) {
                Identifier variableIdentifier = this.getIdentifier(variable);
                String variableName = variableIdentifier == null ? "?" : variableIdentifier.getName();
                this.hints.add(new Hint((Rule)ImmutableVariablesHint.this, Bundle.ImmutableVariablesHintCustom(this.numberOfAllowedAssignments, numberOfAssignments, variableName), this.fileObject, offsetRange, null, 500));
            }
        }

        @Override
        public void visit(Program node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(NamespaceDeclaration node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(FunctionDeclaration node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(IfStatement node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(CatchClause node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(Block node) {
            if (this.parentNodes.peek() instanceof IfStatement) {
                this.parentNodes.push(node);
                super.visit(node);
                this.parentNodes.pop();
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(ForStatement node) {
            this.parentNodes.push(node);
            this.scan(node.getInitializers());
            this.scan(node.getConditions());
            this.scan(node.getBody());
            this.parentNodes.pop();
        }

        @Override
        public void visit(ForEachStatement node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(DoStatement node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(WhileStatement node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(SwitchCase node) {
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(StaticFieldAccess node) {
        }

        @Override
        public void visit(FormalParameter functionParameter) {
            Expression parameterName = functionParameter.getParameterName();
            if (parameterName instanceof Variable) {
                this.processVariableAssignment((Variable)parameterName);
            }
        }

        @Override
        public void visit(Variable node) {
            if (this.variableAssignment) {
                this.processVariableAssignment(node);
            }
        }

        private void processVariableAssignment(Variable node) {
            ASTNode parentNode = this.parentNodes.peek();
            Map<String, List<Variable>> names = this.getNames(parentNode);
            Identifier identifier = this.getIdentifier(node);
            if (identifier != null) {
                this.addValidVariable(identifier, names, node);
            }
        }

        private Map<String, List<Variable>> getNames(ASTNode parentNode) {
            Map<String, List<Variable>> names = this.assignments.get(parentNode);
            if (names == null) {
                names = new HashMap<String, List<Variable>>();
                this.assignments.put(parentNode, names);
            }
            return names;
        }

        private void addValidVariable(Identifier identifier, Map<String, List<Variable>> names, Variable node) {
            String name = identifier.getName();
            if (!UNCHECKED_VARIABLES.contains(name)) {
                List<Variable> variables = this.getVariables(names, name);
                variables.add(node);
            }
        }

        private List<Variable> getVariables(Map<String, List<Variable>> names, String name) {
            List<Variable> variables = names.get(name);
            if (variables == null) {
                variables = new ArrayList<Variable>();
                names.put(name, variables);
            }
            return variables;
        }

        @Override
        public void visit(Assignment node) {
            if (node.getOperator().equals((Object)Assignment.Type.EQUAL)) {
                if (this.parentNodes.peek() instanceof IfStatement) {
                    this.parentNodes.push(node);
                    this.processEqualAssignment(node);
                    this.parentNodes.pop();
                } else {
                    this.processEqualAssignment(node);
                }
            }
        }

        private void processEqualAssignment(Assignment node) {
            if (!(node.getRightHandSide() instanceof InfixExpression) || node.getRightHandSide() instanceof InfixExpression && !this.containsConcatOperator((InfixExpression)node.getRightHandSide())) {
                this.variableAssignment = true;
                this.scan(node.getLeftHandSide());
                this.variableAssignment = false;
            }
        }

        private boolean containsConcatOperator(InfixExpression infixExpression) {
            boolean retval = false;
            if (infixExpression.getOperator().equals((Object)InfixExpression.OperatorType.CONCAT)) {
                retval = true;
            } else if (infixExpression.getLeft() instanceof InfixExpression) {
                retval = this.containsConcatOperator((InfixExpression)infixExpression.getLeft());
            } else if (infixExpression.getLeft() instanceof InfixExpression) {
                retval = this.containsConcatOperator((InfixExpression)infixExpression.getRight());
            }
            return retval;
        }

        @Override
        public void visit(ArrayAccess node) {
        }

        @Override
        public void visit(ArrayCreation node) {
        }

        @Override
        public void visit(FieldAccess node) {
        }

        @CheckForNull
        private Identifier getIdentifier(Variable variable) {
            Identifier retval = null;
            if (variable != null && variable.isDollared()) {
                retval = this.separateIdentifier(variable);
            }
            return retval;
        }

        @CheckForNull
        private Identifier separateIdentifier(Variable variable) {
            Identifier retval = null;
            if (variable.getName() instanceof Identifier) {
                retval = (Identifier)variable.getName();
            }
            return retval;
        }
    }
}

