/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public abstract class ClassEnumBase<T>
extends OffsetableDeclarationBase<T>
implements CsmCompoundClassifier,
CsmMember {
    private final CharSequence name;
    private CharSequence qualifiedName;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private boolean isValid = true;
    private boolean _static = false;
    private CsmVisibility visibility = CsmVisibility.PRIVATE;
    private final List<CsmUID<CsmOffsetableDeclaration>> enclosingElements;

    protected ClassEnumBase(NameHolder name, CsmFile file, AST ast) {
        this(name, file, ClassEnumBase.getStartOffset(ast), ClassEnumBase.getEndOffset(ast));
    }

    protected ClassEnumBase(NameHolder name, CsmFile file, int start, int end) {
        super(file, start, end);
        this.enclosingElements = Collections.synchronizedList(new ArrayList(0));
        assert (name != null);
        this.name = NameCache.getManager().getString(name.getName());
    }

    protected ClassEnumBase(CharSequence name, CharSequence qName, CsmFile file, int startOffset, int endOffset) {
        super(file, startOffset, endOffset);
        this.enclosingElements = Collections.synchronizedList(new ArrayList(0));
        this.name = NameCache.getManager().getString(name);
        this.qualifiedName = QualifiedNameCache.getManager().getString(qName);
    }

    public static int getEndOffset(AST node) {
        if (node != null) {
            AST rcurly = AstUtil.findChildOfType(node, 17);
            if (rcurly instanceof CsmAST) {
                return ((CsmAST)rcurly).getEndOffset();
            }
            switch (node.getType()) {
                case 118: 
                case 158: 
                case 159: 
                case 160: {
                    rcurly = AstUtil.findSiblingOfType(node, 17);
                }
            }
            if (rcurly instanceof CsmAST) {
                return ((CsmAST)rcurly).getEndOffset();
            }
            return OffsetableBase.getEndOffset(node);
        }
        return 0;
    }

    public final CharSequence getName() {
        return this.name;
    }

    protected final ClassImpl.MemberForwardDeclaration findMemberForwardDeclaration(CsmScope scope) {
        if (this.name != null && CharSequences.indexOf((CharSequence)this.name, (CharSequence)"::") > 0) {
            String n = this.name.toString();
            String prefix = n.substring(0, n.lastIndexOf("::"));
            String suffix = n.substring(n.lastIndexOf("::") + 2);
            if (CsmKindUtilities.isNamespace((Object)scope)) {
                CsmNamespace ns = (CsmNamespace)scope;
                CharSequence qn = ns.isGlobal() ? prefix : CharSequenceUtils.concatenate((CharSequence)ns.getQualifiedName(), (CharSequence)"::", (CharSequence)prefix);
                Collection defs = ns.getProject().findClassifiers(qn);
                ClassImpl.MemberForwardDeclaration out = null;
                for (CsmClassifier cls : defs) {
                    CsmMember m;
                    CsmClass container;
                    Iterator it;
                    if (!CsmKindUtilities.isClass((CsmObject)cls) || !(it = CsmSelect.getClassMembers((CsmClass)(container = (CsmClass)cls), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter((CharSequence)suffix, true, true, false))).hasNext() || !((m = (CsmMember)it.next()) instanceof ClassImpl.MemberForwardDeclaration)) continue;
                    if (FunctionImpl.isObjectVisibleInFile(this.getContainingFile(), (CsmOffsetableDeclaration)m)) {
                        out = (ClassImpl.MemberForwardDeclaration)m;
                    }
                    if (out != null) continue;
                    out = (ClassImpl.MemberForwardDeclaration)m;
                }
                return out;
            }
        }
        return null;
    }

    protected final void initScope(CsmScope scope) {
        assert (!this.equals(scope)) : "scope can not be recursive " + this + " vs. " + scope;
        if (UIDCsmConverter.isIdentifiable(scope)) {
            this.scopeUID = UIDCsmConverter.scopeToUID(scope);
            assert (this.scopeUID != null || scope == null) : "null UID for class scope " + scope;
            this.scopeRef = null;
        } else {
            this.scopeRef = scope;
        }
        this.initQualifiedName(scope);
    }

    protected final void initQualifiedName(CsmScope scope) {
        CharSequence qualName;
        CharSequence qualifiedNamePostfix = this.getQualifiedNamePostfix();
        if (CsmKindUtilities.isNamespace((Object)scope)) {
            qualName = Utils.getQualifiedName(qualifiedNamePostfix.toString(), (CsmNamespace)scope);
        } else if (CsmKindUtilities.isClass((CsmObject)scope)) {
            int last = CharSequenceUtils.lastIndexOf((CharSequence)qualifiedNamePostfix, (CharSequence)"::");
            if (last >= 0) {
                qualifiedNamePostfix = qualifiedNamePostfix.toString().substring(last + 2);
            }
            qualName = CharSequenceUtils.concatenate((CharSequence)((CsmClass)scope).getQualifiedName(), (CharSequence)"::", (CharSequence)qualifiedNamePostfix);
        } else {
            qualName = qualifiedNamePostfix;
        }
        this.qualifiedName = QualifiedNameCache.getManager().getString(qualName);
    }

    public abstract CsmDeclaration.Kind getKind();

    protected final void register(CsmScope scope, boolean registerUnnamedInNamespace) {
        RepositoryUtils.put(this);
        boolean registerInNamespace = registerUnnamedInNamespace;
        if (Utils.canRegisterDeclaration((CsmDeclaration)this)) {
            registerInNamespace = this.registerInProject();
        }
        if (registerInNamespace && this.getContainingClass() == null && CsmKindUtilities.isNamespace((Object)scope)) {
            ((NamespaceImpl)scope).addDeclaration(this);
        }
    }

    @Override
    protected boolean registerInProject() {
        return ((ProjectBase)this.getContainingFile().getProject()).registerDeclaration(this);
    }

    private void unregisterInProject() {
        ((ProjectBase)this.getContainingFile().getProject()).unregisterDeclaration(this);
        this.cleanUID();
    }

    public boolean shouldBeReplaced(CsmClassifier another) {
        return false;
    }

    public NamespaceImpl getContainingNamespaceImpl() {
        CsmScope scope = this.getScope();
        return scope instanceof NamespaceImpl ? (NamespaceImpl)scope : null;
    }

    public CharSequence getQualifiedName() {
        return this.qualifiedName;
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    private synchronized CsmScope _getScope() {
        CsmScope scope = this.scopeRef;
        if (scope == null) {
            scope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return scope;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        if (this.getContainingNamespaceImpl() != null) {
            this.getContainingNamespaceImpl().removeDeclaration(this);
        }
        this.unregisterInProject();
        this.isValid = false;
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid && super.isValid();
    }

    public CsmClass getContainingClass() {
        CsmScope scope = this.getScope();
        return CsmKindUtilities.isClass((CsmObject)scope) ? (CsmClass)scope : null;
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(CsmVisibility visibility) {
        this.visibility = visibility;
    }

    public boolean isStatic() {
        return this._static;
    }

    public void setStatic(boolean _static) {
        this._static = _static;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        output.writeBoolean(this.isValid);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        assert (this.qualifiedName != null);
        PersistentUtils.writeUTF(this.qualifiedName, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, output);
        output.writeBoolean(this._static);
        assert (this.visibility != null);
        PersistentUtils.writeVisibility(this.visibility, output);
        if (this.getName().length() == 0) {
            super.writeUID(output);
        }
        UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.enclosingElements, output, true);
    }

    protected ClassEnumBase(RepositoryDataInput input) throws IOException {
        super(input);
        int collSize;
        this.isValid = input.readBoolean();
        this.name = PersistentUtils.readUTF(input, NameCache.getManager());
        assert (this.name != null);
        this.qualifiedName = PersistentUtils.readUTF(input, QualifiedNameCache.getManager());
        assert (this.qualifiedName != null);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        this.scopeRef = null;
        this._static = input.readBoolean();
        this.visibility = PersistentUtils.readVisibility(input);
        assert (this.visibility != null);
        if (this.getName().length() == 0) {
            super.readUID(input);
        }
        this.enclosingElements = (collSize = input.readInt()) < 0 ? Collections.synchronizedList(new ArrayList(0)) : Collections.synchronizedList(new ArrayList(collSize));
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.enclosingElements, input, collSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmTypedef> getEnclosingTypedefs() {
        ArrayList<CsmTypedef> out = new ArrayList<CsmTypedef>(0);
        List<CsmUID<CsmOffsetableDeclaration>> list = this.enclosingElements;
        synchronized (list) {
            for (CsmUID<CsmOffsetableDeclaration> uid : this.enclosingElements) {
                CsmDeclaration obj;
                CsmDeclaration.Kind kind = UIDUtilities.getKind(uid);
                if (kind != CsmDeclaration.Kind.TYPEDEF && kind != CsmDeclaration.Kind.TYPEALIAS || (obj = (CsmDeclaration)UIDCsmConverter.UIDtoCsmObject(uid)) == null) continue;
                out.add((CsmTypedef)obj);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmVariable> getEnclosingVariables() {
        ArrayList<CsmVariable> out = new ArrayList<CsmVariable>(0);
        List<CsmUID<CsmOffsetableDeclaration>> list = this.enclosingElements;
        synchronized (list) {
            for (CsmUID<CsmOffsetableDeclaration> uid : this.enclosingElements) {
                CsmDeclaration obj;
                CsmDeclaration.Kind kind = UIDUtilities.getKind(uid);
                if (kind != CsmDeclaration.Kind.VARIABLE || (obj = (CsmDeclaration)UIDCsmConverter.UIDtoCsmObject(uid)) == null) continue;
                out.add((CsmVariable)obj);
            }
        }
        return out;
    }

    public void addEnclosingTypedef(CsmTypedef typedef) {
        CsmUID uid = UIDs.get((Object)typedef);
        this.enclosingElements.add((CsmUID<CsmOffsetableDeclaration>)uid);
    }

    public void addEnclosingVariable(CsmVariable var) {
        CsmUID uid = UIDs.get((Object)var);
        this.enclosingElements.add((CsmUID<CsmOffsetableDeclaration>)uid);
    }
}

