/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.PrintStream;
import org.netbeans.modules.cnd.antlr.ASTVisitor;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.parser.FakeAST;
import org.netbeans.modules.cnd.modelimpl.parser.OffsetableAST;
import org.netbeans.modules.cnd.modelimpl.parser.OffsetableFakeAST;
import org.netbeans.modules.cnd.modelimpl.parser.TokenBasedAST;
import org.netbeans.modules.cnd.modelimpl.parser.TokenBasedFakeAST;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.openide.util.CharSequences;

public class AstUtil {
    private AstUtil() {
    }

    public static boolean isEmpty(AST ast, boolean hasFakeChild) {
        if (AstUtil.isEmpty(ast)) {
            return true;
        }
        return hasFakeChild ? AstUtil.isEmpty(ast.getFirstChild()) : false;
    }

    private static boolean isEmpty(AST ast) {
        return ast == null || ast.getType() == 1;
    }

    public static boolean isElaboratedKeyword(AST ast) {
        if (ast != null) {
            return ast.getType() == 159 || ast.getType() == 158 || ast.getType() == 160 || ast.getType() == 118;
        }
        return false;
    }

    public static CharSequence getRawNameInChildren(AST ast) {
        return AstUtil.getRawName(AstUtil.findIdToken(ast));
    }

    public static CharSequence[] toRawName(CharSequence rawName) {
        if (rawName == null) {
            return null;
        }
        String[] split = rawName.toString().split("\\.");
        CharSequence[] res = new CharSequence[split.length];
        for (int i = 0; i < split.length; ++i) {
            res[i] = CharSequences.create((CharSequence)split[i]);
        }
        return res;
    }

    public static CharSequence getRawName(AST token) {
        StringBuilder l = new StringBuilder();
        while (token != null) {
            switch (token.getType()) {
                case 91: {
                    if (l.length() > 0) {
                        l.append('.');
                    }
                    l.append(AstUtil.getText(token));
                    break;
                }
                case 52: {
                    break;
                }
            }
            token = token.getNextSibling();
        }
        return NameCache.getManager().getString(CharSequences.create((CharSequence)l));
    }

    private static AST findIdToken(AST ast) {
        for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            if (token.getType() == 91) {
                return token;
            }
            if (token.getType() != 563) continue;
            return token.getFirstChild();
        }
        return null;
    }

    public static CharSequence findId(AST ast) {
        return AstUtil.findId(ast, -1);
    }

    public static CharSequence findId(AST ast, int limitingTokenType) {
        return AstUtil.findId(ast, limitingTokenType, false);
    }

    public static CharSequence findId(AST ast, int limitingTokenType, boolean qualified) {
        for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            int type = token.getType();
            if (type == limitingTokenType && limitingTokenType >= 0) {
                return null;
            }
            if (type == 91) {
                return AstUtil.getText(token);
            }
            if (type != 563) continue;
            if (qualified) {
                return AstUtil.getText(token);
            }
            AST last = AstUtil.getLastChild(token);
            if (last == null) continue;
            if (last.getType() == 91) {
                return AstUtil.getText(last);
            }
            AST first = token.getFirstChild();
            if (first.getType() == 110) {
                StringBuilder sb = new StringBuilder(AstUtil.getText(first));
                sb.append(' ');
                AST next = first.getNextSibling();
                if (next != null) {
                    sb.append(AstUtil.getText(next));
                }
                return sb;
            }
            if (first.getType() != 91) continue;
            return AstUtil.getText(first);
        }
        return "";
    }

    public static CharSequence getText(AST ast) {
        if (ast instanceof FakeAST) {
            return ((FakeAST)ast).getTextID();
        }
        if (ast instanceof CsmAST) {
            return ((CsmAST)ast).getTextID();
        }
        return ast.getText();
    }

    public static AST findMethodName(AST ast) {
        AST type = ast.getFirstChild();
        AST qn = null;
        int i = 0;
        block8: while (type != null) {
            switch (type.getType()) {
                case 21: {
                    ++i;
                    type = type.getNextSibling();
                    continue block8;
                }
                case 23: {
                    --i;
                    type = type.getNextSibling();
                    continue block8;
                }
                case 526: 
                case 528: {
                    type = type.getNextSibling();
                    if (i != 0) continue block8;
                    qn = type;
                    continue block8;
                }
                case 91: {
                    if (i == 0 && qn == null) {
                        qn = type;
                    }
                    type = type.getNextSibling();
                    continue block8;
                }
                case 563: {
                    if (i == 0) {
                        qn = type;
                    }
                    type = type.getNextSibling();
                    continue block8;
                }
                case 7: 
                case 11: 
                case 570: 
                case 571: 
                case 572: {
                    break block8;
                }
                default: {
                    type = type.getNextSibling();
                    continue block8;
                }
            }
        }
        return qn;
    }

    public static AST findTypeNode(AST ast) {
        AST typeAst = AstUtil.findChildOfType(ast, 526);
        if (typeAst == null && (typeAst = AstUtil.findChildOfType(ast, 528)) == null) {
            typeAst = AstUtil.findChildOfType(ast, 527);
        }
        return typeAst;
    }

    public static boolean isTypeNode(AST ast) {
        return ast != null && (ast.getType() == 526 || ast.getType() == 528 || ast.getType() == 527);
    }

    public static boolean hasChildOfType(AST ast, int type) {
        for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            if (token.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static AST findChildOfType(AST ast, int type) {
        return AstUtil.findChildOfType(ast, type, null);
    }

    public static AST findChildOfType(AST ast, int type, AST stopToken) {
        for (AST token = ast.getFirstChild(); token != null && token != stopToken; token = token.getNextSibling()) {
            if (token.getType() != type) continue;
            return token;
        }
        return null;
    }

    public static AST findSiblingOfType(AST ast, int type) {
        return AstUtil.findSiblingOfType(ast, type, null);
    }

    public static AST findSiblingOfType(AST ast, int type, AST stopToken) {
        for (AST token = ast; token != null && token != stopToken; token = token.getNextSibling()) {
            if (token.getType() != type) continue;
            return token;
        }
        return null;
    }

    public static AST findLastSiblingOfType(AST ast, int type) {
        AST result = null;
        for (AST token = ast; token != null; token = token.getNextSibling()) {
            if (token.getType() != type) continue;
            result = token;
        }
        return result;
    }

    public static AST skipTokens(AST ast, int ... tokens) {
        AST next;
        for (next = ast; next != null && AstUtil.arrayContains(next.getType(), tokens); next = next.getNextSibling()) {
        }
        return next;
    }

    public static AST getLastChild(AST token) {
        if (token == null) {
            return null;
        }
        AST child = token.getFirstChild();
        if (child != null) {
            while (child.getNextSibling() != null) {
                child = child.getNextSibling();
            }
            return child;
        }
        return null;
    }

    public static AST getLastChildRecursively(AST token) {
        if (token == null) {
            return null;
        }
        if (token.getFirstChild() == null) {
            return token;
        }
        AST child = AstUtil.getLastChild(token);
        return AstUtil.getLastChildRecursively(child);
    }

    public static AST getLastNonEOFChildRecursively(AST token) {
        if (token == null) {
            return null;
        }
        AST child = token.getFirstChild();
        if (child == null) {
            return token;
        }
        AST lastChild = AstUtil.getLastNonEOFChildRecursively(child);
        while (child.getNextSibling() != null) {
            AST lastChild2 = AstUtil.getLastNonEOFChildRecursively(child = child.getNextSibling());
            if (lastChild2.getType() == 1 || !(lastChild2 instanceof CsmAST)) continue;
            lastChild = lastChild2;
        }
        return lastChild;
    }

    public static OffsetableAST getFirstOffsetableAST(AST node) {
        if (node != null) {
            if (node instanceof OffsetableAST) {
                return (OffsetableAST)node;
            }
            return AstUtil.getFirstOffsetableAST(node.getFirstChild());
        }
        return null;
    }

    public static String toString(AST ast) {
        final StringBuilder out = new StringBuilder();
        ASTVisitor impl = new ASTVisitor(){

            public void visit(AST node) {
                AstUtil.print(node, out);
                for (AST node2 = node; node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getFirstChild() == null) continue;
                    out.append('>');
                    this.visit(node2.getFirstChild());
                    out.append('<');
                }
            }
        };
        impl.visit(ast);
        return out.toString();
    }

    public static void toStream(AST ast, final PrintStream ps) {
        ASTVisitor impl = new ASTVisitor(){

            public void visit(AST node) {
                AstUtil.print(node, ps);
                for (AST node2 = node; node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getFirstChild() == null) continue;
                    ps.print('>');
                    this.visit(node2.getFirstChild());
                    ps.print('<');
                }
            }
        };
        impl.visit(ast);
    }

    public static AST createAST(AST n1, AST n2) {
        CsmAST root = new CsmAST();
        root.initialize(n1);
        CsmAST child = new CsmAST();
        child.initialize(n2);
        root.addChild(child);
        return root;
    }

    private static void print(AST ast, PrintStream ps) {
        ps.print('[');
        ps.print(ast.getText());
        ps.print('(');
        ps.print(ast.getType());
        ps.print(')');
        ps.print(ast.getLine());
        ps.print(':');
        ps.print(ast.getColumn());
        ps.print(']');
    }

    private static void print(AST ast, StringBuilder out) {
        out.append('[');
        out.append(ast.getText());
        out.append('(');
        out.append(ast.getType());
        out.append(')');
        out.append(ast.getLine());
        out.append(':');
        out.append(ast.getColumn());
        out.append(']');
    }

    public static String getOffsetString(AST ast) {
        if (ast == null) {
            return "<null>";
        }
        OffsetableAST startAst = AstUtil.getFirstOffsetableAST(ast);
        AST endAst = AstUtil.getLastChildRecursively(ast);
        if (startAst != null && endAst != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(startAst.getLine());
            sb.append(":").append(startAst.getColumn());
            sb.append("-").append(endAst.getLine());
            sb.append(":").append(endAst.getColumn());
            sb.append("]");
            return sb.toString();
        }
        return "<no csm nodes>";
    }

    public static boolean visitAST(ASTTokenVisitor visitor, AST ast) {
        if (ast != null) {
            switch (visitor.visit(ast)) {
                case ABORT: {
                    return false;
                }
                case SKIP_SUBTREE: {
                    return true;
                }
                case CONTINUE: {
                    for (AST insideToken = ast.getFirstChild(); insideToken != null; insideToken = insideToken.getNextSibling()) {
                        if (AstUtil.visitAST(visitor, insideToken)) continue;
                        return false;
                    }
                    break;
                }
            }
        }
        return true;
    }

    public static boolean hasExpandedTokens(AST ast) {
        ASTExpandedTokensChecker checker = new ASTExpandedTokensChecker();
        AstUtil.visitAST(checker, ast);
        return checker.HasExpanded();
    }

    public static AST cloneAST(AST source, AST stopNode) {
        return AstUtil.cloneAST(source, stopNode, true);
    }

    public static AST cloneAST(AST source, AST stopNode, boolean includeLast) {
        AST firstClonedNode;
        if (source == null) {
            return null;
        }
        AST currentClonedAST = firstClonedNode = AstUtil.createFakeClone(source);
        AST prevClonedAST = null;
        while (source != null) {
            currentClonedAST.initialize(source);
            currentClonedAST.setFirstChild(source.getFirstChild());
            if (prevClonedAST != null) {
                prevClonedAST.setNextSibling(currentClonedAST);
            }
            if (source == stopNode) break;
            source = source.getNextSibling();
            prevClonedAST = currentClonedAST;
            currentClonedAST = AstUtil.createFakeClone(source);
        }
        if (!includeLast) {
            if (prevClonedAST == null) {
                return null;
            }
            prevClonedAST.setNextSibling(null);
        }
        return firstClonedNode;
    }

    public static AST createFakeClone(AST ast) {
        if (ast instanceof TokenBasedAST) {
            return new TokenBasedFakeAST();
        }
        if (ast instanceof OffsetableAST) {
            return new OffsetableFakeAST();
        }
        return new FakeAST();
    }

    private static boolean arrayContains(int value, int ... array) {
        for (int elem : array) {
            if (value != elem) continue;
            return true;
        }
        return false;
    }

    public static class ASTTokensStringizer
    implements ASTTokenVisitor {
        protected int numStringizedTokens = 0;
        protected final StringBuilder sb = new StringBuilder();

        @Override
        public ASTTokenVisitor.Action visit(AST token) {
            if (token.getFirstChild() == null) {
                this.sb.append(token.getText());
                ++this.numStringizedTokens;
            }
            return ASTTokenVisitor.Action.CONTINUE;
        }

        public String getText() {
            return this.sb.toString();
        }

        public int getNumberOfStringizedTokens() {
            return this.numStringizedTokens;
        }
    }

    public static class ASTExpandedTokensChecker
    implements ASTTokenVisitor {
        private boolean expanded;

        @Override
        public ASTTokenVisitor.Action visit(AST token) {
            TokenBasedAST tokenBasedAST;
            if (token instanceof TokenBasedAST && APTUtils.isMacroExpandedToken((Token)(tokenBasedAST = (TokenBasedAST)token).getToken())) {
                this.expanded = true;
                return ASTTokenVisitor.Action.ABORT;
            }
            return ASTTokenVisitor.Action.CONTINUE;
        }

        public boolean HasExpanded() {
            return this.expanded;
        }
    }

    public static interface ASTTokenVisitor {
        public Action visit(AST var1);

        public static enum Action {
            CONTINUE,
            SKIP_SUBTREE,
            ABORT;

        }
    }
}

