/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpressionStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmObjectAttributeQuery;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.impl.services.UsingResolverImpl;

public class FileElementsCollector {
    private static final int MIN_FILE_OFFSET = Short.MIN_VALUE;
    private static final int MAX_FILE_OFFSET = Integer.MAX_VALUE;
    private final CsmFile destFile;
    private int startOffset;
    private int destOffset;
    private int returnPoint;
    private int localReturnPoint;
    private int localEndPoint;
    private final CsmProject onlyInProject;
    private final LinkedHashSet<CsmNamespace> globalDirectVisibleNamespaces = new LinkedHashSet();
    private final LinkedHashSet<CsmUsingDirective> globalUsingNamespaces = new LinkedHashSet();
    private final LinkedHashSet<CsmNamespaceAlias> globalNamespaceAliases = new LinkedHashSet();
    private final LinkedHashSet<CsmUsingDeclaration> globalUsingDeclarations = new LinkedHashSet();
    private LinkedHashSet<CsmNamespace> localDirectVisibleNamespaces = new LinkedHashSet();
    private LinkedHashSet<CsmUsingDirective> localUsingNamespaces = new LinkedHashSet();
    private LinkedHashSet<CsmNamespaceAlias> localNamespaceAliases = new LinkedHashSet();
    private LinkedHashSet<CsmUsingDeclaration> localUsingDeclarations = new LinkedHashSet();
    private final LinkedHashSet<CsmNamespaceDefinition> globalDirectVisibleNamespaceDefinitions = new LinkedHashSet();
    private LinkedHashSet<CsmNamespaceDefinition> localDirectVisibleNamespaceDefinitions = new LinkedHashSet();
    private Collection<CsmDeclaration> visibleUsedDeclarations = null;
    private Collection<CsmNamespace> visibleNamespaces = null;
    private boolean mapsGathered = false;

    public FileElementsCollector(CsmFile file, int offset, CsmProject onlyInProject) {
        this.destFile = file;
        this.destOffset = offset;
        this.startOffset = Short.MIN_VALUE;
        this.returnPoint = Short.MIN_VALUE;
        this.localReturnPoint = Short.MIN_VALUE;
        this.onlyInProject = onlyInProject;
    }

    public int getReturnPoint() {
        return this.returnPoint;
    }

    public synchronized void incrementOffset(int newOffset) {
        if (this.mapsGathered) {
            if (newOffset <= this.destOffset && newOffset > this.localReturnPoint || newOffset <= this.localEndPoint && newOffset > this.localReturnPoint) {
                return;
            }
            this.startOffset = this.returnPoint;
        }
        this.destOffset = newOffset;
        if (this.startOffset < this.destOffset) {
            this.mapsGathered = false;
            this.visibleUsedDeclarations = null;
            this.visibleNamespaces = null;
            this.localDirectVisibleNamespaceDefinitions = new LinkedHashSet();
            this.localDirectVisibleNamespaces = new LinkedHashSet();
            this.localUsingNamespaces = new LinkedHashSet();
            this.localNamespaceAliases = new LinkedHashSet();
            this.localUsingDeclarations = new LinkedHashSet();
        } else if (this.startOffset > this.destOffset) {
            throw new IllegalArgumentException("Start offset " + this.startOffset + " > destination offset " + this.destOffset);
        }
    }

    public Collection<CsmUsingDeclaration> getUsingDeclarations() {
        this.initMaps();
        LinkedHashSet<CsmUsingDeclaration> res = new LinkedHashSet<CsmUsingDeclaration>();
        res.addAll(this.globalUsingDeclarations);
        res.addAll(this.localUsingDeclarations);
        return Collections.unmodifiableCollection(res);
    }

    public Collection<CsmUsingDirective> getUsingDirectives() {
        this.initMaps();
        LinkedHashSet<CsmUsingDirective> res = new LinkedHashSet<CsmUsingDirective>();
        res.addAll(this.globalUsingNamespaces);
        res.addAll(this.localUsingNamespaces);
        return Collections.unmodifiableCollection(res);
    }

    public Collection<CsmNamespaceAlias> getNamespaceAliases() {
        this.initMaps();
        LinkedHashSet<CsmNamespaceAlias> res = new LinkedHashSet<CsmNamespaceAlias>();
        res.addAll(this.globalNamespaceAliases);
        res.addAll(this.localNamespaceAliases);
        return Collections.unmodifiableCollection(res);
    }

    public Collection<CsmDeclaration> getUsedDeclarations() {
        this.initMaps();
        return this._getUsedDeclarations();
    }

    private synchronized Collection<CsmDeclaration> _getUsedDeclarations() {
        Collection<CsmDeclaration> res = this.visibleUsedDeclarations;
        if (res == null) {
            res = UsingResolverImpl.extractDeclarations(this.globalUsingDeclarations);
            res.addAll(UsingResolverImpl.extractDeclarations(this.localUsingDeclarations));
            this.visibleUsedDeclarations = res;
        }
        return Collections.unmodifiableCollection(res);
    }

    public Collection<CsmNamespace> getVisibleNamespaces() {
        this.initMaps();
        return this._getVisibleNamespaces();
    }

    public synchronized Collection<CsmNamespace> _getVisibleNamespaces() {
        Collection<CsmNamespace> res = this.visibleNamespaces;
        if (res == null) {
            res = UsingResolverImpl.extractNamespaces(this.globalUsingNamespaces, this.destFile.getProject());
            res.addAll(UsingResolverImpl.extractNamespaces(this.localUsingNamespaces, this.destFile.getProject()));
            res.addAll(this.globalDirectVisibleNamespaces);
            res.addAll(this.localDirectVisibleNamespaces);
            this.visibleNamespaces = res;
        }
        return Collections.unmodifiableCollection(res);
    }

    private synchronized void initMaps() {
        if (this.mapsGathered) {
            return;
        }
        this.mapsGathered = true;
        this.gatherFileMaps();
    }

    private void gatherFileMaps() {
        HashSet<CsmFile> visitedFiles = new HashSet<CsmFile>();
        List includeStack = CsmFileInfoQuery.getDefault().getIncludeStack(this.destFile);
        for (CsmInclude inc : includeStack) {
            CsmFile includedFrom = inc.getContainingFile();
            int incOffset = inc.getStartOffset();
            this.gatherFileMaps(visitedFiles, includedFrom, Short.MIN_VALUE, incOffset);
        }
        this.gatherFileMaps(visitedFiles, this.destFile, this.startOffset, this.destOffset);
    }

    private void gatherFileMaps(Set<CsmFile> visitedFiles, CsmFile file, int startOffset, int endOffset) {
        if (!file.isValid() || visitedFiles.contains(file)) {
            return;
        }
        visitedFiles.add(file);
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createOffsetFilter(startOffset, endOffset);
        Iterator iter = CsmSelect.getIncludes((CsmFile)file, (CsmSelect.CsmFilter)filter);
        while (iter.hasNext()) {
            CsmFile incFile;
            CsmInclude inc = (CsmInclude)iter.next();
            if (inc.getStartOffset() < startOffset || inc.getEndOffset() >= endOffset) continue;
            if (endOffset != Integer.MAX_VALUE) {
                this.localEndPoint = this.localReturnPoint = (this.returnPoint = inc.getEndOffset());
            }
            if ((incFile = inc.getIncludeFile()) == null || this.onlyInProject != null && incFile.getProject() != this.onlyInProject) continue;
            this.gatherFileMaps(visitedFiles, incFile, Short.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (endOffset == Integer.MAX_VALUE) {
            filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.NAMESPACE_ALIAS, CsmDeclaration.Kind.USING_DECLARATION, CsmDeclaration.Kind.USING_DIRECTIVE});
            this.gatherDeclarationsMaps(CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter), startOffset, endOffset, true);
        } else {
            this.gatherDeclarationsMaps(CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter), startOffset, endOffset, true);
        }
    }

    private void gatherDeclarationsMaps(Iterable declarations, int startOffset, int endOffset, boolean global) {
        this.gatherDeclarationsMaps(declarations.iterator(), startOffset, endOffset, global);
    }

    private void gatherDeclarationsMaps(Iterator it, int startOffset, int endOffset, boolean global) {
        while (it.hasNext()) {
            CsmOffsetable o = (CsmOffsetable)it.next();
            try {
                int start = o.getStartOffset();
                int end = o.getEndOffset();
                if (end < startOffset) continue;
                if (start >= endOffset) break;
                if (CsmKindUtilities.isScopeElement((CsmObject)o)) {
                    if (endOffset != Integer.MAX_VALUE) {
                        this.localEndPoint = global ? (this.localReturnPoint = (this.returnPoint = Math.max(this.returnPoint, start))) : (this.localReturnPoint = Math.max(this.returnPoint, start));
                    }
                    this.gatherScopeElementMaps((CsmScopeElement)o, end, endOffset, global);
                    if (endOffset == Integer.MAX_VALUE || !(o instanceof CsmExpressionStatement) || global) continue;
                    this.localEndPoint = Math.max(this.localEndPoint, end);
                    continue;
                }
                if (!FileImpl.reportErrors) continue;
                System.err.println("Expected CsmScopeElement, got " + o);
            }
            catch (NullPointerException ex) {
                if (!FileImpl.reportErrors) continue;
                System.err.println("Unexpected NULL element in declarations collection");
                DiagnosticExceptoins.register(ex);
            }
        }
    }

    private void gatherScopeElementMaps(CsmScopeElement element, int end, int endOffset, boolean global) {
        CsmDeclaration.Kind kind;
        CsmDeclaration.Kind kind2 = kind = CsmKindUtilities.isDeclaration((CsmObject)element) ? ((CsmDeclaration)element).getKind() : null;
        if (kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            CsmNamespaceDefinition nsd = (CsmNamespaceDefinition)element;
            CsmNamespace namespace = nsd.getNamespace();
            if (nsd.getName().length() == 0 && namespace != null) {
                if (global) {
                    this.globalDirectVisibleNamespaces.add(namespace);
                } else {
                    this.localDirectVisibleNamespaces.add(namespace);
                }
            }
            if (endOffset > CsmObjectAttributeQuery.getDefault().getLeftBracketOffset(nsd) && endOffset < end) {
                if (namespace != null) {
                    this.localDirectVisibleNamespaces.remove(namespace);
                    this.localDirectVisibleNamespaces.add(namespace);
                }
                this.gatherLocalNamespaceElementsFromMaps(nsd, Short.MIN_VALUE, endOffset, global);
                this.gatherDeclarationsMaps(nsd.getDeclarations(), Short.MIN_VALUE, endOffset, false);
            }
            if (global) {
                this.globalDirectVisibleNamespaceDefinitions.add(nsd);
            } else {
                this.localDirectVisibleNamespaceDefinitions.add(nsd);
            }
        } else if (kind == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            CsmNamespaceAlias alias = (CsmNamespaceAlias)element;
            if (global) {
                this.globalNamespaceAliases.add(alias);
            } else {
                this.localNamespaceAliases.add(alias);
            }
        } else if (kind == CsmDeclaration.Kind.USING_DECLARATION) {
            CsmUsingDeclaration udecl = (CsmUsingDeclaration)element;
            if (global) {
                this.globalUsingDeclarations.add(udecl);
            } else {
                this.localUsingDeclarations.add(udecl);
            }
        } else if (kind == CsmDeclaration.Kind.USING_DIRECTIVE) {
            CsmUsingDirective udir = (CsmUsingDirective)element;
            if (global) {
                this.globalUsingNamespaces.add(udir);
            } else {
                this.localUsingNamespaces.add(udir);
            }
        } else if (CsmKindUtilities.isDeclarationStatement((CsmObject)element)) {
            CsmDeclarationStatement ds = (CsmDeclarationStatement)element;
            if (ds.getStartOffset() < endOffset) {
                this.gatherDeclarationsMaps(((CsmDeclarationStatement)element).getDeclarators(), Short.MIN_VALUE, endOffset, false);
            }
        } else if (CsmKindUtilities.isScope((CsmObject)element) && endOffset < end) {
            this.gatherDeclarationsMaps(((CsmScope)element).getScopeElements(), Short.MIN_VALUE, endOffset, false);
        }
    }

    private void gatherLocalNamespaceElementsFromMaps(CsmNamespaceDefinition ns, int end, int endOffset, boolean global) {
        CharSequence nsName = ns.getQualifiedName();
        if (global) {
            for (CsmNamespaceDefinition nsd : this.globalDirectVisibleNamespaceDefinitions) {
                if (!nsd.getQualifiedName().equals(nsName)) continue;
                this.gatherDeclarationsMaps(nsd.getDeclarations(), Short.MIN_VALUE, Integer.MAX_VALUE, false);
            }
        } else {
            LinkedHashSet<CsmNamespaceDefinition> currentDVNDs = new LinkedHashSet<CsmNamespaceDefinition>(this.localDirectVisibleNamespaceDefinitions);
            for (CsmNamespaceDefinition nsd : currentDVNDs) {
                if (!nsd.getQualifiedName().equals(nsName)) continue;
                this.gatherDeclarationsMaps(nsd.getDeclarations(), Short.MIN_VALUE, Integer.MAX_VALUE, false);
            }
        }
    }
}

