/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmExpressionBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameterType;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariadicSpecializationParameter;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmCacheMap;
import org.netbeans.modules.cnd.api.model.services.CsmExpressionEvaluator;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.services.CsmResolveContext;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmTypes;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImplSpecialization;
import org.netbeans.modules.cnd.modelimpl.csm.ExpressionBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.Instantiation;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.VariadicSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.impl.services.ExpressionEvaluator;
import org.netbeans.modules.cnd.modelimpl.util.MapHierarchy;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.model.services.CsmExpressionEvaluatorProvider;
import org.netbeans.modules.cnd.utils.Antiloop;
import org.netbeans.modules.cnd.utils.CndCollectionUtils;
import org.openide.util.Pair;

public final class InstantiationProviderImpl
extends CsmInstantiationProvider {
    private static final Logger LOG = Logger.getLogger(InstantiationProviderImpl.class.getSimpleName());
    private static final char LT = '<';
    private static final char GT = '>';
    private static final ThreadLocal<Antiloop<CsmClassifier>> threadLocalSpecializeAntiloop = new ThreadLocal<Antiloop<CsmClassifier>>(){

        @Override
        protected Antiloop<CsmClassifier> initialValue() {
            return new Antiloop();
        }
    };
    private static final int PARAMETERS_LIMIT = 1000;
    private static final Callable<CsmCacheMap> BASE_TEMPLATE_INITIALIZER = new Callable<CsmCacheMap>(){

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap("BASE_TEMPLATE Cache", 1);
        }
    };
    private static final Callable<CsmCacheMap> SPECIALIZATIONS_INITIALIZER = new Callable<CsmCacheMap>(){

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap("SPECIALIZATIONS Cache", 1);
        }
    };
    private static final Callable<CsmCacheMap> SPECIALIZE_INITIALIZER = new Callable<CsmCacheMap>(){

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap("SPECIALIZE Cache", 1);
        }
    };

    public CsmType[] deduceTemplateType(CsmTemplateParameter templateParam, CsmType patternType, CsmType actualType, CsmInstantiationProvider.DeduceTemplateTypeStrategy strategy) {
        TypeDigger digger;
        if (patternType != null && actualType != null && (digger = TypeDigger.create(templateParam, patternType)) != null) {
            CsmType templateType = digger.getTemplateType();
            CsmType[] targetTypes = digger.extract(actualType, strategy);
            if (targetTypes != null) {
                CsmUtilities.TypeInfoCollector templateTypeInfo = new CsmUtilities.TypeInfoCollector();
                CsmUtilities.iterateTypeChain((CsmType)templateType, (CsmUtilities.Predicate)templateTypeInfo);
                List templateTypeQuals = templateTypeInfo.qualificators;
                ArrayList<CsmType> results = new ArrayList<CsmType>();
                for (CsmType targetType : targetTypes) {
                    CsmUtilities.TypeInfoCollector targetTypeInfo = new CsmUtilities.TypeInfoCollector();
                    CsmType targetUnderlyingType = CsmUtilities.iterateTypeChain((CsmType)targetType, (CsmUtilities.Predicate)targetTypeInfo);
                    List targetTypeQuals = targetTypeInfo.qualificators;
                    ListIterator templateQualIter = templateTypeQuals.listIterator(templateTypeQuals.size());
                    ListIterator targetQualIter = targetTypeQuals.listIterator(targetTypeQuals.size());
                    if (templateQualIter.hasPrevious()) {
                        boolean qualsError = false;
                        while (templateQualIter.hasPrevious()) {
                            CsmUtilities.Qualificator paramQual = (CsmUtilities.Qualificator)templateQualIter.previous();
                            CsmUtilities.Qualificator actualQual = null;
                            while (targetQualIter.hasPrevious() && !paramQual.equals(actualQual)) {
                                actualQual = (CsmUtilities.Qualificator)targetQualIter.previous();
                            }
                            if (paramQual.equals(actualQual)) {
                                targetQualIter.remove();
                                continue;
                            }
                            if (targetQualIter.hasPrevious() || CsmUtilities.Qualificator.REFERENCE.equals((Object)paramQual) || CsmUtilities.Qualificator.RVALUE_REFERENCE.equals((Object)paramQual)) continue;
                            if (strategy.canSkipError(CsmInstantiationProvider.DeduceTemplateTypeStrategy.Error.MatchQualsError)) {
                                qualsError = true;
                                break;
                            }
                            return null;
                        }
                        if (qualsError) {
                            results.add(targetType);
                            continue;
                        }
                        List remainingQualifiers = targetTypeQuals;
                        boolean newConst = remainingQualifiers.contains(CsmUtilities.Qualificator.CONST);
                        int newPtrDepth = InstantiationProviderImpl.howMany(remainingQualifiers, CsmUtilities.Qualificator.POINTER);
                        int newArrayDepth = InstantiationProviderImpl.howMany(remainingQualifiers, CsmUtilities.Qualificator.ARRAY);
                        int newReference = 0;
                        if (remainingQualifiers.contains(CsmUtilities.Qualificator.REFERENCE)) {
                            newReference = 1;
                        } else if (remainingQualifiers.contains(CsmUtilities.Qualificator.RVALUE_REFERENCE)) {
                            newReference = 2;
                        }
                        CsmTypes.TypeDescriptor td = new CsmTypes.TypeDescriptor(newConst, newReference, newPtrDepth, newArrayDepth);
                        results.add(CsmTypes.createType((CsmType)targetUnderlyingType, (CsmTypes.TypeDescriptor)td));
                        continue;
                    }
                    results.add(targetUnderlyingType);
                }
                return results.toArray(new CsmType[results.size()]);
            }
        }
        return null;
    }

    public CsmObject instantiate(CsmTemplate template, List<CsmSpecializationParameter> params) {
        return this.instantiate(template, params, true);
    }

    public CsmObject instantiate(CsmTemplate template, List<CsmSpecializationParameter> params, boolean specialize) {
        CsmResolveContext context = this.getLastResolveContext();
        CsmFile contextFile = context != null ? context.getFile() : null;
        int contextOffset = context != null ? context.getOffset() : 0;
        return this.instantiate(template, contextFile, contextOffset, params, specialize);
    }

    public CsmObject instantiate(CsmTemplate template, CsmType type) {
        return this.instantiate(template, type, true);
    }

    public CsmObject instantiate(CsmTemplate template, CsmType type, boolean specialize) {
        CsmResolveContext context = this.getLastResolveContext();
        CsmFile contextFile = context != null ? context.getFile() : null;
        int contextOffset = context != null ? context.getOffset() : 0;
        return this.instantiate(template, contextFile, contextOffset, type.getInstantiationParams(), specialize);
    }

    public CsmObject instantiate(CsmTemplate template, CsmFile contextFile, int contextOffset, List<CsmSpecializationParameter> params, boolean specialize) {
        long time = System.currentTimeMillis();
        CsmCacheMap cache = InstantiationProviderImpl.getTemplateRelatedCache((CsmObject)template, specialize);
        InstantiateListKey key = new InstantiateListKey(params);
        boolean[] found = new boolean[]{false};
        CsmObject result = (CsmObject)CsmCacheMap.getFromCache((CsmCacheMap)cache, (Object)key, (boolean[])found);
        boolean cached = true;
        if (result == null || found[0]) {
            cached = false;
            time = System.currentTimeMillis();
            LOG.log(Level.FINEST, "instantiate 1 {0}spec:{1};params={2}\n", new Object[]{template.getDisplayName(), specialize, params});
            result = template;
            if (CsmKindUtilities.isClass((CsmObject)template) || CsmKindUtilities.isFunction((CsmObject)template) || CsmKindUtilities.isTypeAlias((CsmObject)template)) {
                CsmClassifier specialization;
                if (contextFile == null) {
                    contextFile = ((CsmOffsetable)template).getContainingFile();
                    contextOffset = ((CsmOffsetable)template).getStartOffset();
                }
                if (InstantiationProviderImpl.hasVariadicParams(params)) {
                    params = InstantiationProviderImpl.expandVariadicParams(params);
                }
                List templateParams = template.getTemplateParameters();
                HashMap<CsmTemplateParameter, CsmSpecializationParameter> mapping = new HashMap<CsmTemplateParameter, CsmSpecializationParameter>();
                Iterator<CsmSpecializationParameter> paramsIter = params.iterator();
                int i = 0;
                for (CsmTemplateParameter templateParam : templateParams) {
                    if (templateParam.isVarArgs() && i == templateParams.size() - 1) {
                        ArrayList<CsmSpecializationParameter> args = new ArrayList<CsmSpecializationParameter>();
                        while (paramsIter.hasNext()) {
                            args.add(paramsIter.next());
                        }
                        mapping.put(templateParam, (CsmSpecializationParameter)this.createVariadicSpecializationParameter(args, ((CsmOffsetableDeclaration)template).getContainingFile(), 0, 0));
                    } else if (paramsIter.hasNext()) {
                        mapping.put(templateParam, paramsIter.next());
                    } else {
                        CsmSpecializationParameter defaultValue = this.getTemplateParameterDefultValue(template, templateParam, i);
                        if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)defaultValue)) {
                            CsmType defaultType = ((CsmTypeBasedSpecializationParameter)defaultValue).getType();
                            if ((defaultType = TemplateUtils.checkTemplateType(defaultType, (CsmObject)template)) != null) {
                                CsmScope paramScope = null;
                                if (CsmKindUtilities.isScope((CsmObject)template)) {
                                    paramScope = (CsmScope)template;
                                } else if (CsmKindUtilities.isScopeElement((CsmObject)template)) {
                                    paramScope = ((CsmScopeElement)template).getScope();
                                }
                                mapping.put(templateParam, (CsmSpecializationParameter)new TypeBasedSpecializationParameterImpl(defaultType, paramScope));
                            }
                        } else if (CsmKindUtilities.isExpressionBasedSpecalizationParameter((CsmObject)defaultValue)) {
                            mapping.put(templateParam, defaultValue);
                        }
                    }
                    ++i;
                }
                result = Instantiation.create(template, mapping);
                if (specialize && CsmKindUtilities.isClassifier((CsmObject)result) && CsmKindUtilities.isTemplate((CsmObject)(specialization = this.specialize((CsmClassifier)result, contextFile, contextOffset)))) {
                    result = (CsmTemplate)specialization;
                }
            }
            time = System.currentTimeMillis() - time;
            if (cache != null) {
                cache.put((Object)key, CsmCacheMap.toValue((Object)result, (long)time));
            }
        } else {
            time = System.currentTimeMillis() - time;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Instantiate 1 took {0}ms ({1})\n", new Object[]{time, cached ? "CACHE HIT" : "calculated"});
        }
        return result;
    }

    public CsmObject instantiate(CsmTemplate template, CsmInstantiation instantiation) {
        return this.instantiate(template, instantiation, true);
    }

    public CsmObject instantiate(CsmTemplate template, CsmInstantiation instantiation, boolean specialize) {
        CsmResolveContext context = this.getLastResolveContext();
        CsmFile contextFile = context != null ? context.getFile() : null;
        int contextOffset = context != null ? context.getOffset() : 0;
        return this.instantiate(template, contextFile, contextOffset, instantiation.getMapping(), specialize);
    }

    public CsmObject instantiate(CsmTemplate template, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping, boolean specialize) {
        CsmResolveContext context = this.getLastResolveContext();
        CsmFile contextFile = context != null ? context.getFile() : null;
        int contextOffset = context != null ? context.getOffset() : 0;
        return this.instantiate(template, contextFile, contextOffset, mapping, specialize);
    }

    public CsmObject instantiate(CsmTemplate template, CsmFile contextFile, int contextOffset, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping, boolean specialize) {
        long time = System.currentTimeMillis();
        CsmCacheMap cache = InstantiationProviderImpl.getTemplateRelatedCache((CsmObject)template, specialize);
        InstantiateMapKey key = new InstantiateMapKey(mapping);
        boolean[] found = new boolean[]{false};
        CsmObject result = (CsmObject)CsmCacheMap.getFromCache((CsmCacheMap)cache, (Object)key, (boolean[])found);
        boolean cached = true;
        if (result == null || found[0]) {
            cached = false;
            LOG.log(Level.FINEST, "instantiate 2 {0}; spec:{1};mapping={2}\n", new Object[]{template.getDisplayName(), specialize, mapping});
            result = template;
            time = System.currentTimeMillis();
            if (CsmKindUtilities.isClass((CsmObject)template) || CsmKindUtilities.isFunctional((CsmObject)template) || CsmKindUtilities.isTypeAlias((CsmObject)template)) {
                CsmClassifier specialization;
                if (contextFile == null) {
                    contextFile = ((CsmOffsetable)template).getContainingFile();
                    contextOffset = ((CsmOffsetable)template).getStartOffset();
                }
                result = Instantiation.create(template, mapping);
                if (specialize && CsmKindUtilities.isClassifier((CsmObject)result) && CsmKindUtilities.isTemplate((CsmObject)(specialization = this.specialize((CsmClassifier)result, contextFile, contextOffset)))) {
                    result = (CsmTemplate)specialization;
                }
            }
            time = System.currentTimeMillis() - time;
            if (cache != null) {
                cache.put((Object)key, CsmCacheMap.toValue((Object)result, (long)time));
            }
        } else {
            time = System.currentTimeMillis() - time;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Instantiate 2 took {0}ms ({1})\n", new Object[]{time, cached ? "CACHE HIT" : "calculated"});
        }
        return result;
    }

    public CsmType instantiate(CsmTemplateParameter templateParam, List<CsmInstantiation> instantiations) {
        CsmSpecializationParameter resolvedParam = Instantiation.resolveTemplateParameter(templateParam, TemplateUtils.gatherMapping(instantiations));
        if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)resolvedParam)) {
            CsmType resolvedType = InstantiationProviderImpl.createTypeInstantiationForTypeParameter((CsmTypeBasedSpecializationParameter)resolvedParam, instantiations.iterator(), 0);
            return resolvedType != null ? resolvedType : (CsmTypeBasedSpecializationParameter)resolvedParam;
        }
        return null;
    }

    public boolean isInstantiatedType(CsmType type) {
        return Instantiation.isInstantiatedType(type);
    }

    public CsmInstantiation getInstantiatedTypeInstantiation(CsmType type) {
        return Instantiation.getInstantiatedTypeInstantiation(type);
    }

    public List<CsmInstantiation> getInstantiatedTypeInstantiations(CsmType type) {
        return Instantiation.getInstantiatedTypeInstantiations(type);
    }

    public boolean isViableInstantiation(CsmInstantiation instantiation, boolean acceptTemplateParams) {
        List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> params = InstantiationProviderImpl.getInstantiationParams((CsmObject)instantiation);
        InstantiationParametersInfoImpl paramsInfo = new InstantiationParametersInfoImpl((CsmObject)instantiation, params);
        return this.isViableInstantiation(paramsInfo, acceptTemplateParams);
    }

    private boolean isViableInstantiation(InstantiationParametersInfo paramsInfo, boolean acceptTemplateParams) {
        for (CsmType paramType : paramsInfo.getParamsTypes()) {
            CsmClassifier paramCls;
            if (paramType == null) continue;
            if (acceptTemplateParams) {
                CsmClassifier paramCls2;
                CsmClassifier csmClassifier = paramCls2 = (paramType = CsmUtilities.iterateTypeChain((CsmType)paramType, (CsmUtilities.Predicate)new UnfoldWhileNestedPredicate())) != null ? paramType.getClassifier() : null;
                if (paramCls2 != null && !CsmBaseUtilities.isUnresolved((Object)paramCls2)) continue;
                return false;
            }
            CsmType lastType = CsmUtilities.iterateTypeChain((CsmType)paramType, (CsmUtilities.Predicate)new CsmUtilities.ConstantPredicate(false));
            if (CsmKindUtilities.isTemplateParameterType((CsmObject)lastType)) {
                return false;
            }
            if (lastType == null || (paramCls = paramType.getClassifier()) != null && !CsmBaseUtilities.isUnresolved((Object)paramCls)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getInstantiatedText(CsmType type) {
        CharSequence charSequence;
        block3: {
            long time = System.currentTimeMillis();
            try {
                charSequence = Instantiation.getInstantiatedText(type);
                if (!LOG.isLoggable(Level.FINE)) break block3;
            }
            catch (Throwable throwable) {
                if (LOG.isLoggable(Level.FINE)) {
                    time = System.currentTimeMillis() - time;
                    LOG.log(Level.FINE, "getInstantiatedText took {0}ms\n", new Object[]{time});
                }
                throw throwable;
            }
            time = System.currentTimeMillis() - time;
            LOG.log(Level.FINE, "getInstantiatedText took {0}ms\n", new Object[]{time});
        }
        return charSequence;
    }

    public CharSequence getTemplateSignature(CsmTemplate template) {
        long time = System.currentTimeMillis();
        LOG.log(Level.FINEST, "getTemplateSignature {0}\n", new Object[]{template});
        StringBuilder sb = new StringBuilder();
        if (CsmKindUtilities.isQualified((CsmObject)template)) {
            sb.append(((CsmQualifiedNamedElement)template).getQualifiedName());
        } else if (CsmKindUtilities.isNamedElement((CsmObject)template)) {
            sb.append(((CsmNamedElement)template).getName());
        } else {
            System.err.println("uknown template object " + template);
        }
        InstantiationProviderImpl.appendTemplateParamsSignature(template.getTemplateParameters(), sb);
        if (LOG.isLoggable(Level.FINE)) {
            time = System.currentTimeMillis() - time;
            LOG.log(Level.FINE, "getTemplateSignature took {0}ms\n", new Object[]{time});
        }
        return sb;
    }

    public Collection<CsmOffsetableDeclaration> getSpecializations(CsmDeclaration templateDecl, CsmFile contextFile, int contextOffset) {
        long time = System.currentTimeMillis();
        CsmCacheMap cache = (CsmCacheMap)CsmCacheManager.getClientCache(TemplateSpecializationsKey.class, SPECIALIZATIONS_INITIALIZER);
        TemplateSpecializationsKey key = new TemplateSpecializationsKey(templateDecl, contextFile, contextOffset);
        List<Object> specs = (List<CsmOffsetableDeclaration>)CsmCacheMap.getFromCache((CsmCacheMap)cache, (Object)key, null);
        boolean cached = true;
        if (specs == null) {
            CsmClass cls;
            cached = false;
            LOG.log(Level.FINEST, "getSpecializations {0}\n", new Object[]{templateDecl});
            time = System.currentTimeMillis();
            specs = Collections.emptyList();
            if (CsmKindUtilities.isTemplate((CsmObject)templateDecl)) {
                CsmProject proj;
                if (contextFile == null && CsmKindUtilities.isOffsetable((Object)templateDecl)) {
                    contextFile = ((CsmOffsetable)templateDecl).getContainingFile();
                }
                CsmProject csmProject = proj = contextFile != null ? contextFile.getProject() : null;
                if (proj instanceof ProjectBase) {
                    StringBuilder fqn = new StringBuilder(templateDecl.getUniqueName());
                    fqn.append('<');
                    specs = new ArrayList<CsmOffsetableDeclaration>(((ProjectBase)proj).findDeclarationsByPrefix(fqn.toString()));
                }
            } else if (CsmKindUtilities.isMethod((CsmObject)templateDecl) && CsmKindUtilities.isTemplate((CsmObject)(cls = CsmBaseUtilities.getFunctionClass((CsmFunction)((CsmFunction)templateDecl))))) {
                specs = new ArrayList<CsmOffsetableDeclaration>();
                CharSequence funName = templateDecl.getName();
                Collection<CsmOffsetableDeclaration> specializations = this.getSpecializations((CsmDeclaration)cls, contextFile, contextOffset);
                for (CsmOffsetableDeclaration specialization : specializations) {
                    CsmTemplate spec = (CsmTemplate)specialization;
                    Iterator classMembers = CsmSelect.getClassMembers((CsmClass)((CsmClass)spec), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(funName, true, true, false));
                    while (classMembers.hasNext()) {
                        CsmFunctionDefinition definition;
                        CsmMember next = (CsmMember)classMembers.next();
                        if (!CsmKindUtilities.isFunctionDeclaration((CsmObject)next) || (definition = ((CsmFunction)next).getDefinition()) == null || definition.equals(next)) continue;
                        specs.add((CsmOffsetableDeclaration)definition);
                    }
                }
            }
            time = System.currentTimeMillis() - time;
            if (cache != null) {
                cache.put((Object)key, CsmCacheMap.toValue(specs, (long)time));
            }
        } else {
            specs = specs.isEmpty() ? Collections.emptyList() : new ArrayList(specs);
            time = System.currentTimeMillis() - time;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getSpecializations took {0}ms ({1})\n", new Object[]{time, cached ? "CACHE HIT" : "calculated"});
        }
        return specs;
    }

    public Collection<CsmOffsetableDeclaration> getBaseTemplate(CsmDeclaration declaration) {
        long time = System.currentTimeMillis();
        CsmCacheMap cache = (CsmCacheMap)CsmCacheManager.getClientCache(BaseTemplateKey.class, BASE_TEMPLATE_INITIALIZER);
        BaseTemplateKey key = new BaseTemplateKey(declaration);
        List<Object> result = (List<CsmOffsetableDeclaration>)CsmCacheMap.getFromCache((CsmCacheMap)cache, (Object)key, null);
        boolean cached = true;
        if (result == null) {
            cached = false;
            LOG.log(Level.FINEST, "getBaseTemplate {0}\n", new Object[]{declaration});
            time = System.currentTimeMillis();
            result = Collections.emptyList();
            if (CsmKindUtilities.isSpecialization((CsmObject)declaration) && CsmKindUtilities.isOffsetable((Object)declaration) && CsmKindUtilities.isQualified((CsmObject)declaration)) {
                CharSequence qualifiedName = declaration.getQualifiedName();
                String removedSpecialization = qualifiedName.toString().replaceAll("<.*>", "");
                CsmFile contextFile = ((CsmOffsetable)declaration).getContainingFile();
                CsmProject proj = contextFile != null ? contextFile.getProject() : null;
                Iterator<Object> decls = Collections.emptyList().iterator();
                if (CsmKindUtilities.isClass((CsmObject)declaration)) {
                    if (proj instanceof ProjectBase) {
                        decls = ((ProjectBase)proj).findClassifiers(removedSpecialization).iterator();
                    }
                } else if (proj != null && CsmKindUtilities.isFunction((CsmObject)declaration)) {
                    String removedParams = removedSpecialization.replaceAll("\\(.*", "");
                    decls = CsmSelect.getFunctions((CsmProject)proj, (CharSequence)removedParams);
                }
                result = new ArrayList<CsmOffsetableDeclaration>();
                while (decls.hasNext()) {
                    CsmObject decl = (CsmObject)decls.next();
                    if (CsmKindUtilities.isSpecialization((CsmObject)decl)) continue;
                    result.add((CsmOffsetableDeclaration)decl);
                }
            }
            time = System.currentTimeMillis() - time;
            if (cache != null) {
                cache.put((Object)key, CsmCacheMap.toValue(result, (long)time));
            }
        } else {
            result = result.isEmpty() ? Collections.emptyList() : new ArrayList(result);
            time = System.currentTimeMillis() - time;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "getBaseTemplate took {0}ms ({1})\n", new Object[]{time, cached ? "CACHE HIT" : "calculated"});
        }
        return result;
    }

    public static void appendParametersSignature(Collection<CsmParameter> params, StringBuilder sb) {
        sb.append('(');
        Iterator<CsmParameter> iter = params.iterator();
        for (int limit = 0; iter.hasNext() && limit < 1000; ++limit) {
            CsmParameter param = iter.next();
            CsmType type = param.getType();
            if (type == null) continue;
            sb.append(type.getCanonicalText());
            if (!iter.hasNext()) continue;
            sb.append(',');
        }
        sb.append(')');
    }

    public static void appendTemplateParamsSignature(List<CsmTemplateParameter> params, StringBuilder sb) {
        if (params != null && params.size() > 0) {
            sb.append('<');
            int limit = 0;
            Iterator<CsmTemplateParameter> iter = params.iterator();
            while (iter.hasNext() && limit < 1000) {
                CsmVariable var;
                CsmType type;
                ++limit;
                CsmTemplateParameter param = iter.next();
                if (CsmKindUtilities.isVariableDeclaration((CsmObject)param) && (type = (var = (CsmVariable)param).getType()) != null) {
                    sb.append(type.getCanonicalText());
                    if (iter.hasNext()) {
                        sb.append(',');
                    }
                }
                if (!CsmKindUtilities.isClassifier((CsmObject)param)) continue;
                CsmClassifier classifier = (CsmClassifier)param;
                sb.append("class");
                if (CsmKindUtilities.isTemplate((CsmObject)param)) {
                    InstantiationProviderImpl.appendTemplateParamsSignature(((CsmTemplate)classifier).getTemplateParameters(), sb);
                }
                if (!iter.hasNext()) continue;
                sb.append(',');
            }
            TemplateUtils.addGREATERTHAN(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmClassifier specialize(CsmClassifier classifier, CsmFile contextFile, int contextOffset) {
        long time = System.currentTimeMillis();
        Object specialization = null;
        if (threadLocalSpecializeAntiloop.get().enter((Object)classifier)) {
            try {
                List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> params = InstantiationProviderImpl.getInstantiationParams((CsmObject)classifier);
                InstantiationParametersInfoImpl paramsInfo = new InstantiationParametersInfoImpl((CsmObject)classifier, params);
                CsmCacheMap cache = InstantiationProviderImpl.getSpecializeCache();
                SpecializeRequest request = new SpecializeRequest(classifier, paramsInfo);
                CsmClassifier result = (CsmClassifier)CsmCacheMap.getFromCache((CsmCacheMap)cache, (Object)request, null);
                if (result == null) {
                    if (CsmKindUtilities.isTemplate((CsmObject)classifier) && !CsmKindUtilities.isSpecialization((CsmObject)classifier)) {
                        CsmClass cls;
                        List templateParams = ((CsmTemplate)classifier).getTemplateParameters();
                        List<ProjectBase> projects = null;
                        List<CsmOffsetableDeclaration> visibleSpecs = null;
                        if (params.size() == templateParams.size() && CsmKindUtilities.isClass((CsmObject)classifier) && !(projects = this.collectProjects(contextFile)).isEmpty()) {
                            cls = (CsmClass)classifier;
                            List<CsmSpecializationParameter> plainParams = InstantiationProviderImpl.getPlainParams(params);
                            if (this.checkAllowFastSearchFullSpecializations(plainParams)) {
                                StringBuilder fqn = new StringBuilder(cls.getUniqueName());
                                fqn.append(Instantiation.getInstantiationCanonicalText(plainParams));
                                for (CsmProject csmProject : projects) {
                                    CsmDeclaration decl = csmProject.findDeclaration((CharSequence)fqn.toString());
                                    if (!(decl instanceof ClassImplSpecialization) || !CsmIncludeResolver.getDefault().isObjectVisible(contextFile, (CsmObject)decl)) continue;
                                    specialization = (CsmClassifier)decl;
                                    break;
                                }
                            }
                            if (specialization == null) {
                                visibleSpecs = this.collectVisibleSpecializations(cls, projects, contextFile);
                                specialization = this.findBestSpecialization(visibleSpecs, paramsInfo, (CsmClassifier)cls);
                            }
                        }
                        if (specialization == null && this.isClassForward(classifier)) {
                            cls = (CsmClass)classifier;
                            if (projects == null) {
                                projects = this.collectProjects(contextFile);
                            }
                            if (visibleSpecs == null) {
                                visibleSpecs = this.collectVisibleSpecializations(cls, projects, contextFile);
                            }
                            for (CsmOffsetableDeclaration decl : visibleSpecs) {
                                if (!(decl instanceof ClassImplSpecialization)) continue;
                                ClassImplSpecialization spec = (ClassImplSpecialization)decl;
                                specialization = spec;
                                break;
                            }
                        }
                    }
                    if (specialization instanceof ClassImplSpecialization && !classifier.equals(specialization) && CsmKindUtilities.isTemplate((CsmObject)specialization) && CsmKindUtilities.isInstantiation((CsmObject)classifier)) {
                        List specTemplateParams = ((CsmTemplate)specialization).getTemplateParameters();
                        MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapping = TemplateUtils.gatherMapping((CsmInstantiation)classifier);
                        HashMap<CsmTemplateParameter, CsmSpecializationParameter> newMapping = new HashMap<CsmTemplateParameter, CsmSpecializationParameter>();
                        for (CsmTemplateParameter specTemplateParam : specTemplateParams) {
                            CsmSpecializationParameter deducedParam = this.deduceSpecializationParam(specTemplateParam, (ClassImplSpecialization)specialization, paramsInfo);
                            if (deducedParam == null) continue;
                            newMapping.put(specTemplateParam, deducedParam);
                        }
                        mapping.pop();
                        mapping.push(newMapping);
                        CsmClassifier obj = specialization;
                        List<Map<CsmTemplateParameter, CsmSpecializationParameter>> maps = mapping.getMaps(new MapHierarchy.NonEmptyFilter());
                        for (int i = maps.size() - 1; i >= 0; --i) {
                            obj = this.instantiate((CsmTemplate)obj, contextFile, contextOffset, maps.get(i), false);
                        }
                        if (CsmKindUtilities.isClassifier((CsmObject)obj)) {
                            specialization = obj;
                        }
                    }
                    time = System.currentTimeMillis() - time;
                    if (cache != null) {
                        cache.put((Object)request, CsmCacheMap.toValue((Object)(specialization != null ? specialization : classifier), (long)time));
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "CLASSIFIER\n{0}\nSPECIALIZED as {1}", new Object[]{classifier, specialization});
                    }
                } else {
                    time = System.currentTimeMillis() - time;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "specialize took {0}ms ({1})\n", new Object[]{time, result != null ? "CACHE HIT" : "calculated"});
                }
            }
            finally {
                threadLocalSpecializeAntiloop.get().exit((Object)classifier);
            }
        }
        return specialization != null ? specialization : classifier;
    }

    private boolean checkAllowFastSearchFullSpecializations(List<CsmSpecializationParameter> params) {
        for (CsmSpecializationParameter param : params) {
            CsmTypeBasedSpecializationParameter typeBasedParam;
            if (!CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param) || !CsmKindUtilities.isTemplateParameterType((CsmObject)(typeBasedParam = (CsmTypeBasedSpecializationParameter)param).getType())) continue;
            return false;
        }
        return true;
    }

    private CsmSpecializationParameter deduceSpecializationParam(CsmTemplateParameter specTemplateParam, ClassImplSpecialization specialization, InstantiationParametersInfo paramsInfo) {
        ListIterator<CsmSpecializationParameter> specParamIter = specialization.getSpecializationParameters().listIterator();
        ListIterator<CsmSpecializationParameter> instParamIter = paramsInfo.getInstParams().listIterator();
        ListIterator<CsmType> instParamTypeIter = paramsInfo.getParamsTypes().listIterator();
        ListIterator<String> instParamTextIter = paramsInfo.getParamsTexts().listIterator();
        while (specParamIter.hasNext() && instParamIter.hasNext() && instParamTypeIter.hasNext() && instParamTextIter.hasNext()) {
            CsmType specParamType;
            CsmSpecializationParameter specParam = specParamIter.next();
            CsmSpecializationParameter instParam = instParamIter.next();
            CsmType instType = instParamTypeIter.next();
            String instParamText = instParamTextIter.next();
            if (specTemplateParam.isTypeBased() && CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)specParam) && instType != null) {
                specParamType = ((CsmTypeBasedSpecializationParameter)specParam).getType();
                ArrayList<CsmType> results = new ArrayList<CsmType>(2);
                CsmInstantiationProvider.DefaultDeduceTemplateTypeStrategy calcStrategy = new CsmInstantiationProvider.DefaultDeduceTemplateTypeStrategy(new CsmInstantiationProvider.DeduceTemplateTypeStrategy.Error[]{CsmInstantiationProvider.DeduceTemplateTypeStrategy.Error.MatchQualsError});
                CsmType[] deduced = this.deduceTemplateType(specTemplateParam, specParamType, instType, (CsmInstantiationProvider.DeduceTemplateTypeStrategy)calcStrategy);
                if (deduced != null && deduced.length > 0) {
                    results.addAll(Arrays.asList(deduced));
                    if (specTemplateParam.isVarArgs() && instParamIter.hasNext() && CsmBaseUtilities.isValid((CsmObject)specParamType.getClassifier()) && CharSequenceUtilities.textEquals((CharSequence)specTemplateParam.getQualifiedName(), (CharSequence)specParamType.getClassifier().getQualifiedName())) {
                        while (instParamIter.hasNext() && instParamTypeIter.hasNext() && instParamTextIter.hasNext()) {
                            instParam = instParamIter.next();
                            instType = instParamTypeIter.next();
                            instParamText = instParamTextIter.next();
                            if (!CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)instParam) || instType == null) break;
                            deduced = this.deduceTemplateType(specTemplateParam, specParamType, instType, (CsmInstantiationProvider.DeduceTemplateTypeStrategy)calcStrategy);
                            if (deduced == null || deduced.length <= 0) continue;
                            results.addAll(Arrays.asList(deduced));
                        }
                    }
                }
                if (results.size() <= 0) continue;
                if (!specTemplateParam.isVarArgs()) {
                    CsmType unfolded = Instantiation.unfoldInstantiatedType((CsmType)results.get(0));
                    return this.createTypeBasedSpecializationParameter(unfolded, specParam.getScope());
                }
                ArrayList<CsmSpecializationParameter> varArgs = new ArrayList<CsmSpecializationParameter>();
                for (CsmType result : results) {
                    CsmType unfolded = Instantiation.unfoldInstantiatedType(result);
                    varArgs.add((CsmSpecializationParameter)this.createTypeBasedSpecializationParameter(unfolded, specParam.getScope()));
                }
                return this.createVariadicSpecializationParameter(varArgs, specParam.getContainingFile(), 0, 0);
            }
            if (!specTemplateParam.isTypeBased() && CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)specParam)) {
                String specParamText;
                specParamType = ((CsmTypeBasedSpecializationParameter)specParam).getType();
                String string = specParamText = specParamType != null ? specParamType.getCanonicalText().toString() : null;
                if (!specTemplateParam.getName().toString().equals(specParamText)) continue;
                return this.createExpressionBasedSpecializationParameter(instParamText, specParam.getScope(), instParam.getContainingFile(), instParam.getStartOffset(), instParam.getEndOffset());
            }
            if (specTemplateParam.isTypeBased() || !CsmKindUtilities.isExpressionBasedSpecalizationParameter((CsmObject)specParam)) continue;
            String specParamText = specParam.getText().toString();
            if (!specTemplateParam.getName().toString().equals(specParamText)) continue;
            return this.createExpressionBasedSpecializationParameter(instParamText, specParam.getScope(), instParam.getContainingFile(), instParam.getStartOffset(), instParam.getEndOffset());
        }
        if (specTemplateParam.isVarArgs()) {
            return this.createVariadicSpecializationParameter(Collections.emptyList(), specTemplateParam.getContainingFile(), 0, 0);
        }
        if (specTemplateParam.getDefaultValue() != null) {
            return specTemplateParam.getDefaultValue();
        }
        return null;
    }

    private List<ProjectBase> collectProjects(CsmFile contextFile) {
        ArrayList<ProjectBase> projects = new ArrayList<ProjectBase>(4);
        CsmProject project = contextFile.getProject();
        if (project instanceof ProjectBase) {
            projects.add((ProjectBase)project);
        }
        if (project != null && !project.isArtificial()) {
            for (CsmProject libProject : project.getLibraries()) {
                if (!(libProject instanceof ProjectBase)) continue;
                projects.add((ProjectBase)libProject);
            }
        }
        return projects;
    }

    private List<CsmOffsetableDeclaration> collectVisibleSpecializations(CsmClass cls, List<ProjectBase> projects, CsmFile contextFile) {
        ArrayList<CsmOffsetableDeclaration> specs = new ArrayList<CsmOffsetableDeclaration>();
        for (ProjectBase proj : projects) {
            StringBuilder fqn = new StringBuilder();
            fqn.append(Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.CLASS));
            fqn.append(':');
            fqn.append(cls.getQualifiedName());
            fqn.append('<');
            specs.addAll(proj.findDeclarationsByPrefix(fqn.toString()));
            fqn.setLength(0);
            fqn.append(Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.STRUCT));
            fqn.append(':');
            fqn.append(cls.getQualifiedName());
            fqn.append('<');
            specs.addAll(proj.findDeclarationsByPrefix(fqn.toString()));
        }
        ArrayList<CsmOffsetableDeclaration> visibleSpecs = new ArrayList<CsmOffsetableDeclaration>();
        for (CsmOffsetableDeclaration spec : specs) {
            if (!CsmIncludeResolver.getDefault().isObjectVisible(contextFile, (CsmObject)spec)) continue;
            visibleSpecs.add(spec);
        }
        return visibleSpecs;
    }

    private CsmClassifier findBestSpecialization(Collection<CsmOffsetableDeclaration> specializations, InstantiationParametersInfo paramsInfo, CsmClassifier cls) {
        CsmClassifier bestSpecialization = null;
        boolean variadic = paramsInfo.isVariadic();
        if (!specializations.isEmpty()) {
            boolean templateBasedInstantiation = CsmKindUtilities.isInstantiation((CsmObject)cls) && Instantiation.isTemplateBasedInstantiation((CsmInstantiation)cls);
            int bestMatch = 0;
            int paramsSize = 0;
            for (Pair<CsmSpecializationParameter, List<CsmInstantiation>> pair : paramsInfo.getExpandedParams()) {
                CsmSpecializationParameter param = (CsmSpecializationParameter)pair.first();
                if (CsmKindUtilities.isVariadicSpecalizationParameter((CsmObject)param)) {
                    paramsSize += ((CsmVariadicSpecializationParameter)param).getArgs().size();
                    continue;
                }
                ++paramsSize;
            }
            List<CsmSpecializationParameter> instParams = paramsInfo.getInstParams();
            List<String> paramsText = paramsInfo.getParamsTexts();
            List<CsmType> paramsType = paramsInfo.getParamsTypes();
            for (CsmOffsetableDeclaration decl : specializations) {
                if (!(decl instanceof ClassImplSpecialization)) continue;
                ClassImplSpecialization specialization = (ClassImplSpecialization)decl;
                List<CsmSpecializationParameter> specParams = specialization.getSpecializationParameters();
                int match = 0;
                if (variadic) {
                    if (InstantiationProviderImpl.hasVariadicParams(specialization)) {
                        if (specParams.size() - 1 <= paramsSize) {
                            match += specParams.size() - 1;
                        }
                    } else if (specParams.size() == paramsSize) {
                        match += specParams.size() + 1;
                    }
                }
                if (specParams.size() == paramsSize) {
                    int i;
                    for (i = 0; i < paramsSize - 1; ++i) {
                        CsmSpecializationParameter specParam1 = specParams.get(i);
                        CsmSpecializationParameter param1 = instParams.get(i);
                        int j = i + 1;
                        CsmSpecializationParameter specParam2 = specParams.get(j);
                        CsmSpecializationParameter param2 = instParams.get(j);
                        if (specParam1.getText().toString().equals(specParam2.getText().toString()) && param1.getText().toString().equals(param2.getText().toString())) {
                            ++match;
                        }
                        if (!TraceFlags.EXPRESSION_EVALUATOR_EXTRA_SPEC_PARAMS_MATCHING || !specParam1.getText().toString().equals(specParam2.getText().toString()) || !CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param1) || !CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param2)) continue;
                        CsmType type1 = paramsType.get(i);
                        CsmType type2 = paramsType.get(j);
                        if (!CsmUtilities.checkTypesEqual((CsmType)type1, (CsmFile)param1.getContainingFile(), (CsmType)type2, (CsmFile)param2.getContainingFile(), (CsmUtilities.QualifiersEqualizer)new CsmUtilities.AlwaysEqualQualsEqualizer(), (!templateBasedInstantiation ? 1 : 0) != 0)) continue;
                        ++match;
                    }
                    for (i = 0; i < paramsSize; ++i) {
                        CsmSpecializationParameter specParam = specParams.get(i);
                        CsmSpecializationParameter param = instParams.get(i);
                        if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)specParam) && CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param)) {
                            int checkReference;
                            CsmFunctionPointerType declSpecFunType;
                            CsmType instSpecParam = paramsType.get(i);
                            CsmTypeBasedSpecializationParameter declSpecParam = (CsmTypeBasedSpecializationParameter)specParam;
                            CsmClassifier declCls = declSpecParam.getClassifier();
                            if (declCls != null && !CsmKindUtilities.isTemplateParameter((CsmObject)declCls)) {
                                String declClsQualifiedName = declCls.getQualifiedName().toString();
                                if (declClsQualifiedName.equals(paramsText.get(i))) {
                                    match += 2;
                                } else if (declCls.isValid()) {
                                    String nestedQualifiedName;
                                    Set<String> nestedQualifiedNames = InstantiationProviderImpl.getNestedTypeNames(instSpecParam, !templateBasedInstantiation);
                                    int matchValue = 0;
                                    Iterator<String> i$ = nestedQualifiedNames.iterator();
                                    while (i$.hasNext() && (matchValue = InstantiationProviderImpl.getQualifiedNamesMatchValue(nestedQualifiedName = i$.next(), declClsQualifiedName)) <= 0) {
                                    }
                                    if (matchValue > 0) {
                                        match += matchValue;
                                    }
                                }
                            }
                            if (CsmKindUtilities.isFunctionPointerType((CsmObject)(declSpecFunType = CsmBaseUtilities.tryGetFunctionPointerType((CsmType)declSpecParam.getType())))) {
                                CsmFunctionPointerType paramFunType = CsmBaseUtilities.tryGetFunctionPointerType((CsmType)paramsType.get(i));
                                if (CsmKindUtilities.isFunctionPointerType((CsmObject)paramFunType)) {
                                    ++match;
                                    if (declSpecFunType.getParameters().size() == paramFunType.getParameters().size()) {
                                        ++match;
                                    }
                                    if (((CsmType)declSpecFunType).getPointerDepth() == ((CsmType)paramFunType).getPointerDepth()) {
                                        ++match;
                                    }
                                }
                            } else if (CsmBaseUtilities.isPointer((CsmType)declSpecParam.getType()) && CsmBaseUtilities.isPointer((CsmType)paramsType.get(i))) {
                                ++match;
                            }
                            if (!declSpecParam.isReference() || (checkReference = CsmBaseUtilities.isReference((CsmType)paramsType.get(i))) <= 0) continue;
                            ++match;
                            if (checkReference == 2 != declSpecParam.isRValueReference()) continue;
                            ++match;
                            continue;
                        }
                        if (InstantiationProviderImpl.isExpressionParameter(cls, specParam, i)) {
                            match += this.evaluateExpression(cls, (ClassImplSpecialization)decl, specParam, i, paramsInfo);
                            continue;
                        }
                        match = 0;
                        break;
                    }
                }
                if (match <= bestMatch) continue;
                bestMatch = match;
                bestSpecialization = (CsmClassifier)decl;
            }
        }
        return bestSpecialization;
    }

    private static Set<String> getNestedTypeNames(CsmType instSpecParam, final boolean resolveTypeChain) {
        final HashSet<String> nestedQualifiedNames = new HashSet<String>();
        CsmUtilities.iterateTypeChain((CsmType)instSpecParam, (CsmUtilities.Predicate)new CsmUtilities.Predicate<CsmType>(){

            public boolean check(CsmType value) {
                CsmClassifier classifier = value.getClassifier();
                if (classifier != null) {
                    nestedQualifiedNames.add(classifier.getQualifiedName().toString());
                }
                return !resolveTypeChain;
            }
        });
        return nestedQualifiedNames;
    }

    private static int getQualifiedNamesMatchValue(String qn1, String qn2) {
        if (qn1 != null && qn2 != null) {
            if (qn1.equals(qn2)) {
                return 2;
            }
            if (qn1.length() > qn2.length() && qn1.startsWith(qn2)) {
                boolean isLastQualifiedPart = qn1.indexOf("::", qn2.length()) == -1;
                boolean isSpecialization = '<' == qn1.charAt(qn2.length());
                return isLastQualifiedPart && isSpecialization ? 1 : 0;
            }
            if (qn2.length() > qn1.length() && qn2.startsWith(qn1)) {
                boolean isLastQualifiedPart = qn2.indexOf("::", qn1.length()) == -1;
                boolean isSpecialization = '<' == qn2.charAt(qn1.length());
                return isLastQualifiedPart && isSpecialization ? 1 : 0;
            }
        }
        return 0;
    }

    private static boolean isExpressionParameter(CsmClassifier cls, CsmSpecializationParameter specParam, int specParamIndex) {
        CsmTemplateParameter param;
        List templateParams;
        if (CsmKindUtilities.isExpressionBasedSpecalizationParameter((CsmObject)specParam)) {
            return true;
        }
        return CsmKindUtilities.isTemplate((CsmObject)cls) && (templateParams = ((CsmTemplate)cls).getTemplateParameters()) != null && templateParams.size() > specParamIndex && (param = (CsmTemplateParameter)templateParams.get(specParamIndex)) != null && !param.isTypeBased();
    }

    private int evaluateExpression(CsmClassifier cls, ClassImplSpecialization spec, CsmSpecializationParameter specParam, int instParamIndex, InstantiationParametersInfo paramsInfo) {
        List<String> instParamsText = paramsInfo.getParamsTexts();
        List<CsmSpecializationParameter> instParams = paramsInfo.getInstParams();
        String specParamText = null;
        CsmTemplateParameter relatedSpecTemplateParam = null;
        if (CsmKindUtilities.isExpressionBasedSpecalizationParameter((CsmObject)specParam)) {
            specParamText = specParam.getText().toString();
            for (CsmTemplateParameter specTemplateParam : spec.getTemplateParameters()) {
                if (specTemplateParam.isTypeBased() || !specTemplateParam.getName().toString().equals(specParamText)) continue;
                relatedSpecTemplateParam = specTemplateParam;
                break;
            }
        } else if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)specParam)) {
            CsmType specParamType = ((CsmTypeBasedSpecializationParameter)specParam).getType();
            CharSequence canonicalText = specParamType.getCanonicalText();
            if (canonicalText != null) {
                specParamText = canonicalText.toString();
            }
            if (CsmKindUtilities.isTemplateParameterType((CsmObject)specParamType)) {
                relatedSpecTemplateParam = ((CsmTemplateParameterType)specParamType).getParameter();
            }
        }
        if (relatedSpecTemplateParam != null && !relatedSpecTemplateParam.isTypeBased()) {
            return 1;
        }
        if (specParamText != null) {
            if (instParamsText.get(instParamIndex).equals(specParamText)) {
                return 2;
            }
            if (TraceFlags.EXPRESSION_EVALUATOR) {
                Object val1;
                CsmExpressionEvaluatorProvider p = CsmExpressionEvaluator.getProvider();
                if (CsmKindUtilities.isInstantiation((CsmObject)cls)) {
                    CsmTemplateParameter templateParameter;
                    List templateParameters = ((CsmTemplate)((CsmInstantiation)cls).getTemplateDeclaration()).getTemplateParameters();
                    CsmTemplateParameter csmTemplateParameter = templateParameter = templateParameters != null && templateParameters.size() > instParamIndex ? (CsmTemplateParameter)templateParameters.get(instParamIndex) : null;
                    if (templateParameter != null) {
                        Object val2;
                        if (p instanceof ExpressionEvaluator) {
                            val1 = ((ExpressionEvaluator)p).eval(templateParameter.getName().toString(), (CsmInstantiation)cls, CsmKindUtilities.isScope((CsmObject)cls) ? (CsmScope)cls : cls.getScope());
                            val2 = ((ExpressionEvaluator)p).eval(specParamText, (CsmInstantiation)cls, specParam.getScope());
                        } else {
                            val1 = p.eval(templateParameter.getName().toString(), (CsmInstantiation)cls, CsmKindUtilities.isScope((CsmObject)cls) ? (CsmScope)cls : cls.getScope());
                            val2 = p.eval(specParamText, (CsmInstantiation)cls, specParam.getScope());
                        }
                        if (p.isValid(val1) && p.isValid(val2) && val1.equals(val2)) {
                            return 2;
                        }
                    } else {
                        LOG.log(Level.WARNING, "Not found template parameter with index {0} in {1}", new Object[]{instParamIndex, ((CsmInstantiation)cls).getTemplateDeclaration().getQualifiedName()});
                    }
                } else {
                    Object val2;
                    if (p instanceof ExpressionEvaluator) {
                        val1 = ((ExpressionEvaluator)p).eval(instParamsText.get(instParamIndex), instParams.get(instParamIndex).getScope());
                        val2 = ((ExpressionEvaluator)p).eval(specParamText, specParam.getScope());
                    } else {
                        val1 = p.eval(instParamsText.get(instParamIndex), instParams.get(instParamIndex).getScope());
                        val2 = p.eval(specParamText, specParam.getScope());
                    }
                    if (p.isValid(val1) && p.isValid(val2) && val1.equals(val2)) {
                        return 2;
                    }
                }
            }
        }
        return 0;
    }

    public static CsmType createTypeInstantiationForTypeParameter(CsmTypeBasedSpecializationParameter param, Iterator<CsmInstantiation> instantiations, int level) {
        if (level > 10 || !instantiations.hasNext()) {
            return null;
        }
        CsmInstantiation instantiation = instantiations.next();
        Collection parameters = instantiation.getMapping().values();
        for (CsmSpecializationParameter parameter : parameters) {
            if (parameter != param) continue;
            return param.getType();
        }
        CsmType instantiatedType = InstantiationProviderImpl.createTypeInstantiationForTypeParameter(param, instantiations, level + 1);
        if (instantiatedType != null) {
            return Instantiation.createType(instantiatedType, instantiation);
        }
        return null;
    }

    private boolean isClassForward(CsmClassifier cls) {
        while (CsmKindUtilities.isInstantiation((CsmObject)cls)) {
            CsmOffsetableDeclaration decl = ((CsmInstantiation)cls).getTemplateDeclaration();
            if (!CsmKindUtilities.isClassifier((CsmObject)cls)) break;
            cls = (CsmClassifier)decl;
        }
        return ForwardClass.isForwardClass((CsmObject)cls);
    }

    public CsmTypeBasedSpecializationParameter createTypeBasedSpecializationParameter(CsmType type, CsmScope scope) {
        return new TypeBasedSpecializationParameterImpl(type, scope);
    }

    public CsmTypeBasedSpecializationParameter createTypeBasedSpecializationParameter(CsmType type, CsmScope scope, CsmFile file, int start, int end) {
        return new TypeBasedSpecializationParameterImpl(type, scope, file, start, end);
    }

    public CsmVariadicSpecializationParameter createVariadicSpecializationParameter(List<CsmSpecializationParameter> args, CsmFile file, int start, int end) {
        return new VariadicSpecializationParameterImpl(args, file, start, end);
    }

    public CsmExpressionBasedSpecializationParameter createExpressionBasedSpecializationParameter(String expression, CsmScope scope, CsmFile file, int start, int end) {
        return ExpressionBasedSpecializationParameterImpl.create(expression, scope, file, start, end);
    }

    @SuppressWarnings(value={"SF"})
    public static List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> getInstantiationParams(CsmObject o) {
        if (!CsmKindUtilities.isInstantiation((CsmObject)o)) {
            return Collections.emptyList();
        }
        long time = System.currentTimeMillis();
        ArrayList<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> res = new ArrayList<Pair<CsmSpecializationParameter, List<CsmInstantiation>>>();
        CsmInstantiation i = (CsmInstantiation)o;
        Map m = i.getMapping();
        CsmOffsetableDeclaration decl = i.getTemplateDeclaration();
        if (!CsmKindUtilities.isInstantiation((CsmObject)decl)) {
            if (CsmKindUtilities.isTemplate((CsmObject)decl)) {
                for (CsmTemplateParameter tp : ((CsmTemplate)decl).getTemplateParameters()) {
                    CsmSpecializationParameter sp = (CsmSpecializationParameter)m.get(tp);
                    if (sp == null) continue;
                    ArrayList<CsmInstantiation> insts = new ArrayList<CsmInstantiation>();
                    insts.add(i);
                    res.add((Pair<CsmSpecializationParameter, List<CsmInstantiation>>)Pair.of((Object)sp, insts));
                }
            }
        } else {
            List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> sps = InstantiationProviderImpl.getInstantiationParams((CsmObject)decl);
            for (Pair<CsmSpecializationParameter, List<CsmInstantiation>> pair : sps) {
                CsmSpecializationParameter instParam = (CsmSpecializationParameter)pair.first();
                List instantiations = (List)pair.second();
                if (CsmKindUtilities.isVariadicSpecalizationParameter((CsmObject)instParam)) {
                    CsmVariadicSpecializationParameter variadicParam = (CsmVariadicSpecializationParameter)instParam;
                    ArrayList<CsmSpecializationParameter> processedArgs = new ArrayList<CsmSpecializationParameter>();
                    VariadicRemapping remapped = InstantiationProviderImpl.getVariadicInstantiationParams(variadicParam, m, processedArgs);
                    switch (remapped) {
                        case ALL: {
                            instantiations.clear();
                        }
                        case SOME: {
                            VariadicSpecializationParameterImpl newVariadicParam = new VariadicSpecializationParameterImpl(processedArgs, variadicParam.getContainingFile(), variadicParam.getStartOffset(), variadicParam.getEndOffset());
                            res.add((Pair<CsmSpecializationParameter, List<CsmInstantiation>>)Pair.of((Object)newVariadicParam, (Object)instantiations));
                            break;
                        }
                        case NONE: {
                            res.add(pair);
                        }
                    }
                } else if (InstantiationProviderImpl.isTemplateSpecParameter(instParam)) {
                    CsmTemplateParameterType paramType = (CsmTemplateParameterType)((CsmTypeBasedSpecializationParameter)instParam).getType();
                    CsmSpecializationParameter newTp = (CsmSpecializationParameter)m.get(paramType.getParameter());
                    if (newTp != null && newTp != instParam) {
                        instantiations.clear();
                        res.add((Pair<CsmSpecializationParameter, List<CsmInstantiation>>)Pair.of((Object)newTp, (Object)instantiations));
                    } else {
                        res.add(pair);
                    }
                } else {
                    res.add(pair);
                }
                instantiations.add(i);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            time = System.currentTimeMillis() - time;
            LOG.log(Level.FINE, "getInstantiationParams took {0}ms\n", new Object[]{time});
        }
        return res;
    }

    public static List<CsmSpecializationParameter> getPlainParams(List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> instParams) {
        ArrayList<CsmSpecializationParameter> params = new ArrayList<CsmSpecializationParameter>(instParams.size());
        for (Pair<CsmSpecializationParameter, List<CsmInstantiation>> pair : instParams) {
            params.add((CsmSpecializationParameter)pair.first());
        }
        return params;
    }

    private static VariadicRemapping getVariadicInstantiationParams(CsmVariadicSpecializationParameter variadicParam, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping, List<CsmSpecializationParameter> results) {
        boolean hasRemapped = false;
        boolean hasNotRemapped = false;
        List<CsmSpecializationParameter> expanded = InstantiationProviderImpl.expandVariadicParams(Arrays.asList(variadicParam));
        for (CsmSpecializationParameter argParam : expanded) {
            if (InstantiationProviderImpl.isTemplateSpecParameter(argParam)) {
                CsmTemplateParameterType paramType = (CsmTemplateParameterType)((CsmTypeBasedSpecializationParameter)argParam).getType();
                CsmSpecializationParameter newSpecParam = mapping.get(paramType.getParameter());
                if (newSpecParam != null && newSpecParam != argParam) {
                    if (CsmKindUtilities.isVariadicSpecalizationParameter((CsmObject)newSpecParam)) {
                        for (CsmSpecializationParameter param : ((CsmVariadicSpecializationParameter)newSpecParam).getArgs()) {
                            results.add(param);
                        }
                    } else {
                        results.add(newSpecParam);
                    }
                    hasRemapped = true;
                    continue;
                }
                results.add(argParam);
                hasNotRemapped = true;
                continue;
            }
            hasNotRemapped = true;
        }
        if (hasRemapped && hasNotRemapped) {
            return VariadicRemapping.SOME;
        }
        return hasRemapped ? VariadicRemapping.ALL : VariadicRemapping.NONE;
    }

    private static boolean isTemplateSpecParameter(CsmSpecializationParameter param) {
        return CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param) && CsmKindUtilities.isTemplateParameterType((CsmObject)((CsmTypeBasedSpecializationParameter)param).getType());
    }

    private CsmClassForwardDeclaration findCsmClassForwardDeclaration(CsmClass cls) {
        CsmNamespace ns;
        CsmScope scope;
        if (TraceFlags.INSTANTIATION_FULL_FORWARDS_SEARCH && CsmKindUtilities.isNamespace((Object)(scope = cls.getScope())) && !(ns = (CsmNamespace)scope).isGlobal() && !ns.getDefinitions().isEmpty()) {
            for (CsmNamespaceDefinition definition : ns.getDefinitions()) {
                CsmClassForwardDeclaration result = this.findCsmClassForwardDeclaration((CsmScope)definition, cls);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        return this.findCsmClassForwardDeclaration((CsmScope)cls.getContainingFile(), cls);
    }

    private CsmClassForwardDeclaration findCsmClassForwardDeclaration(CsmScope scope, CsmClass cls) {
        if (scope != null) {
            CsmClassForwardDeclaration fdecl;
            CsmClass fwdCls;
            CsmOffsetableDeclaration decl;
            Iterator it;
            Iterator declarations;
            CsmSelect.CsmFilter filter;
            if (CsmKindUtilities.isFile((CsmObject)scope)) {
                CsmFile file = (CsmFile)scope;
                filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION});
                it = declarations = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    decl = (CsmOffsetableDeclaration)it.next();
                    fwdCls = ((CsmClassForwardDeclaration)decl).getCsmClass();
                    if (fwdCls == null || !fwdCls.equals(cls)) continue;
                    return (CsmClassForwardDeclaration)decl;
                }
                filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION});
                it = declarations = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    decl = (CsmOffsetableDeclaration)it.next();
                    fdecl = this.findCsmClassForwardDeclaration((CsmScope)((CsmNamespaceDefinition)decl), cls);
                    if (fdecl == null) continue;
                    return fdecl;
                }
            }
            if (CsmKindUtilities.isNamespaceDefinition((CsmObject)scope)) {
                CsmNamespaceDefinition nsd = (CsmNamespaceDefinition)scope;
                if (CharSequenceUtilities.startsWith((CharSequence)cls.getQualifiedName(), (CharSequence)nsd.getQualifiedName())) {
                    filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION});
                    it = declarations = CsmSelect.getDeclarations((CsmNamespaceDefinition)nsd, (CsmSelect.CsmFilter)filter);
                    while (it.hasNext()) {
                        decl = (CsmOffsetableDeclaration)it.next();
                        fwdCls = ((CsmClassForwardDeclaration)decl).getCsmClass();
                        if (fwdCls == null || !fwdCls.equals(cls)) continue;
                        return (CsmClassForwardDeclaration)decl;
                    }
                    filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION});
                    it = declarations = CsmSelect.getDeclarations((CsmNamespaceDefinition)nsd, (CsmSelect.CsmFilter)filter);
                    while (it.hasNext()) {
                        decl = (CsmOffsetableDeclaration)it.next();
                        fdecl = this.findCsmClassForwardDeclaration((CsmScope)((CsmNamespaceDefinition)decl), cls);
                        if (fdecl == null) continue;
                        return fdecl;
                    }
                }
            }
        }
        return null;
    }

    private CsmSpecializationParameter getTemplateParameterDefultValue(CsmTemplate declaration, CsmTemplateParameter param, int index) {
        CsmTemplateParameter p;
        List templateParameters;
        CsmClass cls;
        CsmClassForwardDeclaration fdecl;
        CsmSpecializationParameter res = param.getDefaultValue();
        if (res != null) {
            return res;
        }
        if (CsmKindUtilities.isClass((CsmObject)declaration) && (fdecl = this.findCsmClassForwardDeclaration(cls = (CsmClass)declaration)) != null && (templateParameters = ((CsmTemplate)fdecl).getTemplateParameters()).size() > index && (p = (CsmTemplateParameter)templateParameters.get(index)) != null && (res = p.getDefaultValue()) != null) {
            return res;
        }
        return res;
    }

    private static CsmCacheMap getTemplateRelatedCache(CsmObject template, boolean specialize) {
        return null;
    }

    private static CsmCacheMap getSpecializeCache() {
        return null;
    }

    private static <T> int howMany(Collection<T> collection, T elem) {
        int counter = 0;
        for (T t : collection) {
            if (!Objects.equals(t, elem)) continue;
            ++counter;
        }
        return counter;
    }

    private static boolean hasVariadicParams(CsmTemplate template) {
        if (template != null && template.getTemplateParameters() != null) {
            for (CsmTemplateParameter param : template.getTemplateParameters()) {
                if (!param.isVarArgs()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasVariadicParams(List<CsmSpecializationParameter> params) {
        if (params != null) {
            for (CsmSpecializationParameter param : params) {
                if (!CsmKindUtilities.isVariadicSpecalizationParameter((CsmObject)param)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<CsmSpecializationParameter> expandVariadicParams(List<CsmSpecializationParameter> params) {
        ArrayList<CsmSpecializationParameter> params2 = new ArrayList<CsmSpecializationParameter>();
        for (CsmSpecializationParameter param : params) {
            if (CsmKindUtilities.isVariadicSpecalizationParameter((CsmObject)param)) {
                for (CsmSpecializationParameter arg : ((CsmVariadicSpecializationParameter)param).getArgs()) {
                    params2.add(arg);
                }
                continue;
            }
            params2.add(param);
        }
        return params2;
    }

    private static CsmType[] wrapType(CsmType type) {
        CsmType[] csmTypeArray;
        if (type != null) {
            CsmType[] csmTypeArray2 = new CsmType[1];
            csmTypeArray = csmTypeArray2;
            csmTypeArray2[0] = type;
        } else {
            csmTypeArray = null;
        }
        return csmTypeArray;
    }

    private CsmResolveContext getLastResolveContext() {
        Stack contexts = (Stack)CsmCacheManager.get(CsmResolveContext.class);
        CsmResolveContext context = contexts != null && !contexts.empty() ? (CsmResolveContext)contexts.peek() : null;
        return context;
    }

    private static class UnfoldWhileNestedPredicate
    implements CsmUtilities.Predicate<CsmType> {
        private UnfoldWhileNestedPredicate() {
        }

        public boolean check(CsmType value) {
            return !Instantiation.isNestedType(value);
        }
    }

    private static class SpecializeRequest {
        private final CsmClassifier classifier;
        private final InstantiationParametersInfo paramsInfo;

        public SpecializeRequest(CsmClassifier classifier, InstantiationParametersInfo paramsInfo) {
            this.classifier = classifier;
            this.paramsInfo = paramsInfo;
        }

        public int hashCode() {
            int hash = 7;
            if (CsmKindUtilities.isOffsetableDeclaration((Object)this.classifier)) {
                CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)this.classifier;
                hash = 31 * hash + decl.getStartOffset();
                hash = 31 * hash + Objects.hashCode(decl.getContainingFile());
            }
            hash = 31 * hash + Objects.hashCode(this.classifier.getUniqueName());
            return hash;
        }

        public boolean equals(Object obj) {
            boolean otherOffsetable;
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SpecializeRequest other = (SpecializeRequest)obj;
            boolean ourOffsetable = CsmKindUtilities.isOffsetableDeclaration((Object)this.classifier);
            if (ourOffsetable != (otherOffsetable = CsmKindUtilities.isOffsetableDeclaration((Object)other.classifier))) {
                return false;
            }
            if (ourOffsetable && otherOffsetable) {
                CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)this.classifier;
                CsmOffsetableDeclaration otherDecl = (CsmOffsetableDeclaration)other.classifier;
                if (!decl.getContainingFile().equals(otherDecl.getContainingFile())) {
                    return false;
                }
                if (decl.getStartOffset() != otherDecl.getStartOffset()) {
                    return false;
                }
            }
            if (!Objects.equals(this.classifier.getUniqueName(), other.classifier.getUniqueName())) {
                return false;
            }
            if (this.paramsInfo.getParamsTypes().size() != other.paramsInfo.getParamsTypes().size()) {
                return false;
            }
            boolean hasNullTypes = false;
            Iterator<CsmType> types = this.paramsInfo.getParamsTypes().iterator();
            Iterator<CsmType> otherTypes = other.paramsInfo.getParamsTypes().iterator();
            while (types.hasNext() && otherTypes.hasNext()) {
                CsmType type = types.next();
                CsmType otherType = otherTypes.next();
                if (type == null && otherType == null) {
                    hasNullTypes = true;
                    break;
                }
                if (Objects.equals(type, otherType)) continue;
                return false;
            }
            return hasNullTypes ? this.classifier.equals(other.classifier) : true;
        }
    }

    private static class TemplateSpecializationsKey {
        private final CsmDeclaration decl;
        private final CsmFile contextFile;
        private final int contextOffset;

        public TemplateSpecializationsKey(CsmDeclaration templateDecl, CsmFile contextFile, int contextOffset) {
            this.decl = templateDecl;
            this.contextFile = contextFile;
            this.contextOffset = contextOffset;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + this.contextOffset;
            hash = 31 * hash + Objects.hashCode(this.contextFile);
            hash = 31 * hash + Objects.hashCode(this.decl);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TemplateSpecializationsKey other = (TemplateSpecializationsKey)obj;
            if (this.contextOffset != other.contextOffset) {
                return false;
            }
            if (!Objects.equals(this.contextFile, other.contextFile)) {
                return false;
            }
            return Objects.equals(this.decl, other.decl);
        }
    }

    private static class BaseTemplateKey {
        private final CsmDeclaration declaration;

        public BaseTemplateKey(CsmDeclaration declaration) {
            this.declaration = declaration;
        }

        public int hashCode() {
            int hash = 5;
            hash = 23 * hash + Objects.hashCode(this.declaration);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BaseTemplateKey other = (BaseTemplateKey)obj;
            return Objects.equals(this.declaration, other.declaration);
        }
    }

    private static final class InstantiateMapKey {
        private final HashMap<CsmTemplateParameter, CsmSpecializationParameter> params;
        private int hashCode = 0;

        public InstantiateMapKey(Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            this.params = new HashMap<CsmTemplateParameter, CsmSpecializationParameter>(mapping);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int hash = 7;
                this.hashCode = hash += CndCollectionUtils.hashCode(this.params);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstantiateMapKey other = (InstantiateMapKey)obj;
            if (this.hashCode != other.hashCode && this.hashCode != 0 && other.hashCode != 0) {
                return false;
            }
            return CndCollectionUtils.equals(this.params, other.params);
        }

        public String toString() {
            return "InstantiateMapKey{" + this.params + '}';
        }
    }

    private static final class InstantiateListKey {
        private final List<CsmSpecializationParameter> params;
        private int hashCode = 0;

        public InstantiateListKey(List<CsmSpecializationParameter> params) {
            this.params = new ArrayList<CsmSpecializationParameter>(params);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int hash = 7;
                this.hashCode = hash = 17 * hash + CndCollectionUtils.hashCode(this.params);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstantiateListKey other = (InstantiateListKey)obj;
            if (this.hashCode != other.hashCode && this.hashCode != 0 && other.hashCode != 0) {
                return false;
            }
            return CndCollectionUtils.equals(this.params, other.params);
        }

        public String toString() {
            return "InstantiateListKey{" + this.params + '}';
        }
    }

    private static final class TemplateCacheInitializer
    implements Callable<CsmCacheMap> {
        private final CsmObject template;

        private TemplateCacheInitializer(CsmObject template) {
            this.template = template;
        }

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap("Cache Template " + CsmDisplayUtilities.getTooltipText((CsmObject)this.template), 1);
        }
    }

    private static final class TemplateCacheKey {
        private final CsmObject obj;
        private final boolean specialize;

        public TemplateCacheKey(CsmObject instance, boolean specialize) {
            this.obj = instance;
            this.specialize = specialize;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + System.identityHashCode(this.obj);
            hash = 79 * hash + (this.specialize ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TemplateCacheKey other = (TemplateCacheKey)obj;
            if (this.specialize != other.specialize) {
                return false;
            }
            return this.obj == other.obj;
        }

        public String toString() {
            return "TemplateCacheKey{obj=" + this.obj + ", specialize=" + this.specialize + '}';
        }
    }

    private static class TypeDigger {
        private final CsmType templateType;
        private final List<ExtractAction> actions;

        public static TypeDigger create(CsmTemplateParameter templateParam, CsmType type) {
            ArrayList<ExtractAction> actions = new ArrayList<ExtractAction>();
            CsmType templateType = TypeDigger.findTemplateParam(templateParam.getQualifiedName().toString(), templateParam.isVarArgs(), type, actions);
            if (templateType != null) {
                return new TypeDigger(actions, templateType);
            }
            return null;
        }

        public CsmType getTemplateType() {
            return this.templateType;
        }

        public CsmType[] extract(CsmType target, CsmInstantiationProvider.DeduceTemplateTypeStrategy strategy) {
            CsmType[] types = InstantiationProviderImpl.wrapType(target);
            for (ExtractAction action : this.actions) {
                CsmType[] nextTypes = action.extract(types[0]);
                if (nextTypes == null || nextTypes.length == 0) {
                    return strategy.canSkipError(CsmInstantiationProvider.DeduceTemplateTypeStrategy.Error.ExtractNextTypeError) ? types : null;
                }
                types = nextTypes;
            }
            return types;
        }

        private static CsmType findTemplateParam(String templateParamName, boolean variadic, CsmType type, List<ExtractAction> digActions) {
            if (type == null) {
                return null;
            }
            CsmType foundType = null;
            CsmClassifier cls = type.getClassifier();
            if (CsmBaseUtilities.isValid((CsmObject)cls)) {
                if (!cls.getQualifiedName().toString().equals(templateParamName)) {
                    CsmFunctionPointerType funPtrType = TypeDigger.tryGetFunctionPointerType(type);
                    if (funPtrType != null) {
                        CsmType retType = funPtrType.getReturnType();
                        foundType = TypeDigger.findTemplateParam(templateParamName, variadic, retType, digActions);
                        if (foundType != null) {
                            digActions.add(0, new ExtractFunctionReturnTypeAction());
                            return foundType;
                        }
                        int paramIndex = 0;
                        Iterator paramIter = funPtrType.getParameters().iterator();
                        while (paramIter.hasNext()) {
                            CsmType paramType = ((CsmParameter)paramIter.next()).getType();
                            foundType = TypeDigger.findTemplateParam(templateParamName, variadic, paramType, digActions);
                            if (foundType != null) {
                                digActions.add(0, new ExtractFunctionParamTypeAction(paramIndex, TypeDigger.isActionVariadic(variadic, digActions)));
                                return foundType;
                            }
                            ++paramIndex;
                        }
                    } else {
                        List params;
                        CsmType instType = TypeDigger.tryGetInstantiationType(type);
                        if (instType != null && (params = instType.getInstantiationParams()) != null) {
                            for (int i = 0; i < params.size(); ++i) {
                                CsmType paramType;
                                CsmSpecializationParameter param = (CsmSpecializationParameter)params.get(i);
                                if (!CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param) || (foundType = TypeDigger.findTemplateParam(templateParamName, variadic, paramType = ((CsmTypeBasedSpecializationParameter)param).getType(), digActions)) == null) continue;
                                digActions.add(0, new ExtractInstantiationParamTypeAction(i, TypeDigger.isActionVariadic(variadic, digActions)));
                                return foundType;
                            }
                        }
                    }
                } else {
                    return type;
                }
            }
            return foundType;
        }

        private static boolean isActionVariadic(boolean variadic, List<ExtractAction> digActions) {
            return variadic && digActions.isEmpty();
        }

        private static CsmType tryGetInstantiationType(CsmType type) {
            CsmType result = CsmUtilities.iterateTypeChain((CsmType)type, (CsmUtilities.Predicate)new CsmUtilities.Predicate<CsmType>(){

                public boolean check(CsmType value) {
                    return value != null && value.isInstantiation();
                }
            });
            return result != null && result.isInstantiation() ? result : null;
        }

        private static CsmInstantiation tryGetInstantiation(CsmType type) {
            if (!type.isInstantiation() && type.getStartPosition() == null && type.getEndPosition() == null) {
                CsmClassifier cls = type.getClassifier();
                return CsmKindUtilities.isInstantiation((CsmObject)cls) ? (CsmInstantiation)cls : null;
            }
            return null;
        }

        private static CsmFunctionPointerType tryGetFunctionPointerType(CsmType type) {
            CsmType result = CsmUtilities.iterateTypeChain((CsmType)type, (CsmUtilities.Predicate)new CsmUtilities.Predicate<CsmType>(){

                public boolean check(CsmType value) {
                    return CsmKindUtilities.isFunctionPointerType((CsmObject)value);
                }
            });
            return (CsmFunctionPointerType)(CsmKindUtilities.isFunctionPointerType((CsmObject)result) ? result : null);
        }

        private TypeDigger(List<ExtractAction> actions, CsmType templateType) {
            this.actions = actions;
            this.templateType = templateType;
        }

        private static final class ExtractFunctionReturnTypeAction
        extends ExtractAction {
            private ExtractFunctionReturnTypeAction() {
            }

            @Override
            public CsmType[] extract(CsmType type) {
                CsmFunctionPointerType funPtrType = TypeDigger.tryGetFunctionPointerType(type);
                if (funPtrType != null) {
                    return new CsmType[]{funPtrType.getReturnType()};
                }
                return null;
            }

            @Override
            public String asString(String target) {
                return target + "(*)(...)";
            }
        }

        private static final class ExtractFunctionParamTypeAction
        extends ExtractAction {
            private final boolean variadic;
            private final int index;

            public ExtractFunctionParamTypeAction(int index, boolean variadic) {
                this.index = index;
                this.variadic = variadic;
            }

            @Override
            public CsmType[] extract(CsmType type) {
                Collection params;
                CsmFunctionPointerType funPtrType = TypeDigger.tryGetFunctionPointerType(type);
                if (funPtrType != null && (params = funPtrType.getParameters()) != null && this.index < params.size()) {
                    Iterator paramsIter = params.iterator();
                    for (int current = 0; this.index != current; ++current) {
                        paramsIter.next();
                    }
                    CsmParameter param = (CsmParameter)paramsIter.next();
                    return new CsmType[]{param.getType()};
                }
                return null;
            }

            @Override
            public String asString(String target) {
                StringBuilder sb = new StringBuilder("ret(*)(");
                for (int i = 0; i < this.index; ++i) {
                    sb.append("class,");
                }
                sb.append(target);
                sb.append(")");
                return sb.toString();
            }
        }

        private static final class ExtractInstantiationParamTypeAction
        extends ExtractAction {
            private final boolean variadic;
            private final int index;

            public ExtractInstantiationParamTypeAction(int index, boolean variadic) {
                this.index = index;
                this.variadic = variadic;
            }

            @Override
            public CsmType[] extract(CsmType type) {
                List<CsmSpecializationParameter> params = null;
                CsmType instType = TypeDigger.tryGetInstantiationType(type);
                if (instType != null) {
                    params = this.extractInstantiationParams(instType);
                } else {
                    CsmInstantiation instantiation = TypeDigger.tryGetInstantiation(type);
                    if (instantiation != null) {
                        params = this.extractInstantiationParams(instantiation);
                    }
                }
                if (params != null && this.index < params.size()) {
                    if (!this.variadic) {
                        CsmSpecializationParameter param = params.get(this.index);
                        if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param)) {
                            return new CsmType[]{((CsmTypeBasedSpecializationParameter)param).getType()};
                        }
                    } else {
                        ArrayList<CsmType> result = new ArrayList<CsmType>();
                        ListIterator<CsmSpecializationParameter> paramsIter = params.listIterator(this.index);
                        while (paramsIter.hasNext()) {
                            CsmSpecializationParameter param = paramsIter.next();
                            if (!CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param)) continue;
                            result.add(((CsmTypeBasedSpecializationParameter)param).getType());
                        }
                        return result.toArray(new CsmType[result.size()]);
                    }
                }
                if (this.variadic && params != null && params.size() == this.index) {
                    return new CsmType[0];
                }
                return null;
            }

            private List<CsmSpecializationParameter> extractInstantiationParams(CsmType instType) {
                List params = instType.getInstantiationParams();
                if (InstantiationProviderImpl.hasVariadicParams(params)) {
                    params = InstantiationProviderImpl.expandVariadicParams(params);
                }
                return params;
            }

            private List<CsmSpecializationParameter> extractInstantiationParams(CsmInstantiation inst) {
                Map mapping = inst.getMapping();
                ArrayList templateParams = new ArrayList(mapping.keySet());
                Collections.sort(templateParams, new TemplateParamsComparator());
                if (!templateParams.isEmpty()) {
                    List<Object> params = new ArrayList<CsmSpecializationParameter>();
                    for (CsmTemplateParameter templateParam : templateParams) {
                        CsmSpecializationParameter mappedParam = (CsmSpecializationParameter)mapping.get(templateParam);
                        if (mappedParam == null) continue;
                        params.add(mappedParam);
                    }
                    if (InstantiationProviderImpl.hasVariadicParams(params)) {
                        params = InstantiationProviderImpl.expandVariadicParams(params);
                    }
                    return params;
                }
                return null;
            }

            @Override
            public String asString(String target) {
                StringBuilder sb = new StringBuilder("class<");
                for (int i = 0; i < this.index; ++i) {
                    sb.append("class,");
                }
                sb.append(target);
                sb.append(">");
                return sb.toString();
            }

            private static class TemplateParamsComparator
            implements Comparator<CsmTemplateParameter> {
                private TemplateParamsComparator() {
                }

                @Override
                public int compare(CsmTemplateParameter o1, CsmTemplateParameter o2) {
                    if (Objects.equals(o1.getContainingFile(), o2.getContainingFile())) {
                        return o1.getStartOffset() - o2.getStartOffset();
                    }
                    return 0;
                }
            }
        }

        private static abstract class ExtractAction {
            private ExtractAction() {
            }

            public abstract CsmType[] extract(CsmType var1);

            public abstract String asString(String var1);
        }
    }

    private static enum VariadicRemapping {
        ALL,
        SOME,
        NONE;

    }

    public static final class InstantiationParametersInfoImpl
    implements InstantiationParametersInfo {
        private final CsmObject obj;
        private final List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> originalParams;
        private final List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> expandedParams;
        private final boolean variadic;
        private List<CsmSpecializationParameter> instParams;
        private List<CsmType> paramsTypes;
        private List<String> paramsText;

        public InstantiationParametersInfoImpl(CsmObject obj, List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> originalParams) {
            List templateParams;
            this.obj = obj;
            this.originalParams = originalParams;
            this.variadic = CsmKindUtilities.isTemplate((CsmObject)obj) ? !(templateParams = ((CsmTemplate)obj).getTemplateParameters()).isEmpty() && ((CsmTemplateParameter)templateParams.get(templateParams.size() - 1)).isVarArgs() : false;
            this.expandedParams = InstantiationParametersInfoImpl.hasVariadicParameters(originalParams) ? InstantiationParametersInfoImpl.expandVariadicParameters(originalParams) : this.originalParams;
        }

        @Override
        public List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> getOriginalParams() {
            return Collections.unmodifiableList(this.originalParams);
        }

        @Override
        public List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> getExpandedParams() {
            return Collections.unmodifiableList(this.expandedParams);
        }

        @Override
        public boolean isVariadic() {
            return this.variadic;
        }

        @Override
        public List<CsmSpecializationParameter> getInstParams() {
            this.ensureInitialized();
            return Collections.unmodifiableList(this.instParams);
        }

        @Override
        public List<CsmType> getParamsTypes() {
            this.ensureInitialized();
            return Collections.unmodifiableList(this.paramsTypes);
        }

        @Override
        public List<String> getParamsTexts() {
            this.ensureInitialized();
            return Collections.unmodifiableList(this.paramsText);
        }

        private void ensureInitialized() {
            if (this.instParams == null || this.paramsTypes == null || this.paramsText == null) {
                this.instParams = new ArrayList<CsmSpecializationParameter>();
                this.paramsTypes = new ArrayList<CsmType>();
                this.paramsText = new ArrayList<String>();
                for (Pair<CsmSpecializationParameter, List<CsmInstantiation>> pair : this.expandedParams) {
                    CsmSpecializationParameter param = (CsmSpecializationParameter)pair.first();
                    if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param)) {
                        CsmType paramType = ((CsmTypeBasedSpecializationParameter)param).getType();
                        if (CsmKindUtilities.isInstantiation((CsmObject)this.obj)) {
                            paramType = Instantiation.createType(paramType, (List)pair.second());
                        }
                        this.instParams.add(param);
                        this.paramsTypes.add(paramType);
                        CharSequence paramText = paramType.getCanonicalText();
                        this.paramsText.add(paramText != null ? paramText.toString() : "");
                        continue;
                    }
                    if (!CsmKindUtilities.isExpressionBasedSpecalizationParameter((CsmObject)param)) continue;
                    this.instParams.add(param);
                    this.paramsTypes.add(null);
                    CharSequence paramText = ((CsmExpressionBasedSpecializationParameter)param).getText();
                    this.paramsText.add(paramText != null ? paramText.toString() : "");
                }
            }
        }

        private static boolean hasVariadicParameters(List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> params) {
            for (Pair<CsmSpecializationParameter, List<CsmInstantiation>> pair : params) {
                CsmSpecializationParameter param = (CsmSpecializationParameter)pair.first();
                if (!CsmKindUtilities.isVariadicSpecalizationParameter((CsmObject)param)) continue;
                return true;
            }
            return false;
        }

        private static List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> expandVariadicParameters(List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> params) {
            ArrayList<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> params2 = new ArrayList<Pair<CsmSpecializationParameter, List<CsmInstantiation>>>();
            for (Pair<CsmSpecializationParameter, List<CsmInstantiation>> pair : params) {
                CsmSpecializationParameter param = (CsmSpecializationParameter)pair.first();
                if (CsmKindUtilities.isVariadicSpecalizationParameter((CsmObject)param)) {
                    for (CsmSpecializationParameter arg : ((CsmVariadicSpecializationParameter)param).getArgs()) {
                        params2.add((Pair<CsmSpecializationParameter, List<CsmInstantiation>>)Pair.of((Object)arg, (Object)pair.second()));
                    }
                    continue;
                }
                params2.add(pair);
            }
            return params2;
        }
    }

    public static interface InstantiationParametersInfo {
        public List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> getOriginalParams();

        public List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> getExpandedParams();

        public boolean isVariadic();

        public List<CsmSpecializationParameter> getInstParams();

        public List<CsmType> getParamsTypes();

        public List<String> getParamsTexts();
    }
}

