/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTFileInfoQuerySupport;
import org.netbeans.modules.cnd.modelimpl.parser.clank.ClankFileInfoQuerySupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.model.services.CsmMacroExpansionDocProvider;
import org.openide.text.NbDocument;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;
import org.openide.util.Pair;

public class MacroExpansionDocProviderImpl
implements CsmMacroExpansionDocProvider {
    public static final String MACRO_EXPANSION_OFFSET_TRANSFORMER = "macro-expansion-offset-transformer";
    public static final String MACRO_EXPANSION_MACRO_TABLE = "macro-expansion-macro-table";
    public static final String MACRO_EXPANSION_STOP_ON_OFFSET_PARSE_FILE_WALKER_CACHE = "macro-expansion-stop-on-offset-parse-file-walker-cache";

    public synchronized int expand(final Document inDoc, final int startOffset, final int endOffset, final Document outDoc, final AtomicBoolean canceled) {
        if (inDoc == null || outDoc == null) {
            return 0;
        }
        final CsmFile file = CsmUtilities.getCsmFile((Document)inDoc, (boolean)false, (boolean)false);
        if (file == null) {
            return 0;
        }
        final MyTokenSequence fileTS = this.getFileTokenSequence(file, startOffset, endOffset);
        if (fileTS == null) {
            return 0;
        }
        final StringBuilder expandedData = new StringBuilder();
        final TransformationTable tt = new TransformationTable(DocumentUtilities.getDocumentVersion((Document)inDoc), CsmFileInfoQuery.getDefault().getFileVersion(file));
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TokenSequence docTS = CndLexerUtilities.getCppTokenSequence((Document)inDoc, (int)inDoc.getLength(), (boolean)false, (boolean)true);
                if (docTS == null) {
                    return;
                }
                docTS.move(startOffset);
                tt.setInStart(startOffset);
                tt.setOutStart(0);
                boolean inMacroParams = false;
                boolean inDeadCode = true;
                while (docTS.moveNext()) {
                    Token docToken = docTS.token();
                    int docTokenStartOffset = docTS.offset();
                    int docTokenEndOffset = docTokenStartOffset + docToken.length();
                    if (MacroExpansionDocProviderImpl.this.isWhitespace((Token<TokenId>)docToken)) continue;
                    if (canceled.get()) break;
                    APTToken fileToken = MacroExpansionDocProviderImpl.this.findToken(fileTS, docTokenStartOffset);
                    if (fileToken == null) {
                        if (!inMacroParams && !inDeadCode) {
                            MacroExpansionDocProviderImpl.this.copyInterval(inDoc, (endOffset > docTokenStartOffset ? docTokenStartOffset : endOffset) - tt.currentIn.start, tt, expandedData);
                        }
                        tt.appendInterval(endOffset - tt.currentIn.start, 0);
                        break;
                    }
                    if (docTokenEndOffset <= fileToken.getOffset() || !APTUtils.isMacroExpandedToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                        if (MacroExpansionDocProviderImpl.this.isOnInclude((TokenSequence<TokenId>)docTS)) {
                            if (!inMacroParams && !inDeadCode) {
                                MacroExpansionDocProviderImpl.this.copyInterval(inDoc, docTokenStartOffset - tt.currentIn.start, tt, expandedData);
                            } else {
                                tt.appendInterval(docTokenStartOffset - tt.currentIn.start, 0);
                            }
                            MacroExpansionDocProviderImpl.this.expandIcludeToken((TokenSequence<TokenId>)docTS, inDoc, file, tt, expandedData);
                        } else if (docTokenEndOffset <= fileToken.getOffset()) {
                            if (inMacroParams || inDeadCode) {
                                tt.appendInterval(docTokenEndOffset - tt.currentIn.start, 0);
                                continue;
                            }
                            MacroExpansionDocProviderImpl.this.copyInterval(inDoc, docTokenStartOffset - tt.currentIn.start, tt, expandedData);
                            tt.appendInterval(docTokenEndOffset - tt.currentIn.start, 0);
                            inDeadCode = true;
                            continue;
                        }
                        inMacroParams = false;
                        inDeadCode = false;
                        continue;
                    }
                    MacroExpansionDocProviderImpl.this.copyInterval(inDoc, docTokenStartOffset - tt.currentIn.start, tt, expandedData);
                    Formatter formatter = null;
                    if (outDoc.getProperty("macro-expansion-view-document") != null) {
                        formatter = new Formatter((BaseDocument)outDoc);
                    }
                    MacroExpansionDocProviderImpl.this.expandMacroToken(docTS, fileTS, tt, expandedData, formatter);
                    inMacroParams = true;
                }
                MacroExpansionDocProviderImpl.this.copyInterval(inDoc, endOffset - tt.currentIn.start, tt, expandedData);
                tt.cleanUp();
            }
        };
        inDoc.render(r);
        outDoc.putProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER, tt);
        try {
            outDoc.insertString(0, expandedData.toString(), null);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.initGuardedBlocks(outDoc, tt);
        return this.calcExpansionNumber(tt);
    }

    public int getOffsetInExpandedText(Document expandedDoc, int originalOffset) {
        Object o = expandedDoc.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (o != null && o instanceof TransformationTable) {
            TransformationTable tt = (TransformationTable)o;
            return tt.getOutOffset(originalOffset);
        }
        return originalOffset;
    }

    public int getOffsetInOriginalText(Document expandedDoc, int expandedOffset) {
        Object o = expandedDoc.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (o != null && o instanceof TransformationTable) {
            TransformationTable tt = (TransformationTable)o;
            return tt.getInOffset(expandedOffset);
        }
        return expandedOffset;
    }

    public int getNextMacroExpansionStartOffset(Document expandedDoc, int expandedOffset) {
        Object o = expandedDoc.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (o != null && o instanceof TransformationTable) {
            TransformationTable tt = (TransformationTable)o;
            return tt.getNextMacroExpansionStartOffset(expandedOffset);
        }
        return expandedOffset;
    }

    public int getPrevMacroExpansionStartOffset(Document expandedDoc, int expandedOffset) {
        Object o = expandedDoc.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (o != null && o instanceof TransformationTable) {
            TransformationTable tt = (TransformationTable)o;
            return tt.getPrevMacroExpansionStartOffset(expandedOffset);
        }
        return expandedOffset;
    }

    private void fillParamsToExpansionMap(APTToken fileToken, TransformationTable tt, int expandedOffsetShift, Map<Interval, List<Interval>> paramsToExpansion) {
        APTToken to = APTUtils.getExpandedToken((APTToken)fileToken);
        if (to != null) {
            Interval paramInterval = MacroExpansionDocProviderImpl.createInterval(to.getOffset(), to.getEndOffset());
            Interval paramExpansionInterval = MacroExpansionDocProviderImpl.createInterval(tt.currentOut.start + expandedOffsetShift, tt.currentOut.start + expandedOffsetShift + fileToken.getTextID().length());
            List<Interval> paramExpansions = paramsToExpansion.get(paramInterval);
            if (paramExpansions != null) {
                paramExpansions.add(paramExpansionInterval);
            } else {
                paramExpansions = new ArrayList<Interval>(1);
                paramExpansions.add(paramExpansionInterval);
                paramsToExpansion.put(paramInterval, paramExpansions);
            }
        }
    }

    private APTToken findToken(MyTokenSequence fileTS, int offset) {
        while (fileTS.token() != null && !APTUtils.isEOF((org.netbeans.modules.cnd.antlr.Token)fileTS.token()) && fileTS.token().getOffset() < offset) {
            fileTS.moveNext();
        }
        if (fileTS.token() == null || APTUtils.isEOF((org.netbeans.modules.cnd.antlr.Token)fileTS.token())) {
            return null;
        }
        return fileTS.token();
    }

    private TransformationTable getCachedMacroTable(Document doc) {
        Object o = doc.getProperty(MACRO_EXPANSION_MACRO_TABLE);
        if (o != null && o instanceof TransformationTable) {
            TransformationTable tt = (TransformationTable)o;
            return tt;
        }
        return null;
    }

    private TransformationTable getTransformationTable(Document doc) {
        Object o = doc.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (o != null && o instanceof TransformationTable) {
            TransformationTable tt = (TransformationTable)o;
            return tt;
        }
        return null;
    }

    public String[] getMacroExpansion(Document doc, int offset) {
        return new String[]{"", ""};
    }

    public String expand(Document doc, int startOffset, int endOffset) {
        if (doc == null) {
            return null;
        }
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
        Formatter formatter = null;
        if (doc instanceof BaseDocument) {
            formatter = new Formatter((BaseDocument)doc);
        }
        TransformationTable tt = new TransformationTable(DocumentUtilities.getDocumentVersion((Document)doc), CsmFileInfoQuery.getDefault().getFileVersion(csmFile));
        this.expand(doc, csmFile, tt, formatter);
        tt.cleanUp();
        return this.expandInterval(doc, tt, startOffset, endOffset);
    }

    public String expand(Document doc, CsmFile file, int startOffset, int endOffset, boolean updateIfNeeded) {
        TransformationTable tt = this.getMacroTable(doc, file, updateIfNeeded);
        return tt == null ? null : this.expandInterval(doc, tt, startOffset, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getMacroExpansionSpan(Document doc, int offset, boolean wait) {
        int startIndex;
        TransformationTable tt;
        Document file;
        int[] span = new int[]{offset, offset};
        if (wait) {
            file = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
            tt = this.getMacroTable(doc, (CsmFile)file, true);
        } else {
            file = doc;
            synchronized (file) {
                tt = this.getCachedMacroTable(doc);
            }
        }
        if (tt != null && 0 <= (startIndex = tt.findInIntervalIndex(offset)) && startIndex < tt.intervals.size()) {
            IntervalCorrespondence ic;
            int i;
            if (((IntervalCorrespondence)tt.intervals.get(startIndex)).getInIntervalEnd() == offset && startIndex < tt.intervals.size() - 1) {
                ++startIndex;
            }
            boolean foundMacroExpansion = false;
            int macroIndex = tt.intervals.size();
            for (i = startIndex; i >= 0; --i) {
                ic = (IntervalCorrespondence)tt.intervals.get(i);
                if (ic.isMacro()) {
                    span[0] = ic.getInIntervalStart();
                    span[1] = ic.getInIntervalEnd();
                    foundMacroExpansion = true;
                    macroIndex = i;
                    break;
                }
                if (ic.getOutIntervalLength() == 0) continue;
                return span;
            }
            if (foundMacroExpansion) {
                for (i = macroIndex + 1; i < tt.intervals.size(); ++i) {
                    ic = (IntervalCorrespondence)tt.intervals.get(i);
                    if (ic.getOutIntervalLength() != 0) {
                        return span;
                    }
                    span[1] = ic.getInIntervalEnd();
                }
            }
        }
        return span;
    }

    public int[][] getUsages(Document expandedDoc, int offset) {
        TransformationTable tt;
        int startIndex;
        Object o = expandedDoc.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (o != null && o instanceof TransformationTable && 0 <= (startIndex = (tt = (TransformationTable)o).findInIntervalIndex(offset)) && startIndex < tt.intervals.size()) {
            if (((IntervalCorrespondence)tt.intervals.get(startIndex)).getInIntervalEnd() == offset && startIndex < tt.intervals.size() - 1) {
                ++startIndex;
            }
            for (int i = startIndex; i >= 0; --i) {
                IntervalCorrespondence ic = (IntervalCorrespondence)tt.intervals.get(i);
                if (ic.isMacro()) {
                    List<Interval> anIntervals = ic.getIntervals();
                    for (int k = 0; k < anIntervals.size(); ++k) {
                        Interval in = anIntervals.get(k);
                        if (!in.contains(offset)) continue;
                        List<Interval> params = ic.getParamIntervals(k);
                        int[][] usages = new int[params.size()][2];
                        for (int j = 0; j < usages.length; ++j) {
                            usages[j][0] = params.get(j).getStart();
                            usages[j][1] = params.get(j).getEnd();
                        }
                        return usages;
                    }
                    break;
                }
                if (ic.getOutIntervalLength() == 0) continue;
                return null;
            }
        }
        return null;
    }

    public String expand(Document doc, int offset, String code) {
        if (doc == null) {
            return code;
        }
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
        if (!(file instanceof FileImpl)) {
            return code;
        }
        FileImpl fileImpl = (FileImpl)file;
        PreprocHandler handler = ((FileImpl)file).getPreprocHandler(offset);
        if (handler == null) {
            return code;
        }
        CsmProject project = file.getProject();
        if (!(project instanceof ProjectBase)) {
            return code;
        }
        ProjectBase base = (ProjectBase)project;
        if (APTTraceFlags.USE_CLANK) {
            return ClankFileInfoQuerySupport.expand(fileImpl, code, handler, base, offset);
        }
        return APTFileInfoQuerySupport.expand(fileImpl, code, handler, base, offset);
    }

    private String expandInterval(Document doc, TransformationTable tt, int startOffset, int endOffset) {
        IntervalCorrespondence ic;
        if (tt.intervals.isEmpty()) {
            return null;
        }
        int size = tt.intervals.size();
        int startIndex = tt.findInIntervalIndex(startOffset);
        if (startIndex < 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("");
        for (int i = startIndex; i < size && (ic = (IntervalCorrespondence)tt.intervals.get(i)).getInIntervalStart() < endOffset; ++i) {
            if (ic.getInIntervalEnd() <= startOffset) continue;
            int startShift = startOffset - ic.getInIntervalStart();
            if (startShift < 0) {
                startShift = 0;
            }
            if (startShift >= ic.getOutIntervalLength()) continue;
            int endShift = startShift + (endOffset - startOffset);
            if (endOffset >= ic.getInIntervalEnd()) {
                endShift = ic.getOutIntervalLength();
            }
            if (endShift > ic.getOutIntervalLength()) {
                endShift = ic.getOutIntervalLength();
            }
            if (endShift - startShift == 0) continue;
            if (ic.isMacro()) {
                if (startShift == 0 && endShift == ic.getOutIntervalLength()) {
                    sb.append(ic.getMacroExpansion());
                    continue;
                }
                sb.append(ic.getMacroExpansion().toString().substring(startShift, endShift));
                continue;
            }
            if (ic.getOutIntervalLength() == 0) continue;
            sb.append(MacroExpansionDocProviderImpl.getDocumentText(doc, ic.getInIntervalStart() + startShift, endShift - startShift));
        }
        return sb.toString();
    }

    private void expand(final Document doc, final CsmFile file, final TransformationTable tt, final Formatter formatter) {
        if (doc == null) {
            return;
        }
        if (file == null) {
            return;
        }
        final MyTokenSequence fileTS = this.getFileTokenSequence(file, 0, doc.getLength());
        if (fileTS == null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TokenSequence docTS = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)doc.getLength(), (boolean)false, (boolean)true);
                if (docTS == null) {
                    return;
                }
                docTS.moveStart();
                int startOffset = 0;
                int endOffset = doc.getLength();
                tt.setInStart(startOffset);
                tt.setOutStart(0);
                boolean inMacroParams = false;
                boolean inDeadCode = true;
                while (docTS.moveNext()) {
                    Token docToken = docTS.token();
                    int docTokenStartOffset = docTS.offset();
                    int docTokenEndOffset = docTokenStartOffset + docToken.length();
                    if (MacroExpansionDocProviderImpl.this.isWhitespace((Token<TokenId>)docToken)) continue;
                    APTToken fileToken = MacroExpansionDocProviderImpl.this.findToken(fileTS, docTokenStartOffset);
                    if (fileToken == null) {
                        if (!inMacroParams && !inDeadCode) {
                            MacroExpansionDocProviderImpl.this.copyInterval(doc, (endOffset > docTokenStartOffset ? docTokenStartOffset : endOffset) - tt.currentIn.start, tt, null);
                        }
                        tt.appendInterval(endOffset - tt.currentIn.start, 0);
                        break;
                    }
                    if (docTokenEndOffset <= fileToken.getOffset() || !APTUtils.isMacroExpandedToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                        if (MacroExpansionDocProviderImpl.this.isOnInclude((TokenSequence<TokenId>)docTS)) {
                            if (!inMacroParams && !inDeadCode) {
                                MacroExpansionDocProviderImpl.this.copyInterval(doc, docTokenStartOffset - tt.currentIn.start, tt, null);
                            } else {
                                tt.appendInterval(docTokenStartOffset - tt.currentIn.start, 0);
                            }
                            MacroExpansionDocProviderImpl.this.expandIcludeToken((TokenSequence<TokenId>)docTS, doc, file, tt, null);
                        } else if (docTokenEndOffset <= fileToken.getOffset()) {
                            if (inMacroParams || inDeadCode) {
                                tt.appendInterval(docTokenEndOffset - tt.currentIn.start, 0);
                                continue;
                            }
                            MacroExpansionDocProviderImpl.this.copyInterval(doc, docTokenStartOffset - tt.currentIn.start, tt, null);
                            tt.appendInterval(docTokenEndOffset - tt.currentIn.start, 0);
                            inDeadCode = true;
                            continue;
                        }
                        inMacroParams = false;
                        inDeadCode = false;
                        continue;
                    }
                    MacroExpansionDocProviderImpl.this.copyInterval(doc, docTokenStartOffset - tt.currentIn.start, tt, null);
                    MacroExpansionDocProviderImpl.this.expandMacroToken(docTS, fileTS, tt, null, formatter);
                    inMacroParams = true;
                }
                MacroExpansionDocProviderImpl.this.copyInterval(doc, endOffset - tt.currentIn.start, tt, null);
            }
        };
        doc.render(r);
    }

    private CharSequence expandMacroToken(MyTokenSequence fileTS, int docTokenStartOffset, int docTokenEndOffset, TransformationTable tt, Formatter formatter) {
        APTToken fileToken = fileTS.token();
        StringBuilder expandedToken = new StringBuilder();
        int expandedOffsetShift = 0;
        HashMap<Interval, List<Interval>> paramsToExpansion = new HashMap<Interval, List<Interval>>();
        boolean skipIndent = true;
        if (fileToken.getOffset() < docTokenEndOffset) {
            Pair format = null;
            if (formatter != null) {
                formatter.init(fileToken);
                format = formatter.process(fileToken, fileTS);
            }
            if (!APTUtils.isCommentToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                expandedToken.append(fileToken.getTextID());
                if (APTUtils.isMacroParamExpandedToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                    this.fillParamsToExpansionMap(fileToken, tt, expandedOffsetShift, paramsToExpansion);
                }
                expandedOffsetShift += fileToken.getTextID().length();
                skipIndent = false;
            }
            APTToken prevFileToken = fileToken;
            fileToken = this.skipMetaTokens(fileTS, prevFileToken);
            while (fileToken != null && !APTUtils.isEOF((org.netbeans.modules.cnd.antlr.Token)fileToken) && fileToken.getOffset() < docTokenEndOffset) {
                if (formatter != null) {
                    format = formatter.process(fileToken, fileTS);
                }
                if (!APTUtils.isCommentToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                    CharSequence suffix;
                    CharSequence prefix;
                    if (format != null && (prefix = (CharSequence)format.first()) != null) {
                        if (prefix instanceof UndoIndent) {
                            for (int i = 0; i < prefix.length(); ++i) {
                                char done;
                                char c = prefix.charAt(i);
                                if (expandedToken.length() > 0 && c == (done = expandedToken.charAt(expandedToken.length() - 1))) {
                                    expandedToken.setLength(expandedToken.length() - 1);
                                    --expandedOffsetShift;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            expandedToken.append(prefix);
                            expandedOffsetShift += prefix.length();
                        }
                        skipIndent = true;
                    }
                    if (!skipIndent && !APTUtils.areAdjacent((APTToken)prevFileToken, (APTToken)fileToken)) {
                        expandedToken.append(' ');
                        ++expandedOffsetShift;
                    }
                    skipIndent = false;
                    expandedToken.append(fileToken.getTextID());
                    if (APTUtils.isMacroParamExpandedToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                        this.fillParamsToExpansionMap(fileToken, tt, expandedOffsetShift, paramsToExpansion);
                    }
                    expandedOffsetShift += fileToken.getTextID().length();
                    if (format != null && (suffix = (CharSequence)format.second()) != null) {
                        expandedToken.append(suffix);
                        expandedOffsetShift += suffix.length();
                        skipIndent = true;
                    }
                }
                prevFileToken = fileToken;
                fileTS.moveNext();
                fileToken = fileTS.token();
            }
        }
        if (formatter != null) {
            for (int i = expandedToken.length() - 1; i >= 0; --i) {
                char c = expandedToken.charAt(i);
                if (c == ' ') {
                    expandedToken.setLength(expandedToken.length() - 1);
                    --expandedOffsetShift;
                    continue;
                }
                if (c != '\n') break;
                expandedToken.setLength(expandedToken.length() - 1);
                --expandedOffsetShift;
                break;
            }
        }
        tt.appendInterval(docTokenEndOffset - docTokenStartOffset, expandedToken.length(), true, expandedToken, paramsToExpansion);
        return expandedToken;
    }

    private APTToken skipMetaTokens(MyTokenSequence fileTS, APTToken prevFileToken) {
        if (APTUtils.isMacroExpandedToken((org.netbeans.modules.cnd.antlr.Token)prevFileToken) && APTUtils.isCommentToken((org.netbeans.modules.cnd.antlr.Token)prevFileToken)) {
            APTToken fileToken;
            do {
                fileTS.moveNext();
            } while (APTUtils.isMacroExpandedToken((org.netbeans.modules.cnd.antlr.Token)(fileToken = fileTS.token())) && APTUtils.isCommentToken((org.netbeans.modules.cnd.antlr.Token)fileToken) && prevFileToken.getOffset() < fileToken.getOffset() && prevFileToken.getEndOffset() > fileToken.getEndOffset());
            return fileToken;
        }
        fileTS.moveNext();
        return fileTS.token();
    }

    private void expandMacroToken(TokenSequence docTS, MyTokenSequence fileTS, TransformationTable tt, StringBuilder expandedData, Formatter formatter) {
        this.expandMacroToken(docTS.token(), docTS.offset(), fileTS, tt, expandedData, formatter);
    }

    private void expandMacroToken(Token docToken, int docTokenStartOffset, MyTokenSequence fileTS, TransformationTable tt, StringBuilder expandedData, Formatter formatter) {
        CharSequence expandedToken = this.expandMacroToken(fileTS, docTokenStartOffset, docTokenStartOffset + docToken.length(), tt, formatter);
        this.addString(expandedToken, expandedData);
    }

    private void expandIcludeToken(TokenSequence<TokenId> docTS, Document inDoc, CsmFile file, TransformationTable tt, StringBuilder expandedData) {
        int incStartOffset = docTS.offset();
        String includeName = this.getIncludeName(file, incStartOffset);
        if (includeName == null) {
            return;
        }
        int incNameStartOffset = incStartOffset;
        int incNameEndOffset = incStartOffset;
        Token docToken = docTS.token();
        TokenId id = docToken.id();
        if (id instanceof CppTokenId) {
            block0 : switch ((CppTokenId)id) {
                case PREPROCESSOR_DIRECTIVE: {
                    TokenSequence embTS = docTS.embedded();
                    if (embTS == null) break;
                    embTS.moveStart();
                    if (!embTS.moveNext()) {
                        return;
                    }
                    Token embToken = embTS.token();
                    if (embToken == null || !(embToken.id() instanceof CppTokenId) || embToken.id() != CppTokenId.PREPROCESSOR_START && embToken.id() != CppTokenId.PREPROCESSOR_START_ALT) {
                        return;
                    }
                    if (!embTS.moveNext()) {
                        return;
                    }
                    this.skipWhitespacesAndComments(embTS);
                    embToken = embTS.token();
                    if (embToken == null || !(embToken.id() instanceof CppTokenId)) break;
                    switch ((CppTokenId)embToken.id()) {
                        case PREPROCESSOR_INCLUDE: {
                            if (!embTS.moveNext()) {
                                return;
                            }
                            this.skipWhitespacesAndComments(embTS);
                            incNameStartOffset = embTS.offset();
                            embToken = embTS.token();
                            while (embToken != null && embToken.id() instanceof CppTokenId && embToken.id() != CppTokenId.NEW_LINE) {
                                if (!embTS.moveNext()) {
                                    return;
                                }
                                incNameEndOffset = embTS.offset();
                                this.skipWhitespacesAndComments(embTS);
                                embToken = embTS.token();
                            }
                            break block0;
                        }
                        default: {
                            return;
                        }
                    }
                }
                default: {
                    return;
                }
            }
        }
        this.copyInterval(inDoc, incNameStartOffset - incStartOffset, tt, expandedData);
        int expandedLength = this.addString(includeName, expandedData);
        tt.appendInterval(incNameEndOffset - incNameStartOffset, expandedLength);
    }

    private String getIncludeName(CsmFile file, int offset) {
        for (CsmInclude inc : file.getIncludes()) {
            if (inc.getStartOffset() != offset) continue;
            if (inc.isSystem()) {
                StringBuilder sb = new StringBuilder("<");
                sb.append(inc.getIncludeName().toString());
                sb.append(">");
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder("\"");
            sb.append(inc.getIncludeName().toString());
            sb.append("\"");
            return sb.toString();
        }
        return null;
    }

    private void skipWhitespacesAndComments(TokenSequence ts) {
        if (ts != null) {
            Token token = ts.token();
            block3: while (token != null && token.id() instanceof CppTokenId) {
                switch ((CppTokenId)token.id()) {
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: 
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case ESCAPED_LINE: {
                        ts.moveNext();
                        token = ts.token();
                        continue block3;
                    }
                }
                return;
            }
        }
    }

    private void initGuardedBlocks(Document doc, TransformationTable tt) {
        if (doc instanceof StyledDocument) {
            for (IntervalCorrespondence ic : tt.intervals) {
                if (!ic.isMacro()) continue;
                NbDocument.markGuarded((StyledDocument)((StyledDocument)doc), (int)ic.getOutIntervalStart(), (int)ic.getOutIntervalLength());
            }
        }
    }

    private int calcExpansionNumber(TransformationTable tt) {
        int expansionsNumber = 0;
        for (IntervalCorrespondence ic : tt.intervals) {
            if (!ic.isMacro()) continue;
            ++expansionsNumber;
        }
        return expansionsNumber;
    }

    private MyTokenSequence getFileTokenSequence(CsmFile file, int startOffset, int endOffset) {
        FileImpl fileImpl;
        TokenStream ts;
        if (file instanceof FileImpl && (ts = (fileImpl = (FileImpl)file).getTokenStream(startOffset, endOffset, 0, false)) != null) {
            return new MyTokenSequence(ts, fileImpl);
        }
        return null;
    }

    private void copyInterval(Document inDoc, int length, TransformationTable tt, StringBuilder expandedString) {
        if (length != 0) {
            this.addString(MacroExpansionDocProviderImpl.getDocumentText(inDoc, tt.currentIn.start, length), expandedString);
            tt.appendInterval(length, length);
        }
    }

    private static String getDocumentText(Document doc, int startOffset, int length) {
        try {
            int docLength = doc.getLength();
            startOffset = startOffset > 0 ? startOffset : 0;
            startOffset = startOffset < docLength ? startOffset : docLength;
            length = length > 0 ? length : 0;
            int n = length = startOffset + length <= docLength ? length : docLength - startOffset;
            if (length > 0) {
                return doc.getText(startOffset, length);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "";
    }

    private boolean isWhitespace(Token<TokenId> docToken) {
        TokenId id = docToken.id();
        if (id instanceof CppTokenId) {
            switch ((CppTokenId)id) {
                case WHITESPACE: 
                case ESCAPED_WHITESPACE: 
                case ESCAPED_LINE: 
                case NEW_LINE: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isOnInclude(TokenSequence<TokenId> docTS) {
        Token docToken = docTS.token();
        TokenId id = docToken.id();
        if (id instanceof CppTokenId) {
            switch ((CppTokenId)id) {
                case PREPROCESSOR_DIRECTIVE: {
                    TokenSequence embTS = docTS.embedded();
                    if (embTS == null) break;
                    embTS.moveStart();
                    if (!embTS.moveNext()) break;
                    Token embToken = embTS.token();
                    if (embToken == null || !(embToken.id() instanceof CppTokenId) || embToken.id() != CppTokenId.PREPROCESSOR_START && embToken.id() != CppTokenId.PREPROCESSOR_START_ALT) {
                        return false;
                    }
                    if (!embTS.moveNext()) break;
                    this.skipWhitespacesAndComments(embTS);
                    embToken = embTS.token();
                    if (embToken == null || !(embToken.id() instanceof CppTokenId)) break;
                    switch ((CppTokenId)embToken.id()) {
                        case PREPROCESSOR_INCLUDE: 
                        case PREPROCESSOR_INCLUDE_NEXT: {
                            return true;
                        }
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private int addString(CharSequence s, StringBuilder expandedString) {
        if (expandedString != null) {
            expandedString.append(s);
        }
        return s.length();
    }

    String dumpTables(Document doc) {
        StringBuilder sb = new StringBuilder();
        TransformationTable tt = this.getCachedMacroTable(doc);
        if (tt != null) {
            sb.append("MacroTable: ");
            sb.append(tt.toString());
        }
        if ((tt = this.getTransformationTable(doc)) != null) {
            sb.append("TransformationTable: ");
            sb.append(tt.toString());
        }
        return sb.toString();
    }

    private static Interval createInterval(int start, int end) {
        return new IntervalImpl(start, end);
    }

    private static IntervalCorrespondence createIntervalCorrespondence(int offset) {
        return new IntervalCorrespondenceSimpleCompact(offset, 0, 0);
    }

    private static IntervalCorrespondence createIntervalCorrespondence(int inStart, int inEnd, int outStart, int outEnd, boolean macro, CharSequence macroExpansion, Map<Interval, List<Interval>> paramsToExpansion) {
        int shift;
        int length;
        if (macro) {
            if (paramsToExpansion != null && paramsToExpansion.isEmpty()) {
                paramsToExpansion = Collections.emptyMap();
            }
            return new IntervalCorrespondenceMacro(inStart, inEnd, outStart, outEnd, macroExpansion, paramsToExpansion);
        }
        if (inEnd - inStart == outEnd - outStart && Short.MIN_VALUE < (length = inEnd - inStart) && length < Short.MAX_VALUE && Short.MIN_VALUE < (shift = outEnd - inEnd) && shift < Short.MAX_VALUE) {
            return new IntervalCorrespondenceSimpleCompact(inStart, (short)length, (short)shift);
        }
        return new IntervalCorrespondenceSimple(inStart, inEnd, outStart, outEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransformationTable getMacroTable(Document doc, CsmFile file, boolean updateIfNeeded) {
        TransformationTable tt;
        if (file == null || doc == null) {
            return null;
        }
        Formatter formatter = null;
        if (doc.getProperty("macro-expansion-view-document") != null) {
            formatter = new Formatter((BaseDocument)doc);
        }
        Object object = doc;
        synchronized (object) {
            tt = this.getCachedMacroTable(doc);
            if (tt == null) {
                tt = updateIfNeeded ? new TransformationTable(DocumentUtilities.getDocumentVersion((Document)doc), CsmFileInfoQuery.getDefault().getFileVersion(file)) : new TransformationTable(-1L, -1L);
                doc.putProperty(MACRO_EXPANSION_MACRO_TABLE, tt);
            }
        }
        if (!updateIfNeeded && tt.isInited()) {
            return tt;
        }
        object = tt;
        synchronized (object) {
            Document document = doc;
            synchronized (document) {
                tt = this.getCachedMacroTable(doc);
                if (updateIfNeeded && (tt.documentVersion != DocumentUtilities.getDocumentVersion((Document)doc) || tt.fileVersion != CsmFileInfoQuery.getDefault().getFileVersion(file))) {
                    tt = new TransformationTable(DocumentUtilities.getDocumentVersion((Document)doc), CsmFileInfoQuery.getDefault().getFileVersion(file));
                }
            }
            if (updateIfNeeded && !tt.isInited()) {
                this.expand(doc, file, tt, formatter);
                tt.cleanUp();
                document = doc;
                synchronized (document) {
                    doc.putProperty(MACRO_EXPANSION_MACRO_TABLE, tt);
                }
            }
        }
        return tt;
    }

    private static final class Formatter {
        private static final boolean MACRO_BASED_INDENTER = false;
        private final int tab;
        private final Engine engine;
        private int shift;
        private int line;
        private int indent;

        Formatter(BaseDocument document) {
            this.tab = document.getShiftWidth();
            this.engine = new TokenBasedFormatter();
        }

        private void init(APTToken fileToken) {
            this.shift = 0;
            this.indent = 0;
        }

        private Pair<? extends CharSequence, ? extends CharSequence> process(APTToken fileToken, MyTokenSequence fileTS) {
            return this.engine.process(fileToken, fileTS);
        }

        private final class TokenBasedFormatter
        implements Engine {
            private TokenBasedFormatter() {
            }

            @Override
            public Pair<? extends CharSequence, ? extends CharSequence> process(APTToken fileToken, MyTokenSequence fileTS) {
                boolean isMacroExpansionView = false;
                String macroViewClass = "org.netbeans.modules.cnd.navigation.macroview.impl.services.MacroExpansionViewProviderImpl";
                for (StackTraceElement stackElement : Thread.currentThread().getStackTrace()) {
                    if (!stackElement.getClassName().startsWith("org.netbeans.modules.cnd.navigation.macroview.impl.services.MacroExpansionViewProviderImpl")) continue;
                    isMacroExpansionView = true;
                    break;
                }
                Formatter.this.shift = isMacroExpansionView ? fileTS.file.getLineColumn(fileToken.getOffset())[1] : 0;
                switch (fileToken.getType()) {
                    case 16: {
                        int i;
                        Formatter.this.indent++;
                        StringBuilder suffix = new StringBuilder();
                        suffix.append('\n');
                        for (i = 1; i < Formatter.this.shift + Formatter.this.indent * Formatter.this.tab; ++i) {
                            suffix.append(' ');
                        }
                        return Pair.of(null, (Object)suffix);
                    }
                    case 17: {
                        APTToken next = fileTS.LA();
                        UndoIndent undo = null;
                        if (Formatter.this.indent > 0) {
                            undo = new UndoIndent(Formatter.this.tab);
                            Formatter.this.indent--;
                        }
                        if (next != null && next.getType() == 10) {
                            if (undo == null) {
                                return null;
                            }
                            return Pair.of((Object)undo, null);
                        }
                        StringBuilder suffix = new StringBuilder();
                        suffix.append('\n');
                        for (int i = 1; i < Formatter.this.shift + Formatter.this.indent * Formatter.this.tab; ++i) {
                            suffix.append(' ');
                        }
                        return Pair.of((Object)undo, (Object)suffix);
                    }
                    case 10: {
                        int i;
                        StringBuilder suffix = new StringBuilder();
                        suffix.append('\n');
                        for (i = 1; i < Formatter.this.shift + Formatter.this.indent * Formatter.this.tab; ++i) {
                            suffix.append(' ');
                        }
                        return Pair.of(null, (Object)suffix);
                    }
                    case 175: {
                        break;
                    }
                }
                return null;
            }
        }

        private final class MacroBasedFormatter
        implements Engine {
            private MacroBasedFormatter() {
            }

            @Override
            public Pair<? extends CharSequence, ? extends CharSequence> process(APTToken fileToken, MyTokenSequence fileTS) {
                int aLine = 0;
                int column = 0;
                if (APTUtils.isMacroExpandedToken((org.netbeans.modules.cnd.antlr.Token)fileToken) && !APTUtils.isMacroParamExpandedToken((org.netbeans.modules.cnd.antlr.Token)fileToken)) {
                    aLine = APTUtils.getExpandedToken((APTToken)fileToken).getLine();
                    column = APTUtils.getExpandedToken((APTToken)fileToken).getColumn();
                }
                StringBuilder prefix = null;
                if (aLine > 0) {
                    if (Formatter.this.line > 0 && aLine != Formatter.this.line) {
                        prefix = new StringBuilder();
                        prefix.append('\n');
                        if (column > 1) {
                            for (int i = 1; i < column; ++i) {
                                prefix.append(' ');
                            }
                        }
                    }
                    Formatter.this.line = aLine;
                }
                if (prefix == null) {
                    return null;
                }
                return Pair.of(prefix, null);
            }
        }

        private static interface Engine {
            public Pair<? extends CharSequence, ? extends CharSequence> process(APTToken var1, MyTokenSequence var2);
        }
    }

    private static final class UndoIndent
    implements CharSequence {
        private final int length;

        private UndoIndent(int length) {
            this.length = length;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return ' ';
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TransformationTable {
        private ArrayList<IntervalCorrespondence> intervals = new ArrayList();
        private Map<CharSequence, CharSequence> cache = new HashMap<CharSequence, CharSequence>();
        private final CurrentInterval currentIn = new CurrentInterval(0);
        private final CurrentInterval currentOut = new CurrentInterval(0);
        private final long documentVersion;
        private final long fileVersion;

        public TransformationTable(long documentVersion, long fileVersion) {
            this.documentVersion = documentVersion;
            this.fileVersion = fileVersion;
        }

        public void cleanUp() {
            this.cache = null;
        }

        public boolean isInited() {
            return this.cache == null;
        }

        public void setInStart(int start) {
            this.currentIn.init(start);
        }

        public void setOutStart(int start) {
            this.currentOut.init(start);
        }

        public void appendInterval(int inLength, int outLength) {
            this.appendInterval(inLength, outLength, false, null, null);
        }

        public void appendInterval(int inLength, int outLength, boolean macro, CharSequence macroExpansion, Map<Interval, List<Interval>> paramsToExpansion) {
            assert (this.cache != null);
            CharSequence cs = CharSequences.create((CharSequence)macroExpansion);
            CharSequence cachedCS = this.cache.get(cs);
            if (cachedCS != null) {
                cs = cachedCS;
            } else {
                this.cache.put(cs, cs);
            }
            this.currentIn.setLength(inLength);
            this.currentOut.setLength(outLength);
            this.intervals.add(MacroExpansionDocProviderImpl.createIntervalCorrespondence(this.currentIn.start, this.currentIn.end, this.currentOut.start, this.currentOut.end, macro, cs, paramsToExpansion));
            this.setInStart(this.currentIn.end);
            this.setOutStart(this.currentOut.end);
        }

        public int getOutOffset(int inOffset) {
            if (this.intervals.isEmpty()) {
                return inOffset;
            }
            if (this.intervals.get(0).getInIntervalStart() > inOffset) {
                int shift = this.intervals.get(0).getInIntervalStart() - inOffset;
                return this.intervals.get(0).getOutIntervalStart() - shift;
            }
            IntervalCorrespondence lastMacro = null;
            for (IntervalCorrespondence ic : this.intervals) {
                int shift;
                if (ic.getOutIntervalLength() != 0) {
                    lastMacro = null;
                }
                if (ic.isMacro()) {
                    lastMacro = ic;
                }
                if (!ic.inIntervalContains(inOffset)) continue;
                if (ic.getOutIntervalLength() == 0 && lastMacro != null) {
                    List<Interval> anIntervals = lastMacro.getIntervals();
                    for (int k = 0; k < anIntervals.size(); ++k) {
                        List<Interval> params;
                        Interval j;
                        Interval i = anIntervals.get(k);
                        if (!i.contains(inOffset)) continue;
                        int shift2 = inOffset - i.getStart();
                        if (shift2 >= (j = (params = lastMacro.getParamIntervals(k)).get(0)).length()) {
                            return j.getEnd();
                        }
                        return j.getStart() + shift2;
                    }
                }
                if ((shift = inOffset - ic.getInIntervalStart()) >= ic.getInIntervalLength() || shift >= ic.getOutIntervalLength()) {
                    return ic.getOutIntervalEnd();
                }
                if (ic.isMacro()) {
                    return ic.getOutIntervalStart();
                }
                return ic.getOutIntervalStart() + shift;
            }
            int shift = inOffset - this.intervals.get(this.intervals.size() - 1).getInIntervalEnd();
            return this.intervals.get(this.intervals.size() - 1).getOutIntervalEnd() + shift;
        }

        public int getInOffset(int outOffset) {
            if (this.intervals.isEmpty()) {
                return outOffset;
            }
            if (this.intervals.get(0).getOutIntervalStart() > outOffset) {
                int shift = this.intervals.get(0).getOutIntervalStart() - outOffset;
                return this.intervals.get(0).getInIntervalStart() - shift;
            }
            for (IntervalCorrespondence ic : this.intervals) {
                int shift;
                if (!ic.outIntervalContains(outOffset)) continue;
                if (ic.isMacro()) {
                    List<Interval> anIntervals = ic.getIntervals();
                    for (int k = 0; k < anIntervals.size(); ++k) {
                        Interval i = anIntervals.get(k);
                        for (Interval j : ic.getParamIntervals(k)) {
                            if (!j.contains(outOffset)) continue;
                            int shift2 = outOffset - j.getStart();
                            if (shift2 >= i.length() || shift2 >= j.length()) {
                                return i.getEnd();
                            }
                            return i.getStart() + shift2;
                        }
                    }
                }
                if ((shift = outOffset - ic.getOutIntervalStart()) >= ic.getOutIntervalLength() || shift >= ic.getInIntervalLength()) {
                    return ic.getInIntervalEnd();
                }
                if (ic.isMacro()) {
                    return ic.getInIntervalStart();
                }
                return ic.getInIntervalStart() + shift;
            }
            int shift = outOffset - this.intervals.get(this.intervals.size() - 1).getOutIntervalEnd();
            return this.intervals.get(this.intervals.size() - 1).getInIntervalEnd() + shift;
        }

        public int getNextMacroExpansionStartOffset(int outOffset) {
            if (this.intervals.isEmpty()) {
                return outOffset;
            }
            for (IntervalCorrespondence ic : this.intervals) {
                if (ic.getOutIntervalStart() <= outOffset || !ic.isMacro()) continue;
                return ic.getOutIntervalStart();
            }
            return outOffset;
        }

        public int getPrevMacroExpansionStartOffset(int outOffset) {
            if (this.intervals.isEmpty()) {
                return outOffset;
            }
            int result = outOffset;
            for (IntervalCorrespondence ic : this.intervals) {
                if (ic.getOutIntervalEnd() >= outOffset) {
                    return result;
                }
                if (!ic.isMacro()) continue;
                result = ic.getOutIntervalStart();
            }
            return outOffset;
        }

        public int findInIntervalIndex(int offset) {
            return Collections.binarySearch(this.intervals, MacroExpansionDocProviderImpl.createIntervalCorrespondence(offset), new Comparator<IntervalCorrespondence>(){

                @Override
                public int compare(IntervalCorrespondence o1, IntervalCorrespondence o2) {
                    if (o1.getInIntervalEnd() < o2.getInIntervalStart()) {
                        return -1;
                    }
                    if (o1.getInIntervalStart() > o2.getInIntervalEnd()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("");
            for (IntervalCorrespondence ic : this.intervals) {
                sb.append("[").append(ic.getInIntervalStart()).append(",").append(ic.getInIntervalEnd()).append("] => [").append(ic.getOutIntervalStart()).append(",").append(ic.getOutIntervalEnd()).append("]\n");
            }
            return sb.toString();
        }
    }

    private static class IntervalCorrespondenceMacro
    extends IntervalCorrespondenceSimple {
        private final CharSequence macroExpansion;
        private final List<Interval> keys;
        private final List<List<Interval>> values;

        private IntervalCorrespondenceMacro(int inStart, int inEnd, int outStart, int outEnd, CharSequence macroExpansion, Map<Interval, List<Interval>> paramsToExpansion) {
            super(inStart, inEnd, outStart, outEnd);
            this.macroExpansion = macroExpansion;
            if (paramsToExpansion.isEmpty()) {
                this.keys = Collections.emptyList();
                this.values = Collections.emptyList();
            } else {
                this.keys = new ArrayList<Interval>(paramsToExpansion.size());
                this.values = new ArrayList<List<Interval>>(paramsToExpansion.size());
                for (Map.Entry<Interval, List<Interval>> in : paramsToExpansion.entrySet()) {
                    this.keys.add(in.getKey());
                    List<Interval> value = in.getValue();
                    if (value instanceof ArrayList) {
                        ((ArrayList)value).trimToSize();
                    }
                    this.values.add(value);
                }
            }
        }

        @Override
        public CharSequence getMacroExpansion() {
            return this.macroExpansion;
        }

        @Override
        public boolean isMacro() {
            return true;
        }

        @Override
        public List<Interval> getIntervals() {
            return this.keys;
        }

        @Override
        public List<Interval> getParamIntervals(int i) {
            return this.values.get(i);
        }
    }

    private static class IntervalCorrespondenceSimpleCompact
    extends IntervalCorrespondence {
        private final int offset;
        private final short length;
        private final short shift;

        public IntervalCorrespondenceSimpleCompact(int offset, short length, short shift) {
            this.offset = offset;
            this.length = length;
            this.shift = shift;
        }

        @Override
        public int getInIntervalStart() {
            return this.offset;
        }

        @Override
        public int getInIntervalEnd() {
            return this.offset + this.length;
        }

        @Override
        public int getInIntervalLength() {
            return this.length;
        }

        @Override
        public boolean inIntervalContains(int offset) {
            return this.getInIntervalStart() <= offset && this.getInIntervalEnd() >= offset;
        }

        @Override
        public int getOutIntervalStart() {
            return this.offset + this.shift;
        }

        @Override
        public int getOutIntervalEnd() {
            return this.offset + this.shift + this.length;
        }

        @Override
        public int getOutIntervalLength() {
            return this.length;
        }

        @Override
        public boolean outIntervalContains(int offset) {
            return this.getOutIntervalStart() <= offset && this.getOutIntervalEnd() >= offset;
        }
    }

    private static class IntervalCorrespondenceSimple
    extends IntervalCorrespondence {
        private final int inStart;
        private final int inEnd;
        private final int outStart;
        private final int outEnd;

        public IntervalCorrespondenceSimple(int inStart, int inEnd, int outStart, int outEnd) {
            this.inStart = inStart;
            this.inEnd = inEnd;
            this.outStart = outStart;
            this.outEnd = outEnd;
        }

        @Override
        public int getInIntervalStart() {
            return this.inStart;
        }

        @Override
        public int getInIntervalEnd() {
            return this.inEnd;
        }

        @Override
        public int getInIntervalLength() {
            return this.inEnd - this.inStart;
        }

        @Override
        public boolean inIntervalContains(int offset) {
            return this.getInIntervalStart() <= offset && this.getInIntervalEnd() >= offset;
        }

        @Override
        public int getOutIntervalStart() {
            return this.outStart;
        }

        @Override
        public int getOutIntervalEnd() {
            return this.outEnd;
        }

        @Override
        public int getOutIntervalLength() {
            return this.outEnd - this.outStart;
        }

        @Override
        public boolean outIntervalContains(int offset) {
            return this.getOutIntervalStart() <= offset && this.getOutIntervalEnd() >= offset;
        }
    }

    private static abstract class IntervalCorrespondence {
        private IntervalCorrespondence() {
        }

        public abstract int getInIntervalStart();

        public abstract int getInIntervalEnd();

        public abstract int getInIntervalLength();

        public abstract boolean inIntervalContains(int var1);

        public abstract int getOutIntervalStart();

        public abstract int getOutIntervalEnd();

        public abstract int getOutIntervalLength();

        public abstract boolean outIntervalContains(int var1);

        public boolean isMacro() {
            return false;
        }

        public CharSequence getMacroExpansion() {
            return null;
        }

        public List<Interval> getIntervals() {
            return null;
        }

        public List<Interval> getParamIntervals(int i) {
            return null;
        }

        public String toString() {
            return "IN:[" + this.getInIntervalStart() + "-" + this.getInIntervalEnd() + "]" + " OUT:" + "[" + this.getOutIntervalStart() + "-" + this.getOutIntervalEnd() + "]";
        }
    }

    private static class CurrentInterval {
        private int start;
        private int end;

        public CurrentInterval(int start) {
            this.start = start;
            this.end = start;
        }

        public void init(int start) {
            this.start = start;
            this.end = start;
        }

        public void setLength(int length) {
            this.end = this.start + length;
        }

        public String toString() {
            return "[" + this.start + "-" + this.end + "]";
        }
    }

    private static class IntervalImpl
    implements Interval {
        private final int start;
        private final int end;

        public IntervalImpl(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public int length() {
            return this.getEnd() - this.getStart();
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public boolean contains(int offset) {
            return this.getStart() <= offset && this.getEnd() >= offset;
        }

        public boolean equals(Object o) {
            if (o instanceof Interval) {
                Interval i = (Interval)o;
                return this.getStart() == i.getStart() && this.getEnd() == i.getEnd();
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + this.getStart();
            hash = 79 * hash + this.getEnd();
            return hash;
        }

        public String toString() {
            return "[" + this.getStart() + "-" + this.getEnd() + "]";
        }
    }

    private static interface Interval {
        public boolean contains(int var1);

        public int getEnd();

        public int getStart();

        public int length();
    }

    private static final class MyTokenSequence {
        private final TokenStream ts;
        private final FileImpl file;
        private APTToken currentToken = null;
        private APTToken LAToken;

        public MyTokenSequence(TokenStream ts, FileImpl file) {
            this.ts = ts;
            this.file = file;
            try {
                this.currentToken = (APTToken)ts.nextToken();
                if (this.currentToken != null) {
                    this.LAToken = (APTToken)ts.nextToken();
                }
            }
            catch (TokenStreamException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public APTToken token() {
            return this.currentToken;
        }

        public void moveNext() {
            try {
                this.currentToken = this.LAToken;
                if (this.currentToken != null) {
                    this.LAToken = (APTToken)this.ts.nextToken();
                }
            }
            catch (TokenStreamException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public APTToken LA() {
            return this.LAToken;
        }
    }
}

