/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser;

import java.util.ArrayList;
import java.util.Stack;
import org.antlr.runtime.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageSupport;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.modelimpl.parser.FortranParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.FortranToken;
import org.netbeans.modules.cnd.modelimpl.parser.FortranTokenStream;

public class FortranLexicalPrepass {
    private FortranTokenStream tokens;
    private Stack<Token> doLabels;
    private int sourceForm;

    public FortranLexicalPrepass(FortranTokenStream tokens) {
        this.tokens = tokens;
        this.doLabels = new Stack();
    }

    public void setSourceForm(int sourceForm) {
        this.sourceForm = sourceForm;
    }

    private boolean isAssignment(int start, int end) {
        return this.tokens.getToken(start).getType() == 476 && start + 3 < end && this.tokens.getToken(start + 1).getType() == 386 && this.tokens.getToken(start + 2).getType() == 346;
    }

    private boolean isOperator(int start, int end) {
        return this.tokens.getToken(start).getType() == 358 && start + 3 < end && this.tokens.getToken(start + 1).getType() == 386 && this.tokens.getToken(start + 2).getType() == 297 && this.tokens.getToken(start + 3).getType() == 339;
    }

    private void convertToIdents(int start, int end) {
        for (int i = start; i < end; ++i) {
            Token tmpToken = this.tokens.getToken(i);
            if (tmpToken != null) {
                if (!FortranLexer.isKeyword(tmpToken) || this.isAssignment(i, end) || this.isOperator(i, end)) continue;
                tmpToken.setType(281);
                continue;
            }
            System.out.println("convertToIdents(): couldn't retrieve token");
            System.out.println("start: " + start + " end: " + end + " i: " + i);
            this.tokens.printCurrLine();
        }
    }

    public int salesScanForToken(int start, int desiredToken) {
        int tmpToken;
        int lookAhead = 0;
        if (this.tokens.currLineLA(1) == 411) {
            return -1;
        }
        lookAhead = start;
        do {
            int parenOffset;
            if ((tmpToken = this.tokens.currLineLA(++lookAhead)) == 386 || tmpToken == 438) {
                parenOffset = this.tokens.findToken(lookAhead - 1, 386);
                ++parenOffset;
                if ((lookAhead = this.matchClosingParen(start, lookAhead)) < 1) break;
                tmpToken = this.tokens.currLineLA(lookAhead);
                continue;
            }
            if (tmpToken != 375) continue;
            parenOffset = this.tokens.findToken(lookAhead - 1, 375);
            if ((lookAhead = this.matchClosingParen(lookAhead + 1, parenOffset += 2)) < 1) break;
            tmpToken = this.tokens.currLineLA(lookAhead);
        } while (tmpToken != -1 && tmpToken != 287 && tmpToken != desiredToken);
        if (tmpToken == desiredToken) {
            return lookAhead - 1;
        }
        return -1;
    }

    private boolean matchIfConstStmt(int lineStart, int lineEnd) {
        int rparenOffset = -1;
        int commaOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 310 && this.tokens.currLineLA(lineStart + 2) == 386) {
            rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 2);
            commaOffset = this.salesScanForToken(rparenOffset + 1, 423);
            if (rparenOffset == -1) {
                System.err.println("Error in IF stmt at line: " + this.tokens.getToken(0).getLine());
                return false;
            }
            if (this.tokens.currLineLA(rparenOffset + 1) == 311) {
                this.convertToIdents(lineStart + 1, rparenOffset);
                return true;
            }
            if (commaOffset != -1 && this.tokens.currLineLA(rparenOffset + 1) == 349) {
                this.convertToIdents(lineStart + 1, rparenOffset);
                this.tokens.addToken(lineStart, 373, "__T_ARITHMETIC_IF_STMT__");
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean matchElseStmt(int lineStart, int lineEnd) {
        boolean isElseIf = false;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 383) {
            if (lineEnd >= 2) {
                if (this.tokens.currLineLA(lineStart + 2) == 321) {
                    this.convertToIdents(lineStart + 2, lineEnd);
                } else {
                    isElseIf = this.matchIfConstStmt(lineStart + 1, lineEnd);
                }
            }
            return true;
        }
        return false;
    }

    private boolean matchDataDecl(int lineStart, int lineEnd) {
        int tokenType = this.tokens.currLineLA(1);
        if (this.isIntrinsicType(tokenType) || this.isPrefixToken(tokenType) || (tokenType == 463 || tokenType == 275) && this.tokens.currLineLA(lineStart + 2) == 386) {
            if (this.isSubDecl(lineStart, lineEnd)) {
                return false;
            }
            if (this.isFuncDecl(lineStart, lineEnd)) {
                this.fixupFuncDecl(lineStart, lineEnd);
            } else {
                this.fixupDataDecl(lineStart, lineEnd);
            }
            return true;
        }
        if (tokenType == 467) {
            this.fixupFuncDecl(lineStart, lineEnd);
            return true;
        }
        return false;
    }

    private boolean matchDerivedTypeStmt(int lineStart, int lineEnd) {
        Token identToken = null;
        if (this.tokens.currLineLA(lineStart + 1) == 463 && this.tokens.currLineLA(lineStart + 2) != 386) {
            int colonOffset = this.tokens.findToken(lineStart, 350);
            if (colonOffset != -1) {
                int identOffset = colonOffset + 1;
                this.convertToIdents(identOffset, lineEnd);
            } else {
                identToken = this.tokens.getToken(lineStart + 1);
                int identOffset = lineStart + 1;
                if (FortranLexer.isKeyword(identToken)) {
                    identToken.setType(281);
                }
                if (this.tokens.currLineLA(lineStart + 3) == 386) {
                    int rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 3) - 1;
                    if (this.isIntrinsicType(this.tokens.currLineLA(lineStart + 4))) {
                        this.fixupDeclTypeSpec(lineStart + 3, lineEnd);
                    } else {
                        this.convertToIdents(lineStart + 3, lineEnd);
                    }
                    if (lineEnd - 1 > rparenOffset + 1 && FortranLexer.isKeyword(this.tokens.currLineLA(rparenOffset + 2))) {
                        this.tokens.getToken(rparenOffset + 1).setType(281);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean matchSub(int lineStart, int lineEnd) {
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        int bindOffset = this.tokens.findToken(lineStart, 375);
        if (bindOffset != -1) {
            this.convertToIdents(lineStart + 1, bindOffset + lineStart);
        } else {
            this.convertToIdents(lineStart + 1, lineEnd);
        }
        return true;
    }

    private boolean matchEnd(int lineStart, int lineEnd) {
        boolean matchedEnd = false;
        boolean isEndDo = false;
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 304) {
            if (lineEnd > 2) {
                identOffset = this.tokens.currLineLA(lineStart + 2) == 271 ? lineStart + 3 : (this.tokens.currLineLA(lineStart + 2) == 282 ? this.matchGenericSpec(lineStart + 2, lineEnd) : lineStart + 2);
            }
            if (this.tokens.currLineLA(lineStart + 2) == 377) {
                isEndDo = true;
            }
            matchedEnd = true;
        } else if (tokenType == 341) {
            identOffset = lineStart + 2;
            matchedEnd = true;
        } else if (tokenType == 303) {
            identOffset = this.matchGenericSpec(lineStart + 1, lineEnd);
        } else {
            if (lineEnd > 1) {
                identOffset = lineStart + 1;
            }
            matchedEnd = true;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
        }
        if (isEndDo || tokenType == 453) {
            this.fixupLabeledEndDo(lineStart, lineEnd);
        }
        return matchedEnd;
    }

    private boolean matchModule(int lineStart, int lineEnd) {
        this.convertToIdents(lineStart + 1, lineEnd);
        return true;
    }

    private boolean matchBlockData(int lineStart, int lineEnd) {
        if (lineEnd < lineStart + 2) {
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 271) {
            if (this.tokens.currLineLA(lineStart + 2) == 319) {
                if (lineEnd >= lineStart + 3 && FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 3))) {
                    this.tokens.getToken(lineStart + 2).setType(281);
                }
                return true;
            }
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 329) {
            if (FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 2))) {
                this.tokens.getToken(lineStart + 1).setType(281);
            }
            return true;
        }
        return false;
    }

    private boolean matchUseStmt(int lineStart, int lineEnd) {
        Object onlyToken = null;
        int colonOffset = this.tokens.findToken(lineStart, 350);
        int identPos = colonOffset != -1 ? colonOffset + 1 : lineStart + 1;
        if (FortranLexer.isKeyword(this.tokens.currLineLA(identPos + 1))) {
            this.tokens.getToken(identPos).setType(281);
        }
        if (++identPos < lineEnd) {
            if (this.tokens.currLineLA(identPos + 1) == 423 && this.tokens.currLineLA(identPos + 2) == 447) {
                identPos += 3;
            }
            this.convertToIdents(identPos, lineEnd);
        }
        return true;
    }

    private boolean matchLabel(int lineStart, int lineEnd) {
        return this.tokens.currLineLA(1) == 349;
    }

    private boolean matchIdentColon(int lineStart, int lineEnd) {
        int secondToken = this.tokens.currLineLA(lineStart + 2);
        if (secondToken == 443) {
            if (FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 1))) {
                this.tokens.getToken(lineStart).setType(281);
            }
            return true;
        }
        return false;
    }

    private boolean matchProcStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        if (lineEnd < lineStart + 2) {
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 401 && this.tokens.currLineLA(lineStart + 2) != 386) {
            int colonOffset = -1;
            colonOffset = this.tokens.findToken(lineStart + 1, 350);
            identOffset = colonOffset != -1 ? colonOffset + 1 : lineStart + 1;
        } else if (this.tokens.currLineLA(lineStart + 1) == 390 && this.tokens.currLineLA(lineStart + 2) == 401) {
            if (lineEnd < lineStart + 4) {
                return false;
            }
            identOffset = lineStart + 2;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            return true;
        }
        return false;
    }

    private boolean matchProcDeclStmt(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 401) {
            int lParenOffset = lineStart + 1;
            int rParenOffset = this.matchClosingParen(lineStart, lParenOffset + 1);
            int colonOffset = this.tokens.findToken(rParenOffset + 1, 350);
            if (colonOffset != -1) {
                this.convertToIdents(colonOffset + 1, lineEnd);
            } else {
                this.convertToIdents(rParenOffset + 1, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchAttrStmt(int lineStart, int lineEnd) {
        int identOffset;
        block7: {
            block11: {
                int firstToken;
                block10: {
                    block9: {
                        int rParenOffset;
                        block8: {
                            identOffset = -1;
                            firstToken = this.tokens.currLineLA(lineStart + 1);
                            if (firstToken != 340) break block8;
                            int lParenOffset = this.tokens.findToken(lineStart + 1, 386);
                            identOffset = this.matchClosingParen(lineStart, lParenOffset + 1);
                            break block7;
                        }
                        if (firstToken != 375) break block9;
                        identOffset = rParenOffset = this.matchClosingParen(lineStart, lineStart + 2);
                        break block7;
                    }
                    if (firstToken != 459) break block10;
                    int lParenOffset = this.tokens.findToken(lineStart + 1, 386);
                    if (lParenOffset != -1) {
                        identOffset = lParenOffset;
                        lineEnd = this.matchClosingParen(lineStart, lParenOffset + 1);
                    }
                    break block7;
                }
                if (firstToken != 309) break block11;
                int lparenOffset = -1;
                int rparenOffset = -1;
                if (this.tokens.currLineLA(lineStart + 2) == 418) break block7;
                boolean nothingChanges = false;
                do {
                    if ((lparenOffset = this.tokens.findToken(lineStart, 386)) != -1) {
                        rparenOffset = this.matchClosingParen(lineStart, lparenOffset + 1);
                        for (int i = lparenOffset; i < rparenOffset; ++i) {
                            if (!FortranLexer.isKeyword(this.tokens.currLineLA(i + 1)) || this.tokens.currLineLA(i + 1) == 298 || this.tokens.currLineLA(i + 1) == 472) continue;
                            this.tokens.getToken(i).setType(281);
                        }
                        if (this.tokens.currLineLA(rparenOffset + 1) == 386) {
                            rparenOffset = this.matchClosingParen(lineStart, rparenOffset + 1);
                        }
                        lineStart = rparenOffset;
                        nothingChanges = false;
                        continue;
                    }
                    if (nothingChanges) break block7;
                    nothingChanges = true;
                } while (lineStart < lineEnd && this.tokens.currLineLA(lineStart + 1) != 287);
                break block7;
                {
                }
            }
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            return true;
        }
        return false;
    }

    private int matchClosingParen(int lineStart, int offset) {
        int tmpTokenType;
        int lookAhead = 0;
        int nestingLevel = 0;
        lookAhead = offset;
        nestingLevel = 1;
        do {
            if ((tmpTokenType = this.tokens.currLineLA(++lookAhead)) == 386 || tmpTokenType == 438) {
                ++nestingLevel;
                continue;
            }
            if (tmpTokenType != 339 && tmpTokenType != 385) continue;
            --nestingLevel;
        } while ((tmpTokenType != 287 && tmpTokenType != -1 || nestingLevel == 0) && (nestingLevel != 0 || tmpTokenType != 339 && tmpTokenType != 385 && tmpTokenType != 287 && tmpTokenType != -1));
        if (tmpTokenType == 339 || tmpTokenType == 385) {
            return lookAhead;
        }
        return -1;
    }

    private int fixupDeclTypeSpec(int lineStart, int lineEnd) {
        int kindOffsetEnd = -1;
        if (this.tokens.currLineLA(lineStart + 1) == 463 || this.tokens.currLineLA(lineStart + 1) == 275) {
            int rparenOffset = -1;
            if (this.tokens.currLineLA(lineStart + 2) != 386) {
                System.err.println("Derived type or Class declaration error!");
            }
            rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            this.convertToIdents(lineStart + 1, rparenOffset);
            return rparenOffset - 1;
        }
        if (this.tokens.currLineLA(lineStart + 2) == 386) {
            int kindTokenOffset = -1;
            int lenTokenOffset = -1;
            kindOffsetEnd = this.matchClosingParen(lineStart, this.tokens.findToken(lineStart, 386) + 1);
            kindTokenOffset = this.tokens.findToken(lineStart + 1, 298);
            lenTokenOffset = this.tokens.findToken(lineStart + 1, 472);
            this.convertToIdents(lineStart + 1, kindOffsetEnd);
            if (kindTokenOffset != -1 && kindTokenOffset < kindOffsetEnd && this.tokens.currLineLA(kindTokenOffset + 2) == 346) {
                this.tokens.getToken(kindTokenOffset).setType(298);
            }
            if (lenTokenOffset != -1 && lenTokenOffset < kindOffsetEnd && this.tokens.currLineLA(lenTokenOffset + 2) == 346) {
                this.tokens.getToken(lenTokenOffset).setType(472);
            }
            return kindOffsetEnd - 1;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 389) {
            ++lineStart;
        }
        return lineStart;
    }

    private void fixupDataDecl(int lineStart, int lineEnd) {
        int identOffset = this.tokens.findToken(lineStart = this.fixupDeclTypeSpec(lineStart, lineEnd), 350);
        identOffset = identOffset != -1 ? ++identOffset : lineStart + 1;
        this.convertToIdents(identOffset, lineEnd);
    }

    private void fixupFuncDecl(int lineStart, int lineEnd) {
        int newLineStart = 0;
        Token resultToken = null;
        Token bindToken = null;
        newLineStart = this.fixupDeclTypeSpec(lineStart, lineEnd);
        if (newLineStart != lineStart) {
            lineStart = newLineStart + 1;
        }
        int identOffset = this.tokens.findToken(lineStart, 467) + 1;
        int resultOffset = this.salesScanForToken(lineStart, 424);
        int bindOffset = this.salesScanForToken(lineStart, 375);
        if (resultOffset != -1) {
            resultToken = this.tokens.getToken(resultOffset);
        }
        if (bindOffset != -1) {
            bindToken = this.tokens.getToken(bindOffset);
        }
        this.convertToIdents(identOffset, lineEnd);
        if (resultToken != null) {
            resultToken.setType(424);
        }
        if (bindToken != null) {
            bindToken.setType(375);
        }
    }

    private boolean isIntrinsicType(int type) {
        return type == 393 || type == 399 || type == 389 || type == 307 || type == 444 || type == 369 || type == 426;
    }

    private int skipTypeSpec(int lineStart) {
        int rparenOffset = -1;
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (this.isIntrinsicType(firstToken) || firstToken == 463) {
            if (firstToken == 389) {
                ++lineStart;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 305 && this.tokens.currLineLA(lineStart + 3) == 349) {
                lineStart += 2;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 386) {
                rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            }
            lineStart = rparenOffset != -1 ? rparenOffset : ++lineStart;
            return lineStart;
        }
        return lineStart;
    }

    private int skipPrefix(int lineStart) {
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        lineStart = this.skipTypeSpec(lineStart);
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        return lineStart;
    }

    private boolean isPrefixToken(int token) {
        return token == 405 || token == 368 || token == 326;
    }

    private boolean isFuncDecl(int lineStart, int lineEnd) {
        return this.tokens.currLineLA((lineStart = this.skipPrefix(lineStart)) + 1) == 467 && (this.tokens.currLineLA(lineStart + 2) == 281 || FortranLexer.isKeyword(this.tokens.currLineLA(3)));
    }

    private boolean isSubDecl(int lineStart, int lineEnd) {
        return this.tokens.currLineLA((lineStart = this.skipPrefix(lineStart)) + 1) == 293 && (this.tokens.currLineLA(lineStart + 2) == 281 || FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 2)));
    }

    private boolean isValidDataEditDesc(String line, int lineIndex) {
        char secondChar = '\u0000';
        char firstChar = Character.toLowerCase(line.charAt(lineIndex));
        if (lineIndex < line.length() - 1) {
            secondChar = Character.toLowerCase(line.charAt(lineIndex + 1));
        }
        return firstChar == 'i' || firstChar == 'b' && secondChar != 'n' && secondChar != 'z' || firstChar == 'o' || firstChar == 'z' || firstChar == 'f' || firstChar == 'g' || firstChar == 'l' || firstChar == 'a' || firstChar == 'd' && (secondChar == 't' || this.isDigit(secondChar)) || firstChar == 'e' && (secondChar == 'n' || secondChar == 's' || this.isDigit(secondChar));
    }

    private int findFormatItemEnd(String line, int lineIndex) {
        char currChar;
        int lineLength = line.length();
        do {
            currChar = line.charAt(lineIndex);
        } while (++lineIndex < lineLength && currChar != ',' && currChar != ')' && currChar != '/' && currChar != ':');
        return lineIndex - 1;
    }

    private int matchVList(String line, int lineIndex) {
        int tmpLineIndex = lineIndex + 2;
        int lineLength = line.length();
        if (line.charAt(tmpLineIndex) == '\'' || line.charAt(tmpLineIndex) == '\"') {
            ++tmpLineIndex;
            while (line.charAt(tmpLineIndex) != '\'' && line.charAt(tmpLineIndex) != '\"' && tmpLineIndex < lineLength) {
                ++tmpLineIndex;
            }
        }
        if (tmpLineIndex == lineLength) {
            return lineIndex;
        }
        if (line.charAt(tmpLineIndex) == '\'' || line.charAt(tmpLineIndex) == '\"') {
            ++tmpLineIndex;
        }
        if (line.charAt(tmpLineIndex) == '(') {
            ++tmpLineIndex;
            while (tmpLineIndex < lineLength && Character.isDigit(line.charAt(tmpLineIndex))) {
                ++tmpLineIndex;
            }
            if (tmpLineIndex == lineLength) {
                return lineIndex;
            }
            if (line.charAt(tmpLineIndex) == ')') {
                return ++tmpLineIndex;
            }
            System.err.println("Error: Unable to match v-list in data-edit-desc!");
            return lineIndex;
        }
        return lineIndex;
    }

    private int getDataEditDesc(String line, int lineIndex, int lineEnd) {
        while (lineIndex < lineEnd && this.isDigit(line.charAt(lineIndex))) {
            ++lineIndex;
        }
        if (this.isValidDataEditDesc(line, lineIndex)) {
            if (Character.toLowerCase(line.charAt(lineIndex)) == 'd' && Character.toLowerCase(line.charAt(lineIndex + 1)) == 't') {
                lineIndex = this.matchVList(line, lineIndex);
            }
            return this.findFormatItemEnd(line, lineIndex);
        }
        return -1;
    }

    private boolean isDigit(char tmpChar) {
        return tmpChar >= '0' && tmpChar <= '9';
    }

    private boolean isLetter(char tmpChar) {
        return (tmpChar = Character.toLowerCase(tmpChar)) >= 'a' && tmpChar <= 'z';
    }

    private boolean isValidControlEditDesc(String line, int lineIndex) {
        char secondChar = '\u0000';
        char firstChar = Character.toLowerCase(line.charAt(lineIndex));
        if (lineIndex < line.length() - 1) {
            secondChar = Character.toLowerCase(line.charAt(lineIndex + 1));
        }
        if (firstChar == ':' || firstChar == '/' || firstChar == 'p' || firstChar == 't' || firstChar == 's' || firstChar == 'b' || firstChar == 'r' || firstChar == 'd' || firstChar == 'x') {
            if (firstChar == 's') {
                if (secondChar != 's' && secondChar != 'p' && Character.isLetterOrDigit(secondChar)) {
                    return false;
                }
                if (firstChar == 't' && !this.isDigit(secondChar) && secondChar != 'l' && secondChar != 'r') {
                    return false;
                }
                if (firstChar == 'b' && secondChar != 'n' && secondChar != 'z') {
                    return false;
                }
                if (firstChar == 'r' && secondChar != 'u' && secondChar != 'd' && secondChar != 'z' && secondChar != 'n' && secondChar != 'c' && secondChar != 'p') {
                    return false;
                }
                if (firstChar == 'd' && secondChar != 'c' && secondChar != 'p') {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private int getControlEditDesc(String line, int lineIndex, int lineLength) {
        while (lineIndex < lineLength && line.charAt(lineIndex) >= '0' && line.charAt(lineIndex) <= '9') {
            ++lineIndex;
        }
        if (this.isValidControlEditDesc(line, lineIndex)) {
            return this.findFormatItemEnd(line, lineIndex);
        }
        return -1;
    }

    private int getCharString(String line, int lineIndex, char quoteChar) {
        char nextChar;
        if ((nextChar = line.charAt(++lineIndex)) == '\'' || nextChar == '\"') {
            return this.getCharString(line, lineIndex, nextChar);
        }
        while ((nextChar = line.charAt(++lineIndex)) != '\'' && nextChar != '\"') {
        }
        return lineIndex;
    }

    private int getCharStringEditDesc(String line, int lineIndex, int lineLength) {
        int startIndex = lineIndex;
        while (lineIndex < lineLength && this.isDigit(line.charAt(lineIndex))) {
            ++lineIndex;
        }
        char quoteChar = Character.toLowerCase(line.charAt(lineIndex));
        if (quoteChar == 'h' && startIndex != lineIndex) {
            return Math.min(lineLength, lineIndex + Integer.parseInt(line.substring(startIndex, lineIndex)));
        }
        if (quoteChar != '\'' && quoteChar != '\"') {
            return -1;
        }
        lineIndex = this.getCharString(line, lineIndex, quoteChar);
        return this.findFormatItemEnd(line, lineIndex + 1);
    }

    private int parseFormatString(String line, int lineIndex, int lineNum, int charPos) {
        int descIndex = 0;
        boolean foundClosingParen = false;
        int lineLength = line.length();
        while (lineIndex < lineLength - 1 && !foundClosingParen) {
            descIndex = this.getCharStringEditDesc(line, lineIndex, lineLength);
            if (descIndex == -1) {
                descIndex = this.getDataEditDesc(line, lineIndex, lineLength);
                if (descIndex == -1) {
                    descIndex = this.getControlEditDesc(line, lineIndex, lineLength);
                    if (descIndex != -1 && (descIndex - lineIndex > 0 || line.charAt(descIndex) != '/')) {
                        this.tokens.addToken(this.tokens.createToken(294, line.substring(lineIndex, descIndex), lineNum, charPos));
                        charPos += line.substring(lineIndex, descIndex).length();
                    }
                } else {
                    this.tokens.addToken(this.tokens.createToken(363, line.substring(lineIndex, descIndex), lineNum, charPos));
                    charPos += line.substring(lineIndex, descIndex).length();
                }
            } else {
                this.tokens.addToken(this.tokens.createToken(301, line.substring(lineIndex, descIndex), lineNum, charPos));
                charPos += line.substring(lineIndex, descIndex).length();
            }
            if (descIndex != -1 || descIndex == -1 && !this.isDigit(line.charAt(lineIndex)) && line.charAt(lineIndex) != '(') {
                String termString = null;
                if (descIndex == -1) {
                    descIndex = lineIndex;
                }
                if (descIndex == line.length()) {
                    descIndex = line.length() - 1;
                }
                if (line.charAt(descIndex) == ',') {
                    termString = new String(",");
                    this.tokens.addToken(this.tokens.createToken(423, ",", lineNum, charPos));
                } else if (line.charAt(descIndex) == ')') {
                    this.tokens.addToken(this.tokens.createToken(339, ")", lineNum, charPos));
                } else {
                    termString = line.charAt(descIndex) == ':' ? new String(":") : (line.charAt(descIndex) == '/' ? new String("/") : null);
                    if (termString != null) {
                        this.tokens.addToken(this.tokens.createToken(294, termString, lineNum, charPos));
                    }
                }
                lineIndex = descIndex + 1;
            } else {
                int startIndex = lineIndex;
                while (lineIndex < lineLength && this.isDigit(line.charAt(lineIndex))) {
                    ++lineIndex;
                    ++charPos;
                }
                if (startIndex != lineIndex) {
                    this.tokens.addToken(this.tokens.createToken(349, line.substring(startIndex, lineIndex), lineNum, charPos - (lineIndex - startIndex)));
                }
                if (line.charAt(lineIndex) == '(') {
                    this.tokens.addToken(this.tokens.createToken(386, "(", lineNum, charPos));
                    descIndex = this.parseFormatString(line, ++lineIndex, lineNum, ++charPos);
                    if (descIndex == -1) {
                        System.err.println("Could not parse the format string: " + line);
                        return -1;
                    }
                    lineIndex = descIndex + 1;
                } else {
                    return -1;
                }
            }
            ++charPos;
        }
        if (lineIndex < lineLength && line.charAt(lineIndex) == ')') {
            this.tokens.addToken(this.tokens.createToken(339, ")", lineNum, charPos));
            ++lineIndex;
        }
        return lineIndex;
    }

    private int fixupFormatStmt(int lineStart, int lineEnd) {
        int lineIndex = 0;
        int i = 0;
        int lineLength = 0;
        int lineNum = 0;
        int charPos = 0;
        ArrayList<Token> origLine = new ArrayList<Token>();
        lineNum = this.tokens.getToken(lineStart).getLine();
        charPos = this.tokens.getToken(++lineStart).getCharPositionInLine();
        if (this.tokens.currLineLA(lineStart + 1) != 386) {
            return -1;
        }
        String line = this.tokens.lineToString(lineStart, lineEnd);
        origLine.addAll(this.tokens.getTokensList());
        this.tokens.clearTokensList();
        for (i = 0; i < lineStart; ++i) {
            this.tokens.addToken((Token)origLine.get(i));
        }
        lineIndex = 0;
        lineLength = line.length();
        lineIndex = this.parseFormatString(line, lineIndex, lineNum, charPos);
        this.tokens.addToken(this.tokens.createToken(287, "\n", lineNum, charPos + lineIndex));
        if (lineIndex == -1) {
            System.err.println("Error in format statement " + line + " at line " + lineNum);
            this.tokens.clearTokensList();
            for (i = 0; i < lineEnd; ++i) {
                this.tokens.addToken((Token)origLine.get(i));
            }
        }
        return lineIndex;
    }

    private boolean matchIOStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 291) {
            if (this.tokens.currLineLA(lineStart + 2) == 346) {
                return false;
            }
            identOffset = lineStart + 1;
        } else if (this.tokens.currLineLA(lineStart + 2) == 386) {
            identOffset = lineStart + 2;
            if (tokenType == 434) {
                int rparenOffset = -1;
                rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 2);
                if (rparenOffset != -1 && rparenOffset < lineEnd - 1 && this.tokens.currLineLA(rparenOffset + 1) != 287) {
                    this.tokens.addToken(lineStart, 364, "__T_INQUIRE_STMT_2__");
                    ++identOffset;
                }
            }
        } else if ((tokenType == 432 || tokenType == 372) && this.tokens.currLineLA(lineStart + 2) != 346) {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (tokenType == 415) {
                this.fixupFormatStmt(lineStart, lineEnd);
            }
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 349) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchProgramStmt(int lineStart, int lineEnd) {
        if (FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 2))) {
            this.tokens.getToken(lineStart + 1).setType(281);
        }
        return true;
    }

    private boolean labelsMatch(String label1, String label2) {
        return Integer.parseInt(label1) == Integer.parseInt(label2);
    }

    private void fixupLabeledEndDo(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(1) != 349) {
            return;
        }
        if (!this.doLabels.empty()) {
            String doLabelString = this.doLabels.peek().getText();
            Token firstToken = this.tokens.getToken(0);
            int endType = this.tokens.currLineLA(lineStart + 1);
            String labeledDoText = new String("LABELED_DO_TERM");
            if (this.labelsMatch(doLabelString, firstToken.getText())) {
                this.tokens.addToken(1, 398, labeledDoText);
                this.doLabels.pop();
                while (!this.doLabels.empty() && this.labelsMatch(this.doLabels.peek().getText(), firstToken.getText())) {
                    if (!(this.tokens.appendToken(349, new String(firstToken.getText())) && this.tokens.appendToken(398, labeledDoText) && this.tokens.appendToken(473, new String("CONTINUE")) && this.tokens.appendToken(287, null))) {
                        System.err.println("Couldn't add tokens!");
                        break;
                    }
                    this.doLabels.pop();
                }
            }
        }
    }

    private boolean matchActionStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 288) {
            if (this.tokens.currLineLA(lineStart + 2) != 359) {
                return false;
            }
            identOffset = lineStart + 2;
        } else if (tokenType == 392) {
            int colonOffset = -1;
            colonOffset = this.tokens.findToken(lineStart + 1, 350);
            if (colonOffset != -1) {
                this.tokens.addToken(lineStart, 292, "__T_ALLOCATE_STMT_1__");
                ++lineStart;
                identOffset = colonOffset + 2;
            } else {
                identOffset = lineStart + 1;
            }
        } else {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 349 && tokenType != 313) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchSingleTokenStmt(int lineStart, int lineEnd) {
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 449 || firstToken == 395 || firstToken == 419 || firstToken == 321 || firstToken == 457 || firstToken == 429 || firstToken == 333 || firstToken == 348 || firstToken == 331 || firstToken == 308 || firstToken == 275 && this.tokens.currLineLA(lineStart + 2) != 416 || firstToken == 282 || firstToken == 397 || firstToken == 336 || firstToken == 319) {
            if (firstToken == 333 || firstToken == 308 && this.tokens.currLineLA(lineStart + 2) == 416) {
                this.convertToIdents(lineStart + 2, lineEnd);
            } else if (firstToken == 282) {
                int identOffset = this.matchGenericSpec(lineStart + 1, lineEnd);
                if (identOffset != -1) {
                    this.convertToIdents(identOffset, lineEnd);
                }
            } else if (firstToken == 397) {
                if (lineStart + 3 < lineEnd) {
                    if (this.tokens.currLineLA(lineStart + 3) == 386) {
                        int resultLA = this.matchClosingParen(lineStart + 3, lineStart + 3);
                        this.convertToIdents(lineStart + 1, resultLA - 1);
                        if (this.tokens.currLineLA(resultLA) == 424) {
                            this.convertToIdents(resultLA, lineEnd);
                        }
                    }
                } else {
                    this.convertToIdents(lineStart + 1, lineEnd);
                }
            } else {
                this.convertToIdents(lineStart + 1, lineEnd);
            }
            if (firstToken == 321) {
                this.tokens.addToken(lineStart, 456, "__T_WHERE_CONSTRUCT_STMT__");
            } else if (firstToken == 429) {
                this.tokens.addToken(lineStart, 374, "__T_FORALL_CONSTRUCT_STMT__");
            }
            return true;
        }
        return false;
    }

    private boolean matchDoStmt(int lineStart, int lineEnd) {
        int whileOffset = -1;
        if (this.tokens.currLineLA(lineStart + 2) == 287) {
            return true;
        }
        if (this.tokens.currLineLA(lineStart + 2) == 349) {
            this.doLabels.push((Token)new FortranToken(this.tokens.getToken(lineStart + 1)));
        }
        if (this.tokens.currLineLA(lineStart + 3) == 287) {
            return true;
        }
        whileOffset = this.tokens.findToken(lineStart + 1, 433);
        int equalsOffset = this.salesScanForToken(lineStart + 1, 346);
        int identOffset = equalsOffset != -1 ? lineStart + 1 : whileOffset + 1;
        this.convertToIdents(identOffset, lineEnd);
        return true;
    }

    private boolean matchOneLineStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int rparenOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 321 || tokenType == 310 || tokenType == 429) {
            if (this.tokens.currLineLA(lineStart + 2) == 386) {
                identOffset = lineStart + 2;
                rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
                if (rparenOffset == -1) {
                    rparenOffset = lineEnd;
                }
                this.convertToIdents(identOffset, rparenOffset);
                if (!this.matchLine(rparenOffset, lineEnd)) {
                    this.matchAssignStmt(rparenOffset, lineEnd);
                }
                if (tokenType == 321) {
                    this.tokens.addToken(lineStart, 378, "__T_WHERE_STMT__");
                } else if (tokenType == 310) {
                    this.tokens.addToken(lineStart, 384, "__T_IF_STMT__");
                } else {
                    this.tokens.addToken(lineStart, 436, "__T_FORALL_STMT__");
                }
                if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 349) {
                    this.fixupLabeledEndDo(lineStart, lineEnd);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private int matchDataRef(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 281 || FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 1))) {
            if (this.tokens.currLineLA(lineStart + 2) == 386) {
                int tmpLineStart = this.matchClosingParen(lineStart, lineStart + 2);
                lineStart = tmpLineStart - 1;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 290) {
                return this.matchDataRef(lineStart + 2, lineEnd);
            }
            return lineStart;
        }
        return lineStart;
    }

    private boolean matchAssignStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int assignType = 0;
        if (lineEnd < lineStart + 3) {
            return false;
        }
        int newLineStart = this.matchDataRef(lineStart, lineEnd);
        if (this.tokens.currLineLA(newLineStart + 2) == 346 || this.tokens.currLineLA(newLineStart + 2) == 468) {
            identOffset = lineStart;
            assignType = this.tokens.currLineLA(newLineStart + 2);
        } else if (this.tokens.currLineLA(newLineStart + 2) == 386) {
            int rparenOffset = -1;
            rparenOffset = this.matchClosingParen(newLineStart, newLineStart + 2);
            if (this.tokens.currLineLA(rparenOffset + 1) == 346 || this.tokens.currLineLA(rparenOffset + 1) == 468) {
                identOffset = lineStart;
                assignType = this.tokens.currLineLA(rparenOffset + 1);
            }
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (assignType == 346) {
                this.tokens.addToken(lineStart, 342, "__T_ASSIGNMENT_STMT__");
            } else if (assignType == 468) {
                this.tokens.addToken(lineStart, 462, "__T_PTR_ASSIGNMENT_STMT__");
            }
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 349) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private int matchGenericSpec(int lineStart, int lineEnd) {
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 358 || firstToken == 476) {
            return lineStart + 1;
        }
        if (firstToken == 391 || firstToken == 316) {
            if (this.tokens.currLineLA(lineStart + 2) != 386) {
                return -1;
            }
            int rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            return rparenOffset + 1;
        }
        return lineStart;
    }

    private boolean matchGenericBinding(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 325) {
            int colonOffset = this.salesScanForToken(lineStart + 1, 350);
            if (colonOffset == -1) {
                return false;
            }
            int nextToken = this.tokens.currLineLA(colonOffset + 2);
            if (nextToken == 358 || nextToken == 476) {
                this.convertToIdents(colonOffset + 2, lineEnd);
            } else if (nextToken == 391 || nextToken == 316) {
                int nextTokenLA = colonOffset + 2;
                if (this.tokens.currLineLA(nextTokenLA + 1) != 386) {
                    return false;
                }
                int rparenOffset = this.matchClosingParen(lineStart, nextTokenLA + 1);
                this.convertToIdents(rparenOffset + 1, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchLine(int lineStart, int lineEnd) {
        if (this.matchDataDecl(lineStart, lineEnd)) {
            return true;
        }
        if (this.matchDerivedTypeStmt(lineStart, lineEnd)) {
            return true;
        }
        switch (this.tokens.currLineLA(lineStart + 1)) {
            case 293: 
            case 326: 
            case 368: 
            case 405: {
                return this.matchSub(lineStart, lineEnd);
            }
            case 279: 
            case 303: 
            case 304: 
            case 314: 
            case 322: 
            case 341: 
            case 345: 
            case 360: 
            case 376: 
            case 381: 
            case 404: 
            case 413: 
            case 425: 
            case 453: 
            case 454: 
            case 455: 
            case 469: {
                return this.matchEnd(lineStart, lineEnd);
            }
            case 401: {
                if (this.matchProcStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchProcDeclStmt(lineStart, lineEnd);
            }
            case 390: {
                if (this.matchProcStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchModule(lineStart, lineEnd);
            }
            case 271: 
            case 329: {
                return this.matchBlockData(lineStart, lineEnd);
            }
            case 337: {
                return this.matchUseStmt(lineStart, lineEnd);
            }
            case 380: {
                return this.matchProgramStmt(lineStart, lineEnd);
            }
            case 283: 
            case 286: 
            case 288: 
            case 299: 
            case 313: 
            case 356: 
            case 371: 
            case 382: 
            case 392: 
            case 400: 
            case 465: 
            case 473: 
            case 477: {
                return this.matchActionStmt(lineStart, lineEnd);
            }
            case 310: {
                if (this.matchIfConstStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchOneLineStmt(lineStart, lineEnd);
            }
            case 383: {
                if (this.matchElseStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchSingleTokenStmt(lineStart, lineEnd);
            }
            case 377: {
                return this.matchDoStmt(lineStart, lineEnd);
            }
            case 270: 
            case 291: 
            case 316: 
            case 354: 
            case 372: 
            case 391: 
            case 415: 
            case 432: 
            case 434: {
                return this.matchIOStmt(lineStart, lineEnd);
            }
            case 295: 
            case 302: 
            case 306: 
            case 309: 
            case 312: 
            case 340: 
            case 375: 
            case 379: 
            case 388: 
            case 408: 
            case 422: 
            case 427: 
            case 430: 
            case 439: 
            case 440: 
            case 448: 
            case 452: 
            case 459: 
            case 460: {
                return this.matchAttrStmt(lineStart, lineEnd);
            }
        }
        return this.matchSingleTokenStmt(lineStart, lineEnd);
    }

    private void fixupFixedFormatLine(int lineStart, int lineEnd, boolean startsWithKeyword) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        if (startsWithKeyword) {
            Token token;
            do {
                System.out.println("fixed-format line must start with keyword");
                this.tokens.printPackedList();
                buffer = buffer.append(this.tokens.getToken(lineStart + i).getText());
                TokenStream ts = APTTokenStreamBuilder.buildTokenStream((String)buffer.toString().toUpperCase(), (String)"Fortran Language");
                ts = new APTCommentsFilter(ts);
                ts = APTLanguageSupport.getInstance().getFilter("Fortran Language").getFilteredStream(ts);
                FortranParserEx.MyTokenSource myLexer = new FortranParserEx.MyTokenSource(ts);
                token = myLexer.nextToken();
            } while (lineStart + ++i < lineEnd && !FortranLexer.isKeyword(token.getType()));
            if (lineStart + i == lineEnd) {
                System.err.println("Error: Expected keyword on line: " + token.getLine());
            } else {
                int j = 0;
                for (j = lineStart; j < lineStart + i; ++j) {
                    Token tmpToken = this.tokens.getToken(j);
                    tmpToken.setChannel(99);
                    this.tokens.set(j, tmpToken);
                }
                this.tokens.add(j, token);
            }
        } else {
            System.out.println("fixed-format line must NOT start with keyword");
        }
    }

    private int scanForRealConsts(int lineStart, int lineEnd) {
        for (int i = lineStart; i < lineEnd; ++i) {
            if (this.tokens.currLineLA(i + 1) == 412) {
                this.tokens.getToken(i).setType(410);
                continue;
            }
            if (this.tokens.currLineLA(i + 1) != 349 || i + 2 >= lineEnd || this.tokens.currLineLA(i + 2) != 396 && this.tokens.currLineLA(i + 2) != 412) continue;
            StringBuffer newTokenText = new StringBuffer();
            int line = this.tokens.getToken(i).getLine();
            int col = this.tokens.getToken(i).getCharPositionInLine();
            newTokenText.append(this.tokens.getToken(i).getText());
            newTokenText.append(this.tokens.getToken(i + 1).getText());
            if (this.sourceForm != 2 && col + this.tokens.getToken(i).getText().length() != this.tokens.getToken(i + 1).getCharPositionInLine()) {
                System.err.println("Error: Whitespace within real constant at {line:col}: " + line + ":" + (col + 1));
            }
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.add(i, this.tokens.createToken(410, newTokenText.toString(), line, col));
            --lineEnd;
        }
        return lineEnd;
    }

    private int scanForRelationalOp(int lineStart, int lineEnd) {
        for (int i = lineStart; i < lineEnd; ++i) {
            int type;
            if (i + 2 >= lineEnd) {
                return lineEnd;
            }
            if (this.tokens.currLineLA(i + 1) != 396 || this.tokens.currLineLA(i + 2) != 281 || this.tokens.currLineLA(i + 3) != 396) continue;
            int line = this.tokens.getToken(i).getLine();
            int col = this.tokens.getToken(i).getCharPositionInLine();
            String text = this.tokens.getToken(i + 1).getText();
            if (text.compareToIgnoreCase("EQ") == 0) {
                type = 361;
            } else if (text.compareToIgnoreCase("NE") == 0) {
                type = 407;
            } else if (text.compareToIgnoreCase("GT") == 0) {
                type = 280;
            } else if (text.compareToIgnoreCase("GE") == 0) {
                type = 272;
            } else if (text.compareToIgnoreCase("LT") == 0) {
                type = 466;
            } else {
                if (text.compareToIgnoreCase("LE") != 0) continue;
                type = 471;
            }
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.add(i, this.tokens.createToken(type, "." + text + ".", line, col));
            lineEnd -= 2;
        }
        return lineEnd;
    }

    public void performPrepass() {
        int tokensStart;
        int commaIndex = -1;
        int equalsIndex = -1;
        int lineLength = 0;
        int newLineLength = 0;
        Token eof = null;
        if (this.sourceForm == 2) {
            tokensStart = this.tokens.mark();
            this.tokens.fixupFixedFormat();
            this.tokens.rewind(tokensStart);
        }
        if ((tokensStart = this.tokens.mark()) != -1) {
            this.tokens.seek(-1);
            tokensStart = -1;
        }
        while (this.tokens.LA(1) != -1) {
            commaIndex = -1;
            equalsIndex = -1;
            int lineStart = 0;
            int rawLineStart = this.tokens.mark();
            this.tokens.setCurrLine(rawLineStart);
            lineLength = this.tokens.getCurrLineLength();
            int rawLineEnd = this.tokens.findTokenInSuper(rawLineStart, 287);
            if (rawLineEnd == -1) {
                rawLineEnd = this.tokens.getRawLineLength();
            }
            rawLineEnd += rawLineStart;
            if (this.tokens.currLineLA(1) == 285) {
                ++lineStart;
            }
            if (this.matchLabel(lineStart, lineLength)) {
                ++lineStart;
            }
            if (this.matchIdentColon(lineStart, lineLength)) {
                lineStart += 2;
            }
            if ((newLineLength = this.scanForRealConsts(lineStart, lineLength)) != lineLength) {
                lineLength = newLineLength;
            }
            if (this.sourceForm == 2 && (newLineLength = this.scanForRelationalOp(lineStart, lineLength)) != lineLength) {
                lineLength = newLineLength;
            }
            if ((commaIndex = this.salesScanForToken(lineStart, 423)) != -1) {
                this.matchLine(lineStart, lineLength);
            } else {
                equalsIndex = this.salesScanForToken(lineStart, 346);
                if (equalsIndex == -1) {
                    equalsIndex = this.salesScanForToken(lineStart, 468);
                }
                if (equalsIndex != -1) {
                    if (!(this.matchOneLineStmt(lineStart, lineLength) || this.matchProcStmt(lineStart, lineLength) || this.matchAssignStmt(lineStart, lineLength) || this.matchDataDecl(lineStart, lineLength) || this.matchGenericBinding(lineStart, lineLength))) {
                        System.err.println("Couldn't match line!");
                    }
                } else if (!this.matchLine(lineStart, lineLength)) {
                    this.matchOneLineStmt(lineStart, lineLength);
                }
            }
            for (int i = rawLineStart; i < rawLineEnd; ++i) {
                this.tokens.consume();
            }
            this.tokens.finalizeLine();
        }
        eof = this.tokens.LT(1);
        eof.setText("EOF");
        this.tokens.addTokenToNewList(eof);
        this.tokens.rewind(tokensStart);
    }

    private static class FortranLexer {
        public static final int EOF = -1;
        public static final int NULL_TREE_LOOKAHEAD = 3;
        public static final int ELLIPSIS = 4;
        public static final int DOT = 5;
        public static final int ASSIGNEQUAL = 6;
        public static final int COLON = 7;
        public static final int COMMA = 8;
        public static final int QUESTIONMARK = 9;
        public static final int SEMICOLON = 10;
        public static final int POINTERTO = 11;
        public static final int LPAREN = 12;
        public static final int RPAREN = 13;
        public static final int LSQUARE = 14;
        public static final int RSQUARE = 15;
        public static final int LCURLY = 16;
        public static final int RCURLY = 17;
        public static final int EQUAL = 18;
        public static final int NOTEQUAL = 19;
        public static final int LESSTHANOREQUALTO = 20;
        public static final int LESSTHAN = 21;
        public static final int GREATERTHANOREQUALTO = 22;
        public static final int GREATERTHAN = 23;
        public static final int DIVIDE = 24;
        public static final int DIVIDEEQUAL = 25;
        public static final int PLUS = 26;
        public static final int PLUSEQUAL = 27;
        public static final int PLUSPLUS = 28;
        public static final int MINUS = 29;
        public static final int MINUSEQUAL = 30;
        public static final int MINUSMINUS = 31;
        public static final int STAR = 32;
        public static final int TIMESEQUAL = 33;
        public static final int MOD = 34;
        public static final int MODEQUAL = 35;
        public static final int SHIFTRIGHT = 36;
        public static final int SHIFTRIGHTEQUAL = 37;
        public static final int SHIFTLEFT = 38;
        public static final int SHIFTLEFTEQUAL = 39;
        public static final int AND = 40;
        public static final int NOT = 41;
        public static final int OR = 42;
        public static final int AMPERSAND = 43;
        public static final int BITWISEANDEQUAL = 44;
        public static final int TILDE = 45;
        public static final int BITWISEOR = 46;
        public static final int BITWISEOREQUAL = 47;
        public static final int BITWISEXOR = 48;
        public static final int BITWISEXOREQUAL = 49;
        public static final int POINTERTOMBR = 50;
        public static final int DOTMBR = 51;
        public static final int SCOPE = 52;
        public static final int AT = 53;
        public static final int DOLLAR = 54;
        public static final int BACK_SLASH = 55;
        public static final int DEFINED = 56;
        public static final int DBL_SHARP = 57;
        public static final int SHARP = 58;
        public static final int FUN_LIKE_MACRO_LPAREN = 59;
        public static final int LAST_CONST_TEXT_TOKEN = 62;
        public static final int FLOATONE = 63;
        public static final int FLOATTWO = 64;
        public static final int HEXADECIMALINT = 65;
        public static final int OCTALINT = 66;
        public static final int DECIMALINT = 67;
        public static final int Whitespace = 68;
        public static final int EndOfLine = 69;
        public static final int Skip = 70;
        public static final int PreProcComment = 71;
        public static final int PPLiterals = 72;
        public static final int Space = 73;
        public static final int PreProcBlockComment = 74;
        public static final int PreProcLineComment = 75;
        public static final int Comment = 76;
        public static final int CPPComment = 77;
        public static final int CHAR_LITERAL = 78;
        public static final int STRING_LITERAL = 79;
        public static final int InterStringWhitespace = 80;
        public static final int StringPart = 81;
        public static final int Escape = 82;
        public static final int Digit = 83;
        public static final int Decimal = 84;
        public static final int LongSuffix = 85;
        public static final int UnsignedSuffix = 86;
        public static final int FloatSuffix = 87;
        public static final int Exponent = 88;
        public static final int Vocabulary = 89;
        public static final int NUMBER = 90;
        public static final int IDENT = 91;
        public static final int BINARYINT = 92;
        public static final int INCLUDE_STRING = 93;
        public static final int SYS_INCLUDE_STRING = 94;
        public static final int END_PREPROC_DIRECTIVE = 61;
        public static final int INCLUDE = 95;
        public static final int INCLUDE_NEXT = 96;
        public static final int DEFINE = 97;
        public static final int UNDEF = 98;
        public static final int IFDEF = 99;
        public static final int IFNDEF = 100;
        public static final int IF = 101;
        public static final int ELIF = 102;
        public static final int ELSE = 103;
        public static final int ENDIF = 104;
        public static final int PRAGMA = 105;
        public static final int LINE = 106;
        public static final int ERROR = 107;
        public static final int PREPROC_DIRECTIVE = 108;
        public static final int LITERAL_OPERATOR = 110;
        public static final int LITERAL_alignof = 111;
        public static final int LITERAL___alignof__ = 112;
        public static final int LITERAL_typeof = 113;
        public static final int LITERAL___typeof__ = 114;
        public static final int LITERAL___typeof = 115;
        public static final int LITERAL_template = 116;
        public static final int LITERAL_typedef = 117;
        public static final int LITERAL_enum = 118;
        public static final int LITERAL_namespace = 119;
        public static final int LITERAL_extern = 120;
        public static final int LITERAL_inline = 121;
        public static final int LITERAL__inline = 122;
        public static final int LITERAL___inline__ = 123;
        public static final int LITERAL___inline = 124;
        public static final int LITERAL_virtual = 125;
        public static final int LITERAL_explicit = 126;
        public static final int LITERAL_friend = 127;
        public static final int LITERAL__stdcall = 128;
        public static final int LITERAL___stdcall = 129;
        public static final int LITERAL_typename = 130;
        public static final int LITERAL_auto = 131;
        public static final int LITERAL_register = 132;
        public static final int LITERAL_static = 133;
        public static final int LITERAL_mutable = 134;
        public static final int LITERAL_const = 135;
        public static final int LITERAL___const__ = 136;
        public static final int LITERAL___const = 137;
        public static final int LITERAL_const_cast = 138;
        public static final int LITERAL_volatile = 139;
        public static final int LITERAL___volatile__ = 140;
        public static final int LITERAL___volatile = 141;
        public static final int LITERAL_char = 142;
        public static final int LITERAL_wchar_t = 143;
        public static final int LITERAL_bool = 144;
        public static final int LITERAL_short = 145;
        public static final int LITERAL_int = 146;
        public static final int LITERAL_long = 147;
        public static final int LITERAL_signed = 148;
        public static final int LITERAL___signed__ = 149;
        public static final int LITERAL___signed = 150;
        public static final int LITERAL_unsigned = 151;
        public static final int LITERAL___unsigned__ = 152;
        public static final int LITERAL_float = 153;
        public static final int LITERAL_double = 154;
        public static final int LITERAL_void = 155;
        public static final int LITERAL__declspec = 156;
        public static final int LITERAL___declspec = 157;
        public static final int LITERAL_class = 158;
        public static final int LITERAL_struct = 159;
        public static final int LITERAL_union = 160;
        public static final int LITERAL_this = 161;
        public static final int LITERAL_true = 162;
        public static final int LITERAL_false = 163;
        public static final int LITERAL_public = 164;
        public static final int LITERAL_protected = 165;
        public static final int LITERAL_private = 166;
        public static final int LITERAL_throw = 167;
        public static final int LITERAL_case = 168;
        public static final int LITERAL_default = 169;
        public static final int LITERAL_if = 170;
        public static final int LITERAL_else = 171;
        public static final int LITERAL_switch = 172;
        public static final int LITERAL_while = 173;
        public static final int LITERAL_do = 174;
        public static final int LITERAL_for = 175;
        public static final int LITERAL_goto = 176;
        public static final int LITERAL_continue = 177;
        public static final int LITERAL_break = 178;
        public static final int LITERAL_return = 179;
        public static final int LITERAL_try = 180;
        public static final int LITERAL_catch = 181;
        public static final int LITERAL_using = 182;
        public static final int LITERAL_export = 183;
        public static final int LITERAL_asm = 184;
        public static final int LITERAL__asm = 185;
        public static final int LITERAL___asm__ = 186;
        public static final int LITERAL___asm = 187;
        public static final int LITERAL_sizeof = 189;
        public static final int LITERAL_dynamic_cast = 190;
        public static final int LITERAL_static_cast = 191;
        public static final int LITERAL_reinterpret_cast = 192;
        public static final int LITERAL_new = 193;
        public static final int LITERAL__cdecl = 194;
        public static final int LITERAL___cdecl = 195;
        public static final int LITERAL__near = 196;
        public static final int LITERAL___near = 197;
        public static final int LITERAL__far = 198;
        public static final int LITERAL___far = 199;
        public static final int LITERAL___interrupt = 200;
        public static final int LITERAL_pascal = 201;
        public static final int LITERAL__pascal = 202;
        public static final int LITERAL___pascal = 203;
        public static final int LITERAL_delete = 204;
        public static final int LITERAL__int64 = 205;
        public static final int LITERAL___int64 = 206;
        public static final int LITERAL___w64 = 207;
        public static final int LITERAL___extension__ = 208;
        public static final int LITERAL___attribute__ = 209;
        public static final int LITERAL_restrict = 210;
        public static final int LITERAL___restrict = 211;
        public static final int LITERAL___complex__ = 212;
        public static final int LITERAL___imag = 213;
        public static final int LITERAL___real = 214;
        public static final int LITERAL___global = 215;
        public static final int LITERAL__Complex = 217;
        public static final int LITERAL___thread = 218;
        public static final int LITERAL___attribute = 219;
        public static final int LITERAL__Imaginary = 220;
        public static final int T_CLOSE = 270;
        public static final int T_BLOCK = 271;
        public static final int T_GE = 272;
        public static final int T_CONTAINS = 273;
        public static final int T_ABSTRACT = 274;
        public static final int T_CLASS = 275;
        public static final int T_NOPASS = 276;
        public static final int T_UNFORMATTED = 277;
        public static final int T_LESSTHAN = 278;
        public static final int T_ENDSUBROUTINE = 279;
        public static final int T_GT = 280;
        public static final int T_IDENT = 281;
        public static final int T_INTERFACE = 282;
        public static final int T_RETURN = 283;
        public static final int T_XYZ = 284;
        public static final int T_EOF = 285;
        public static final int T_CALL = 286;
        public static final int T_EOS = 287;
        public static final int T_GO = 288;
        public static final int T_AND = 289;
        public static final int T_PERCENT = 290;
        public static final int T_PRINT = 291;
        public static final int T_ALLOCATE_STMT_1 = 292;
        public static final int T_SUBROUTINE = 293;
        public static final int T_CONTROL_EDIT_DESC = 294;
        public static final int T_ENUMERATOR = 295;
        public static final int Alphanumeric_Character = 296;
        public static final int T_DEFINED_OP = 297;
        public static final int T_KIND = 298;
        public static final int T_STOP = 299;
        public static final int T_GREATERTHAN_EQ = 300;
        public static final int T_CHAR_STRING_EDIT_DESC = 301;
        public static final int T_ALLOCATABLE = 302;
        public static final int T_ENDINTERFACE = 303;
        public static final int T_END = 304;
        public static final int T_ASTERISK = 305;
        public static final int T_PRIVATE = 306;
        public static final int T_DOUBLEPRECISION = 307;
        public static final int T_CASE = 308;
        public static final int T_IMPLICIT = 309;
        public static final int T_IF = 310;
        public static final int T_THEN = 311;
        public static final int T_DIMENSION = 312;
        public static final int T_GOTO = 313;
        public static final int T_ENDMODULE = 314;
        public static final int T_IN = 315;
        public static final int T_WRITE = 316;
        public static final int T_FORMATTED = 317;
        public static final int WS = 318;
        public static final int T_DATA = 319;
        public static final int T_FALSE = 320;
        public static final int T_WHERE = 321;
        public static final int T_ENDIF = 322;
        public static final int T_SLASH = 323;
        public static final int SQ_Rep_Char = 324;
        public static final int T_GENERIC = 325;
        public static final int T_RECURSIVE = 326;
        public static final int DQ_Rep_Char = 327;
        public static final int T_ELSEIF = 328;
        public static final int T_BLOCKDATA = 329;
        public static final int OCTAL_CONSTANT = 330;
        public static final int T_SELECTTYPE = 331;
        public static final int T_MINUS = 332;
        public static final int T_SELECT = 333;
        public static final int T_FINAL = 334;
        public static final int T_UNDERSCORE = 335;
        public static final int T_IMPORT = 336;
        public static final int T_USE = 337;
        public static final int T_FILE = 338;
        public static final int T_RPAREN = 339;
        public static final int T_INTENT = 340;
        public static final int T_ENDBLOCK = 341;
        public static final int T_ASSIGNMENT_STMT = 342;
        public static final int T_PAUSE = 343;
        public static final int T_BACKSPACE = 344;
        public static final int T_ENDFILE = 345;
        public static final int T_EQUALS = 346;
        public static final int T_NON_INTRINSIC = 347;
        public static final int T_SELECTCASE = 348;
        public static final int T_DIGIT_STRING = 349;
        public static final int T_COLON_COLON = 350;
        public static final int T_NON_OVERRIDABLE = 351;
        public static final int Special_Character = 352;
        public static final int T_INCLUDE = 353;
        public static final int T_OPEN = 354;
        public static final int T_POWER = 355;
        public static final int T_ASSOCIATE = 356;
        public static final int T_CHAR_CONSTANT = 357;
        public static final int T_OPERATOR = 358;
        public static final int T_TO = 359;
        public static final int T_ENDASSOCIATE = 360;
        public static final int T_EQ = 361;
        public static final int T_GREATERTHAN = 362;
        public static final int T_DATA_EDIT_DESC = 363;
        public static final int T_INQUIRE_STMT_2 = 364;
        public static final int T_EQV = 365;
        public static final int HEX_CONSTANT = 366;
        public static final int Digit_String = 367;
        public static final int T_ELEMENTAL = 368;
        public static final int T_CHARACTER = 369;
        public static final int PREPROCESS_LINE = 370;
        public static final int T_NULLIFY = 371;
        public static final int T_REWIND = 372;
        public static final int T_ARITHMETIC_IF_STMT = 373;
        public static final int T_FORALL_CONSTRUCT_STMT = 374;
        public static final int T_BIND = 375;
        public static final int T_ENDFORALL = 376;
        public static final int T_DO = 377;
        public static final int T_WHERE_STMT = 378;
        public static final int T_POINTER = 379;
        public static final int T_PROGRAM = 380;
        public static final int T_ENDTYPE = 381;
        public static final int T_WAIT = 382;
        public static final int T_ELSE = 383;
        public static final int T_IF_STMT = 384;
        public static final int T_RBRACKET = 385;
        public static final int T_LPAREN = 386;
        public static final int T_EXTENDS = 387;
        public static final int T_OPTIONAL = 388;
        public static final int T_DOUBLE = 389;
        public static final int T_MODULE = 390;
        public static final int T_READ = 391;
        public static final int T_ALLOCATE = 392;
        public static final int T_INTEGER = 393;
        public static final int T_OR = 394;
        public static final int T_EQUIVALENCE = 395;
        public static final int T_PERIOD = 396;
        public static final int T_ENTRY = 397;
        public static final int T_LABEL_DO_TERMINAL = 398;
        public static final int T_REAL = 399;
        public static final int T_CYCLE = 400;
        public static final int T_PROCEDURE = 401;
        public static final int T_EQ_EQ = 402;
        public static final int T_SLASH_EQ = 403;
        public static final int T_ENDSELECT = 404;
        public static final int T_PURE = 405;
        public static final int T_TRUE = 406;
        public static final int T_NE = 407;
        public static final int T_INTRINSIC = 408;
        public static final int T_PASS = 409;
        public static final int T_REAL_CONSTANT = 410;
        public static final int LINE_COMMENT = 411;
        public static final int T_PERIOD_EXPONENT = 412;
        public static final int T_ENDWHERE = 413;
        public static final int MISC_CHAR = 414;
        public static final int T_FORMAT = 415;
        public static final int T_DEFAULT = 416;
        public static final int T_SLASH_SLASH = 417;
        public static final int T_NONE = 418;
        public static final int T_NAMELIST = 419;
        public static final int T_SEQUENCE = 420;
        public static final int T_PRECISION = 421;
        public static final int T_ASYNCHRONOUS = 422;
        public static final int T_COMMA = 423;
        public static final int T_RESULT = 424;
        public static final int T_ENDBLOCKDATA = 425;
        public static final int T_LOGICAL = 426;
        public static final int T_VALUE = 427;
        public static final int Letter = 428;
        public static final int T_FORALL = 429;
        public static final int T_SAVE = 430;
        public static final int T_HOLLERITH = 431;
        public static final int T_FLUSH = 432;
        public static final int T_WHILE = 433;
        public static final int T_INQUIRE = 434;
        public static final int T_DEFERRED = 435;
        public static final int T_FORALL_STMT = 436;
        public static final int T_ASSIGN = 437;
        public static final int T_LBRACKET = 438;
        public static final int T_EXTERNAL = 439;
        public static final int T_VOLATILE = 440;
        public static final int T_OUT = 441;
        public static final int CONTINUE_CHAR = 442;
        public static final int T_COLON = 443;
        public static final int T_COMPLEX = 444;
        public static final int T_PLUS = 445;
        public static final int T_STMT_FUNCTION = 446;
        public static final int T_ONLY = 447;
        public static final int T_PROTECTED = 448;
        public static final int T_COMMON = 449;
        public static final int T_INOUT = 450;
        public static final int T_NEQV = 451;
        public static final int T_PUBLIC = 452;
        public static final int T_ENDDO = 453;
        public static final int T_ENDPROGRAM = 454;
        public static final int T_ENDFUNCTION = 455;
        public static final int T_WHERE_CONSTRUCT_STMT = 456;
        public static final int T_ELSEWHERE = 457;
        public static final int T_ENUM = 458;
        public static final int T_PARAMETER = 459;
        public static final int T_TARGET = 460;
        public static final int T_DOUBLECOMPLEX = 461;
        public static final int T_PTR_ASSIGNMENT_STMT = 462;
        public static final int T_TYPE = 463;
        public static final int T_LESSTHAN_EQ = 464;
        public static final int T_DEALLOCATE = 465;
        public static final int T_LT = 466;
        public static final int T_FUNCTION = 467;
        public static final int T_EQ_GT = 468;
        public static final int T_ENDENUM = 469;
        public static final int BINARY_CONSTANT = 470;
        public static final int T_LE = 471;
        public static final int T_LEN = 472;
        public static final int T_CONTINUE = 473;
        public static final int T_NOT = 474;
        public static final int Rep_Char = 475;
        public static final int T_ASSIGNMENT = 476;
        public static final int T_EXIT = 477;
        public static final int FORTRAN_COMMENT = 478;
        public static final int FIRST_ASSIGN = 479;
        public static final int FIRST_DIVIDE = 480;
        public static final int FIRST_STAR = 481;
        public static final int FIRST_MOD = 482;
        public static final int FIRST_NOT = 483;
        public static final int FIRST_AMPERSAND = 484;
        public static final int COMMENT = 485;
        public static final int CPP_COMMENT = 486;
        public static final int FIRST_OR = 487;
        public static final int FIRST_BITWISEXOR = 488;
        public static final int FIRST_COLON = 489;
        public static final int FIRST_LESS = 490;
        public static final int FIRST_GREATER = 491;
        public static final int FIRST_MINUS = 492;
        public static final int FIRST_PLUS = 493;
        public static final int FIRST_QUOTATION = 494;
        public static final int H_char_sequence = 495;
        public static final int Q_char_sequence = 496;
        public static final int DirectiveBody = 497;
        public static final int CHAR_LITERAL_BODY = 498;
        public static final int STRING_LITERAL_BODY = 499;
        public static final int ID_LIKE = 503;
        public static final int ID_DEFINED = 504;
        public static final int Identifier = 505;
        public static final int PostPPKwdChar = 506;
        public static final int PostInclChar = 507;
        public static final int PostIfChar = 508;
        public static final int LAST_LEXER_FAKE_RULE = 509;

        private FortranLexer() {
        }

        public static boolean isKeyword(Token tmpToken) {
            return FortranLexer.isKeyword(tmpToken.getType());
        }

        public static boolean isKeyword(int tokenType) {
            switch (tokenType) {
                case 270: 
                case 271: 
                case 273: 
                case 274: 
                case 275: 
                case 276: 
                case 277: 
                case 279: 
                case 282: 
                case 283: 
                case 286: 
                case 288: 
                case 291: 
                case 293: 
                case 295: 
                case 298: 
                case 299: 
                case 302: 
                case 303: 
                case 304: 
                case 306: 
                case 307: 
                case 308: 
                case 309: 
                case 310: 
                case 311: 
                case 312: 
                case 313: 
                case 314: 
                case 315: 
                case 316: 
                case 317: 
                case 319: 
                case 321: 
                case 322: 
                case 325: 
                case 326: 
                case 328: 
                case 329: 
                case 331: 
                case 333: 
                case 334: 
                case 336: 
                case 337: 
                case 338: 
                case 340: 
                case 341: 
                case 343: 
                case 344: 
                case 345: 
                case 347: 
                case 348: 
                case 351: 
                case 354: 
                case 356: 
                case 358: 
                case 359: 
                case 360: 
                case 368: 
                case 369: 
                case 371: 
                case 372: 
                case 376: 
                case 377: 
                case 379: 
                case 380: 
                case 381: 
                case 382: 
                case 383: 
                case 387: 
                case 388: 
                case 389: 
                case 390: 
                case 391: 
                case 392: 
                case 393: 
                case 395: 
                case 397: 
                case 399: 
                case 400: 
                case 401: 
                case 404: 
                case 405: 
                case 408: 
                case 409: 
                case 413: 
                case 415: 
                case 416: 
                case 418: 
                case 419: 
                case 420: 
                case 421: 
                case 422: 
                case 424: 
                case 425: 
                case 426: 
                case 427: 
                case 429: 
                case 430: 
                case 432: 
                case 433: 
                case 434: 
                case 435: 
                case 437: 
                case 439: 
                case 440: 
                case 441: 
                case 444: 
                case 447: 
                case 448: 
                case 449: 
                case 450: 
                case 452: 
                case 453: 
                case 454: 
                case 455: 
                case 457: 
                case 458: 
                case 459: 
                case 460: 
                case 461: 
                case 463: 
                case 465: 
                case 467: 
                case 469: 
                case 472: 
                case 473: 
                case 476: 
                case 477: {
                    return true;
                }
            }
            return false;
        }
    }
}

