/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.openide.filesystems.FileObject;

class CsmEvent {
    public static final Logger LOG = Logger.getLogger("CsmEvent");
    private final Kind kind;
    private final Object object;
    private final String oldPath;

    static CsmEvent create(Kind kind, CsmEvent event) {
        return new CsmEvent(kind, event.object, event.oldPath);
    }

    static CsmEvent createItemEvent(Kind kind, NativeFileItem item) {
        return new CsmEvent(kind, item, null);
    }

    static CsmEvent createItemEvent(Kind kind, NativeFileItem item, String oldPath) {
        return new CsmEvent(kind, item, oldPath);
    }

    static CsmEvent createFileEvent(Kind kind, FileObject fileObject) {
        return new CsmEvent(kind, fileObject, null);
    }

    static CsmEvent createFileEvent(Kind kind, FileObject fileObject, String oldPath) {
        return new CsmEvent(kind, fileObject, oldPath);
    }

    static CsmEvent createEmptyEvent(Kind kind) {
        return new CsmEvent(kind, null, null);
    }

    static CsmEvent createProjectEvent(Kind kind, NativeProject project) {
        return new CsmEvent(kind, project, null);
    }

    private CsmEvent(Kind kind, Object object, String oldPath) {
        if (object != null) assert (kind.getObjectClass().isAssignableFrom(object.getClass())) : "Wrong object class " + object.getClass().getName() + ", should be " + kind.getObjectClass().getName();
        if (object instanceof NativeFileItem) {
            NativeFileItem item = (NativeFileItem)object;
        }
        this.kind = kind;
        this.object = object;
        this.oldPath = oldPath;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getPath() {
        if (this.object instanceof FileObject) {
            return ((FileObject)this.object).getPath();
        }
        if (this.object instanceof NativeFileItem) {
            return ((NativeFileItem)this.object).getAbsolutePath();
        }
        if (this.object instanceof NativeProject) {
            return ((NativeProject)this.object).getProjectRoot();
        }
        return "";
    }

    public String getOldPath() {
        return this.oldPath;
    }

    public FileObject getFileObject() {
        if (this.object instanceof FileObject) {
            return (FileObject)this.object;
        }
        if (this.object instanceof NativeFileItem) {
            return ((NativeFileItem)this.object).getFileObject();
        }
        return null;
    }

    public NativeFileItem getNativeFileItem() {
        if (this.object instanceof NativeFileItem) {
            return (NativeFileItem)this.object;
        }
        return null;
    }

    public NativeProject getNativeProject() {
        if (this.object instanceof NativeProject) {
            return (NativeProject)this.object;
        }
        if (this.object instanceof NativeFileItem) {
            return ((NativeFileItem)this.object).getNativeProject();
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + (Object)((Object)this.kind) + ' ' + this.object + ' ' + (this.oldPath == null ? "" : "oldPath=" + this.oldPath);
    }

    public static void trace(String format, Object ... args) {
        if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
            System.out.printf("CsmEvent: %s%n", String.format(format, args));
        }
    }

    public static enum Kind {
        FILE_DELETED(FileObject.class),
        FILE_CREATED(FileObject.class),
        FILE_RENAMED_CREATED(FileObject.class),
        FILE_RENAMED_DELETED(FileObject.class),
        FOLDER_CREATED(FileObject.class),
        FILE_CHANGED(FileObject.class),
        FILE_ATTRIBUTE_CHANGED(FileObject.class),
        ITEM_ADDED(NativeFileItem.class),
        ITEM_REMOVED(NativeFileItem.class),
        ITEM_PROPERTY_CHANGED(NativeFileItem.class),
        ITEMS_ALL_PROPERTY_CHANGED(null),
        ITEM_RENAMED_DELETED(NativeFileItem.class),
        ITEM_RENAMED_CREATED(NativeFileItem.class),
        PROJECT_DELETED(NativeProject.class),
        FILES_IN_SOURCE_ROOT_DELETED(FileObject.class),
        FILE_INDEXED(FileObject.class),
        NULL(null);

        private final Class cls;

        private Kind(Class cls) {
            this.cls = cls;
        }

        public Class getObjectClass() {
            return this.cls;
        }
    }
}

