/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.dom;

import java.util.WeakHashMap;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.text.dom.CDATASection;
import org.netbeans.modules.xml.text.dom.Comment;
import org.netbeans.modules.xml.text.dom.DocumentType;
import org.netbeans.modules.xml.text.dom.EmptyTag;
import org.netbeans.modules.xml.text.dom.EndTag;
import org.netbeans.modules.xml.text.dom.ProcessingInstruction;
import org.netbeans.modules.xml.text.dom.StartTag;
import org.netbeans.modules.xml.text.dom.SyntaxElement;
import org.netbeans.modules.xml.text.dom.Text;
import org.openide.util.WeakListeners;

public class XMLSyntaxSupport {
    private char lastInsertedChar = (char)88;
    private final DocumentMonitor documentMonitor;
    private BaseDocument document;
    private static WeakHashMap<BaseDocument, XMLSyntaxSupport> supportMap = new WeakHashMap();

    private XMLSyntaxSupport(BaseDocument doc) {
        this.document = doc;
        this.documentMonitor = new DocumentMonitor();
        DocumentListener l = WeakListeners.document((DocumentListener)this.documentMonitor, (Object)doc);
        doc.addDocumentListener(l);
    }

    public static XMLSyntaxSupport getSyntaxSupport(BaseDocument doc) {
        XMLSyntaxSupport support = supportMap.get(doc);
        if (support != null) {
            return support;
        }
        support = new XMLSyntaxSupport(doc);
        supportMap.put(doc, support);
        return support;
    }

    public BaseDocument getDocument() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getPreviousToken(int offset) throws BadLocationException {
        if (offset == 0) {
            return null;
        }
        if (offset < 0) {
            throw new BadLocationException("Offset " + offset + " cannot be less than 0.", offset);
        }
        this.document.readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)this.document);
            TokenSequence ts = th.tokenSequence();
            Token token = this.getToken(ts, offset, false);
            return token;
        }
        finally {
            this.document.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getNextToken(int offset) throws BadLocationException {
        if (offset == 0) {
            return null;
        }
        if (offset < 0) {
            throw new BadLocationException("Offset " + offset + " cannot be less than 0.", offset);
        }
        this.document.readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)this.document);
            TokenSequence ts = th.tokenSequence();
            Token token = this.getToken(ts, offset, true);
            return token;
        }
        finally {
            this.document.readUnlock();
        }
    }

    private Token getToken(TokenSequence ts, int offset, boolean next) {
        ts.move(offset);
        Token token = ts.token();
        if (token == null) {
            ts.moveNext();
        }
        if (next) {
            ts.moveNext();
        } else {
            ts.movePrevious();
        }
        token = ts.token();
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyntaxElement getElementChain(int offset) throws BadLocationException {
        this.document.readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)this.document);
            TokenSequence ts = th.tokenSequence();
            Token token = this.initialize(ts, offset);
            if (token == null) {
                SyntaxElement syntaxElement = null;
                return syntaxElement;
            }
            switch ((XMLTokenId)token.id()) {
                case PI_START: 
                case PI_END: 
                case PI_CONTENT: 
                case PI_TARGET: {
                    while (true) {
                        if (token.id() == XMLTokenId.PI_START) {
                            SyntaxElement syntaxElement = this.createElement(ts, token);
                            return syntaxElement;
                        }
                        ts.movePrevious();
                        token = ts.token();
                    }
                }
                case TEXT: 
                case DECLARATION: 
                case CDATA_SECTION: 
                case BLOCK_COMMENT: 
                case TAG: 
                case ERROR: {
                    SyntaxElement syntaxElement = this.createElement(ts, token);
                    return syntaxElement;
                }
            }
            return null;
        }
        finally {
            this.document.readUnlock();
        }
    }

    private Token<XMLTokenId> initialize(TokenSequence ts, int offset) {
        Token token;
        block3: {
            ts.move(offset);
            token = ts.token();
            if (token == null) {
                if (!ts.moveNext()) {
                    return null;
                }
                token = ts.token();
            }
            XMLTokenId id = (XMLTokenId)token.id();
            String image = token.text().toString();
            if (id != XMLTokenId.WS && id != XMLTokenId.ARGUMENT && id != XMLTokenId.OPERATOR && id != XMLTokenId.VALUE && (id != XMLTokenId.TAG || !">".equals(image) && !"/>".equals(image))) break block3;
            do {
                ts.movePrevious();
            } while ((id = (XMLTokenId)(token = ts.token()).id()) != XMLTokenId.TAG && id != XMLTokenId.PI_START);
        }
        return token;
    }

    private SyntaxElement createElement(TokenSequence ts, Token<XMLTokenId> token) throws BadLocationException {
        int start = ts.offset();
        int end = start + token.length();
        switch ((XMLTokenId)token.id()) {
            case PI_START: {
                String target = null;
                String content = null;
                Token t = token;
                while (t.id() != XMLTokenId.PI_END) {
                    if (t.id() == XMLTokenId.PI_TARGET) {
                        target = t.text().toString();
                    }
                    if (t.id() == XMLTokenId.PI_CONTENT) {
                        content = t.text().toString();
                    }
                    ts.moveNext();
                    t = ts.token();
                }
                end = ts.offset() + t.length();
                return new ProcessingInstruction(this, (Token<XMLTokenId>)token, start, end, target, content);
            }
            case DECLARATION: {
                return new DocumentType(this, (Token<XMLTokenId>)token, start, end);
            }
            case CDATA_SECTION: {
                return new CDATASection(this, (Token<XMLTokenId>)token, start, end);
            }
            case BLOCK_COMMENT: {
                return new Comment(this, (Token<XMLTokenId>)token, start, end);
            }
            case TEXT: {
                return new Text(this, token, start, end);
            }
            case TAG: {
                Token t = token;
                do {
                    ts.moveNext();
                } while ((t = ts.token()).id() != XMLTokenId.TAG);
                end = ts.offset() + t.length();
                if (t.text().toString().equals("/>")) {
                    return new EmptyTag(this, (Token<XMLTokenId>)token, start, end);
                }
                if (token.text().toString().startsWith("</")) {
                    return new EndTag(this, (Token<XMLTokenId>)token, start, end);
                }
                return new StartTag(this, (Token<XMLTokenId>)token, start, end);
            }
            case ERROR: {
                return new SyntaxElement.Error(this, token, start, end);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean noCompletion(JTextComponent target) {
        if (target == null || target.getCaret() == null) {
            return false;
        }
        int offset = target.getCaret().getDot();
        if (offset < 0) {
            return false;
        }
        BaseDocument document = (BaseDocument)target.getDocument();
        document.readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)document);
            TokenSequence ts = th.tokenSequence();
            if (ts == null) {
                boolean bl = false;
                return bl;
            }
            ts.move(offset);
            Token token = ts.token();
            if (token == null) {
                ts.moveNext();
                token = ts.token();
                if (token == null) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (token.id() == XMLTokenId.CDATA_SECTION || token.id() == XMLTokenId.BLOCK_COMMENT || token.id() == XMLTokenId.PI_START || token.id() == XMLTokenId.PI_END || token.id() == XMLTokenId.PI_CONTENT || token.id() == XMLTokenId.PI_TARGET) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            document.readUnlock();
        }
        return false;
    }

    public final char lastTypedChar() {
        return this.lastInsertedChar;
    }

    private class DocumentMonitor
    implements DocumentListener {
        private DocumentMonitor() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            int start = e.getOffset();
            int len = e.getLength();
            try {
                String s = e.getDocument().getText(start + len - 1, 1);
                XMLSyntaxSupport.this.lastInsertedChar = s.charAt(0);
            }
            catch (BadLocationException e1) {
                // empty catch block
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }
    }
}

