/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.debug;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.ComponentType;

public class APTTraceFlags {
    public static final boolean USE_CLANK;
    public static final boolean TRACE_PREPROC;
    public static final boolean TRACE_PREPROC_STACKS;
    public static final boolean DEFERRED_MACRO_USAGES;
    public static final boolean FIX_NOT_FOUND_INCLUDES;
    public static final boolean ALWAYS_USE_NB_FS;
    public static final boolean ALWAYS_USE_BUFFER_BASED_FILES;
    public static final boolean INCLUDE_TOKENS_IN_TOKEN_STREAM;
    public static final boolean APT_SHARE_MACROS;
    public static final boolean APT_SHARE_TEXT;
    public static final boolean APT_NON_RECURSE_VISIT;
    public static final int BUF_SIZE;
    public static final boolean OPTIMIZE_INCLUDE_SEARCH;
    public static final boolean TRACE_APT;
    public static final boolean TRACE_APT_LEXER;
    public static final boolean TRACE_APT_CACHE;
    public static final boolean USE_SOFT_APT_CACHE;
    public static final boolean USE_APT_TEST_TOKEN;
    public static final boolean TEST_APT_SERIALIZATION;
    public static final boolean APT_DISPOSE_TOKENS;
    public static final boolean APT_USE_SOFT_REFERENCE;
    public static final boolean APT_ABSOLUTE_INCLUDES;
    public static final boolean APT_RECURSIVE_BUILD;

    static {
        boolean val;
        TRACE_PREPROC = Boolean.getBoolean("apt.clank.trace.pp");
        TRACE_PREPROC_STACKS = Boolean.getBoolean("apt.clank.trace.pp.stacks");
        String propUseClank = System.getProperty("apt.use.clank");
        if (propUseClank != null) {
            val = Boolean.parseBoolean(propUseClank);
        } else {
            ComponentType product = ComponentType.getComponent();
            switch (product) {
                case CND: 
                case PROJECT_CREATOR: {
                    val = true;
                    break;
                }
                case OSS_IDE: 
                case DBXTOOL: 
                case DLIGHTTOOL: 
                case CODE_ANALYZER: {
                    val = false;
                    break;
                }
                default: {
                    val = false;
                    APTUtils.LOG.severe("Unexpected product type: " + product);
                }
            }
        }
        USE_CLANK = val;
        if (!CndUtils.isUnitTestMode()) {
            Logger.getLogger(APTTraceFlags.class.getName()).log(Level.INFO, "C/C++ code model: using {0} preprocessor", USE_CLANK ? "new" : "old");
        }
        DEFERRED_MACRO_USAGES = DebugUtils.getBoolean((String)"apt.deferred.macro.usages", (boolean)true);
        FIX_NOT_FOUND_INCLUDES = DebugUtils.getBoolean((String)"apt.fix.includes", (boolean)true);
        ALWAYS_USE_NB_FS = DebugUtils.getBoolean((String)"apt.always.use.filesystem", (boolean)true);
        ALWAYS_USE_BUFFER_BASED_FILES = DebugUtils.getBoolean((String)"apt.use.buffer.fs", (boolean)true);
        INCLUDE_TOKENS_IN_TOKEN_STREAM = DebugUtils.getBoolean((String)"apt.include.tokens", (boolean)false);
        APT_SHARE_MACROS = DebugUtils.getBoolean((String)"apt.share.macros", (boolean)true);
        APT_SHARE_TEXT = DebugUtils.getBoolean((String)"apt.share.text", (boolean)true);
        APT_NON_RECURSE_VISIT = DebugUtils.getBoolean((String)"apt.nonrecurse.visit", (boolean)true);
        BUF_SIZE = 8192 * Integer.getInteger("cnd.file.buffer", (int)Integer.getInteger("antlr.input.buffer", 1));
        OPTIMIZE_INCLUDE_SEARCH = DebugUtils.getBoolean((String)"cnd.optimize.include.search", (boolean)true);
        TRACE_APT = Boolean.getBoolean("cnd.apt.trace");
        TRACE_APT_LEXER = Boolean.getBoolean("cnd.aptlexer.trace");
        TRACE_APT_CACHE = Boolean.getBoolean("cnd.apt.cache.hits");
        USE_SOFT_APT_CACHE = DebugUtils.getBoolean((String)"cnd.apt.cache.soft", (boolean)true);
        USE_APT_TEST_TOKEN = Boolean.getBoolean("cnd.apt.apttoken");
        TEST_APT_SERIALIZATION = DebugUtils.getBoolean((String)"cnd.cache.apt", (boolean)false);
        APT_DISPOSE_TOKENS = DebugUtils.getBoolean((String)"apt.dispose.tokens", (boolean)false);
        APT_USE_SOFT_REFERENCE = DebugUtils.getBoolean((String)"apt.soft.reference", (boolean)true);
        APT_ABSOLUTE_INCLUDES = DebugUtils.getBoolean((String)"apt.absolute.include", (boolean)true);
        APT_RECURSIVE_BUILD = DebugUtils.getBoolean((String)"apt.recursive.build", (boolean)true);
    }
}

