/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.apt.impl.support.APTIncludeResolverImpl;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;

public class ResolverResultsCache {
    private static final Map<String, Map<APTIncludeResolverImpl, ResolvedPath>> cache = new HashMap<String, Map<APTIncludeResolverImpl, ResolvedPath>>();
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private ResolverResultsCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ResolvedPath getResolvedPath(String include, APTIncludeResolverImpl resolver) {
        lock.readLock().lock();
        try {
            Map<APTIncludeResolverImpl, ResolvedPath> results = cache.get(include);
            if (results != null) {
                ResolvedPath resolvedPath = results.get(resolver);
                return resolvedPath;
            }
        }
        finally {
            lock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putResolvedPath(String include, APTIncludeResolverImpl resolver, ResolvedPath resolvedPath) {
        lock.writeLock().lock();
        try {
            Map<APTIncludeResolverImpl, ResolvedPath> results = cache.get(include);
            if (results == null) {
                results = new WeakHashMap<APTIncludeResolverImpl, ResolvedPath>();
                cache.put(include, results);
            }
            results.put(resolver, resolvedPath);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        lock.writeLock().lock();
        try {
            cache.clear();
        }
        finally {
            lock.writeLock().unlock();
        }
    }
}

