/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import org.netbeans.modules.web.monitor.client.DataDisplay;
import org.netbeans.modules.web.monitor.client.DisplayTable;
import org.netbeans.modules.web.monitor.data.ClientData;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.netbeans.modules.web.monitor.data.EngineData;
import org.netbeans.modules.web.monitor.data.ServletData;
import org.openide.util.NbBundle;

public class ClientDisplay
extends DataDisplay {
    private static final boolean debug = false;
    private DisplayTable clientTable = null;
    private DisplayTable engineTable = null;
    private String[] categories = new String[]{NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Protocol"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Remote_Address"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Software"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Locale"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Encodings"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Fileformats"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Charsets")};
    private static final String[] props = new String[]{NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Java_version"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Platform"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Server_name"), NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Server_port")};

    private void createPanelWidgets() {
        int gridy = -1;
        this.addGridBagComponent(this, ClientDisplay.createTopSpacer(), 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, topSpacerInsets, 0, 0);
        this.clientTable = new DisplayTable(this.categories);
        this.clientTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)ClientDisplay.class).getString("ACS_MON_ClientTable_3A11yName"));
        this.clientTable.setToolTipText(NbBundle.getBundle((Class)ClientDisplay.class).getString("ACS_MON_ClientTable_3A11yDesc"));
        this.addGridBagComponent(this, ClientDisplay.createHeaderLabel(NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Client_3"), NbBundle.getBundle((Class)ClientDisplay.class).getString("ACS_MON_Client_3A11yDesc"), this.clientTable), 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
        this.addGridBagComponent(this, this.clientTable, 0, ++gridy, 0, 1, 1.0, 0.0, 17, 1, tableInsets, 0, 0);
        this.engineTable = new DisplayTable(props);
        this.engineTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)ClientDisplay.class).getString("ACS_MON_Servlet_engineTableA11yName"));
        this.engineTable.setToolTipText(NbBundle.getBundle((Class)ClientDisplay.class).getString("ACS_MON_Servlet_engineTableA11yDesc"));
        this.addGridBagComponent(this, ClientDisplay.createHeaderLabel(NbBundle.getBundle((Class)ClientDisplay.class).getString("MON_Servlet_engine"), NbBundle.getBundle((Class)ClientDisplay.class).getString("ACS_MON_Servlet_engineA11yDesc"), this.engineTable), 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
        this.addGridBagComponent(this, this.engineTable, 0, ++gridy, 0, 1, 1.0, 0.0, 17, 1, tableInsets, 0, 0);
        this.addGridBagComponent(this, ClientDisplay.createGlue(), 0, ++gridy, 1, 1, 1.0, 1.0, 17, 1, zeroInsets, 0, 0);
    }

    public void setData(DataRecord md) {
        this.removeAll();
        if (md == null) {
            return;
        }
        this.createPanelWidgets();
        ClientData cd = md.getClientData();
        this.clientTable.setValueAt(cd.getAttributeValue("protocol"), 0, 1);
        this.clientTable.setValueAt(cd.getAttributeValue("remoteAddress"), 1, 1);
        this.clientTable.setValueAt(cd.getAttributeValue("software"), 2, 1);
        this.clientTable.setValueAt(cd.getAttributeValue("locale"), 3, 1);
        this.clientTable.setValueAt(cd.getAttributeValue("encodingsAccepted"), 4, 1);
        this.clientTable.setValueAt(cd.getAttributeValue("formatsAccepted"), 5, 1);
        this.clientTable.setValueAt(cd.getAttributeValue("charsetsAccepted"), 6, 1);
        EngineData ed = md.getEngineData();
        if (ed != null) {
            this.engineTable.setValueAt(ed.getAttributeValue("jre"), 0, 1);
            this.engineTable.setValueAt(ed.getAttributeValue("platform"), 1, 1);
            this.engineTable.setValueAt(ed.getAttributeValue("serverName"), 2, 1);
            this.engineTable.setValueAt(ed.getAttributeValue("serverPort"), 3, 1);
        } else {
            ServletData sd = md.getServletData();
            this.engineTable.setValueAt(sd.getAttributeValue("jre"), 0, 1);
            this.engineTable.setValueAt(sd.getAttributeValue("platform"), 1, 1);
            this.engineTable.setValueAt(sd.getAttributeValue("serverName"), 2, 1);
            this.engineTable.setValueAt(sd.getAttributeValue("serverPort"), 3, 1);
        }
    }
}

