/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.treeview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemListener;
import java.io.CharConversionException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.mobility.end2end.ui.treeview.MultiStateCheckBox;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.xml.XMLUtil;

public class MethodCheckedNodeRenderer
extends JPanel
implements TreeCellRenderer {
    private static final Color selectionForeground = UIManager.getColor("Tree.selectionForeground");
    private static final Color selectionBackground = UIManager.getColor("Tree.selectionBackground");
    private static final Color textForeground = UIManager.getColor("Tree.textForeground");
    private MultiStateCheckBox jCheckBox1;
    private JLabel jLabel1;

    public MethodCheckedNodeRenderer() {
        Font fontValue = UIManager.getFont("Tree.font");
        if (fontValue != null) {
            this.setFont(fontValue);
        }
        this.initComponents();
        Boolean booleanValue = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.setFocusPainted(booleanValue != null && booleanValue != false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Node node = Visualizer.findNode((Object)value);
        this.setText(node.getDisplayName());
        this.setEnabled(tree.isEnabled());
        if (selected) {
            this.setForeground(selectionForeground, textForeground);
            this.setBackground(selectionBackground, tree.getBackground());
        } else {
            this.setForeground(textForeground);
            this.setBackground(tree.getBackground());
        }
        this.setState((MultiStateCheckBox.State)((Object)node.getValue("isSelected")));
        Boolean val = (Boolean)node.getValue("isValid");
        if (val != null && !val.booleanValue()) {
            try {
                this.setText("<html><s>" + XMLUtil.toAttributeValue((String)node.getDisplayName()) + "</s></html>");
                this.setEnabled(false);
            }
            catch (CharConversionException cce) {}
        } else {
            this.setEnabled(true);
        }
        this.setIcon(new ImageIcon(node.getIcon(1)));
        return this;
    }

    @Override
    public void setForeground(Color fg) {
        this.setForeground(fg, fg);
    }

    @Override
    public void setBackground(Color bg) {
        this.setBackground(bg, bg);
    }

    public int getCheckBoxWidth() {
        return this.jCheckBox1.getWidth();
    }

    public void setForeground(Color selection, Color text) {
        if (this.jCheckBox1 == null || this.jLabel1 == null) {
            return;
        }
        this.jCheckBox1.setForeground(text);
        this.jLabel1.setForeground(selection);
        super.setForeground(selection);
    }

    public void setBackground(Color selection, Color text) {
        if (this.jCheckBox1 == null || this.jLabel1 == null) {
            return;
        }
        this.jCheckBox1.setBackground(text);
        this.jLabel1.setBackground(selection);
        super.setBackground(selection);
    }

    public void setFocusPainted(boolean painted) {
        this.jCheckBox1.setFocusPainted(painted);
    }

    public void setText(String text) {
        this.jLabel1.setText(text);
    }

    public String getText() {
        return this.jLabel1.getText();
    }

    public MultiStateCheckBox.State getState() {
        return this.jCheckBox1.getState();
    }

    public void setState(MultiStateCheckBox.State state) {
        this.jCheckBox1.setState(state);
    }

    public void setIcon(Icon icon) {
        this.jLabel1.setIcon(icon);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jCheckBox1.setEnabled(enabled);
        if (!enabled) {
            this.jCheckBox1.setState(MultiStateCheckBox.State.UNSELECTED);
        }
    }

    public void addItemListener(ItemListener itemListener) {
        this.jCheckBox1.addItemListener(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.jCheckBox1.removeItemListener(itemListener);
    }

    private void initComponents() {
        this.jCheckBox1 = new MultiStateCheckBox();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout(5, 0));
        this.jCheckBox1.setBorder(null);
        this.add((Component)this.jCheckBox1, "West");
        this.add((Component)this.jLabel1, "East");
    }
}

