/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.options.ui.v2.impl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.options.ui.v2.ProfilerOptionsPanel;
import org.netbeans.modules.profiler.options.ui.v2.impl.Bundle;
import org.openide.awt.Mnemonics;

public final class SnapshotsOptionsPanel
extends ProfilerOptionsPanel {
    private JComboBox onSnapshotCombo;
    private JComboBox onHeapDumpCombo;
    private JComboBox onOOMEHeapDumpCombo;
    private JTextField customOOMEField;
    private JButton customOOMEButton;
    private JComboBox openSnapshotsWindowCombo;
    private JComboBox closeSnapshotsWindowCombo;

    public SnapshotsOptionsPanel() {
        this.initUI();
    }

    @Override
    public String getDisplayName() {
        return Bundle.SnapshotsOptionsPanel_Name();
    }

    @Override
    public void storeTo(ProfilerIDESettings settings) {
        String onHeapDump;
        int onSnapshot;
        String customDir = this.customOOMEField.getText().trim();
        if (this.onOOMEHeapDumpCombo.getSelectedIndex() == 3 && !new File(customDir).isDirectory()) {
            this.onOOMEHeapDumpCombo.setSelectedIndex(0);
        }
        settings.setAutoOpenSnapshot((onSnapshot = this.onSnapshotCombo.getSelectedIndex()) == 0 || onSnapshot == 2);
        settings.setAutoSaveSnapshot(onSnapshot == 1 || onSnapshot == 2);
        switch (this.onHeapDumpCombo.getSelectedIndex()) {
            case 0: {
                onHeapDump = "NO_OPTION";
                break;
            }
            case 1: {
                onHeapDump = "YES_OPTION";
                break;
            }
            default: {
                onHeapDump = null;
            }
        }
        settings.setDoNotShowAgain("HeapDumpAction.heapdumpSaved", onHeapDump);
        settings.setOOMDetectionMode(this.onOOMEHeapDumpCombo.getSelectedIndex());
        settings.setCustomHeapdumpPath(customDir);
        settings.setSnapshotWindowOpenPolicy(this.openSnapshotsWindowCombo.getSelectedIndex());
        settings.setSnapshotWindowClosePolicy(this.closeSnapshotsWindowCombo.getSelectedIndex());
    }

    @Override
    public void loadFrom(ProfilerIDESettings settings) {
        int onSnapshot;
        int n = onSnapshot = settings.getAutoSaveSnapshot() ? 1 : 0;
        if (settings.getAutoOpenSnapshot()) {
            onSnapshot *= 2;
        }
        this.onSnapshotCombo.setSelectedIndex(onSnapshot);
        String onHeapDump = settings.getDoNotShowAgain("HeapDumpAction.heapdumpSaved");
        if ("NO_OPTION".equals(onHeapDump)) {
            this.onHeapDumpCombo.setSelectedIndex(0);
        } else if ("YES_OPTION".equals(onHeapDump)) {
            this.onHeapDumpCombo.setSelectedIndex(1);
        } else {
            this.onHeapDumpCombo.setSelectedIndex(2);
        }
        int oomeMode = settings.getOOMDetectionMode();
        String customDir = settings.getCustomHeapdumpPath();
        if (oomeMode == 3 && !new File(customDir).isDirectory()) {
            oomeMode = 0;
            settings.setOOMDetectionMode(oomeMode);
        }
        this.onOOMEHeapDumpCombo.setSelectedIndex(oomeMode);
        this.customOOMEField.setText(customDir);
        this.openSnapshotsWindowCombo.setSelectedIndex(settings.getSnapshotWindowOpenPolicy());
        this.closeSnapshotsWindowCombo.setSelectedIndex(settings.getSnapshotWindowClosePolicy());
    }

    @Override
    public boolean equalsTo(ProfilerIDESettings settings) {
        int onSnapshot;
        int n = onSnapshot = settings.getAutoSaveSnapshot() ? 1 : 0;
        if (settings.getAutoOpenSnapshot()) {
            onSnapshot *= 2;
        }
        if (onSnapshot != this.onSnapshotCombo.getSelectedIndex()) {
            return false;
        }
        String onHeapDump = settings.getDoNotShowAgain("HeapDumpAction.heapdumpSaved");
        if (onHeapDump == null && this.onHeapDumpCombo.getSelectedIndex() != 2) {
            return false;
        }
        if ("NO_OPTION".equals(onHeapDump) && this.onHeapDumpCombo.getSelectedIndex() != 0) {
            return false;
        }
        if ("YES_OPTION".equals(onHeapDump) && this.onHeapDumpCombo.getSelectedIndex() != 1) {
            return false;
        }
        if (settings.getOOMDetectionMode() != this.onOOMEHeapDumpCombo.getSelectedIndex()) {
            return false;
        }
        if (!Objects.equals(settings.getCustomHeapdumpPath(), this.customOOMEField.getText().trim())) {
            return false;
        }
        if (settings.getSnapshotWindowOpenPolicy() != this.openSnapshotsWindowCombo.getSelectedIndex()) {
            return false;
        }
        return settings.getSnapshotWindowClosePolicy() == this.closeSnapshotsWindowCombo.getSelectedIndex();
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        int y = 0;
        int htab = 8;
        int hgap = 10;
        int vgap = 5;
        ProfilerOptionsPanel.Separator snapshotsSeparator = new ProfilerOptionsPanel.Separator(Bundle.SnapshotsOptionsPanel_CatSnapshots());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(0, 0, vgap * 2, 0);
        this.add((Component)snapshotsSeparator, c);
        JLabel onSnapshotLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)onSnapshotLabel, (String)Bundle.SnapshotsOptionsPanel_OnSnapshotLabel());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.anchor = 17;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)onSnapshotLabel, c);
        this.onSnapshotCombo = new JComboBox<String>(new String[]{Bundle.SnapshotsOptionsPanel_ItemOpenSnapshot(), Bundle.SnapshotsOptionsPanel_ItemSaveSnapshot(), Bundle.SnapshotsOptionsPanel_ItemSaveOpenSnapshot()});
        onSnapshotLabel.setLabelFor(this.onSnapshotCombo);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y;
        c.fill = 2;
        c.insets = new Insets(0, hgap, vgap, 0);
        this.add((Component)this.onSnapshotCombo, c);
        JPanel filler1 = new JPanel(null);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = y++;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)filler1, c);
        JLabel onHeapDumpLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)onHeapDumpLabel, (String)Bundle.SnapshotsOptionsPanel_OnHeapdumpLabel());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.anchor = 17;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)onHeapDumpLabel, c);
        this.onHeapDumpCombo = new JComboBox<String>(new String[]{Bundle.SnapshotsOptionsPanel_ItemSaveSnapshot(), Bundle.SnapshotsOptionsPanel_ItemSaveOpenSnapshot(), Bundle.SnapshotsOptionsPanel_ItemSaveConfirmOpen()});
        onHeapDumpLabel.setLabelFor(this.onHeapDumpCombo);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y;
        c.fill = 2;
        c.insets = new Insets(0, hgap, vgap, 0);
        this.add((Component)this.onHeapDumpCombo, c);
        JPanel filler3 = new JPanel(null);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = y++;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)filler3, c);
        JLabel onOOMEHeapDumpLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)onOOMEHeapDumpLabel, (String)Bundle.SnapshotsOptionsPanel_OnOOMEHeapdumpLabel());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.anchor = 17;
        c.insets = new Insets(vgap * 3, htab, vgap, 0);
        this.add((Component)onOOMEHeapDumpLabel, c);
        this.onOOMEHeapDumpCombo = new JComboBox(new String[]{Bundle.SnapshotsOptionsPanel_ItemDoNothing(), Bundle.SnapshotsOptionsPanel_ItemSaveToProject(), Bundle.SnapshotsOptionsPanel_ItemSaveToTemp(), Bundle.SnapshotsOptionsPanel_ItemSaveToCustom()}){

            @Override
            public void setSelectedIndex(int index) {
                super.setSelectedIndex(index);
                boolean custom = index == 3;
                SnapshotsOptionsPanel.this.customOOMEField.setVisible(custom);
                SnapshotsOptionsPanel.this.customOOMEButton.setVisible(custom);
            }
        };
        onOOMEHeapDumpLabel.setLabelFor(this.onOOMEHeapDumpCombo);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y;
        c.fill = 2;
        c.insets = new Insets(vgap * 3, hgap, vgap, 0);
        this.add((Component)this.onOOMEHeapDumpCombo, c);
        JPanel filler4 = new JPanel(null);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = y++;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)filler4, c);
        this.customOOMEField = new JTextField();
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y;
        c.fill = 2;
        c.insets = new Insets(0, hgap, vgap, 0);
        this.add((Component)this.customOOMEField, c);
        this.customOOMEButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String newDir = SnapshotsOptionsPanel.this.selectCustomDir(SnapshotsOptionsPanel.this.customOOMEField.getText().trim());
                        if (newDir != null) {
                            SnapshotsOptionsPanel.this.customOOMEField.setText(newDir);
                        }
                    }
                });
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)this.customOOMEButton, (String)Bundle.SnapshotsOptionsPanel_ChooseCustomDir());
        this.customOOMEButton.setMargin(new Insets(0, hgap, 0, hgap));
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = y;
        c.fill = 3;
        c.insets = new Insets(0, vgap, vgap, 0);
        this.add((Component)this.customOOMEButton, c);
        JPanel filler5 = new JPanel(null);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = y++;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)filler5, c);
        ProfilerOptionsPanel.Separator snapshotsWindowSeparator = new ProfilerOptionsPanel.Separator(Bundle.SnapshotsOptionsPanel_CatSnapshotsWindow());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(vgap * 4, 0, vgap * 2, 0);
        this.add((Component)snapshotsWindowSeparator, c);
        JLabel openSnapshotsWindowLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)openSnapshotsWindowLabel, (String)Bundle.SnapshotsOptionsPanel_OpenAutomaticallyLabel());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.anchor = 17;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)openSnapshotsWindowLabel, c);
        this.openSnapshotsWindowCombo = new JComboBox<String>(new String[]{Bundle.SnapshotsOptionsPanel_ItemNever(), Bundle.SnapshotsOptionsPanel_ItemNewSession(), Bundle.SnapshotsOptionsPanel_ItemShowWindow(), Bundle.SnapshotsOptionsPanel_ItemFirstSnapshot(), Bundle.SnapshotsOptionsPanel_ItemEachSnapshot()});
        openSnapshotsWindowLabel.setLabelFor(this.openSnapshotsWindowCombo);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y;
        c.fill = 2;
        c.insets = new Insets(0, hgap, vgap, 0);
        this.add((Component)this.openSnapshotsWindowCombo, c);
        JPanel filler6 = new JPanel(null);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = y++;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)filler6, c);
        JLabel closeSnapshotsWindowLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)closeSnapshotsWindowLabel, (String)Bundle.SnapshotsOptionsPanel_CloseAutomaticallyLabel());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.anchor = 17;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)closeSnapshotsWindowLabel, c);
        this.closeSnapshotsWindowCombo = new JComboBox<String>(new String[]{Bundle.SnapshotsOptionsPanel_ItemNever(), Bundle.SnapshotsOptionsPanel_ItemCloseSession(), Bundle.SnapshotsOptionsPanel_ItemHideWindow()});
        closeSnapshotsWindowLabel.setLabelFor(this.closeSnapshotsWindowCombo);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y;
        c.fill = 2;
        c.insets = new Insets(0, hgap, vgap, 0);
        this.add((Component)this.closeSnapshotsWindowCombo, c);
        JPanel filler7 = new JPanel(null);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = y++;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)filler7, c);
        JPanel filler = UIUtils.createFillerPanel();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        c.gridwidth = 0;
        c.fill = 1;
        this.add((Component)filler, c);
    }

    private String selectCustomDir(String currentDir) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(currentDir));
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogType(0);
        chooser.setDialogTitle(Bundle.SnapshotsOptionsPanel_ChooseDirCaption());
        return chooser.showOpenDialog(SwingUtilities.getRoot(this)) == 0 ? chooser.getSelectedFile().getAbsolutePath() : null;
    }
}

