/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.ui.options;

import java.awt.EventQueue;
import java.io.IOException;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.css.prep.CssPreprocessorType;
import org.netbeans.modules.css.prep.less.LessCssPreprocessor;
import org.netbeans.modules.css.prep.less.LessExecutable;
import org.netbeans.modules.css.prep.options.CssPrepOptions;
import org.netbeans.modules.css.prep.options.CssPrepOptionsValidator;
import org.netbeans.modules.css.prep.ui.options.Bundle;
import org.netbeans.modules.css.prep.ui.options.LessOptionsPanel;
import org.netbeans.modules.css.prep.util.Warnings;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.spi.CssPreprocessorImplementation;

public class LessOptions
implements CssPreprocessorImplementation.Options {
    private final LessCssPreprocessor lessCssPreprocessor;
    private LessOptionsPanel panel = null;

    public LessOptions(LessCssPreprocessor lessCssPreprocessor) {
        this.lessCssPreprocessor = lessCssPreprocessor;
    }

    public String getDisplayName() {
        return Bundle.LessOptions_displayName();
    }

    public void addChangeListener(ChangeListener listener) {
        this.getComponent().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getComponent().removeChangeListener(listener);
    }

    public LessOptionsPanel getComponent() {
        assert (EventQueue.isDispatchThread());
        if (this.panel == null) {
            this.panel = new LessOptionsPanel();
        }
        return this.panel;
    }

    public void update() {
        this.getComponent().setLessPath(this.getOptions().getLessPath());
        this.getComponent().setLessOutputOnError(this.getOptions().getLessOutputOnError());
        this.getComponent().setLessDebug(this.getOptions().getLessDebug());
    }

    public boolean isValid() {
        return !this.getValidationResult().hasErrors();
    }

    public String getErrorMessage() {
        ValidationResult validationResult = this.getValidationResult();
        if (validationResult.hasErrors()) {
            return ((ValidationResult.Message)validationResult.getErrors().get(0)).getMessage();
        }
        return null;
    }

    public String getWarningMessage() {
        ValidationResult validationResult = this.getValidationResult();
        if (validationResult.hasWarnings()) {
            return ((ValidationResult.Message)validationResult.getWarnings().get(0)).getMessage();
        }
        return null;
    }

    public boolean changed() {
        String lessPath = this.getOptions().getLessPath();
        return !this.getComponent().getLessPath().equals(lessPath == null ? "" : lessPath) || this.getComponent().getLessOutputOnError() != this.getOptions().getLessOutputOnError() || this.getComponent().getLessDebug() != this.getOptions().getLessDebug();
    }

    public void save() throws IOException {
        Warnings.resetWarning(CssPreprocessorType.LESS);
        LessExecutable.resetVersion();
        boolean fire = false;
        String originalPath = this.getOptions().getLessPath();
        String path = this.getComponent().getLessPath();
        this.getOptions().setLessPath(path);
        if (!path.equals(originalPath)) {
            fire = true;
        }
        this.getOptions().setLessOutpuOnError(this.getComponent().getLessOutputOnError());
        boolean originalDebug = this.getOptions().getLessDebug();
        boolean debug = this.getComponent().getLessDebug();
        this.getOptions().setLessDebug(debug);
        if (debug != originalDebug) {
            fire = true;
        }
        if (fire) {
            this.lessCssPreprocessor.fireOptionsChanged();
        }
    }

    private ValidationResult getValidationResult() {
        return new CssPrepOptionsValidator().validateLessPath(this.getComponent().getLessPath(), true).getResult();
    }

    private CssPrepOptions getOptions() {
        return CssPrepOptions.getInstance();
    }
}

