/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DateFormat;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Annotator;
import org.netbeans.modules.subversion.remote.DiskMapTurboProvider;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNLock;
import org.netbeans.modules.subversion.remote.api.ISVNProperty;
import org.netbeans.modules.subversion.remote.api.ISVNStatus;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNConflictDescriptor;
import org.netbeans.modules.subversion.remote.api.SVNNodeKind;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNStatusKind;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.util.DelayScanRegistry;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.filesystems.FileSystem;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class FileStatusCache {
    public static final Object EVENT_FILE_STATUS_CHANGED = new Object();
    public static final String PROP_CACHE_READY = "subversion.cache.ready";
    private static final Map<VCSFileProxy, FileInformation> NOT_MANAGED_MAP = new NotManagedMap();
    public static final RepositoryStatus REPOSITORY_STATUS_UNKNOWN = null;
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(2, false);
    private static final FileInformation FILE_INFORMATION_EXCLUDED_DIRECTORY = new FileInformation(2, true);
    private static final FileInformation FILE_INFORMATION_UPTODATE_DIRECTORY = new FileInformation(8, true);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(1, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED_DIRECTORY = new FileInformation(1, true);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(0, false);
    private static final int CACHE_SIZE_WARNING_THRESHOLD = 100000;
    private static final Pattern auxConflictPattern = Pattern.compile("(.*?)\\.((r\\d+)|(mine)|(working)|(merge-right\\.r\\d+)|((merge-left.r\\d+)))$");
    private final Turbo turbo;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.subversion.remote.FileStatusCache");
    private boolean ready = false;
    private final String FILE_STATUS_MAP = "subversion.STATUS_MAP";
    private DiskMapTurboProvider cacheProvider;
    private RequestProcessor rp = new RequestProcessor("Subversion - file status refresh", 1);
    private final LinkedHashSet<VCSFileProxy> filesToRefresh = new LinkedHashSet();
    private RequestProcessor.Task refreshTask;
    private final FileLabelCache labelsCache;
    private Annotator annotator;
    private long refreshedFilesCount;
    private static final boolean EXCLUDE_SYMLINKS = "true".equals(System.getProperty("versioning.subversion.doNotFollowSymlinks", "false"));
    private static final Logger LABELS_CACHE_LOG = Logger.getLogger(FileStatusCache.class.getName());
    private static final FileLabelInfo FAKE_LABEL_INFO = new FileLabelInfo("", "", "", "", "", "");
    private static final boolean VERSIONING_ASYNC_ANNOTATOR = !"false".equals(System.getProperty("versioning.asyncAnnotator", "true"));
    PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    FileStatusCache() {
        this.cacheProvider = new DiskMapTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(FileStatusCache.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)200, (int)5000);
        this.refreshTask = this.rp.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VCSFileProxy fileToRefresh;
                if (DelayScanRegistry.getInstance().isDelayed(FileStatusCache.this.refreshTask, LOG, "FileStatusCache.refreshTask")) {
                    return;
                }
                long startTime = 0L;
                long files = 0L;
                boolean logEnabled = LOG.isLoggable(Level.FINE);
                if (logEnabled) {
                    startTime = System.currentTimeMillis();
                }
                do {
                    fileToRefresh = null;
                    LinkedHashSet linkedHashSet = FileStatusCache.this.filesToRefresh;
                    synchronized (linkedHashSet) {
                        Iterator it = FileStatusCache.this.filesToRefresh.iterator();
                        if (it.hasNext()) {
                            fileToRefresh = (VCSFileProxy)it.next();
                            it.remove();
                        }
                    }
                    if (fileToRefresh == null) continue;
                    FileStatusCache.this.refresh(fileToRefresh, REPOSITORY_STATUS_UNKNOWN);
                    if (!logEnabled) continue;
                    ++files;
                    ++FileStatusCache.this.refreshedFilesCount;
                } while (fileToRefresh != null);
                if (logEnabled) {
                    LOG.log(Level.FINE, "refreshTask lasted {0} ms for {1} files, {2} files refreshed so far", new Object[]{System.currentTimeMillis() - startTime, files, FileStatusCache.this.refreshedFilesCount});
                }
            }
        });
        this.labelsCache = new FileLabelCache(this);
    }

    void setAnnotator(Annotator annotator) {
        this.annotator = annotator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFiles(Context context, int includeStatus, boolean addExcluded) {
        long ts = System.currentTimeMillis();
        try {
            VCSFileProxy[] roots = context.getRootFiles();
            boolean bl = this.containsFiles(roots, includeStatus, addExcluded);
            return bl;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " containsFiles(Context, int) took {0}", System.currentTimeMillis() - ts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFiles(Set<VCSFileProxy> rootFiles, int includeStatus, boolean addExcluded) {
        long ts = System.currentTimeMillis();
        try {
            VCSFileProxy[] roots = rootFiles.toArray(new VCSFileProxy[rootFiles.size()]);
            boolean bl = this.containsFiles(roots, includeStatus, addExcluded);
            return bl;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " containsFiles(Set<File>, int) took {0}", System.currentTimeMillis() - ts);
            }
        }
    }

    private boolean containsFiles(VCSFileProxy[] roots, int includeStatus, boolean addExcluded) {
        for (VCSFileProxy root : roots) {
            if (!this.containsFilesIntern(this.cacheProvider.getIndexValues(root, includeStatus), includeStatus, !VersioningSupport.isFlat((VCSFileProxy)root), addExcluded)) continue;
            return true;
        }
        return this.containsFilesIntern(roots, includeStatus, false, addExcluded);
    }

    private boolean containsFilesIntern(VCSFileProxy[] indexRoots, int includeStatus, boolean recursively, boolean addExcluded) {
        if (indexRoots == null || indexRoots.length == 0) {
            return false;
        }
        for (VCSFileProxy root : indexRoots) {
            VCSFileProxy[] indexValues = this.cacheProvider.getIndexValues(root, includeStatus);
            if (!recursively || !this.containsFilesIntern(indexValues, includeStatus, recursively, addExcluded)) continue;
            return true;
        }
        for (VCSFileProxy root : indexRoots) {
            FileInformation fi = this.getCachedStatus(root);
            if (fi == null || (fi.getStatus() & includeStatus) == 0 || !addExcluded && SvnModuleConfig.getDefault(VCSFileProxySupport.getFileSystem((VCSFileProxy)root)).isExcludedFromCommit(root.getPath())) continue;
            return true;
        }
        return false;
    }

    public VCSFileProxy[] listFiles(VCSFileProxy dir) {
        Set<VCSFileProxy> files = this.getScannedFiles(dir).keySet();
        return files.toArray(new VCSFileProxy[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCSFileProxy[] listFiles(VCSFileProxy[] roots, int includeStatus) {
        long ts = System.currentTimeMillis();
        try {
            HashSet<VCSFileProxy> set = new HashSet<VCSFileProxy>();
            for (VCSFileProxy root : roots) {
                Set<VCSFileProxy> files = this.listFilesIntern(this.cacheProvider.getIndexValues(root, includeStatus), includeStatus, !VersioningSupport.isFlat((VCSFileProxy)root));
                set.addAll(files);
            }
            set.addAll(this.listFilesIntern(roots, includeStatus, false));
            VCSFileProxy[] vCSFileProxyArray = set.toArray(new VCSFileProxy[set.size()]);
            return vCSFileProxyArray;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " listFiles(File[], int, boolean) took {0}", System.currentTimeMillis() - ts);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCSFileProxy[] listFiles(Context context, int includeStatus) {
        long ts = System.currentTimeMillis();
        try {
            HashSet<VCSFileProxy> set = new HashSet<VCSFileProxy>();
            VCSFileProxy[] roots = context.getRootFiles();
            set.addAll(Arrays.asList(this.listFiles(roots, includeStatus)));
            if (context.getExclusions().size() > 0) {
                for (VCSFileProxy excluded : context.getExclusions()) {
                    Iterator i = set.iterator();
                    while (i.hasNext()) {
                        VCSFileProxy file = (VCSFileProxy)i.next();
                        if (!SvnUtils.isParentOrEqual(excluded, file)) continue;
                        i.remove();
                    }
                }
            }
            VCSFileProxy[] vCSFileProxyArray = set.toArray(new VCSFileProxy[set.size()]);
            return vCSFileProxyArray;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " listFiles(Context, int) took {0}", System.currentTimeMillis() - ts);
            }
        }
    }

    private Set<VCSFileProxy> listFilesIntern(VCSFileProxy[] roots, int includeStatus, boolean recursively) {
        if (roots == null || roots.length == 0) {
            return Collections.emptySet();
        }
        HashSet<VCSFileProxy> ret = new HashSet<VCSFileProxy>();
        for (VCSFileProxy root : roots) {
            FileInformation fi;
            if (recursively) {
                ret.addAll(this.listFilesIntern(this.cacheProvider.getIndexValues(root, includeStatus), includeStatus, recursively));
            }
            if ((fi = this.getCachedStatus(root)) == null || (fi.getStatus() & includeStatus) == 0) continue;
            ret.add(root);
        }
        return ret;
    }

    public FileInformation getStatus(VCSFileProxy file) {
        if (SvnUtils.isAdministrative(file)) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        VCSFileProxy dir = file.getParentFile();
        if (dir == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<VCSFileProxy, FileInformation> files = this.getScannedFiles(dir);
        if (files == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fi = files.get(file);
        if (fi != null) {
            return fi;
        }
        if (!this.exists(file)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (file.isDirectory()) {
            return this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
        return new FileInformation(8, false);
    }

    public FileInformation getCachedStatus(VCSFileProxy file) {
        VCSFileProxy parent = file.getParentFile();
        if (parent == null) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        Map files = (Map)this.turbo.readEntry((Object)parent, "subversion.STATUS_MAP");
        return files != null ? (FileInformation)files.get(file) : null;
    }

    public void refreshAsync(List<VCSFileProxy> files) {
        this.refreshAsync(false, files.toArray(new VCSFileProxy[files.size()]));
    }

    public void refreshAsync(VCSFileProxy ... files) {
        this.refreshAsync(false, files);
    }

    public void refreshAsync(final boolean recursively, final VCSFileProxy ... files) {
        if (files == null || files.length == 0) {
            return;
        }
        Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LinkedHashSet linkedHashSet = FileStatusCache.this.filesToRefresh;
                synchronized (linkedHashSet) {
                    for (VCSFileProxy file : files) {
                        if (recursively) {
                            FileStatusCache.this.filesToRefresh.addAll(SvnUtils.listManagedRecursively(file));
                            continue;
                        }
                        FileStatusCache.this.filesToRefresh.add(file);
                    }
                }
                FileStatusCache.this.refreshTask.schedule(200);
            }
        });
    }

    public FileInformation refresh(VCSFileProxy file, RepositoryStatus repositoryStatus) {
        return this.refresh(file, repositoryStatus, false);
    }

    public void refreshCached(Context ctx) {
        VCSFileProxy[] files = this.listFiles(ctx, -3);
        for (int i = 0; i < files.length; ++i) {
            VCSFileProxy file = files[i];
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    public void refreshRecursively(VCSFileProxy root) {
        FileInformation info = this.refresh(root, REPOSITORY_STATUS_UNKNOWN);
        if (info == null || (info.getStatus() & 2) == 0) {
            List<VCSFileProxy> files = SvnUtils.listChildren(root);
            for (VCSFileProxy file : files) {
                this.refreshRecursively(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInformation refresh(VCSFileProxy file, RepositoryStatus repositoryStatus, boolean forceChangeEvent) {
        boolean refreshDone = false;
        FileInformation current = null;
        FileInformation fi = null;
        VCSFileProxy[] content = null;
        FileStatusCache fileStatusCache = this;
        synchronized (fileStatusCache) {
            boolean symlink;
            ISVNStatus status;
            Map<VCSFileProxy, FileInformation> files;
            VCSFileProxy dir;
            block31: {
                dir = file.getParentFile();
                if (dir == null) {
                    return FILE_INFORMATION_NOTMANAGED;
                }
                files = this.getScannedFiles(dir);
                if (files == NOT_MANAGED_MAP && repositoryStatus == REPOSITORY_STATUS_UNKNOWN) {
                    return FILE_INFORMATION_NOTMANAGED;
                }
                current = files.get(file);
                for (Map.Entry<VCSFileProxy, FileInformation> e : files.entrySet()) {
                    VCSFileProxy fKey = e.getKey();
                    if (!fKey.getPath().equals(file.getPath())) continue;
                    current = e.getValue();
                    break;
                }
                status = null;
                symlink = false;
                try {
                    VCSFileProxy topmost = Subversion.getInstance().getTopmostManagedAncestor(file);
                    boolean bl = symlink = topmost != null && this.isSymlink(file);
                    if (!symlink && !SvnUtils.isPartOfSubversionMetadata(file)) {
                        SvnClient client;
                        if (this.isParentIgnored(file)) {
                            status = null;
                        } else if (Subversion.getInstance().isConnected(file) && (status = SvnUtils.getSingleStatus(client = Subversion.getInstance().getClient(false, new Context(file)), file)) != null && SVNStatusKind.UNVERSIONED.equals((Object)status.getTextStatus())) {
                            status = null;
                        }
                    }
                }
                catch (SVNClientException e) {
                    if (SvnClientExceptionHandler.isUnversionedResource(e.getMessage()) || WorkingCopyAttributesCache.getInstance().isSuppressed(e)) break block31;
                    SvnClientExceptionHandler.notifyException(new Context(file), e, false, false);
                }
            }
            fi = symlink ? new FileInformation(8, false) : this.createFileInformation(file, status, repositoryStatus);
            if (FileStatusCache.equivalent(fi, current)) {
                refreshDone = true;
            }
            if (!refreshDone && current == null && !fi.isDirectory() && fi.getStatus() == 8) {
                refreshDone = true;
            }
            if (!refreshDone) {
                if (fi.getStatus() == 0 && current != null && current.isDirectory() && (current.getStatus() == 2048 || current.getStatus() == 256)) {
                    content = this.listFiles(new VCSFileProxy[]{file}, -1);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "refresh: will need recursive refresh for deleted folder {0}", file.getPath());
                    }
                }
                dir = dir.normalizeFile();
                file = VCSFileProxy.createFileProxy((VCSFileProxy)dir, (String)file.getName());
                HashMap<VCSFileProxy, FileInformation> newFiles = new HashMap<VCSFileProxy, FileInformation>(files);
                if (fi.getStatus() == 0) {
                    newFiles.remove(file);
                    this.turbo.writeEntry((Object)file, "subversion.STATUS_MAP", null);
                } else if (fi.getStatus() == 8 && file.isFile()) {
                    newFiles.remove(file);
                } else {
                    newFiles.remove(file);
                    newFiles.put(file, fi);
                }
                assert (!newFiles.containsKey(dir)) : "Dir " + dir + "contains " + files.toString();
                this.turbo.writeEntry((Object)dir, "subversion.STATUS_MAP", newFiles.isEmpty() ? null : newFiles);
            }
        }
        if (!refreshDone) {
            if (content == null && file.isDirectory() && this.needRecursiveRefresh(fi, current)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "refresh: need recursive refresh for {0}", file.getPath());
                }
                content = this.listFiles(file);
            }
            if (content != null) {
                for (int i = 0; i < content.length; ++i) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "refresh: recursive refresh for {0}, child of {1}", new Object[]{content[i].getPath(), file.getPath()});
                    }
                    this.refresh(content[i], REPOSITORY_STATUS_UNKNOWN);
                }
            }
            this.fireFileStatusChanged(file, current, fi);
        } else {
            if (fi.isDirectory() && "true".equals(System.getProperty("org.netbeans.modules.subversion.FileStatusCache.recursiveScan", "false")) && (fi.getStatus() & 3) == 0 && this.turbo.readEntry((Object)file, "subversion.STATUS_MAP") == null) {
                this.refreshAsync(file.listFiles());
            }
            if (forceChangeEvent) {
                this.fireFileStatusChanged(file, current, fi);
            }
        }
        return fi;
    }

    private boolean isParentIgnored(VCSFileProxy file) {
        VCSFileProxy parent = file.getParentFile();
        if (parent != null) {
            FileInformation parentInfo = this.getCachedStatus(parent);
            return parentInfo != null && parentInfo.getStatus() == 2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patchRevision(VCSFileProxy[] fileArray, SVNRevision.Number revision) {
        for (VCSFileProxy file : fileArray) {
            FileStatusCache fileStatusCache = this;
            synchronized (fileStatusCache) {
                ISVNStatus entry;
                FileInformation status = this.getCachedStatus(file);
                ISVNStatus iSVNStatus = entry = status != null ? status.getEntry(file) : null;
                if (entry != null) {
                    SVNRevision.Number rev = entry.getRevision();
                    if (rev == null) {
                        continue;
                    }
                    if (rev.getNumber() != revision.getNumber()) {
                        FileInformation info = this.createFileInformation(file, new FakeRevisionStatus(entry, revision), REPOSITORY_STATUS_UNKNOWN);
                        VCSFileProxy dir = file.getParentFile();
                        Map<VCSFileProxy, FileInformation> files = this.getScannedFiles(dir);
                        HashMap<VCSFileProxy, FileInformation> newFiles = new HashMap<VCSFileProxy, FileInformation>(files);
                        newFiles.put(file, info);
                        this.turbo.writeEntry((Object)dir, "subversion.STATUS_MAP", newFiles.isEmpty() ? null : newFiles);
                    }
                }
            }
        }
    }

    private static boolean equivalent(FileInformation main, FileInformation other) {
        ISVNStatus e2;
        if (other == null || main.getStatus() != other.getStatus() || main.isDirectory() != other.isDirectory()) {
            return false;
        }
        ISVNStatus e1 = main.getEntry(null);
        return e1 == (e2 = other.getEntry(null)) || e1 == null || e2 == null || FileStatusCache.equal(e1, e2);
    }

    private static boolean equal(ISVNStatus e1, ISVNStatus e2) {
        if (!(SVNStatusKind.IGNORED.equals((Object)e1.getTextStatus()) || SVNStatusKind.UNVERSIONED.equals((Object)e1.getTextStatus()) || SVNStatusKind.ADDED.equals((Object)e1.getTextStatus()))) {
            long r1 = -1L;
            if (e1 != null) {
                SVNRevision.Number r = e1.getRevision();
                r1 = r != null ? e1.getRevision().getNumber() : r1;
            }
            long r2 = -2L;
            if (e2 != null) {
                SVNRevision.Number r = e2.getRevision();
                long l = r2 = r != null ? e2.getRevision().getNumber() : r2;
            }
            if (r1 != r2) {
                return false;
            }
        }
        if (e1.isCopied() != e2.isCopied()) {
            return false;
        }
        return e1.getUrl() == e2.getUrl() || e1.getUrl() != null && e1.getUrl().equals(e2.getUrl());
    }

    private boolean needRecursiveRefresh(FileInformation fi, FileInformation current) {
        if (fi.getStatus() == 2 || current != null && current.getStatus() == 2) {
            return true;
        }
        if (fi.getStatus() == 1 || current != null && current.getStatus() == 1) {
            return true;
        }
        return fi.getStatus() == 4 || current != null && current.getStatus() == 4096;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public boolean ready() {
        return this.ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeIndex() {
        try {
            this.cacheProvider.computeIndex();
            Subversion.getInstance().refreshAllAnnotations();
        }
        finally {
            this.ready = true;
            this.propertySupport.firePropertyChange(PROP_CACHE_READY, false, true);
        }
    }

    void cleanUp() {
        VCSFileProxy[] modifiedFiles = this.cacheProvider.getAllIndexValues();
        if (modifiedFiles.length > 100000) {
            LOG.log(Level.WARNING, "Cache contains too many entries: {0}", modifiedFiles.length);
        }
        for (VCSFileProxy file : modifiedFiles) {
            if (!VCSFileProxySupport.isConnectedFileSystem((FileSystem)VCSFileProxySupport.getFileSystem((VCSFileProxy)file))) continue;
            FileInformation info = this.getCachedStatus(file);
            if (info != null && (info.getStatus() & 0x159D4) != 0) {
                this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
                continue;
            }
            if (info != null && info.getStatus() != 2 || this.exists(file)) continue;
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    void directoryContentChanged(VCSFileProxy dir) {
        Map originalFiles = (Map)this.turbo.readEntry((Object)dir, "subversion.STATUS_MAP");
        if (originalFiles != null) {
            for (VCSFileProxy file : originalFiles.keySet()) {
                this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
            }
        }
    }

    private Map<VCSFileProxy, FileInformation> getScannedFiles(VCSFileProxy dir) {
        if (SvnUtils.isAdministrative(dir)) {
            return NOT_MANAGED_MAP;
        }
        VCSFileProxy parent = dir.getParentFile();
        if (parent != null && SvnUtils.isAdministrative(parent)) {
            return NOT_MANAGED_MAP;
        }
        Map<VCSFileProxy, FileInformation> files = (Map<VCSFileProxy, FileInformation>)this.turbo.readEntry((Object)dir, "subversion.STATUS_MAP");
        if (files != null) {
            if (files.containsKey(dir)) {
                LOG.log(Level.WARNING, "Corrupted cached entry for folder {0}, it contains {1}", new Object[]{dir, files});
                files.remove(dir);
                this.turbo.writeEntry((Object)dir, "subversion.STATUS_MAP", files);
            }
            return files;
        }
        if (this.isNotManagedByDefault(dir)) {
            return NOT_MANAGED_MAP;
        }
        dir = dir.normalizeFile();
        files = this.scanFolder(dir);
        assert (!files.containsKey(dir)) : "Dir " + dir + "contains " + files.toString();
        this.turbo.writeEntry((Object)dir, "subversion.STATUS_MAP", files);
        for (VCSFileProxy file : files.keySet()) {
            FileInformation info = files.get(file);
            if ((info.getStatus() & 0x159D6) == 0) continue;
            this.fireFileStatusChanged(file, null, info);
        }
        return files;
    }

    private boolean isNotManagedByDefault(VCSFileProxy dir) {
        return !dir.exists() && !SvnUtils.isManaged(dir);
    }

    private Map<VCSFileProxy, FileInformation> scanFolder(VCSFileProxy dir) {
        ISVNStatus[] entries;
        HashMap<VCSFileProxy, FileInformation> folderFiles;
        VCSFileProxy[] files;
        block9: {
            files = dir.listFiles();
            if (files == null) {
                files = new VCSFileProxy[]{};
            }
            folderFiles = new HashMap<VCSFileProxy, FileInformation>(files.length);
            entries = null;
            Context context = new Context(dir);
            try {
                if (SvnUtils.isManaged(dir) && !this.isParentIgnored(dir)) {
                    SvnClient client = Subversion.getInstance().getClient(true, context);
                    entries = client.getStatus(dir, false, true);
                }
            }
            catch (SVNClientException e) {
                if (SvnClientExceptionHandler.isUnversionedResource(e.getMessage()) || WorkingCopyAttributesCache.getInstance().isSuppressed(e)) break block9;
                SvnClientExceptionHandler.notifyException(context, e, false, false);
            }
        }
        if (entries == null) {
            for (int i = 0; i < files.length; ++i) {
                FileInformation fi;
                VCSFileProxy file = files[i];
                if (SvnUtils.isAdministrative(file) || !(fi = this.createFileInformation(file, null, REPOSITORY_STATUS_UNKNOWN)).isDirectory() && fi.getStatus() == 8) continue;
                folderFiles.put(file, fi);
            }
        } else {
            HashSet<VCSFileProxy> localFiles = new HashSet<VCSFileProxy>(Arrays.asList(files));
            for (int i = 0; i < entries.length; ++i) {
                FileInformation fi;
                ISVNStatus entry = entries[i];
                VCSFileProxy file = entry.getFile();
                if (file.equals((Object)dir)) continue;
                localFiles.remove(file);
                if (SvnUtils.isAdministrative(file) || !(fi = this.createFileInformation(file, entry, REPOSITORY_STATUS_UNKNOWN)).isDirectory() && fi.getStatus() == 8) continue;
                folderFiles.put(file, fi);
            }
            for (VCSFileProxy localFile : localFiles) {
                FileInformation fi = this.createFileInformation(localFile, null, REPOSITORY_STATUS_UNKNOWN);
                VCSFileProxy topmost = Subversion.getInstance().getTopmostManagedAncestor(localFile);
                if (!fi.isDirectory() && topmost != null && (fi.getStatus() == 8 || this.isSymlink(localFile))) continue;
                folderFiles.put(localFile, fi);
            }
        }
        return folderFiles;
    }

    private FileInformation createFileInformation(VCSFileProxy file, ISVNStatus status, RepositoryStatus repositoryStatus) {
        if (status == null || status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
            if (!SvnUtils.isManaged(file)) {
                return file.isDirectory() ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_NOTMANAGED;
            }
            return this.createMissingEntryFileInformation(file, repositoryStatus);
        }
        return this.createVersionedFileInformation(file, status, repositoryStatus);
    }

    private FileInformation createVersionedFileInformation(VCSFileProxy file, ISVNStatus status, RepositoryStatus repositoryStatus) {
        SVNStatusKind kind = status.getTextStatus();
        SVNStatusKind pkind = status.getPropStatus();
        int remoteStatus = 0;
        if (repositoryStatus != REPOSITORY_STATUS_UNKNOWN) {
            if (repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.MODIFIED || repositoryStatus.getStatus().getRepositoryPropStatus() == SVNStatusKind.MODIFIED) {
                remoteStatus = 32;
            } else if (repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.DELETED) {
                remoteStatus = 1024;
            } else if (!(repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.ADDED || repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.REPLACED || repositoryStatus.getStatus().getRepositoryTextStatus() == null && repositoryStatus.getStatus().getRepositoryPropStatus() == null || repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.NONE && repositoryStatus.getStatus().getRepositoryPropStatus() == SVNStatusKind.NONE)) {
                Subversion.LOG.log(Level.WARNING, "SVN.FSC: unhandled repository status: {0}\n\ttext: {1}\n\tprop: {2}", new Object[]{file.getPath(), repositoryStatus.getStatus().getRepositoryTextStatus(), repositoryStatus.getStatus().getRepositoryPropStatus()});
            }
            if (repositoryStatus.getLock() != null) {
                remoteStatus |= 0x8000;
            }
        }
        if (status.getLockOwner() != null) {
            remoteStatus = 0x2000 | remoteStatus;
        }
        int propertyStatus = 0;
        if (!SVNStatusKind.NONE.equals((Object)pkind) && !SVNStatusKind.NORMAL.equals((Object)pkind)) {
            if (SVNStatusKind.MODIFIED.equals((Object)pkind)) {
                propertyStatus = 65536;
            } else {
                if (SVNStatusKind.CONFLICTED.equals((Object)pkind)) {
                    return new FileInformation(0x40 | remoteStatus, status);
                }
                throw new IllegalArgumentException("Unknown prop status: " + (Object)((Object)status.getPropStatus()));
            }
        }
        int additionalStatus = remoteStatus | propertyStatus;
        if (status.hasTreeConflict()) {
            return new FileInformation(0x4000 | additionalStatus, status);
        }
        if (SVNStatusKind.NONE.equals((Object)kind)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (SVNStatusKind.NORMAL.equals((Object)kind)) {
            int finalStatus = 8 | remoteStatus;
            if (propertyStatus != 0) {
                finalStatus = additionalStatus;
            }
            return new FileInformation(finalStatus, status);
        }
        if (SVNStatusKind.MODIFIED.equals((Object)kind)) {
            return new FileInformation(0x10 | additionalStatus, status);
        }
        if (SVNStatusKind.ADDED.equals((Object)kind)) {
            return new FileInformation(0x1000 | additionalStatus, status);
        }
        if (SVNStatusKind.DELETED.equals((Object)kind)) {
            return new FileInformation(0x100 | additionalStatus, status);
        }
        if (SVNStatusKind.UNVERSIONED.equals((Object)kind)) {
            return new FileInformation(4 | additionalStatus, status);
        }
        if (SVNStatusKind.MISSING.equals((Object)kind)) {
            return new FileInformation(0x800 | additionalStatus, status);
        }
        if (SVNStatusKind.REPLACED.equals((Object)kind)) {
            return new FileInformation(0x1000 | additionalStatus, status);
        }
        if (SVNStatusKind.MERGED.equals((Object)kind)) {
            return new FileInformation(0x80 | additionalStatus, status);
        }
        if (SVNStatusKind.CONFLICTED.equals((Object)kind)) {
            return new FileInformation(0x40 | additionalStatus, status);
        }
        if (SVNStatusKind.OBSTRUCTED.equals((Object)kind)) {
            return new FileInformation(0x40 | additionalStatus, status);
        }
        if (SVNStatusKind.IGNORED.equals((Object)kind)) {
            return new FileInformation(2 | remoteStatus, status);
        }
        if (SVNStatusKind.INCOMPLETE.equals((Object)kind)) {
            return new FileInformation(0x40 | additionalStatus, status);
        }
        if (SVNStatusKind.EXTERNAL.equals((Object)kind)) {
            return new FileInformation(8 | remoteStatus, status);
        }
        throw new IllegalArgumentException("Unknown text status: " + (Object)((Object)status.getTextStatus()));
    }

    static String statusText(ISVNStatus status) {
        return "file: " + status.getTextStatus().toString() + " copied: " + status.isCopied() + " prop: " + status.getPropStatus().toString();
    }

    private FileInformation createMissingEntryFileInformation(VCSFileProxy file, RepositoryStatus repositoryStatus) {
        String masterName;
        VCSFileProxy master;
        int parentStatus;
        boolean exists = file.exists();
        VCSFileProxy parent = file.getParentFile();
        if (parent == null) {
            LOG.log(Level.WARNING, "createMissingEntryFileInformation for root folder: {0}, isManaged={1}", new Object[]{file, SvnUtils.isManaged(file)});
        }
        if (exists && VCSFileProxySupport.isMac((VCSFileProxy)file) && parent != null) {
            exists = false;
            VCSFileProxy[] listFiles = parent.listFiles();
            if (listFiles != null) {
                for (VCSFileProxy child : listFiles) {
                    if (!child.getName().equals(file.getName())) continue;
                    exists = true;
                    break;
                }
            }
        }
        boolean isDirectory = exists && file.isDirectory();
        int n = parentStatus = parent == null || this.isNotManagedByDefault(parent) ? 1 : this.getStatus(parent).getStatus();
        if (parentStatus == 2) {
            return isDirectory ? FILE_INFORMATION_EXCLUDED_DIRECTORY : FILE_INFORMATION_EXCLUDED;
        }
        if (exists && parentStatus == 1) {
            if (isDirectory) {
                return SvnUtils.isPartOfSubversionMetadata(file) ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_UPTODATE_DIRECTORY;
            }
            return FILE_INFORMATION_NOTMANAGED;
        }
        String name = file.getName();
        Matcher m = auxConflictPattern.matcher(name);
        if (exists && m.matches() && parent != null && (master = VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)(masterName = m.group(1)))).isFile()) {
            return FILE_INFORMATION_EXCLUDED;
        }
        if (exists) {
            if (Subversion.getInstance().isIgnored(file) || repositoryStatus != null && repositoryStatus.getStatus().getTextStatus() == SVNStatusKind.EXTERNAL) {
                return new FileInformation(2, file.isDirectory());
            }
            return new FileInformation(4, file.isDirectory());
        }
        if (repositoryStatus != REPOSITORY_STATUS_UNKNOWN && (repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.ADDED || repositoryStatus.getStatus().getRepositoryTextStatus() == SVNStatusKind.REPLACED)) {
            boolean folder = repositoryStatus.getStatus().getNodeKind() == SVNNodeKind.DIR;
            return new FileInformation(512, folder);
        }
        return FILE_INFORMATION_UNKNOWN;
    }

    private boolean exists(VCSFileProxy file) {
        if (!file.exists()) {
            return false;
        }
        return file.getPath().equals(file.normalizeFile().getPath());
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    private void fireFileStatusChanged(VCSFileProxy file, FileInformation oldInfo, FileInformation newInfo) {
        this.getLabelsCache().remove(file);
        this.listenerSupport.fireVersioningEvent(EVENT_FILE_STATUS_CHANGED, new Object[]{file, oldInfo, newInfo});
    }

    private boolean isSymlink(VCSFileProxy file) {
        boolean symlink = false;
        if (EXCLUDE_SYMLINKS) {
            symlink = VCSFileProxySupport.isSymlink((VCSFileProxy)file);
        }
        return symlink;
    }

    public FileLabelCache getLabelsCache() {
        return this.labelsCache;
    }

    public static class RepositoryStatus {
        private final ISVNStatus status;
        private final ISVNLock lock;

        public RepositoryStatus(ISVNStatus status, ISVNLock lock) {
            this.status = status;
            this.lock = lock;
        }

        public ISVNStatus getStatus() {
            return this.status;
        }

        public ISVNLock getLock() {
            return this.lock;
        }
    }

    public static class FileLabelInfo {
        private static final long VALID_LABEL_PERIOD = 20000L;
        private final String revisionString;
        private final String binaryString;
        private final String stickyString;
        private final String lastRevisionString;
        private final String lastAuthorString;
        private final String lastDateString;
        private boolean pickedUp;
        private long timestamp;

        private FileLabelInfo(String revisionString, String binaryString, String stickyString, String lastAuthorString, String lastDateString, String lastRevisionString) {
            this.revisionString = revisionString;
            this.binaryString = binaryString;
            this.stickyString = stickyString;
            this.lastAuthorString = lastAuthorString;
            this.lastDateString = lastDateString;
            this.lastRevisionString = lastRevisionString;
            this.updateTimestamp();
        }

        private void updateTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isValid(boolean mimeFlag, boolean checkFirstAccess) {
            block3: {
                long diff;
                block2: {
                    diff = System.currentTimeMillis() - this.timestamp;
                    if (!checkFirstAccess || this.pickedUp) break block2;
                    this.pickedUp = true;
                    if (true) break block3;
                }
                if (diff > 20000L) return false;
            }
            boolean bl = true;
            boolean valid = bl;
            if (!valid) return false;
            if (!mimeFlag) return true;
            if (this.binaryString == null) return false;
            return true;
        }

        String getRevisionString() {
            return this.revisionString != null ? this.revisionString : "";
        }

        public String getBinaryString() {
            return this.binaryString != null ? this.binaryString : "";
        }

        public String getStickyString() {
            return this.stickyString != null ? this.stickyString : "";
        }

        public String getLastRevisionString() {
            return this.lastRevisionString == null ? "" : this.lastRevisionString;
        }

        public String getLastDateString() {
            return this.lastDateString == null ? "" : this.lastDateString;
        }

        public String getLastAuthorString() {
            return this.lastAuthorString == null ? "" : this.lastAuthorString;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileLabelInfo) {
                FileLabelInfo other = (FileLabelInfo)obj;
                return this.getRevisionString().equals(other.getRevisionString()) && this.getBinaryString().equals(other.getBinaryString()) && this.getStickyString().equals(other.getStickyString()) && this.getLastAuthorString().equals(other.getLastAuthorString()) && this.getLastDateString().equals(other.getLastDateString()) && this.getLastRevisionString().equals(other.getLastRevisionString());
            }
            return super.equals(obj);
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + (this.revisionString != null ? this.revisionString.hashCode() : 0);
            hash = 71 * hash + (this.binaryString != null ? this.binaryString.hashCode() : 0);
            hash = 71 * hash + (this.stickyString != null ? this.stickyString.hashCode() : 0);
            hash = 71 * hash + (this.lastRevisionString != null ? this.lastRevisionString.hashCode() : 0);
            hash = 71 * hash + (this.lastAuthorString != null ? this.lastAuthorString.hashCode() : 0);
            hash = 71 * hash + (this.lastDateString != null ? this.lastDateString.hashCode() : 0);
            return hash;
        }
    }

    public class FileLabelCache {
        private final LinkedHashMap<VCSFileProxy, FileLabelInfo> fileLabels;
        private final Set<VCSFileProxy> filesForLabelRefresh = new HashSet<VCSFileProxy>();
        private final RequestProcessor.Task labelInfoRefreshTask;
        private final FileStatusCache master;

        private FileLabelCache(FileStatusCache master) {
            this.master = master;
            this.labelInfoRefreshTask = master.rp.create((Runnable)((Object)new LabelInfoRefreshTask()));
            this.fileLabels = new LinkedHashMap(100);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushFileLabels(VCSFileProxy ... files) {
            LinkedHashMap<VCSFileProxy, FileLabelInfo> linkedHashMap = this.fileLabels;
            synchronized (linkedHashMap) {
                if (files == null) {
                    this.fileLabels.clear();
                    return;
                }
                for (VCSFileProxy f : files) {
                    if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                        LABELS_CACHE_LOG.log(Level.FINE, "Removing from cache: {0}", f.getPath());
                    }
                    this.fileLabels.remove(f);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressWarnings(value={"RCN"})
        public FileLabelInfo getLabelInfo(VCSFileProxy file, boolean mimeTypeFlag) {
            FileLabelInfo labelInfo;
            boolean refreshInfo = false;
            LinkedHashMap<VCSFileProxy, FileLabelInfo> linkedHashMap = this.fileLabels;
            synchronized (linkedHashMap) {
                labelInfo = this.fileLabels.get(file);
                if (labelInfo == null || !labelInfo.isValid(mimeTypeFlag, true)) {
                    if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                        if (labelInfo == null && LABELS_CACHE_LOG.isLoggable(Level.FINER)) {
                            LABELS_CACHE_LOG.log(Level.FINER, "No item in cache for : {0}", file.getPath());
                        } else if (labelInfo != null) {
                            LABELS_CACHE_LOG.log(Level.FINE, "Too old item in cache for : {0}", file.getPath());
                        }
                    }
                    if (labelInfo == null) {
                        labelInfo = FAKE_LABEL_INFO;
                    }
                    refreshInfo = true;
                }
            }
            if (refreshInfo) {
                this.refreshLabelFor(file);
            }
            if (VERSIONING_ASYNC_ANNOTATOR) {
                labelInfo = this.fileLabels.get(file);
                assert (labelInfo != null) : "null label info for " + file.getPath();
                if (labelInfo == null) {
                    labelInfo = FAKE_LABEL_INFO;
                }
            }
            return labelInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshLabelFor(VCSFileProxy file) {
            Set<VCSFileProxy> set = this.filesForLabelRefresh;
            synchronized (set) {
                this.filesForLabelRefresh.add(file);
            }
            if (!EventQueue.isDispatchThread() || VERSIONING_ASYNC_ANNOTATOR) {
                this.labelInfoRefreshTask.run();
            } else {
                this.labelInfoRefreshTask.schedule(200);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(VCSFileProxy file) {
            LinkedHashMap<VCSFileProxy, FileLabelInfo> linkedHashMap = this.fileLabels;
            synchronized (linkedHashMap) {
                this.fileLabels.remove(file);
            }
        }

        private class LabelInfoRefreshTask
        extends Task {
            private LabelInfoRefreshTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashSet filesToRefresh;
                Set set = FileLabelCache.this.filesForLabelRefresh;
                synchronized (set) {
                    filesToRefresh = new HashSet(FileLabelCache.this.filesForLabelRefresh);
                    FileLabelCache.this.filesForLabelRefresh.clear();
                }
                if (!filesToRefresh.isEmpty()) {
                    HashMap<VCSFileProxy, FileLabelInfo> labels = new HashMap<VCSFileProxy, FileLabelInfo>(filesToRefresh.size());
                    for (VCSFileProxy file : filesToRefresh) {
                        try {
                            String lastRevisionString;
                            FileInformation fi = FileLabelCache.this.master.getCachedStatus(file);
                            if (fi != null && (fi.getStatus() & 2) != 0 || FileLabelCache.this.master.isParentIgnored(file)) {
                                labels.put(file, FAKE_LABEL_INFO);
                                continue;
                            }
                            Context context = new Context(file);
                            SvnClient client = Subversion.getInstance().getClient(false, context);
                            ISVNInfo info = SvnUtils.getInfoFromWorkingCopy(client, file);
                            SVNRevision.Number rev = info.getRevision();
                            String binaryString = null;
                            String lastDateString = null;
                            String revisionString = rev != null && !"-1".equals(((SVNRevision)rev).toString()) ? ((SVNRevision)rev).toString() : "";
                            rev = info.getLastChangedRevision();
                            String string = lastRevisionString = rev != null && !"-1".equals(((SVNRevision)rev).toString()) ? ((SVNRevision)rev).toString() : "";
                            if (info.getLastChangedDate() != null) {
                                lastDateString = DateFormat.getDateTimeInstance(3, 3).format(info.getLastChangedDate());
                            }
                            Annotator.AnnotationFormat af = FileStatusCache.this.annotator.getAnnotationFormat(context.getFileSystem());
                            if (af.mimeTypeFlag) {
                                binaryString = fi == null || (fi.getStatus() & 6) == 0 ? this.getMimeType(client, file) : "";
                            }
                            String stickyString = fi == null || (fi.getStatus() & 2) == 0 ? (info.getUrl() != null ? SvnUtils.getCopy(context, info.getUrl()) : SvnUtils.getCopy(file)) : "";
                            labels.put(file, new FileLabelInfo(revisionString, binaryString, stickyString, info.getLastCommitAuthor(), lastDateString, lastRevisionString));
                        }
                        catch (SVNClientException ex) {
                            if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) {
                                try {
                                    WorkingCopyAttributesCache.getInstance().logSuppressed(ex, file);
                                }
                                catch (SVNClientException ex1) {}
                            } else if (!SvnClientExceptionHandler.isUnversionedResource(ex.getMessage())) {
                                LABELS_CACHE_LOG.log(Level.WARNING, "LabelInfoRefreshTask: failed getting info and info for {0}", file.getPath());
                                LABELS_CACHE_LOG.log(Level.INFO, null, ex);
                            }
                            labels.put(file, FAKE_LABEL_INFO);
                        }
                    }
                    LinkedHashMap linkedHashMap = FileLabelCache.this.fileLabels;
                    synchronized (linkedHashMap) {
                        for (Map.Entry e : labels.entrySet()) {
                            ((FileLabelInfo)e.getValue()).updateTimestamp();
                            FileLabelInfo oldInfo = (FileLabelInfo)FileLabelCache.this.fileLabels.remove(e.getKey());
                            FileLabelCache.this.fileLabels.put(e.getKey(), e.getValue());
                            if (!((FileLabelInfo)e.getValue()).equals(oldInfo)) continue;
                            filesToRefresh.remove(e.getKey());
                        }
                    }
                    if (!VERSIONING_ASYNC_ANNOTATOR) {
                        Subversion.getInstance().refreshAnnotations(filesToRefresh.toArray(new VCSFileProxy[filesToRefresh.size()]));
                    }
                    linkedHashMap = FileLabelCache.this.fileLabels;
                    synchronized (linkedHashMap) {
                        if (FileLabelCache.this.fileLabels.size() > 50) {
                            if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                                LABELS_CACHE_LOG.log(Level.FINE, "Cache contains : {0} entries before a cleanup", FileLabelCache.this.fileLabels.size());
                            }
                            Iterator it = FileLabelCache.this.fileLabels.keySet().iterator();
                            while (it.hasNext()) {
                                VCSFileProxy f = (VCSFileProxy)it.next();
                                Annotator.AnnotationFormat af = FileStatusCache.this.annotator.getAnnotationFormat(VCSFileProxySupport.getFileSystem((VCSFileProxy)f));
                                if (((FileLabelInfo)FileLabelCache.this.fileLabels.get(f)).isValid(af.mimeTypeFlag, false)) break;
                                it.remove();
                            }
                            if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                                LABELS_CACHE_LOG.log(Level.FINE, "Cache contains : {0} entries after a cleanup", FileLabelCache.this.fileLabels.size());
                            }
                        }
                    }
                }
            }

            private String getMimeType(SvnClient client, VCSFileProxy file) {
                try {
                    ISVNProperty prop = client.propertyGet(file, "svn:mime-type");
                    if (prop != null) {
                        String mime = prop.getValue();
                        return mime != null ? mime : "";
                    }
                }
                catch (SVNClientException ex) {
                    if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                        LABELS_CACHE_LOG.log(Level.FINE, null, ex);
                    }
                    return "";
                }
                return "";
            }
        }
    }

    private static class FakeRevisionStatus
    implements ISVNStatus {
        private final ISVNStatus value;
        private final SVNRevision.Number revision;

        public FakeRevisionStatus(ISVNStatus value, SVNRevision.Number revision) {
            this.value = value;
            this.revision = revision;
        }

        @Override
        public boolean isWcLocked() {
            return this.value.isWcLocked();
        }

        @Override
        public boolean isSwitched() {
            return this.value.isSwitched();
        }

        @Override
        public boolean isCopied() {
            return this.value.isCopied();
        }

        @Override
        public String getUrlString() {
            return this.value.getUrlString();
        }

        @Override
        public SVNUrl getUrl() {
            return this.value.getUrl();
        }

        @Override
        public SVNStatusKind getTextStatus() {
            return this.value.getTextStatus();
        }

        @Override
        public SVNRevision.Number getRevision() {
            return this.revision;
        }

        @Override
        public SVNStatusKind getRepositoryTextStatus() {
            return this.value.getRepositoryTextStatus();
        }

        @Override
        public SVNStatusKind getRepositoryPropStatus() {
            return this.value.getRepositoryPropStatus();
        }

        @Override
        public SVNStatusKind getPropStatus() {
            return this.value.getPropStatus();
        }

        @Override
        public String getPath() {
            return this.value.getPath();
        }

        @Override
        public SVNNodeKind getNodeKind() {
            return this.value.getNodeKind();
        }

        @Override
        public String getLockOwner() {
            return this.value.getLockOwner();
        }

        @Override
        public Date getLockCreationDate() {
            return this.value.getLockCreationDate();
        }

        @Override
        public String getLockComment() {
            return this.value.getLockComment();
        }

        @Override
        public String getLastCommitAuthor() {
            return this.value.getLastCommitAuthor();
        }

        @Override
        public SVNRevision.Number getLastChangedRevision() {
            return this.value.getLastChangedRevision();
        }

        @Override
        public Date getLastChangedDate() {
            return this.value.getLastChangedDate();
        }

        @Override
        public VCSFileProxy getFile() {
            return this.value.getFile();
        }

        @Override
        public VCSFileProxy getConflictWorking() {
            return this.value.getConflictWorking();
        }

        @Override
        public VCSFileProxy getConflictOld() {
            return this.value.getConflictOld();
        }

        @Override
        public VCSFileProxy getConflictNew() {
            return this.value.getConflictNew();
        }

        @Override
        public boolean hasTreeConflict() {
            return this.value.hasTreeConflict();
        }

        @Override
        public SVNConflictDescriptor getConflictDescriptor() {
            return this.value.getConflictDescriptor();
        }

        @Override
        public boolean isFileExternal() {
            return this.value.isFileExternal();
        }

        @Override
        public String getMovedFromAbspath() {
            return this.value.getMovedFromAbspath();
        }

        @Override
        public String getMovedToAbspath() {
            return this.value.getMovedToAbspath();
        }
    }

    private static final class NotManagedMap
    extends AbstractMap<VCSFileProxy, FileInformation> {
        private NotManagedMap() {
        }

        @Override
        public Set<Map.Entry<VCSFileProxy, FileInformation>> entrySet() {
            return Collections.emptySet();
        }
    }
}

