/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNProperty;
import org.netbeans.modules.subversion.remote.api.ISVNStatus;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNStatusKind;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnClientFactory;
import org.netbeans.modules.subversion.remote.notifications.NotificationsManager;
import org.netbeans.modules.subversion.remote.ui.status.StatusAction;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnSearchHistorySupport;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSInterceptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class FilesystemHandler
extends VCSInterceptor {
    private final FileStatusCache cache;
    private final Set<VCSFileProxy> movedFiles = new HashSet<VCSFileProxy>();
    private final Set<VCSFileProxy> copiedFiles = new HashSet<VCSFileProxy>();
    private final Set<VCSFileProxy> internalyDeletedFiles = new HashSet<VCSFileProxy>();
    private final Set<VCSFileProxy> toLockFiles = Collections.synchronizedSet(new HashSet());
    private final Map<VCSFileProxy, Boolean> readOnlyFiles = Collections.synchronizedMap(new LinkedHashMap<VCSFileProxy, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<VCSFileProxy, Boolean> eldest) {
            return this.size() > 100;
        }
    });
    private static final RequestProcessor RP = new RequestProcessor("Subversion FileSystemHandler", 1, false, false);
    private final Set<VCSFileProxy> invalidMetadata = new HashSet<VCSFileProxy>(5);
    private static final int STATUS_VCS_MODIFIED_ATTRIBUTE = 86228;

    public FilesystemHandler(Subversion svn) {
        this.cache = svn.getStatusCache();
    }

    public boolean beforeDelete(VCSFileProxy file) {
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.log(Level.FINE, "beforeDelete {0}", file);
        }
        if (!SvnClientFactory.isClientAvailable(new Context(file))) {
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.fine(" skipping delete due to missing client");
            }
            return false;
        }
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return true;
        }
        return this.isVersioned(file.getParentFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(VCSFileProxy file) throws IOException {
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.log(Level.FINE, "doDelete {0}", file);
        }
        if (!SvnUtils.isPartOfSubversionMetadata(file)) {
            try {
                SvnClient client = Subversion.getInstance().getClient(false, new Context(file));
                try {
                    client.remove(new VCSFileProxy[]{file}, true);
                    return;
                }
                catch (SVNClientException ex) {
                    try {
                        if (this.isVersioned(file.getParentFile())) {
                            client.remove(new VCSFileProxy[]{file}, true);
                        }
                        this.internalyDeletedFiles.add(file);
                    }
                    catch (SVNClientException e) {
                        if (e.getMessage().indexOf("does not exist") < 0) {
                            if (!WorkingCopyAttributesCache.getInstance().isSuppressed(e)) {
                                SvnClientExceptionHandler.notifyException(new Context(file), e, false, false);
                            }
                            IOException ex2 = new IOException();
                            Exceptions.attachLocalizedMessage((Throwable)ex2, (String)NbBundle.getMessage(FilesystemHandler.class, (String)"MSG_DeleteFailed", (Object[])new Object[]{file, e.getLocalizedMessage()}));
                            ex2.getCause().initCause(e);
                            throw ex2;
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.internalyDeletedFiles.add(file);
            }
        }
    }

    public void afterDelete(final VCSFileProxy file) {
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.log(Level.FINE, "afterDelete {0}", file);
        }
        if (file == null || SvnUtils.isPartOfSubversionMetadata(file)) {
            return;
        }
        if (this.internalyDeletedFiles.remove(file)) {
            this.cache.refreshAsync(file);
            return;
        }
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block7: {
                    try {
                        VCSFileProxy parent = file.getParentFile();
                        if (parent == null || parent.exists()) break block7;
                    }
                    catch (Throwable throwable) {
                        FilesystemHandler.this.cache.refreshAsync(file);
                        throw throwable;
                    }
                    FilesystemHandler.this.cache.refreshAsync(file);
                    return;
                }
                try {
                    SvnClient client = Subversion.getInstance().getClient(false, new Context(file));
                    if (FilesystemHandler.this.shallRemove(client, file)) {
                        client.remove(new VCSFileProxy[]{file}, true);
                    }
                }
                catch (SVNClientException e) {
                    if (Subversion.LOG.isLoggable(Level.FINER)) {
                        Subversion.LOG.log(Level.FINER, null, e);
                    }
                }
                FilesystemHandler.this.cache.refreshAsync(file);
            }
        });
    }

    private void moveFolderToDifferentRepository(VCSFileProxy from, VCSFileProxy to) throws IOException, SVNClientException {
        VCSFileProxy[] files;
        assert (from.isDirectory());
        assert (to.getParentFile().exists());
        if (!to.exists()) {
            if (VCSFileProxySupport.mkdir((VCSFileProxy)to)) {
                this.cache.refreshAsync(to);
            } else {
                Subversion.LOG.log(Level.WARNING, "{0}: Cannot create folder {1}", new Object[]{FilesystemHandler.class.getName(), to});
            }
        }
        if ((files = from.listFiles()) != null) {
            for (VCSFileProxy file : files) {
                if (SvnUtils.isAdministrative(file)) continue;
                this.svnMoveImplementation(file, VCSFileProxy.createFileProxy((VCSFileProxy)to, (String)file.getName()));
            }
        }
    }

    private void copyFolderToDifferentRepository(VCSFileProxy from, VCSFileProxy to) throws IOException, SVNClientException {
        VCSFileProxy[] files;
        assert (from.isDirectory());
        assert (to.getParentFile().exists());
        if (!to.exists()) {
            if (VCSFileProxySupport.mkdir((VCSFileProxy)to)) {
                this.cache.refreshAsync(to);
            } else {
                Subversion.LOG.log(Level.WARNING, "{0}: Cannot create folder {1}", new Object[]{FilesystemHandler.class.getName(), to});
            }
        }
        if ((files = from.listFiles()) != null) {
            for (VCSFileProxy file : files) {
                if (SvnUtils.isAdministrative(file)) continue;
                this.svnCopyImplementation(file, VCSFileProxy.createFileProxy((VCSFileProxy)to, (String)file.getName()));
            }
        }
    }

    private boolean shallRemove(SvnClient client, VCSFileProxy file) throws SVNClientException {
        boolean retval = true;
        if (!"true".equals(System.getProperty("org.netbeans.modules.subversion.deleteMissingFiles", "false"))) {
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.log(Level.FINE, "File {0} deleted externally, metadata not repaired (org.netbeans.modules.subversion.deleteMissingFiles=false by default)", new String[]{file.getPath()});
            }
            retval = false;
        } else {
            String existingFilename;
            ISVNStatus status = FilesystemHandler.getStatus(client, file);
            if (!SVNStatusKind.MISSING.equals((Object)status.getTextStatus())) {
                if (Subversion.LOG.isLoggable(Level.FINE)) {
                    Subversion.LOG.fine(" shallRemove: skipping delete due to correct metadata");
                }
                retval = false;
            } else if (VCSFileProxySupport.isMac((VCSFileProxy)file) && (existingFilename = VCSFileProxySupport.getExistingFilenameInParent((VCSFileProxy)file)) != null) {
                retval = false;
            }
        }
        return retval;
    }

    public boolean beforeMove(VCSFileProxy from, VCSFileProxy to) {
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.log(Level.FINE, "beforeMove {0} -> {1}", new Object[]{from, to});
        }
        if (!SvnClientFactory.isClientAvailable(new Context(from))) {
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.fine(" skipping move due to missing client");
            }
            return false;
        }
        VCSFileProxy destDir = to.getParentFile();
        if (from != null && destDir != null && (this.isVersioned(from) || this.isVersioned(to))) {
            return SvnUtils.isManaged(to);
        }
        return false;
    }

    public void doMove(VCSFileProxy from, VCSFileProxy to) throws IOException {
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.log(Level.FINE, "doMove {0} -> {1}", new Object[]{from, to});
        }
        this.svnMoveImplementation(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterMove(VCSFileProxy from, VCSFileProxy to) {
        VCSFileProxy[] files;
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.log(Level.FINE, "afterMove {0} -> {1}", new Object[]{from, to});
        }
        Set<VCSFileProxy> set = this.movedFiles;
        synchronized (set) {
            this.movedFiles.add(from);
            files = this.movedFiles.toArray(new VCSFileProxy[this.movedFiles.size()]);
            this.movedFiles.clear();
        }
        this.cache.refreshAsync(true, to);
        this.cache.refreshAsync(files);
        VCSFileProxy parent = to.getParentFile();
        if (parent != null && from.equals((Object)to)) {
            Subversion.LOG.log(Level.WARNING, "Wrong (identity) rename event for {0}", from.getPath());
        }
    }

    public boolean beforeCopy(VCSFileProxy from, VCSFileProxy to) {
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.log(Level.FINE, "beforeCopy {0} -> {1}", new Object[]{from, to});
        }
        if (!SvnClientFactory.isClientAvailable(new Context(from))) {
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.fine(" skipping copy due to missing client");
            }
            return false;
        }
        VCSFileProxy destDir = to.getParentFile();
        if (from != null && destDir != null && (this.isVersioned(from) || this.isVersioned(to))) {
            if (from.isDirectory()) {
                return true;
            }
            return SvnUtils.isManaged(to);
        }
        return false;
    }

    public void doCopy(VCSFileProxy from, VCSFileProxy to) throws IOException {
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.log(Level.FINE, "doCopy {0} -> {1}", new Object[]{from, to});
        }
        this.svnCopyImplementation(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCopy(VCSFileProxy from, VCSFileProxy to) {
        VCSFileProxy[] files;
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.log(Level.FINE, "afterCopy {0} -> {1}", new Object[]{from, to});
        }
        Set<VCSFileProxy> set = this.copiedFiles;
        synchronized (set) {
            this.copiedFiles.add(from);
            files = this.copiedFiles.toArray(new VCSFileProxy[this.copiedFiles.size()]);
            this.copiedFiles.clear();
        }
        this.cache.refreshAsync(true, to);
        this.cache.refreshAsync(files);
        VCSFileProxy parent = to.getParentFile();
        if (parent != null && from.equals((Object)to)) {
            Subversion.LOG.log(Level.WARNING, "Wrong (identity) rename event for {0}", from.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void svnCopyImplementation(VCSFileProxy from, VCSFileProxy to) throws IOException {
        try {
            SvnClient client = Subversion.getInstance().getClient(false, new Context(from));
            this.removeInvalidMetadata();
            VCSFileProxy parent = to.isDirectory() ? to : to.getParentFile();
            boolean parentManaged = false;
            boolean parentIgnored = false;
            if (parent != null && (parentManaged = SvnUtils.isManaged(parent)) && !this.isVersioned(parent)) {
                parentIgnored = !this.addDirectories(parent);
            }
            int retryCounter = 6;
            while (true) {
                try {
                    ISVNStatus toStatus = FilesystemHandler.getStatus(client, to);
                    ISVNStatus status = FilesystemHandler.getStatus(client, from);
                    List<VCSFileProxy> srcChildren = null;
                    try {
                        srcChildren = SvnUtils.listManagedRecursively(from);
                        if (parentIgnored) {
                            if (!this.copyFile(from, to)) {
                                Subversion.LOG.log(Level.INFO, "Cannot copy file {0} to {1}", new Object[]{from, to});
                            }
                        } else if (status != null && (status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED) || status.getTextStatus().equals((Object)SVNStatusKind.IGNORED))) {
                            this.revertDeleted(client, toStatus, to, true);
                            if (!this.copyFile(from, to)) {
                                Subversion.LOG.log(Level.INFO, "Cannot copy file {0} to {1}", new Object[]{from, to});
                            }
                        } else {
                            SVNUrl repositoryTarget;
                            SVNUrl repositorySource = SvnUtils.getRepositoryRootUrl(from);
                            SVNUrl sVNUrl = repositoryTarget = parentManaged ? SvnUtils.getRepositoryRootUrl(parent) : null;
                            if (parentManaged && repositorySource.equals(repositoryTarget)) {
                                client.copy(from, to);
                            } else if (from.isDirectory()) {
                                this.copyFolderToDifferentRepository(from, to);
                            } else if (this.copyFile(from, to)) {
                                if (Subversion.LOG.isLoggable(Level.FINE)) {
                                    Subversion.LOG.log(Level.FINE, FilesystemHandler.class.getName() + ": copying between different repositories {0} to {1}", new Object[]{from, to});
                                }
                            } else {
                                Subversion.LOG.log(Level.WARNING, FilesystemHandler.class.getName() + ": cannot copy {0} to {1}", new Object[]{from, to});
                            }
                        }
                    }
                    finally {
                        Set<VCSFileProxy> set = this.copiedFiles;
                        synchronized (set) {
                            if (srcChildren != null) {
                                this.copiedFiles.addAll(srcChildren);
                            }
                        }
                    }
                }
                catch (SVNClientException e) {
                    if (e.getMessage().endsWith("' locked") && retryCounter > 0) {
                        try {
                            Thread.sleep(107L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        --retryCounter;
                        continue;
                    }
                    if (!WorkingCopyAttributesCache.getInstance().isSuppressed(e)) {
                        SvnClientExceptionHandler.notifyException(null, e, false, false);
                    }
                    IOException ex = new IOException();
                    Exceptions.attachLocalizedMessage((Throwable)ex, (String)NbBundle.getMessage(FilesystemHandler.class, (String)"MSG_MoveFailed", (Object[])new Object[]{from, to, e.getLocalizedMessage()}));
                    ex.getCause().initCause(e);
                    throw ex;
                }
                break;
            }
        }
        catch (SVNClientException e) {
            if (!WorkingCopyAttributesCache.getInstance().isSuppressed(e)) {
                SvnClientExceptionHandler.notifyException(new Context(from), e, false, false);
            }
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)ex, (String)("Subversion failed to move " + from.getPath() + " to: " + to.getPath() + "\n" + e.getLocalizedMessage()));
            ex.getCause().initCause(e);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeCreate(VCSFileProxy file, boolean isDirectory) {
        block12: {
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.log(Level.FINE, "beforeCreate {0}", file);
            }
            if (!SvnClientFactory.isClientAvailable(new Context(file))) {
                if (Subversion.LOG.isLoggable(Level.FINE)) {
                    Subversion.LOG.fine(" skipping create due to missing client");
                }
                return false;
            }
            if (SvnUtils.isPartOfSubversionMetadata(file)) {
                Set<VCSFileProxy> set = this.invalidMetadata;
                synchronized (set) {
                    VCSFileProxy p = file;
                    while (!SvnUtils.isAdministrative(p.getName())) {
                        p = p.getParentFile();
                        assert (p != null) : "file " + file + " doesn't have a .svn parent";
                    }
                    this.invalidMetadata.add(p);
                }
                return false;
            }
            if (!file.exists()) {
                try {
                    SvnClient client = Subversion.getInstance().getClient(false, new Context(file));
                    this.revertDeleted(client, file, true);
                }
                catch (SVNClientException ex) {
                    if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) break block12;
                    SvnClientExceptionHandler.notifyException(new Context(file), ex, false, false);
                }
            }
        }
        return false;
    }

    public void doCreate(VCSFileProxy file, boolean isDirectory) throws IOException {
    }

    public void afterCreate(final VCSFileProxy file) {
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.log(Level.FINE, "afterCreate {0}", file);
        }
        if (file == null) {
            return;
        }
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return;
        }
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block30: {
                    try {
                        VCSFileProxy temporary;
                        block31: {
                            int status = FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                            if ((status & 0xFFFFFFFE) == 0) {
                                return;
                            }
                            if (file.isDirectory()) {
                                FilesystemHandler.this.cache.directoryContentChanged(file);
                                break block30;
                            }
                            if ((status & 0x100) == 0 || !file.exists()) break block30;
                            temporary = VCSFileProxySupport.generateTemporaryFile((VCSFileProxy)file.getParentFile(), (String)file.getName());
                            try {
                                SvnClient client = Subversion.getInstance().getClient(false, new Context(file));
                                if (VCSFileProxySupport.renameTo((VCSFileProxy)file, (VCSFileProxy)temporary)) {
                                    client.revert(file, false);
                                    VCSFileProxySupport.delete((VCSFileProxy)file);
                                    break block31;
                                }
                                Subversion.LOG.log(Level.WARNING, "FileSystemHandler.afterCreate: cannot rename {0} to {1}", new Object[]{file, temporary});
                                client.addFile(file);
                            }
                            catch (SVNClientException ex) {
                                try {
                                    Subversion.LOG.log(Level.INFO, null, ex);
                                }
                                catch (Throwable throwable) {
                                    if (temporary.exists()) {
                                        try {
                                            if (!VCSFileProxySupport.renameTo((VCSFileProxy)temporary, (VCSFileProxy)file)) {
                                                Subversion.LOG.log(Level.WARNING, "FileSystemHandler.afterCreate: cannot rename {0} back to {1}, {1} exists={2}", new Object[]{temporary, file, file.exists()});
                                                VCSFileProxySupport.copyFile((VCSFileProxy)temporary, (VCSFileProxy)file);
                                            }
                                        }
                                        catch (IOException ex2) {
                                            Subversion.LOG.log(Level.INFO, "FileSystemHandler.afterCreate: cannot copy {0} back to {1}", new Object[]{temporary, file});
                                        }
                                        finally {
                                            VCSFileProxySupport.delete((VCSFileProxy)temporary);
                                        }
                                    }
                                    FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                                    throw throwable;
                                }
                                if (temporary.exists()) {
                                    try {
                                        if (!VCSFileProxySupport.renameTo((VCSFileProxy)temporary, (VCSFileProxy)file)) {
                                            Subversion.LOG.log(Level.WARNING, "FileSystemHandler.afterCreate: cannot rename {0} back to {1}, {1} exists={2}", new Object[]{temporary, file, file.exists()});
                                            VCSFileProxySupport.copyFile((VCSFileProxy)temporary, (VCSFileProxy)file);
                                        }
                                    }
                                    catch (IOException ex3) {
                                        Subversion.LOG.log(Level.INFO, "FileSystemHandler.afterCreate: cannot copy {0} back to {1}", new Object[]{temporary, file});
                                    }
                                    finally {
                                        VCSFileProxySupport.delete((VCSFileProxy)temporary);
                                    }
                                }
                                FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                                break block30;
                            }
                        }
                        if (temporary.exists()) {
                            try {
                                if (!VCSFileProxySupport.renameTo((VCSFileProxy)temporary, (VCSFileProxy)file)) {
                                    Subversion.LOG.log(Level.WARNING, "FileSystemHandler.afterCreate: cannot rename {0} back to {1}, {1} exists={2}", new Object[]{temporary, file, file.exists()});
                                    VCSFileProxySupport.copyFile((VCSFileProxy)temporary, (VCSFileProxy)file);
                                }
                            }
                            catch (IOException ex) {
                                Subversion.LOG.log(Level.INFO, "FileSystemHandler.afterCreate: cannot copy {0} back to {1}", new Object[]{temporary, file});
                            }
                            finally {
                                VCSFileProxySupport.delete((VCSFileProxy)temporary);
                            }
                        }
                        FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                    }
                    catch (Throwable t) {
                        Subversion.LOG.log(Level.INFO, null, t);
                    }
                }
            }
        });
    }

    public void afterChange(final VCSFileProxy file) {
        if (!SvnClientFactory.isClientAvailable(new Context(file))) {
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.fine(" skipping afterChange due to missing client");
            }
            return;
        }
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.log(Level.FINE, "afterChange {0}", file);
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                if ((FilesystemHandler.this.cache.getStatus(file).getStatus() & 0xFFFFFFFE) != 0) {
                    FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        });
    }

    public Object getAttribute(final VCSFileProxy file, String attrName) {
        if ("ProvidedExtensions.RemoteLocation".equals(attrName)) {
            return this.getRemoteRepository(file);
        }
        if ("ProvidedExtensions.Refresh".equals(attrName)) {
            return new Runnable(){

                @Override
                public void run() {
                    if (!SvnClientFactory.isClientAvailable(new Context(file))) {
                        if (Subversion.LOG.isLoggable(Level.FINE)) {
                            Subversion.LOG.fine(" skipping ProvidedExtensions.Refresh due to missing client");
                        }
                        return;
                    }
                    if (!SvnUtils.isManaged(file)) {
                        return;
                    }
                    try {
                        SvnClient client = Subversion.getInstance().getClient(file);
                        if (client != null) {
                            Subversion.getInstance().getStatusCache().refreshCached(new Context(file));
                            StatusAction.executeStatus(file, client, null, false);
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException(new Context(file), ex, true, true);
                        return;
                    }
                }
            };
        }
        if ("ProvidedExtensions.SearchHistorySupport".equals(attrName)) {
            return new SvnSearchHistorySupport(file);
        }
        if ("ProvidedExtensions.VCSIsModified".equals(attrName)) {
            if (file == null) {
                return null;
            }
            if (!SvnClientFactory.isClientAvailable(new Context(file))) {
                if (Subversion.LOG.isLoggable(Level.FINE)) {
                    Subversion.LOG.fine(" skipping ProvidedExtensions.VCSIsModified due to missing client");
                }
                return null;
            }
            if (!SvnUtils.isManaged(file)) {
                return null;
            }
            try {
                SvnClient client = Subversion.getInstance().getClient(file);
                if (client != null) {
                    Context ctx = new Context(file);
                    Subversion.getInstance().getStatusCache().refreshCached(ctx);
                    StatusAction.executeStatus(file, client, null, false);
                    return this.cache.containsFiles(ctx, 86228, true);
                }
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException(new Context(file), ex, false, false);
            }
            return null;
        }
        return super.getAttribute(file, attrName);
    }

    public void beforeEdit(VCSFileProxy file) {
        if (this.cache.ready()) {
            NotificationsManager.getInstance().scheduleFor(file);
        }
        this.ensureLocked(file);
    }

    public long refreshRecursively(VCSFileProxy dir, long lastTimeStamp, List<? super VCSFileProxy> children) {
        long retval = -1L;
        if (SvnUtils.isAdministrative(dir.getName())) {
            retval = 0L;
        }
        return retval;
    }

    public boolean isMutable(VCSFileProxy file) {
        boolean mutable;
        boolean bl = mutable = SvnUtils.isPartOfSubversionMetadata(file) || super.isMutable(file);
        if (!mutable && SvnModuleConfig.getDefault(VCSFileProxySupport.getFileSystem((VCSFileProxy)file)).isAutoLock() && !this.readOnlyFiles.containsKey(file)) {
            this.toLockFiles.add(file);
            return true;
        }
        return mutable;
    }

    private String getRemoteRepository(VCSFileProxy file) {
        SVNUrl url;
        block6: {
            if (file == null) {
                return null;
            }
            url = null;
            try {
                url = SvnUtils.getRepositoryRootUrl(file);
            }
            catch (SVNClientException ex) {
                if (Subversion.LOG.isLoggable(Level.FINE)) {
                    Subversion.LOG.log(Level.FINE, "No repository root url found for managed file : [" + file + "]", ex);
                }
                try {
                    url = SvnUtils.getRepositoryUrl(file);
                }
                catch (SVNClientException ex1) {
                    if (!Subversion.LOG.isLoggable(Level.FINE)) break block6;
                    Subversion.LOG.log(Level.FINE, "No repository url found for managed file : [" + file + "]", ex1);
                }
            }
        }
        return url != null ? SvnUtils.decodeToString(url) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInvalidMetadata() {
        Set<VCSFileProxy> set = this.invalidMetadata;
        synchronized (set) {
            for (VCSFileProxy file : this.invalidMetadata) {
                SvnUtils.deleteRecursively(file);
            }
            this.invalidMetadata.clear();
        }
    }

    private boolean hasMetadata(VCSFileProxy file) {
        return VCSFileProxySupport.canRead((VCSFileProxy)VCSFileProxy.createFileProxy((VCSFileProxy)file, (String)".svn/entries"));
    }

    private boolean isVersioned(VCSFileProxy file) {
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return false;
        }
        if (!file.isFile() && this.hasMetadata(file) || file.isFile() && this.hasMetadata(file.getParentFile())) {
            return true;
        }
        try {
            SVNStatusKind statusKind = SvnUtils.getSingleStatus(Subversion.getInstance().getClient(false, new Context(file)), file).getTextStatus();
            return statusKind != SVNStatusKind.UNVERSIONED && statusKind != SVNStatusKind.IGNORED;
        }
        catch (SVNClientException ex) {
            return false;
        }
    }

    private static List<VCSFileProxy> getDeletedParents(VCSFileProxy file, SvnClient client) throws SVNClientException {
        ArrayList<VCSFileProxy> ret = new ArrayList<VCSFileProxy>();
        for (VCSFileProxy parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            ISVNStatus status = FilesystemHandler.getStatus(client, parent);
            if (status == null || !status.getTextStatus().equals((Object)SVNStatusKind.DELETED)) {
                return ret;
            }
            ret.add(parent);
        }
        return ret;
    }

    private void revertDeleted(SvnClient client, VCSFileProxy file, boolean checkParents) {
        block2: {
            try {
                ISVNStatus status = FilesystemHandler.getStatus(client, file);
                this.revertDeleted(client, status, file, checkParents);
            }
            catch (SVNClientException ex) {
                if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) break block2;
                SvnClientExceptionHandler.notifyException(new Context(file), ex, false, false);
            }
        }
    }

    private void revertDeleted(SvnClient client, ISVNStatus status, VCSFileProxy file, boolean checkParents) {
        block6: {
            try {
                if (this.equals(status, SVNStatusKind.DELETED)) {
                    if (checkParents) {
                        List<VCSFileProxy> deletedParents = FilesystemHandler.getDeletedParents(file, client);
                        for (VCSFileProxy parent : deletedParents) {
                            client.revert(parent, false);
                        }
                        if (!deletedParents.isEmpty()) {
                            Subversion.getInstance().getStatusCache().refreshAsync(deletedParents.toArray(new VCSFileProxy[deletedParents.size()]));
                        }
                    }
                    client.revert(file, false);
                    this.internalyDeletedFiles.add(file);
                    VCSFileProxySupport.delete((VCSFileProxy)file);
                }
            }
            catch (SVNClientException ex) {
                if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) break block6;
                SvnClientExceptionHandler.notifyException(new Context(file), ex, false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void svnMoveImplementation(VCSFileProxy from, VCSFileProxy to) throws IOException {
        try {
            boolean force = true;
            SvnClient client = Subversion.getInstance().getClient(false, new Context(from));
            this.removeInvalidMetadata();
            VCSFileProxy parent = to.isDirectory() ? to : to.getParentFile();
            boolean parentIgnored = false;
            if (parent != null) {
                assert (SvnUtils.isManaged(parent)) : "Cannot move " + from.getPath() + " to " + to.getPath() + ", " + parent.getPath() + " is not managed";
                if (!this.isVersioned(parent)) {
                    parentIgnored = !this.addDirectories(parent);
                }
            }
            int retryCounter = 6;
            while (true) {
                try {
                    ISVNStatus toStatus = FilesystemHandler.getStatus(client, to);
                    ISVNStatus status = FilesystemHandler.getStatus(client, from);
                    List<VCSFileProxy> srcChildren = null;
                    SVNUrl url = status != null && status.isCopied() ? this.getCopiedUrl(client, from) : null;
                    SVNUrl toUrl = toStatus != null ? toStatus.getUrl() : null;
                    try {
                        boolean moved;
                        block46: {
                            srcChildren = SvnUtils.listManagedRecursively(from);
                            moved = true;
                            if (status != null && (status.getTextStatus().equals((Object)SVNStatusKind.ADDED) || status.getTextStatus().equals((Object)SVNStatusKind.REPLACED)) && (!status.isCopied() || url != null && url.equals(toUrl))) {
                                VCSFileProxy temp = from;
                                if (VCSFileProxySupport.isMac((VCSFileProxy)from) && from.getPath().equalsIgnoreCase(to.getPath())) {
                                    if (Subversion.LOG.isLoggable(Level.FINE)) {
                                        Subversion.LOG.log(Level.FINE, "svnMoveImplementation: magic workaround for filename case change {0} -> {1}", new Object[]{from, to});
                                    }
                                    temp = VCSFileProxySupport.generateTemporaryFile((VCSFileProxy)from.getParentFile(), (String)from.getName());
                                    if (Subversion.LOG.isLoggable(Level.FINE)) {
                                        Subversion.LOG.log(Level.FINE, "svnMoveImplementation: magic workaround, step 1: {0} -> {1}", new Object[]{from, temp});
                                    }
                                    client.move(from, temp, force);
                                }
                                this.revertDeleted(client, toStatus, to, true);
                                moved = VCSFileProxySupport.renameTo((VCSFileProxy)temp, (VCSFileProxy)to);
                                if (moved) {
                                    if (status.getTextStatus().equals((Object)SVNStatusKind.ADDED)) {
                                        client.revert(temp, true);
                                    } else {
                                        client.remove(new VCSFileProxy[]{temp}, true);
                                    }
                                }
                            } else if (status != null && (status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED) || status.getTextStatus().equals((Object)SVNStatusKind.IGNORED))) {
                                this.revertDeleted(client, toStatus, to, true);
                                moved = VCSFileProxySupport.renameTo((VCSFileProxy)from, (VCSFileProxy)to);
                            } else if (parentIgnored) {
                                moved = VCSFileProxySupport.renameTo((VCSFileProxy)from, (VCSFileProxy)to);
                                client.remove(new VCSFileProxy[]{from}, true);
                            } else {
                                SVNUrl repositoryTarget;
                                SVNUrl repositorySource = SvnUtils.getRepositoryRootUrl(from);
                                if (repositorySource.equals(repositoryTarget = SvnUtils.getRepositoryRootUrl(parent))) {
                                    try {
                                        client.move(from, to, force);
                                    }
                                    catch (SVNClientException ex) {
                                        if (!VCSFileProxySupport.isMac((VCSFileProxy)from)) throw ex;
                                        if (!from.getPath().equalsIgnoreCase(to.getPath())) throw ex;
                                        if (Subversion.LOG.isLoggable(Level.FINE)) {
                                            Subversion.LOG.log(Level.FINE, "svnMoveImplementation: magic workaround for filename case change {0} -> {1}", new Object[]{from, to});
                                        }
                                        VCSFileProxy temp = VCSFileProxySupport.generateTemporaryFile((VCSFileProxy)to.getParentFile(), (String)from.getName());
                                        if (Subversion.LOG.isLoggable(Level.FINE)) {
                                            Subversion.LOG.log(Level.FINE, "svnMoveImplementation: magic workaround, step 1: {0} -> {1}", new Object[]{from, temp});
                                        }
                                        client.move(from, temp, force);
                                        if (Subversion.LOG.isLoggable(Level.FINE)) {
                                            Subversion.LOG.log(Level.FINE, "svnMoveImplementation: magic workaround, step 2: {0} -> {1}", new Object[]{temp, to});
                                        }
                                        client.move(temp, to, force);
                                        if (Subversion.LOG.isLoggable(Level.FINE)) {
                                            Subversion.LOG.log(Level.FINE, "svnMoveImplementation: magic workaround completed");
                                        }
                                        break block46;
                                    }
                                }
                                boolean remove = false;
                                if (from.isDirectory()) {
                                    this.moveFolderToDifferentRepository(from, to);
                                    remove = true;
                                } else if (VCSFileProxySupport.renameTo((VCSFileProxy)from, (VCSFileProxy)to)) {
                                    remove = true;
                                } else {
                                    Subversion.LOG.log(Level.WARNING, FilesystemHandler.class.getName() + ": cannot rename {0} to {1}", new Object[]{from, to});
                                }
                                if (remove) {
                                    client.remove(new VCSFileProxy[]{from}, force);
                                    if (Subversion.LOG.isLoggable(Level.FINE)) {
                                        Subversion.LOG.log(Level.FINE, FilesystemHandler.class.getName() + ": moving between different repositories {0} to {1}", new Object[]{from, to});
                                    }
                                }
                            }
                        }
                        if (moved) return;
                        Subversion.LOG.log(Level.INFO, "Cannot rename file {0} to {1}", new Object[]{from, to});
                        return;
                    }
                    finally {
                        Set<VCSFileProxy> set = this.movedFiles;
                        synchronized (set) {
                            if (srcChildren != null) {
                                this.movedFiles.addAll(srcChildren);
                            }
                        }
                    }
                }
                catch (SVNClientException e) {
                    if (e.getMessage().endsWith("' locked") && retryCounter > 0) {
                        try {
                            Thread.sleep(107L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        --retryCounter;
                        continue;
                    }
                    if (!WorkingCopyAttributesCache.getInstance().isSuppressed(e)) {
                        SvnClientExceptionHandler.notifyException(new Context(from), e, false, false);
                    }
                    IOException ex = new IOException();
                    Exceptions.attachLocalizedMessage((Throwable)ex, (String)NbBundle.getMessage(FilesystemHandler.class, (String)"MSG_MoveFailed", (Object[])new Object[]{from, to, e.getLocalizedMessage()}));
                    ex.getCause().initCause(e);
                    throw ex;
                }
                break;
            }
        }
        catch (SVNClientException e) {
            if (!WorkingCopyAttributesCache.getInstance().isSuppressed(e)) {
                SvnClientExceptionHandler.notifyException(new Context(from), e, false, false);
            }
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)ex, (String)("Subversion failed to move " + from.getPath() + " to: " + to.getPath() + "\n" + e.getLocalizedMessage()));
            ex.getCause().initCause(e);
            throw ex;
        }
    }

    private boolean addDirectories(VCSFileProxy dir) throws SVNClientException {
        SvnClient client = Subversion.getInstance().getClient(false, new Context(dir));
        ISVNStatus s = FilesystemHandler.getStatus(client, dir);
        if (s.getTextStatus().equals((Object)SVNStatusKind.IGNORED)) {
            return false;
        }
        VCSFileProxy parent = dir.getParentFile();
        if (parent != null) {
            if (SvnUtils.isManaged(parent) && !this.isVersioned(parent) && !this.addDirectories(parent)) {
                return false;
            }
            client.addDirectory(dir, false);
            this.cache.refreshAsync(dir);
            return true;
        }
        throw new SVNClientException("Reached FS root, but it's still not Subversion versioned!");
    }

    private static ISVNStatus getStatus(SvnClient client, VCSFileProxy file) throws SVNClientException {
        return SvnUtils.getSingleStatus(client, file);
    }

    private boolean equals(ISVNStatus status, SVNStatusKind kind) {
        return status != null && status.getTextStatus().equals((Object)kind);
    }

    private boolean copyFile(VCSFileProxy from, VCSFileProxy to) {
        try {
            VCSFileProxySupport.copyFile((VCSFileProxy)from, (VCSFileProxy)to);
        }
        catch (IOException ex) {
            SvnClientExceptionHandler.notifyException(new Context(from), ex, false, false);
            return false;
        }
        return true;
    }

    private void ensureLocked(final VCSFileProxy file) {
        if (this.toLockFiles.contains(file)) {
            Runnable outsideAWT = new Runnable(){

                @Override
                public void run() {
                    boolean readOnly = true;
                    try {
                        SVNUrl url;
                        ISVNStatus status;
                        SvnClient client = Subversion.getInstance().getClient(false, new Context(file));
                        boolean hasPropSet = false;
                        for (ISVNProperty prop : client.getProperties(file)) {
                            if (!"svn:needs-lock".equals(prop.getName())) continue;
                            hasPropSet = true;
                            break;
                        }
                        if (hasPropSet && (status = SvnUtils.getSingleStatus(client, file)) != null && status.getTextStatus() != SVNStatusKind.ADDED && (url = SvnUtils.getRepositoryRootUrl(file)) != null) {
                            client = Subversion.getInstance().getClient(new Context(file), url);
                            if (status.getLockOwner() != null) {
                                client.unlock(new VCSFileProxy[]{file}, false);
                            }
                            client.lock(new VCSFileProxy[]{file}, "", false);
                            readOnly = false;
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException(new Context(file), ex, false, false);
                        readOnly = true;
                    }
                    if (readOnly) {
                        FilesystemHandler.this.readOnlyFiles.put(file, Boolean.TRUE);
                    }
                    FilesystemHandler.this.toLockFiles.remove(file);
                }
            };
            if (EventQueue.isDispatchThread()) {
                Subversion.getInstance().getRequestProcessor().post(outsideAWT);
            } else {
                outsideAWT.run();
            }
        }
    }

    private SVNUrl getCopiedUrl(SvnClient client, VCSFileProxy f) {
        block3: {
            try {
                ISVNInfo info = SvnUtils.getInfoFromWorkingCopy(client, f);
                if (info != null) {
                    return info.getCopyUrl();
                }
            }
            catch (SVNClientException e) {
                if (WorkingCopyAttributesCache.getInstance().isSuppressed(e)) break block3;
                Subversion.LOG.log(Level.INFO, null, e);
            }
        }
        return null;
    }
}

