/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNStatus;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnClientFactory;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.historystore.Storage;
import org.netbeans.modules.versioning.historystore.StorageManager;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class VersionsCache {
    private static final Map<FileSystem, VersionsCache> instances = new HashMap<FileSystem, VersionsCache>();
    private final FileSystem fileSystem;

    private VersionsCache(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public static synchronized VersionsCache getInstance(FileSystem fileSystem) {
        VersionsCache res = instances.get(fileSystem);
        if (res == null) {
            res = new VersionsCache(fileSystem);
            instances.put(fileSystem, res);
        }
        return res;
    }

    public File getFileRevision(SVNUrl repoUrl, SVNUrl url, String revision, String fileName) throws IOException {
        return this.getFileRevision(repoUrl, url, revision, revision, fileName);
    }

    public File getFileRevision(SVNUrl repoUrl, SVNUrl url, String revision, String pegRevision, String fileName) throws IOException {
        boolean canUseRevisionsCache = true;
        try {
            canUseRevisionsCache = SVNRevision.getRevision(revision).getKind() == SVNRevision.Kind.number && SVNRevision.getRevision(pegRevision).getKind() == SVNRevision.Kind.number;
        }
        catch (ParseException ex) {
            // empty catch block
        }
        try {
            SvnClient client;
            InputStream in;
            Context context = new Context(VCSFileProxy.createFileProxy((FileObject)this.fileSystem.getRoot()));
            if (!canUseRevisionsCache || "false".equals(System.getProperty("versioning.subversion.historycache.enable", "true"))) {
                SvnClient client2 = Subversion.getInstance().getClient(context, repoUrl);
                InputStream in2 = this.getInputStream(client2, url, revision, pegRevision);
                return this.createContent(fileName, in2);
            }
            String rootUrl = repoUrl.toString();
            String resourceUrl = url.toString() + "@" + pegRevision;
            Storage cachedVersions = StorageManager.getInstance().getStorage(rootUrl);
            File cachedFile = cachedVersions.getContent(resourceUrl, fileName, revision);
            if (cachedFile.length() == 0L && (cachedFile = this.createContent(fileName, in = this.getInputStream(client = Subversion.getInstance().getClient(context, repoUrl), url, revision, pegRevision))).length() != 0L) {
                cachedVersions.setContent(resourceUrl, revision, cachedFile);
            }
            return cachedFile;
        }
        catch (SVNClientException ex) {
            throw new IOException("Can not load: " + url + " in revision: " + revision, ex);
        }
    }

    public VCSFileProxy getFileRevision(VCSFileProxy base, String revision) throws IOException {
        return this.getFileRevision(base, revision, "BASE");
    }

    public VCSFileProxy getFileRevision(VCSFileProxy base, String revision, String pegRevision) throws IOException {
        try {
            SvnClientFactory.checkClientAvailable(new Context(base));
        }
        catch (SVNClientException e) {
            return null;
        }
        if ("BASE".equals(revision)) {
            return this.getBaseRevisionFile(base);
        }
        if ("PRISTINE".equals(revision)) {
            String name = base.getName();
            VCSFileProxy svnDir = this.getMetadataDir(base.getParentFile());
            if (svnDir != null) {
                VCSFileProxy text_base = VCSFileProxy.createFileProxy((VCSFileProxy)svnDir, (String)"text-base");
                VCSFileProxy pristine = VCSFileProxy.createFileProxy((VCSFileProxy)text_base, (String)(name + ".svn-base"));
                if (pristine.isFile()) {
                    return pristine;
                }
                return null;
            }
            return null;
        }
        if ("LOCAL".equals(revision)) {
            return base;
        }
        SVNRevision svnrevision = SvnUtils.toSvnRevision(revision);
        try {
            InputStream in;
            block19: {
                SvnClient client = Subversion.getInstance().getClient(base);
                FileStatusCache cache = Subversion.getInstance().getStatusCache();
                in = null;
                try {
                    SVNUrl url;
                    boolean gotContent;
                    block18: {
                        gotContent = false;
                        if ((cache.getStatus(base).getStatus() & 0x15DF8) != 0) {
                            try {
                                in = client.getContent(base, svnrevision);
                                gotContent = true;
                            }
                            catch (SVNClientException e) {
                                if (svnrevision.getKind() == SVNRevision.Kind.number && (SvnClientExceptionHandler.isFileNotFoundInRevision(e.getMessage()) || SvnClientExceptionHandler.isPathNotFound(e.getMessage()))) break block18;
                                throw e;
                            }
                        }
                    }
                    if (gotContent) break block19;
                    if ("BASE".equals(pegRevision)) {
                        try {
                            ISVNStatus st = SvnUtils.getSingleStatus(client, base);
                            pegRevision = st != null && st.getRevision() != null ? st.getRevision().toString() : SVNRevision.HEAD.toString();
                        }
                        catch (SVNClientException e) {
                            // empty catch block
                        }
                    }
                    in = (url = SvnUtils.getRepositoryUrl(base)) != null ? this.getInputStream(client, url, revision, pegRevision) : new ByteArrayInputStream(NbBundle.getMessage(VersionsCache.class, (String)"MSG_UnknownURL").getBytes("UTF-8"));
                }
                catch (SVNClientException e) {
                    if (SvnClientExceptionHandler.isFileNotFoundInRevision(e.getMessage()) || SvnClientExceptionHandler.isPathNotFound(e.getMessage())) {
                        in = new ByteArrayInputStream(new byte[0]);
                    }
                    throw e;
                }
            }
            return VCSFileProxy.createFileProxy((File)this.createContent(base.getName(), in));
        }
        catch (SVNClientException ex) {
            throw new IOException("Can not load: " + base.getPath() + " in revision: " + revision, ex);
        }
    }

    VCSFileProxy getBaseRevisionFile(VCSFileProxy referenceFile) throws IOException {
        try {
            VCSFileProxy newMetadataFolder;
            VCSFileProxy topmost;
            boolean newMetadataFormat = false;
            VCSFileProxy svnDir = this.getMetadataDir(referenceFile.getParentFile());
            if (svnDir == null && (topmost = Subversion.getInstance().getTopmostManagedAncestor(referenceFile)) != null && (newMetadataFolder = VCSFileProxy.createFileProxy((VCSFileProxy)topmost, (String)".svn")).exists() && !(newMetadataFormat = VCSFileProxy.createFileProxy((VCSFileProxy)(svnDir = newMetadataFolder), (String)"pristine").exists())) {
                Logger.getLogger(VersionsCache.class.getName()).log(Level.FINE, "No 1.7 metadata in {0}", svnDir);
            }
            if (svnDir == null) {
                return null;
            }
            if (newMetadataFormat) {
                return this.getContentBase(referenceFile, new File(Utils.getTempFolder(), referenceFile.getName() + ".netbeans-base"));
            }
            VCSFileProxy svnBase = VCSFileProxy.createFileProxy((VCSFileProxy)svnDir, (String)("text-base/" + referenceFile.getName() + ".svn-base"));
            if (!svnBase.exists()) {
                if (VCSFileProxy.createFileProxy((VCSFileProxy)svnDir, (String)"pristine").exists()) {
                    return this.getContentBase(referenceFile, new File(Utils.getTempFolder(), referenceFile.getName() + ".netbeans-base"));
                }
                return null;
            }
            VCSFileProxy expanded = VCSFileProxy.createFileProxy((VCSFileProxy)svnDir, (String)("text-base/" + referenceFile.getName() + ".netbeans-base"));
            if (VCSFileProxySupport.canRead((VCSFileProxy)expanded) && svnBase.isFile() && VCSFileProxySupport.length((VCSFileProxy)expanded) == VCSFileProxySupport.length((VCSFileProxy)svnBase) && expanded.lastModified() >= svnBase.lastModified()) {
                return expanded;
            }
            expanded = this.getContentBase(referenceFile, expanded);
            VCSFileProxySupport.setLastModified((VCSFileProxy)expanded, (VCSFileProxy)svnBase);
            return expanded;
        }
        catch (SVNClientException e) {
            throw new IOException(e);
        }
    }

    private VCSFileProxy getContentBase(VCSFileProxy referenceFile, VCSFileProxy output) throws SVNClientException, IOException {
        InputStream in;
        SvnClient client = Subversion.getInstance().getClient(false, new Context(referenceFile));
        try {
            in = client.getContent(referenceFile, SVNRevision.BASE);
        }
        catch (SVNClientException ex) {
            if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage()) || SvnClientExceptionHandler.hasNoBaseRevision(ex.getMessage())) {
                in = new ByteArrayInputStream(new byte[0]);
            }
            throw ex;
        }
        VCSFileProxy res = output.normalizeFile();
        VCSFileProxySupport.copyStreamToFile((InputStream)new BufferedInputStream(in), (VCSFileProxy)res);
        return res;
    }

    private VCSFileProxy getContentBase(VCSFileProxy referenceFile, File output) throws SVNClientException, IOException {
        InputStream in;
        SvnClient client = Subversion.getInstance().getClient(false, new Context(referenceFile));
        try {
            in = client.getContent(referenceFile, SVNRevision.BASE);
        }
        catch (SVNClientException ex) {
            if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage()) || SvnClientExceptionHandler.hasNoBaseRevision(ex.getMessage())) {
                in = new ByteArrayInputStream(new byte[0]);
            }
            throw ex;
        }
        VCSFileProxy res = VCSFileProxy.createFileProxy((File)FileUtil.normalizeFile((File)output));
        VCSFileProxySupport.copyStreamToFile((InputStream)new BufferedInputStream(in), (VCSFileProxy)res);
        return res;
    }

    private InputStream getInputStream(SvnClient client, SVNUrl url, String revision, String pegRevision) throws SVNClientException {
        InputStream in = null;
        try {
            in = client.getContent(url, SvnUtils.toSvnRevision(revision), SvnUtils.toSvnRevision(pegRevision));
        }
        catch (SVNClientException e) {
            if (SvnClientExceptionHandler.isFileNotFoundInRevision(e.getMessage()) || SvnClientExceptionHandler.isPathNotFound(e.getMessage())) {
                in = new ByteArrayInputStream(new byte[0]);
            }
            throw e;
        }
        return in;
    }

    private File createContent(String fileName, InputStream in) throws IOException {
        File tmp = new File(Utils.getTempFolder(), fileName);
        tmp = FileUtil.normalizeFile((File)tmp);
        tmp.deleteOnExit();
        FileUtils.copyStreamToFile((InputStream)new BufferedInputStream(in), (File)tmp);
        return tmp;
    }

    private VCSFileProxy getMetadataDir(VCSFileProxy dir) {
        VCSFileProxy svnDir = VCSFileProxy.createFileProxy((VCSFileProxy)dir, (String)".svn");
        if (!svnDir.isDirectory()) {
            return null;
        }
        return svnDir;
    }
}

