/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client;

import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.subversion.remote.OutputLogger;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNNodeKind;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public abstract class SvnProgressSupport
implements Runnable,
Cancellable,
ISVNNotifyListener {
    private Cancellable delegate;
    private volatile boolean canceled;
    private ProgressHandle progressHandle = null;
    private String displayName = "";
    private String originalDisplayName = "";
    private OutputLogger logger;
    private SVNUrl repositoryRoot;
    private RequestProcessor.Task task;
    private final FileSystem fileSystem;

    protected SvnProgressSupport(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public RequestProcessor.Task start(RequestProcessor rp, SVNUrl repositoryRoot, String displayName) {
        this.setDisplayName(displayName);
        this.repositoryRoot = repositoryRoot;
        this.startProgress();
        this.setProgressQueued();
        this.task = rp.post((Runnable)this);
        this.task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                SvnProgressSupport.this.delegate = null;
            }
        });
        return this.task;
    }

    public void setRepositoryRoot(SVNUrl repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
        this.logger = null;
    }

    @Override
    public void run() {
        this.setProgress();
        this.performIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performIntern() {
        try {
            SvnProgressSupport.log("Start - " + this.displayName);
            if (!this.canceled) {
                this.perform();
            }
        }
        finally {
            SvnProgressSupport.log("End - " + this.displayName);
            this.finnishProgress();
            this.getLogger().closeLog();
        }
    }

    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    protected abstract void perform();

    public synchronized boolean isCanceled() {
        return this.canceled;
    }

    public synchronized boolean cancel() {
        if (this.canceled) {
            return false;
        }
        this.getLogger().flushLog();
        if (this.delegate != null) {
            this.delegate.cancel();
        }
        if (this.task != null) {
            this.task.cancel();
        }
        this.finnishProgress();
        this.canceled = true;
        return true;
    }

    public void setCancellableDelegate(Cancellable cancellable) {
        this.delegate = cancellable;
    }

    public void setDisplayName(String displayName) {
        if (this.originalDisplayName.equals("")) {
            this.originalDisplayName = displayName;
        }
        this.logChangedDisplayName(this.displayName, displayName);
        this.displayName = displayName;
        this.setProgress();
    }

    private void setProgressQueued() {
        if (this.progressHandle != null) {
            this.progressHandle.progress(NbBundle.getMessage(SvnProgressSupport.class, (String)"LBL_Queued", (Object)this.displayName));
        }
    }

    private void setProgress() {
        if (this.progressHandle != null) {
            this.progressHandle.progress(this.displayName);
        }
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    protected ProgressHandle getProgressHandle() {
        if (this.progressHandle == null) {
            this.progressHandle = this.repositoryRoot != null ? ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)this, (Action)this.getLogger().getOpenOutputAction()) : ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)this);
        }
        return this.progressHandle;
    }

    protected void startProgress() {
        this.getProgressHandle().start();
        this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.originalDisplayName);
    }

    protected void finnishProgress() {
        this.getProgressHandle().finish();
        if (!this.isCanceled()) {
            this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.originalDisplayName + " " + NbBundle.getMessage(SvnProgressSupport.class, (String)"MSG_Progress_Finished"));
        } else {
            this.getLogger().logCommandLine("==[IDE]== " + DateFormat.getDateTimeInstance().format(new Date()) + " " + this.originalDisplayName + " " + NbBundle.getMessage(SvnProgressSupport.class, (String)"MSG_Progress_Canceled"));
        }
    }

    protected OutputLogger getLogger() {
        if (this.logger == null) {
            this.logger = Subversion.getInstance().getLogger(this.fileSystem, this.repositoryRoot);
        }
        return this.logger;
    }

    private static void log(String msg) {
        SvnUtils.logT9Y(msg);
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.log(Level.FINE, msg);
        }
    }

    private void logChangedDisplayName(String thisDisplayName, String displayName) {
        if (thisDisplayName != null && !thisDisplayName.equals(displayName) && !thisDisplayName.equals("")) {
            SvnProgressSupport.log("End - " + thisDisplayName);
            SvnProgressSupport.log("Start - " + displayName);
        }
    }

    public void annotate(SVNClientException ex) {
        SvnClientExceptionHandler.notifyException(null, ex, !this.isCanceled(), true);
    }

    @Override
    public void setCommand(ISVNNotifyListener.Command i) {
    }

    @Override
    public void logCommandLine(String string) {
    }

    @Override
    public void logMessage(String string) {
    }

    @Override
    public void logError(String string) {
    }

    @Override
    public void logRevision(long l, String string) {
    }

    @Override
    public void logCompleted(String string) {
    }

    @Override
    public void onNotify(VCSFileProxy file, SVNNodeKind svnnk) {
        if (this.progressHandle != null) {
            this.progressHandle.progress(file.getName());
        }
    }
}

