/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.browser;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.ui.browser.Browser;
import org.netbeans.modules.subversion.remote.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.remote.ui.search.SvnSearch;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RepositoryPaths
implements ActionListener,
DocumentListener {
    private static final RepositoryFile[] EMPTY_REPOSITORY_FILES = new RepositoryFile[0];
    private RepositoryFile repositoryFile;
    private JTextComponent repositoryPathTextField;
    private JTextComponent revisionTextField;
    private JButton browseButton;
    private JButton searchRevisionButton;
    private JButton browseRevisionButton;
    private int browserMode;
    private BrowserAction[] browserActions;
    private String browserPurpose;
    private String browserHelpID;
    private String searchHelpID;
    private boolean valid = false;
    public static final String PROP_VALID = "valid";
    private List<PropertyChangeListener> listeners;
    private PropertyChangeSupport propertyChangeSupport;
    private final FileSystem fileSystem;

    public RepositoryPaths(FileSystem fileSystem, RepositoryFile repositoryFile, JTextComponent repositoryPathTextField, JButton browseButton, JTextField revisionTextField, JButton searchRevisionButton) {
        this(fileSystem, repositoryFile, repositoryPathTextField, browseButton, revisionTextField, searchRevisionButton, null);
    }

    public RepositoryPaths(FileSystem fileSystem, RepositoryFile repositoryFile, JTextComponent repositoryPathTextField, JButton browseButton, JTextField revisionTextField, JButton searchRevisionButton, JButton browseRevisionButton) {
        assert (repositoryFile != null);
        assert (repositoryPathTextField != null && browseButton != null || revisionTextField != null && searchRevisionButton != null);
        this.fileSystem = fileSystem;
        this.repositoryFile = repositoryFile;
        if (repositoryPathTextField != null) {
            this.repositoryPathTextField = repositoryPathTextField;
            repositoryPathTextField.getDocument().addDocumentListener(this);
            this.browseButton = browseButton;
            if (browseButton != null) {
                browseButton.addActionListener(this);
            }
        }
        if (revisionTextField != null) {
            this.revisionTextField = revisionTextField;
            revisionTextField.setInputVerifier(new RevisionInputVerifier());
            revisionTextField.getDocument().addDocumentListener(this);
            this.searchRevisionButton = searchRevisionButton;
            this.browseRevisionButton = browseRevisionButton;
            if (searchRevisionButton != null) {
                searchRevisionButton.addActionListener(this);
            }
            if (browseRevisionButton != null) {
                browseRevisionButton.addActionListener(this);
            }
        }
    }

    public void setupBehavior(String browserPurpose, int browserMode, String browserHelpID, String searchHelpID) {
        this.browserMode = browserMode;
        this.browserPurpose = browserPurpose;
        this.browserHelpID = browserHelpID;
        this.searchHelpID = searchHelpID;
    }

    public void setupBehavior(String browserPurpose, int browserMode, BrowserAction[] browserActions, String browserHelpID, String searchHelpID) {
        this.setupBehavior(browserPurpose, browserMode, browserHelpID, searchHelpID);
        this.browserActions = browserActions;
        this.browserPurpose = browserPurpose;
    }

    public RepositoryFile[] getRepositoryFiles() throws MalformedURLException, NumberFormatException {
        return this.getRepositoryFiles(null);
    }

    public RepositoryFile[] getRepositoryFiles(String defaultPath) throws MalformedURLException, NumberFormatException {
        SVNRevision revision = this.getRevision();
        if (this.repositoryPathTextField == null) {
            RepositoryFile rf = new RepositoryFile(this.fileSystem, this.repositoryFile.getRepositoryUrl(), this.repositoryFile.getFileUrl(), revision);
            return new RepositoryFile[]{rf};
        }
        if (this.getRepositoryString().equals("")) {
            if (defaultPath != null && !defaultPath.trim().equals("")) {
                return new RepositoryFile[]{new RepositoryFile(this.fileSystem, this.getRepositoryUrl(), defaultPath, revision)};
            }
            return EMPTY_REPOSITORY_FILES;
        }
        if (revision == null) {
            return EMPTY_REPOSITORY_FILES;
        }
        String[] paths = this.getRepositoryString().split(",");
        RepositoryFile[] ret = new RepositoryFile[paths.length];
        SVNUrl repositoryUrl = this.getRepositoryUrl();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i].trim();
            String repositoryUrlString = SvnUtils.decodeToString(this.getRepositoryUrl());
            if (path.startsWith("file://") || path.startsWith("http://") || path.startsWith("https://") || path.startsWith("svn://") || path.startsWith("svn+ssh://")) {
                if (path.startsWith(repositoryUrlString)) {
                    ret[i] = new RepositoryFile(this.fileSystem, repositoryUrl, path.substring(repositoryUrlString.length()), revision);
                    continue;
                }
                throw new MalformedURLException(NbBundle.getMessage(RepositoryPaths.class, (String)"MSG_RepositoryPath_WrongStart", (Object)path, (Object)repositoryUrlString));
            }
            ret[i] = new RepositoryFile(this.fileSystem, repositoryUrl, path, revision);
        }
        return ret;
    }

    private void browseRepository() {
        RepositoryFile[] repositoryFilesToSelect;
        SVNRevision revision = this.getRevision();
        try {
            repositoryFilesToSelect = this.getRepositoryFiles();
        }
        catch (MalformedURLException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(this.fileSystem, this.getRepositoryUrl(), revision);
        Browser browser = new Browser(this.fileSystem, this.browserPurpose, this.browserMode, repositoryFile, repositoryFilesToSelect, this.browserActions, this.browserHelpID);
        RepositoryFile[] selectedFiles = browser.getRepositoryFiles();
        if (selectedFiles.length > 0) {
            StringBuilder paths = new StringBuilder();
            for (int i = 0; i < selectedFiles.length; ++i) {
                paths.append(selectedFiles[i].getPath());
                if (i >= selectedFiles.length - 1) continue;
                paths.append(", ");
            }
            this.setRepositoryTextField(paths.toString());
        }
    }

    private void browseRepositoryForRevision() {
        RepositoryFile repoFile;
        int mode;
        SVNUrl repositoryUrl = this.getRepositoryUrl();
        String title = NbBundle.getMessage(RepositoryPaths.class, (String)"CTL_BrowseTag");
        Browser browser = new Browser(this.fileSystem, title, mode = 11, repoFile = new RepositoryFile(this.fileSystem, repositoryUrl, SVNRevision.HEAD), null, null, "org.netbeans.modules.subversion.ui.browser.mergetag");
        final RepositoryFile[] repositoryFiles = browser.getRepositoryFiles();
        if (repositoryFiles == null || repositoryFiles.length == 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RepositoryPaths.this.revisionTextField.setText(repositoryFiles[0].getRevision().toString());
            }
        });
    }

    private void searchRepository() {
        SvnSearch svnSearch;
        try {
            RepositoryFile[] repositoryFiles = this.getRepositoryFiles();
            svnSearch = repositoryFiles.length > 0 ? new SvnSearch(repositoryFiles) : new SvnSearch(this.repositoryFile);
        }
        catch (MalformedURLException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
            return;
        }
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)svnSearch.getSearchPanel(), ResourceBundle.getBundle("org/netbeans/modules/subversion/remote/ui/browser/Bundle").getString("CTL_RepositoryPath_SearchRevisions"));
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.searchHelpID));
        dialogDescriptor.setValid(false);
        svnSearch.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                dialogDescriptor.setValid(svnSearch.getSelectedRevision() != null);
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            SVNRevision revision = svnSearch.getSelectedRevision();
            if (revision != null) {
                if (revision.equals(SVNRevision.HEAD)) {
                    this.setRevisionTextField("");
                } else {
                    this.setRevisionTextField(revision.toString());
                }
            }
        } else {
            svnSearch.cancel();
        }
    }

    public SVNRevision getRevision() {
        if (this.revisionTextField == null) {
            return SVNRevision.HEAD;
        }
        String revisionString = this.getRevisionString();
        if (revisionString.equals("")) {
            return SVNRevision.HEAD;
        }
        return SvnUtils.getSVNRevision(revisionString);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.browseButton) {
            this.browseRepository();
        } else if (e.getSource() == this.searchRevisionButton) {
            this.searchRepository();
        } else if (e.getSource() == this.browseRevisionButton) {
            this.browseRepositoryForRevision();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    private void validateUserInput() {
        boolean oldValue = this.valid;
        boolean valid = true;
        try {
            this.getRepositoryFiles();
        }
        catch (NumberFormatException ex) {
            valid = false;
        }
        catch (MalformedURLException ex) {
            valid = false;
        }
        if (this.browseButton != null) {
            this.browseButton.setEnabled(valid);
        }
        if (this.searchRevisionButton != null) {
            this.searchRevisionButton.setEnabled(valid);
        }
        if (valid && !this.acceptEmptyUrl() && this.repositoryPathTextField != null && this.getRepositoryString().equals("")) {
            valid = false;
        }
        if (valid && !this.acceptEmptyRevision() && this.revisionTextField != null && this.getRevisionString().equals("")) {
            valid = false;
        }
        this.valid = valid;
        this.fireValidPropertyChanged(oldValue, valid);
    }

    private void fireValidPropertyChanged(boolean oldValue, boolean valid) {
        this.getChangeSupport().firePropertyChange(new PropertyChangeEvent(this, PROP_VALID, oldValue, valid));
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getChangeSupport().addPropertyChangeListener(l);
        this.validateUserInput();
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getChangeSupport().removePropertyChangeListener(l);
    }

    private PropertyChangeSupport getChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    protected boolean acceptEmptyUrl() {
        return false;
    }

    protected boolean acceptEmptyRevision() {
        return true;
    }

    public SVNUrl getRepositoryUrl() {
        return this.repositoryFile.getRepositoryUrl();
    }

    public void setRepositoryFile(RepositoryFile repositoryFile) {
        this.repositoryFile = repositoryFile;
    }

    public void setRepositoryTextField(String url) {
        this.repositoryPathTextField.setText(url);
    }

    public void setRevisionTextField(String revision) {
        this.revisionTextField.setText(revision);
    }

    protected String getRepositoryString() {
        char c;
        int startIndex;
        String text = this.repositoryPathTextField.getText();
        int length = text.length();
        if (length == 0) {
            return text;
        }
        for (startIndex = 0; startIndex < length && ((c = text.charAt(startIndex)) == ',' || c == ' '); ++startIndex) {
        }
        if (startIndex == length) {
            return "";
        }
        int endIndex = length;
        c = text.charAt(endIndex - 1);
        while (c == ',' || c == ' ') {
            c = text.charAt(--endIndex - 1);
        }
        return startIndex == 0 && endIndex == length ? text : text.substring(startIndex, endIndex);
    }

    protected String getRevisionString() {
        return this.revisionTextField.getText().trim();
    }

    private static class RevisionInputVerifier
    extends InputVerifier {
        private RevisionInputVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            JTextComponent comp;
            if (input instanceof JTextComponent && (comp = (JTextComponent)input).getText().trim().isEmpty()) {
                comp.setText(SVNRevision.HEAD.toString());
            }
            return true;
        }
    }
}

