/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.diff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnFileNode;
import org.netbeans.modules.subversion.remote.api.Depth;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNProperty;
import org.netbeans.modules.subversion.remote.api.ISVNStatus;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNDiffSummary;
import org.netbeans.modules.subversion.remote.api.SVNNodeKind;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.api.SVNUrlUtils;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.diff.Bundle;
import org.netbeans.modules.subversion.remote.ui.diff.DiffNode;
import org.netbeans.modules.subversion.remote.ui.diff.MultiDiffPanel;
import org.netbeans.modules.subversion.remote.ui.diff.Setup;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.util.Lookup;

class RevisionSetupsSupport {
    private final RepositoryFile repositoryTreeLeft;
    private final RepositoryFile repositoryTreeRight;
    private final SVNUrl repositoryUrl;
    private final Context context;
    private final FileStatusCache cache;
    private final Map<VCSFileProxy, Setup> wcSetups;
    private final boolean workingCopy;
    private final boolean base;
    private final Map<String, SVNDiffSummary[]> diffSummaryCache;
    private final Set<String> missingURLs;
    private static final Logger LOG = Logger.getLogger(RevisionSetupsSupport.class.getName());
    private boolean logged;

    public RevisionSetupsSupport(RepositoryFile repositoryTreeLeft, RepositoryFile repositoryTreeRight, SVNUrl repositoryUrl, Context context) {
        this.repositoryTreeLeft = repositoryTreeLeft;
        this.repositoryTreeRight = repositoryTreeRight;
        this.repositoryUrl = repositoryUrl;
        this.context = context;
        this.cache = Subversion.getInstance().getStatusCache();
        this.wcSetups = new LinkedHashMap<VCSFileProxy, Setup>();
        this.diffSummaryCache = new LinkedHashMap<String, SVNDiffSummary[]>();
        this.missingURLs = new LinkedHashSet<String>();
        this.workingCopy = SVNRevision.WORKING.equals(this.repositoryTreeRight.getRevision());
        this.base = SVNRevision.BASE.equals(this.repositoryTreeRight.getRevision()) || SVNRevision.BASE.equals(this.repositoryTreeLeft.getRevision());
    }

    Setup[] computeSetupsBetweenRevisions(SvnProgressSupport supp) {
        RepositoryFile left = this.repositoryTreeLeft;
        RepositoryFile right = this.repositoryTreeRight;
        assert (left != null && right != null);
        if (left.toString().equals(right.toString())) {
            return new Setup[0];
        }
        try {
            VCSFileProxy[] roots = this.getRoots();
            SvnClient client = Subversion.getInstance().getClient(this.context, this.repositoryUrl);
            ArrayList<Setup> setups = new ArrayList<Setup>();
            for (VCSFileProxy root : roots) {
                SVNUrl rightUrl;
                boolean flatFile = false;
                SVNUrl leftUrl = roots.length > 1 ? left.replaceLastSegment(root.getName(), 0).getFileUrl() : left.getFileUrl();
                SVNUrl sVNUrl = rightUrl = roots.length > 1 ? right.replaceLastSegment(root.getName(), 0).getFileUrl() : right.getFileUrl();
                if (this.base || this.workingCopy) {
                    ISVNStatus[] statuses = client.getStatus(root, !flatFile, true, false, true);
                    HashMap<VCSFileProxy, ISVNStatus> statusMap = new HashMap<VCSFileProxy, ISVNStatus>(statuses.length);
                    for (ISVNStatus s : statuses) {
                        statusMap.put(s.getFile(), s);
                    }
                    for (ISVNStatus s : statuses) {
                        SVNRevision rightRevision;
                        SVNUrl rightFileUrl;
                        SVNRevision leftRevision;
                        SVNUrl leftFileUrl;
                        if (supp.isCanceled()) {
                            return null;
                        }
                        VCSFileProxy f = s.getFile();
                        if ((this.cache.getStatus(f).getStatus() & 2) != 0 || flatFile && !f.equals((Object)root) && s.getNodeKind() == SVNNodeKind.DIR) continue;
                        SVNRevision.Number revision = s.getRevision();
                        SVNUrl url = s.getUrl();
                        if (s.isCopied() || revision == null) {
                            url = null;
                            revision = null;
                            if (!this.workingCopy) continue;
                        }
                        String relativePath = this.getRelativePath(root, f);
                        if (SVNRevision.BASE.equals(right.getRevision()) || this.workingCopy) {
                            leftFileUrl = leftUrl.appendPath(relativePath);
                            leftRevision = left.getRevision();
                            rightFileUrl = url;
                            rightRevision = revision;
                        } else {
                            leftFileUrl = url;
                            leftRevision = revision;
                            rightFileUrl = rightUrl.appendPath(relativePath);
                            rightRevision = right.getRevision();
                        }
                        List<Setup> partialSetups = this.buildSetups(client, leftFileUrl, leftRevision, rightFileUrl, rightRevision, supp, flatFile, flatFile ? Depth.files : Depth.infinity, f, false, statusMap);
                        if (partialSetups == null) {
                            return null;
                        }
                        setups.addAll(partialSetups);
                    }
                    continue;
                }
                List<Setup> partialSetups = this.buildSetups(client, leftUrl, left.getRevision(), rightUrl, right.getRevision(), supp, flatFile, flatFile ? Depth.files : Depth.infinity, root, true, Collections.emptyMap());
                if (partialSetups == null) {
                    return null;
                }
                setups.addAll(partialSetups);
            }
            if (this.workingCopy) {
                for (Map.Entry<VCSFileProxy, Setup> e : this.wcSetups.entrySet()) {
                    setups.add(e.getValue());
                }
            }
            return setups.toArray(new Setup[setups.size()]);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(this.context, ex, true, false);
            return new Setup[0];
        }
    }

    void setWCSetups(Setup[] wcSetups) {
        for (Setup s : wcSetups) {
            VCSFileProxy f = s.getBaseFile();
            if (s.getPropertyName() != null) continue;
            this.wcSetups.put(f, s);
        }
    }

    private ISVNInfo checkUrlExistance(Context context, SvnClient client, SVNUrl url, SVNRevision revision) throws SVNClientException {
        if (url == null) {
            return null;
        }
        if (this.parentMissing(url, revision)) {
            return null;
        }
        try {
            return client.getInfo(context, url, revision, revision);
        }
        catch (SVNClientException ex) {
            if (SvnClientExceptionHandler.isWrongURLInRevision(ex.getMessage())) {
                this.cacheParentMissing(url, revision);
                return null;
            }
            throw ex;
        }
    }

    private List<Setup> addPropertySetups(SvnClient client, SVNUrl leftFileUrl, SVNRevision leftRevision, SVNUrl rightFileUrl, SVNRevision rightRevision) throws SVNClientException {
        ArrayList<Setup> propSetups = new ArrayList<Setup>();
        DiffProvider diffAlgorithm = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        try {
            Map leftProps = leftFileUrl == null ? Collections.emptyMap() : this.toMap(client.getProperties(leftFileUrl, leftRevision, leftRevision));
            Map rightProps = rightFileUrl == null ? Collections.emptyMap() : this.toMap(client.getProperties(rightFileUrl, rightRevision, rightRevision));
            TreeSet allProps = new TreeSet(leftProps.keySet());
            allProps.addAll(rightProps.keySet());
            for (String key : allProps) {
                boolean isLeft = leftProps.containsKey(key);
                boolean isRight = rightProps.containsKey(key);
                boolean propertiesDiffer = true;
                if (isLeft && isRight) {
                    MultiDiffPanel.Property p1 = new MultiDiffPanel.Property(leftProps.get(key));
                    MultiDiffPanel.Property p2 = new MultiDiffPanel.Property(rightProps.get(key));
                    Difference[] diffs = diffAlgorithm.computeDiff(p1.toReader(), p2.toReader());
                    boolean bl = propertiesDiffer = diffs.length != 0;
                }
                if (!propertiesDiffer) continue;
            }
        }
        catch (IOException e) {
            Subversion.LOG.log(Level.INFO, null, e);
        }
        return propSetups;
    }

    private Map<String, byte[]> toMap(ISVNProperty[] properties) {
        LinkedHashMap<String, byte[]> map = new LinkedHashMap<String, byte[]>(properties.length);
        for (ISVNProperty prop : properties) {
            map.put(prop.getName(), prop.getData());
        }
        return map;
    }

    private boolean isSkippedInParent(List<String> skippedPaths, String filePath) {
        for (String p : skippedPaths) {
            if (!filePath.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    private String getRelativePath(VCSFileProxy root, VCSFileProxy f) {
        String path = "";
        while (f != null && !f.equals((Object)root)) {
            path = f.getName() + "/" + path;
            f = f.getParentFile();
        }
        if (f == null) {
            return null;
        }
        return path.isEmpty() ? path : path.substring(0, path.length() - 1);
    }

    private Setup createSetup(SVNDiffSummary summary, VCSFileProxy file, SVNUrl leftUrl, SVNRevision leftRevision, SVNUrl rightUrl, String rightRevision) {
        boolean added;
        FileInformation fi = null;
        Setup localSetup = this.wcSetups.get(file);
        boolean deleted = summary.getDiffKind() == SVNDiffSummary.SVNDiffKind.DELETED;
        boolean bl = added = summary.getDiffKind() == SVNDiffSummary.SVNDiffKind.ADDED;
        if (localSetup != null) {
            fi = this.cache.getStatus(file);
            if (added && (fi.getStatus() & 0x14FF8) == 0) {
                fi = null;
            } else {
                deleted = (fi.getStatus() & 0x900) != 0;
                boolean bl2 = added = (fi.getStatus() & 0x1004) != 0;
            }
        }
        if (fi == null) {
            fi = new RevisionsFileInformation(summary);
        }
        this.wcSetups.remove(file);
        Setup setup = new Setup(file, this.repositoryUrl, leftUrl, added ? null : leftRevision.toString(), SVNUrlUtils.getRelativePath(this.repositoryUrl, leftUrl) + "@" + leftRevision, rightUrl, deleted ? null : rightRevision, "LOCAL".equals(rightRevision) ? file.getName() + "@" + rightRevision : SVNUrlUtils.getRelativePath(this.repositoryUrl, rightUrl) + "@" + rightRevision, fi);
        setup.setNode(new DiffNode(setup, new SvnFileNode(file), -1));
        return setup;
    }

    private List<Setup> buildSetups(SvnClient client, SVNUrl leftFileUrl, SVNRevision leftRevision, SVNUrl rightFileUrl, SVNRevision rightRevision, SvnProgressSupport supp, boolean flatFile, Depth depth, VCSFileProxy root, boolean addAll, Map<VCSFileProxy, ISVNStatus> statusMap) throws SVNClientException {
        boolean sameURLs = leftFileUrl != null && leftFileUrl.equals(rightFileUrl) && leftRevision != null && leftRevision.equals(rightRevision);
        ArrayList<Setup> setups = new ArrayList<Setup>();
        if (!sameURLs) {
            boolean rightExists;
            boolean leftExists;
            SVNDiffSummary[] diffSummaries = this.getCachedSummaries(leftFileUrl, leftRevision, rightRevision);
            ISVNInfo infoLeft = null;
            ISVNInfo infoRight = null;
            if (diffSummaries == null) {
                Context context = new Context(root);
                infoLeft = this.checkUrlExistance(context, client, leftFileUrl, leftRevision);
                infoRight = this.checkUrlExistance(context, client, rightFileUrl, rightRevision);
                leftExists = infoLeft != null;
                rightExists = infoRight != null;
            } else {
                rightExists = true;
                leftExists = true;
            }
            if (supp.isCanceled()) {
                return null;
            }
            if (leftExists && rightExists) {
                if (diffSummaries == null) {
                    diffSummaries = client.diffSummarize(leftFileUrl, leftRevision, rightFileUrl, rightRevision, depth, true);
                    this.cacheSummaries(diffSummaries, leftFileUrl, leftRevision, rightRevision);
                }
                ArrayList<String> skippedPaths = new ArrayList<String>();
                HashSet<String> deletedPaths = new HashSet<String>();
                for (SVNDiffSummary summary : diffSummaries) {
                    if (summary.getDiffKind() != SVNDiffSummary.SVNDiffKind.DELETED) continue;
                    deletedPaths.add(summary.getPath());
                }
                for (SVNDiffSummary summary : diffSummaries) {
                    boolean skipItem;
                    if (supp.isCanceled()) {
                        return null;
                    }
                    String filePath = summary.getPath();
                    VCSFileProxy file = filePath.isEmpty() ? root : VCSFileProxy.createFileProxy((VCSFileProxy)root, (String)filePath);
                    boolean bl = skipItem = !filePath.isEmpty();
                    if (addAll || summary.getDiffKind() == SVNDiffSummary.SVNDiffKind.DELETED && this.containsAllParents(filePath, deletedPaths) && (!flatFile || summary.getNodeKind() != SVNNodeKind.DIR && !filePath.contains("/")) && !this.isSkippedInParent(skippedPaths, filePath)) {
                        skipItem = false;
                        ISVNStatus fileStatus = statusMap.get(file);
                        if (fileStatus != null && !fileStatus.isCopied() && fileStatus.getRevision() != null) {
                            skipItem = true;
                            skippedPaths.add(filePath);
                        }
                    }
                    if (summary.getDiffKind() == SVNDiffSummary.SVNDiffKind.NORMAL || skipItem) continue;
                    Setup setup = this.createSetup(summary, file, leftFileUrl.appendPath(filePath), leftRevision, this.workingCopy ? null : rightFileUrl.appendPath(filePath), this.workingCopy ? "LOCAL" : rightRevision.toString());
                    setups.add(setup);
                }
            } else {
                SVNDiffSummary summary = new SVNDiffSummary("", leftExists ? SVNDiffSummary.SVNDiffKind.DELETED : SVNDiffSummary.SVNDiffKind.ADDED, false, SVNNodeKind.NONE);
                Setup setup = this.createSetup(summary, root, leftFileUrl, leftRevision, this.workingCopy ? null : rightFileUrl, this.workingCopy ? "LOCAL" : rightRevision.toString());
                setups.add(setup);
            }
        }
        if (this.workingCopy && this.wcSetups.containsKey(root)) {
            SVNDiffSummary summary = new SVNDiffSummary("", SVNDiffSummary.SVNDiffKind.NORMAL, false, SVNNodeKind.NONE);
            Setup setup = this.createSetup(summary, root, leftFileUrl, leftRevision, null, "LOCAL");
            setups.add(setup);
        }
        return setups;
    }

    private void cacheSummaries(SVNDiffSummary[] diffSummaries, SVNUrl leftUrl, SVNRevision leftRevision, SVNRevision rightRevision) {
        String revisionString = "@" + leftRevision + ":" + rightRevision;
        LinkedHashMap sums = new LinkedHashMap();
        sums.put("", new ArrayList(diffSummaries.length));
        for (SVNDiffSummary s : diffSummaries) {
            int index;
            String path = s.getPath();
            do {
                String suffix;
                ArrayList<SVNDiffSummary> list;
                if ((list = (ArrayList<SVNDiffSummary>)sums.get(path)) == null) {
                    list = new ArrayList<SVNDiffSummary>();
                    sums.put(path, list);
                }
                if ((suffix = s.getPath().substring(path.length())).startsWith("/")) {
                    suffix = suffix.substring(1);
                }
                list.add(new SVNDiffSummary(suffix, s.getDiffKind(), s.propsChanged(), s.getNodeKind()));
            } while ((path = (index = path.lastIndexOf(47)) > -1 ? path.substring(0, index) : (!path.isEmpty() ? "" : null)) != null);
        }
        for (Map.Entry e : sums.entrySet()) {
            SVNDiffSummary[] summaryArray = ((List)e.getValue()).toArray(new SVNDiffSummary[((List)e.getValue()).size()]);
            String key = ((String)e.getKey()).isEmpty() ? leftUrl.toString() : leftUrl.toString() + "/" + (String)e.getKey();
            key = key + revisionString;
            this.diffSummaryCache.put(key, summaryArray);
        }
    }

    private SVNDiffSummary[] getCachedSummaries(SVNUrl url, SVNRevision leftRevision, SVNRevision rightRevision) {
        String revisionString = "@" + leftRevision + ":" + rightRevision;
        boolean direct = true;
        while (url != null) {
            SVNDiffSummary[] sums = this.diffSummaryCache.get(url.toString() + revisionString);
            if (sums != null) {
                return direct ? sums : new SVNDiffSummary[]{};
            }
            direct = false;
            url = url.getParent();
        }
        return null;
    }

    private void cacheParentMissing(SVNUrl url, SVNRevision revision) {
        this.missingURLs.add(url.toString() + "@" + revision);
    }

    private boolean parentMissing(SVNUrl url, SVNRevision revision) {
        while (url != null) {
            if (this.missingURLs.contains(url.toString() + "@" + revision)) {
                return true;
            }
            url = url.getParent();
        }
        return false;
    }

    private boolean containsAllParents(String filePath, Set<String> deletedPaths) {
        while (filePath != null) {
            if (!deletedPaths.contains(filePath)) {
                return false;
            }
            int pos = filePath.lastIndexOf(47);
            if (pos > -1) {
                filePath = filePath.substring(0, pos);
                continue;
            }
            filePath = null;
        }
        return true;
    }

    protected VCSFileProxy[] getRoots() {
        return SvnUtils.getActionRoots(this.context, false);
    }

    private static class RevisionsFileInformation
    extends FileInformation {
        private final String name;

        public RevisionsFileInformation(SVNDiffSummary item) {
            super(RevisionsFileInformation.toStatus(item.getDiffKind()), 0, item.getNodeKind() == SVNNodeKind.DIR);
            this.name = RevisionsFileInformation.toStatusText(item.getDiffKind());
        }

        @Override
        public String getStatusText(int displayStatuses) {
            return this.name;
        }

        private static String toStatusText(SVNDiffSummary.SVNDiffKind diffKind) {
            if (diffKind == SVNDiffSummary.SVNDiffKind.DELETED) {
                return Bundle.LBL_DiffRevisions_status_removed();
            }
            if (diffKind == SVNDiffSummary.SVNDiffKind.ADDED) {
                return Bundle.LBL_DiffRevisions_status_added();
            }
            if (diffKind == SVNDiffSummary.SVNDiffKind.MODIFIED) {
                return Bundle.LBL_DiffRevisions_status_modified();
            }
            return Bundle.LBL_DiffRevisions_status_uptodate();
        }

        private static int toStatus(SVNDiffSummary.SVNDiffKind diffKind) {
            if (diffKind == SVNDiffSummary.SVNDiffKind.ADDED) {
                return 4096;
            }
            if (diffKind == SVNDiffSummary.SVNDiffKind.DELETED) {
                return 256;
            }
            if (diffKind == SVNDiffSummary.SVNDiffKind.MODIFIED) {
                return 65552;
            }
            return 8;
        }
    }
}

