/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.ignore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.nodes.Node;

public class IgnoreAction
extends ContextAction {
    public static final int UNDEFINED = 0;
    public static final int IGNORING = 1;
    public static final int UNIGNORING = 2;

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        int actionStatus = this.getActionStatus(activatedNodes);
        switch (actionStatus) {
            case 0: 
            case 1: {
                return "CTL_MenuItem_Ignore";
            }
            case 2: {
                return "CTL_MenuItem_Unignore";
            }
        }
        throw new RuntimeException("Invalid action status: " + actionStatus);
    }

    @Override
    protected int getFileEnabledStatus() {
        return 4102;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 4102;
    }

    public int getActionStatus(Node[] nodes) {
        return this.getActionStatus(this.getCachedContext(nodes).getFiles());
    }

    public int getActionStatus(VCSFileProxy[] files) {
        int actionStatus = -1;
        if (files.length == 0) {
            return 0;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().equals(".svn")) {
                actionStatus = 0;
                break;
            }
            FileInformation info = cache.getStatus(files[i]);
            if ((info.getStatus() & 0x1004) != 0) {
                if (actionStatus == 2) {
                    actionStatus = 0;
                    break;
                }
                actionStatus = 1;
                continue;
            }
            if (info.getStatus() == 2) {
                if (actionStatus == 1) {
                    actionStatus = 0;
                    break;
                }
                actionStatus = 2;
                continue;
            }
            actionStatus = 0;
            break;
        }
        return actionStatus == -1 ? 0 : actionStatus;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return this.isCacheReady() && this.getActionStatus(nodes) != 0;
    }

    @Override
    public void performContextAction(Node[] nodes) {
        final int actionStatus = this.getActionStatus(nodes);
        if (actionStatus != 1 && actionStatus != 2) {
            throw new RuntimeException("Invalid action status: " + actionStatus);
        }
        final Context ctx = SvnUtils.getCurrentContext(nodes);
        if (!Subversion.getInstance().checkClientAvailable(ctx)) {
            return;
        }
        final VCSFileProxy[] files = ctx.getRootFiles();
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes, this.getCachedContext(nodes)){

            @Override
            public void perform() {
                SvnClient client;
                Map names = IgnoreAction.this.splitByParent(files);
                try {
                    client = Subversion.getInstance().getClient(false, ctx);
                }
                catch (SVNClientException e) {
                    SvnClientExceptionHandler.notifyException(ctx, e, true, true);
                    return;
                }
                if (actionStatus == 1) {
                    FileStatusCache cache = Subversion.getInstance().getStatusCache();
                    try {
                        for (VCSFileProxy file : files) {
                            ISVNInfo info;
                            FileInformation s = cache.getStatus(file);
                            if (s.getStatus() != 4096 || (info = client.getInfo(file)) != null && info.isCopied()) continue;
                            client.revert(file, true);
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
                        return;
                    }
                }
                for (VCSFileProxy parent : names.keySet()) {
                    Set patterns = (Set)names.get(parent);
                    if (this.isCanceled()) {
                        return;
                    }
                    try {
                        List<String> c = client.getIgnoredPatterns(parent);
                        if (c == null) {
                            Subversion.LOG.log(Level.WARNING, IgnoreAction.class.toString() + ": cannot acquire ignored patterns for " + parent.getPath());
                            if (!parent.exists()) continue;
                            Subversion.LOG.log(Level.WARNING, IgnoreAction.class.toString() + ": file does exist: " + parent.getPath());
                            continue;
                        }
                        HashSet<String> currentPatterns = new HashSet<String>(c);
                        if (actionStatus == 1) {
                            IgnoreAction.ensureVersioned(parent);
                            currentPatterns.addAll(patterns);
                        } else if (actionStatus == 2) {
                            currentPatterns.removeAll(patterns);
                        }
                        client.setIgnoredPatterns(parent, new ArrayList<String>(currentPatterns));
                    }
                    catch (SVNClientException e) {
                        SvnClientExceptionHandler.notifyException(ctx, e, true, true);
                    }
                }
                for (VCSFileProxy file : files) {
                    Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
                for (VCSFileProxy parent : names.keySet()) {
                    Subversion.getInstance().getStatusCache().refresh(parent, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        };
        support.start(this.createRequestProcessor(ctx));
    }

    private Map<VCSFileProxy, Set<String>> splitByParent(VCSFileProxy[] files) {
        HashMap<VCSFileProxy, Set<String>> map = new HashMap<VCSFileProxy, Set<String>>(2);
        for (VCSFileProxy file : files) {
            VCSFileProxy parent = file.getParentFile();
            if (parent == null) continue;
            HashSet<String> names = (HashSet<String>)map.get(parent);
            if (names == null) {
                names = new HashSet<String>(5);
                map.put(parent, names);
            }
            names.add(file.getName());
        }
        return map;
    }

    private static void ensureVersioned(VCSFileProxy file) throws SVNClientException {
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        if ((cache.getStatus(file).getStatus() & 0x15DF8) != 0) {
            return;
        }
        IgnoreAction.ensureVersioned(file.getParentFile());
        IgnoreAction.add(file);
        cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    private static void add(VCSFileProxy file) throws SVNClientException {
        SVNUrl repositoryUrl = SvnUtils.getRepositoryRootUrl(file);
        SvnClient client = Subversion.getInstance().getClient(new Context(file), repositoryUrl);
        if (file.isDirectory()) {
            client.addDirectory(file, false);
        } else {
            client.addFile(file);
        }
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ignore(VCSFileProxy file) throws SVNClientException {
        VCSFileProxy parent = file.getParentFile();
        IgnoreAction.ensureVersioned(parent);
        Class<IgnoreAction> clazz = IgnoreAction.class;
        synchronized (IgnoreAction.class) {
            List<String> patterns = Subversion.getInstance().getClient(true, new Context(file)).getIgnoredPatterns(parent);
            if (patterns != null && !patterns.contains(file.getName())) {
                patterns.add(file.getName());
                String value = IgnoreAction.getPatternsAsString(patterns);
                Subversion.getInstance().getClient(true, new Context(file)).propertySet(parent, "svn:ignore", value, false);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static String getPatternsAsString(List<String> patterns) {
        StringBuilder value = new StringBuilder();
        for (String pattern : patterns) {
            value.append(pattern).append('\n');
        }
        return value.toString();
    }
}

