/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.update;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNStatus;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNStatusKind;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.commit.ConflictResolvedAction;
import org.netbeans.modules.subversion.remote.ui.update.ResolveConflictsExecutor;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ResolveConflictsAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/subversion/remote/resources/icons/conflict-resolve.png";

    public ResolveConflictsAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "ResolveConflicts";
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return this.isCacheReady() && Subversion.getInstance().getStatusCache().containsFiles(this.getCachedContext(nodes), 16448, true);
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        Context ctx = this.getContext(nodes);
        if (!Subversion.getInstance().checkClientAvailable(ctx)) {
            return;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        VCSFileProxy[] files = cache.listFiles(ctx, 16448);
        ResolveConflictsAction.resolveConflicts(files);
    }

    static void resolveConflicts(final VCSFileProxy[] files) {
        Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                final Map treeConflicts = ResolveConflictsAction.getTreeConflicts(files);
                final Map propertyConflicts = ResolveConflictsAction.getPropertyConflicts(files);
                final List filteredFiles = ResolveConflictsAction.removeFolders(files, treeConflicts.keySet());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (filteredFiles.isEmpty() && treeConflicts.isEmpty() && propertyConflicts.isEmpty()) {
                            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_NoConflictsFound"));
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        } else {
                            this.resolveTreeConflicts(treeConflicts);
                            this.resolvePropertyConflicts(propertyConflicts, filteredFiles);
                            for (VCSFileProxy file : filteredFiles) {
                                ResolveConflictsExecutor executor = new ResolveConflictsExecutor(file);
                                executor.exec();
                            }
                        }
                    }
                });
            }

            private void resolveTreeConflicts(Map<VCSFileProxy, ISVNStatus> treeConflicts) {
                for (Map.Entry<VCSFileProxy, ISVNStatus> e : treeConflicts.entrySet()) {
                    VCSFileProxy file = e.getKey();
                    ISVNStatus status = e.getValue();
                    if (!this.acceptLocalChanges(status)) continue;
                    try {
                        ConflictResolvedAction.perform(file);
                    }
                    catch (SVNClientException ex) {
                        Logger.getLogger(ResolveConflictsAction.class.getName()).log(Level.INFO, null, ex);
                    }
                }
            }

            private boolean acceptLocalChanges(ISVNStatus status) {
                VCSFileProxy file = status.getFile();
                NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_ResolveConflictsAction.ResolveTreeConflict.message", (Object)file.getName()), NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_ResolveConflictsAction.ResolveTreeConflict.title"), 0, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.NO_OPTION);
                return DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.YES_OPTION;
            }

            private void resolvePropertyConflicts(Map<VCSFileProxy, ISVNStatus> propertyConflicts, List<VCSFileProxy> filesToResolve) {
                for (Map.Entry<VCSFileProxy, ISVNStatus> e : propertyConflicts.entrySet()) {
                    VCSFileProxy file = e.getKey();
                    ISVNStatus status = e.getValue();
                    if (this.acceptPropertyLocalChanges(status)) {
                        if (filesToResolve.contains(file)) continue;
                        try {
                            ConflictResolvedAction.perform(file);
                        }
                        catch (SVNClientException ex) {
                            Logger.getLogger(ResolveConflictsAction.class.getName()).log(Level.INFO, null, ex);
                        }
                        continue;
                    }
                    filesToResolve.remove(file);
                }
            }

            private boolean acceptPropertyLocalChanges(ISVNStatus status) {
                VCSFileProxy file = status.getFile();
                NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_ResolveConflictsAction.ResolvePropertyConflict.message", (Object)file.getName()), NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_ResolveConflictsAction.ResolvePropertyConflict.title"), 0, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.NO_OPTION);
                return DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.YES_OPTION;
            }
        });
    }

    private static List<VCSFileProxy> removeFolders(VCSFileProxy[] files, Set<VCSFileProxy> treeConflicts) {
        LinkedList<VCSFileProxy> filteredFiles = new LinkedList<VCSFileProxy>();
        for (VCSFileProxy file : files) {
            if (treeConflicts.contains(file) || !file.isFile()) continue;
            filteredFiles.add(file);
        }
        return filteredFiles;
    }

    private static Map<VCSFileProxy, ISVNStatus> getTreeConflicts(VCSFileProxy[] files) {
        HashMap<VCSFileProxy, ISVNStatus> treeConflicts = new HashMap<VCSFileProxy, ISVNStatus>(files.length);
        if (files.length > 0) {
            try {
                SvnClient client = Subversion.getInstance().getClient(false, new Context(files));
                FileStatusCache cache = Subversion.getInstance().getStatusCache();
                for (VCSFileProxy file : files) {
                    ISVNStatus status;
                    if ((cache.getStatus(file).getStatus() & 0x4000) == 0 || !(status = SvnUtils.getSingleStatus(client, file)).hasTreeConflict()) continue;
                    treeConflicts.put(file, status);
                }
            }
            catch (SVNClientException ex) {
                Subversion.LOG.log(Level.INFO, null, ex);
            }
        }
        return treeConflicts;
    }

    private static Map<VCSFileProxy, ISVNStatus> getPropertyConflicts(VCSFileProxy[] files) {
        HashMap<VCSFileProxy, ISVNStatus> propertyConflicts = new HashMap<VCSFileProxy, ISVNStatus>(files.length);
        if (files.length > 0) {
            try {
                SvnClient client = Subversion.getInstance().getClient(false, new Context(files));
                FileStatusCache cache = Subversion.getInstance().getStatusCache();
                for (VCSFileProxy file : files) {
                    ISVNStatus status;
                    if ((cache.getStatus(file).getStatus() & 0x40) == 0 || (status = SvnUtils.getSingleStatus(client, file)).getPropStatus() != SVNStatusKind.CONFLICTED) continue;
                    propertyConflicts.put(file, status);
                }
            }
            catch (SVNClientException ex) {
                Subversion.LOG.log(Level.INFO, null, ex);
            }
        }
        return propertyConflicts;
    }

    @Override
    public boolean asynchronous() {
        return false;
    }
}

