/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.v8debug.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.lib.v8debug.JSONReader;
import org.netbeans.lib.v8debug.JSONWriter;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Event;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.V8Type;
import org.netbeans.lib.v8debug.connection.DebuggerConnection;
import org.netbeans.lib.v8debug.connection.IOListener;
import org.netbeans.lib.v8debug.connection.LinkedJSONContainterFactory;
import org.netbeans.lib.v8debug.connection.Utils;

public final class ClientConnection {
    private static final Logger LOG = Logger.getLogger(ClientConnection.class.getName());
    private final Socket server;
    private final InputStream serverIn;
    private final OutputStream serverOut;
    private final Object outLock = new Object();
    private final byte[] buffer = new byte[4096];
    private final ContainerFactory containerFactory = new LinkedJSONContainterFactory();
    private final Set<IOListener> ioListeners = new CopyOnWriteArraySet<IOListener>();

    public ClientConnection(String serverName, int serverPort) throws IOException {
        this.server = new Socket(serverName, serverPort);
        this.serverIn = this.server.getInputStream();
        this.serverOut = this.server.getOutputStream();
    }

    ClientConnection(InputStream serverIn, OutputStream serverOut) throws IOException {
        this.server = null;
        this.serverIn = serverIn;
        this.serverOut = serverOut;
    }

    public void runEventLoop(Listener listener) throws IOException {
        int n;
        byte[] emptyArray;
        int contentLength = -1;
        int[] beginPos = new int[]{0};
        int[] fromPtr = new int[]{0};
        int readOffset = 0;
        String tools = null;
        byte[] messageBytes = emptyArray = new byte[0];
        Map<String, String> header = null;
        int from = 0;
        while ((n = this.serverIn.read(this.buffer, readOffset, 4096 - readOffset)) > 0) {
            n += readOffset;
            do {
                if (contentLength < 0) {
                    fromPtr[0] = from;
                    contentLength = DebuggerConnection.readContentLength(this.buffer, fromPtr, n, beginPos);
                    if (contentLength < 0) break;
                    if (header == null) {
                        header = ClientConnection.readProperties(new String(this.buffer, from, beginPos[0], DebuggerConnection.CHAR_SET));
                        listener.header(header);
                    }
                    from = fromPtr[0];
                }
                if (tools == null) {
                    fromPtr[0] = from;
                    tools = DebuggerConnection.readTools(this.buffer, fromPtr, n);
                    if (tools == null) break;
                    from = fromPtr[0];
                }
                if (from >= n) break;
                int length = Math.min(contentLength - messageBytes.length, n - from);
                messageBytes = Utils.joinArrays(messageBytes, this.buffer, from, length);
                from += length;
                if (messageBytes.length != contentLength) continue;
                String message = new String(messageBytes, DebuggerConnection.CHAR_SET);
                try {
                    this.received(listener, tools, message);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (ParseException pex) {
                    throw new IOException(pex.getLocalizedMessage() + " message = '" + message + "'", pex);
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, message, t);
                }
                contentLength = -1;
                tools = null;
                messageBytes = emptyArray;
            } while (from < n);
            if (from < n) {
                System.arraycopy(this.buffer, from, this.buffer, 0, n - from);
                readOffset = n - from;
                from = 0;
                continue;
            }
            readOffset = 0;
            from -= n;
        }
    }

    private static Map<String, String> readPropertiesScan(String properties) {
        Scanner sp = new Scanner(properties);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (sp.hasNext()) {
                String key = sp.next(": ");
                String value = sp.next("\r\n");
                map.put(key, value);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return map;
    }

    private static Map<String, String> readProperties(String properties) {
        int pos2;
        HashMap<String, String> map = new HashMap<String, String>();
        int l = properties.length();
        int pos = 0;
        while (pos < l && (pos2 = properties.indexOf(": ", pos)) >= 0) {
            String key = properties.substring(pos, pos2).trim();
            pos = pos2 + 2;
            if ((pos2 = properties.indexOf("\r\n", pos)) < 0) break;
            String value = properties.substring(pos, pos2).trim();
            pos = pos2 + 2;
            map.put(key, value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(V8Request request) throws IOException {
        JSONObject obj = JSONWriter.store(request);
        String text = obj.toJSONString();
        this.fireSent(text);
        LOG.log(Level.FINE, "SEND: {0}", text);
        byte[] bytes = text.getBytes(DebuggerConnection.CHAR_SET);
        String contentLength = "Content-Length: " + bytes.length + "\r\n\r\n";
        Object object = this.outLock;
        synchronized (object) {
            this.serverOut.write(contentLength.getBytes(DebuggerConnection.CHAR_SET));
            this.serverOut.write(bytes);
        }
    }

    public void close() throws IOException {
        if (this.server != null) {
            this.server.close();
        }
        this.fireClosed();
    }

    public boolean isClosed() {
        if (this.server != null) {
            return this.server.isClosed();
        }
        return false;
    }

    public void addIOListener(IOListener iol) {
        this.ioListeners.add(iol);
    }

    public void removeIOListener(IOListener iol) {
        this.ioListeners.remove(iol);
    }

    private void fireSent(String str) {
        for (IOListener iol : this.ioListeners) {
            iol.sent(str);
        }
    }

    private void fireReceived(String str) {
        for (IOListener iol : this.ioListeners) {
            iol.received(str);
        }
    }

    private void fireClosed() {
        for (IOListener iol : this.ioListeners) {
            iol.closed();
        }
    }

    private void received(Listener listener, String tools, String message) throws ParseException {
        this.fireReceived(message);
        LOG.log(Level.FINE, "RECEIVED: {0}, {1}", new Object[]{tools, message});
        if (message.isEmpty()) {
            return;
        }
        JSONParser parser = new JSONParser();
        JSONObject obj = (JSONObject)parser.parse(message, this.containerFactory);
        V8Type type = JSONReader.getType(obj);
        switch (type) {
            case event: {
                V8Event event = JSONReader.getEvent(obj);
                listener.event(event);
                break;
            }
            case response: {
                V8Response response = JSONReader.getResponse(obj);
                listener.response(response);
                if (!V8Command.Disconnect.equals((Object)response.getCommand())) break;
                try {
                    this.close();
                }
                catch (IOException ioex) {}
                break;
            }
            default: {
                throw new IllegalStateException("Wrong type: " + (Object)((Object)type));
            }
        }
    }

    public static interface Listener {
        public void header(Map<String, String> var1);

        public void response(V8Response var1);

        public void event(V8Event var1);
    }
}

