/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.awt.Dialog;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.ui.ServerListUIEx;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.remote.server.RemoteServerList;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.ui.EditServerListDialog;
import org.netbeans.modules.cnd.remote.ui.HostPropertiesDialog;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class RemoteServerListUI
extends ServerListUIEx {
    protected boolean showServerListDialogImpl() {
        return this.showServerListDialogImpl(null);
    }

    protected boolean showServerListDialogImpl(AtomicReference<ExecutionEnvironment> selectedEnv) {
        ToolsCacheManager cacheManager = ToolsCacheManager.createInstance((boolean)true);
        if (RemoteServerListUI.showServerListDialog((ToolsCacheManager)cacheManager, selectedEnv)) {
            cacheManager.applyChanges();
            return true;
        }
        return false;
    }

    protected boolean showServerRecordPropertiesDialogImpl(ExecutionEnvironment env) {
        RemoteServerRecord record = RemoteServerList.getInstance().get(env);
        return record instanceof RemoteServerRecord && HostPropertiesDialog.invokeMe(record);
    }

    protected JComponent getServerListComponentImpl(ToolsCacheManager cacheManager, AtomicReference<ExecutionEnvironment> selectedEnv) {
        EditServerListDialog dlg = new EditServerListDialog(cacheManager, selectedEnv, true);
        return dlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean showServerListDialogImpl(ToolsCacheManager cacheManager, AtomicReference<ExecutionEnvironment> selectedEnv) {
        EditServerListDialog dlg = new EditServerListDialog(cacheManager, selectedEnv);
        DialogDescriptor dd = new DialogDescriptor((Object)dlg, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITLE_EditServerList"), true, 2, DialogDescriptor.OK_OPTION, null);
        dlg.setDialogDescriptor(dd);
        dd.addPropertyChangeListener((PropertyChangeListener)dlg);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setMinimumSize(dialog.getPreferredSize());
        try {
            dialog.setVisible(true);
        }
        catch (Throwable th) {
            if (!(th.getCause() instanceof InterruptedException)) {
                throw new RuntimeException(th);
            }
            dd.setValue(DialogDescriptor.CANCEL_OPTION);
        }
        finally {
            dialog.dispose();
        }
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            cacheManager.setHosts(dlg.getHosts());
            cacheManager.setDefaultRecord(dlg.getDefaultRecord());
            return true;
        }
        return false;
    }

    public static boolean showConfirmDialog(final String message, final String title) {
        final AtomicBoolean res = new AtomicBoolean(false);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int option = JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), message, title, 0);
                    if (option == 0) {
                        res.set(true);
                    }
                }
            });
        }
        catch (InterruptedException ex) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return res.get();
    }

    protected boolean ensureRecordOnlineImpl(ExecutionEnvironment env, String customMessage) {
        CndUtils.assertNonUiThread();
        if (env.isLocal()) {
            return true;
        }
        ServerRecord record = ServerList.get((ExecutionEnvironment)env);
        boolean result = false;
        if (record.isDeleted()) {
            String message = MessageFormat.format(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ERR_RequestingDeletedConnection"), record.getDisplayName());
            boolean res = RemoteServerListUI.showConfirmDialog(message, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"DLG_TITLE_DeletedConnection"));
            if (res) {
                ServerList.addServer((ExecutionEnvironment)record.getExecutionEnvironment(), (String)record.getDisplayName(), (RemoteSyncFactory)record.getSyncFactory(), (boolean)false, (boolean)true);
                result = true;
            }
        } else if (record.isOnline()) {
            result = true;
        } else {
            String message = MessageFormat.format(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ERR_NeedToConnectToRemoteHost"), record.getDisplayName());
            boolean res = RemoteServerListUI.showConfirmDialog(message, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"DLG_TITLE_Connect"));
            if (res && ConnectionManager.getInstance().connect(record.getExecutionEnvironment())) {
                record.validate(true);
                result = true;
            }
        }
        return result;
    }

    protected boolean ensureRecordOnlineImpl(ExecutionEnvironment env) {
        return this.ensureRecordOnlineImpl(env, null);
    }
}

